#!/bin/sh
PROG_DIR=$(dirname "$0")/mplayer
cd ${PROG_DIR}

if [ -f "$1" ]; then
	VIDEO="$1"
	VIDEO_DIR=$(dirname "$1")

	if [ "${VIDEO##*.}" == "m3u" ]; then
		PLAYLIST="-playlist"
	fi

	cp /sys/class/backlight/backlight.2/brightness brighntess.txt
	echo -n "${VIDEO_DIR}/" > mp_current_path.txt

	HOME=${PROG_DIR} \
	LD_LIBRARY_PATH="$LD_LIBRARY_PATH":"${PROG_DIR}/libs" \
	./mplayer $PLAYLIST "${VIDEO}" &> log.txt

	cat brighntess.txt > /sys/class/backlight/backlight.2/brightness
	rm brighntess.txt
	rm mp_current_path.txt

else
	./printstr " Check instructions in readme.txt "
	sleep 2
fi

sync
