/*
 * Decompiled with CFR 0.152.
 */
package videostop;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import videostop.Video;
import videostop.VideoText;

class VideoGameOver
extends Canvas
implements VideoText,
CommandListener {
    private Video video;
    private Font boldFont;
    private Font plainFont;
    private Font defaultFont = Font.getDefaultFont();
    private int offsetY;
    private Image line;

    VideoGameOver(Video video) {
        this.video = video;
        this.boldFont = Font.getFont((int)this.defaultFont.getFace(), (int)1, (int)8);
        this.plainFont = Font.getFont((int)this.defaultFont.getFace(), (int)0, (int)8);
        try {
            this.line = Image.createImage((String)"/line.png");
            this.offsetY = (this.getHeight() - (this.boldFont.getHeight() + 3 * this.plainFont.getHeight() + this.line.getHeight())) / 2;
        }
        catch (IOException iOException) {
            this.offsetY = (this.getHeight() - (this.boldFont.getHeight() + 3 * this.plainFont.getHeight())) / 2;
            this.line = null;
        }
        this.addCommand(new Command("OK", 4, 1));
        this.setCommandListener(this);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0, 0, 0);
        int n = this.offsetY;
        graphics.setFont(this.plainFont);
        graphics.drawString("GAME OVER", this.getWidth() / 2, n, 1 | 0x10);
        n += this.plainFont.getHeight();
        if (this.line != null) {
            graphics.drawImage(this.line, this.getWidth() / 2, n, 1 | 0x10);
            n += this.line.getHeight();
        }
        graphics.setFont(this.plainFont);
        graphics.drawString("Your score is:", this.getWidth() / 2, n, 1 | 0x10);
        graphics.setFont(this.boldFont);
        int n2 = this.video.videoScreen.level == 1 ? this.video.videoScreen.score : this.video.videoSecondScreen.score;
        graphics.drawString(Integer.toString(n2), this.getWidth() / 2, n += this.plainFont.getHeight(), 1 | 0x10);
        graphics.setFont(this.plainFont);
        graphics.drawString("Congratulation !", this.getWidth() / 2, n += this.boldFont.getHeight(), 1 | 0x10);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getLabel().equals("OK")) {
            if (this.video.videoScreen.level == 1) {
                this.video.display.setCurrent((Displayable)this.video.videoLogo);
            } else {
                this.video.videoSendScore.init();
                this.video.display.setCurrent((Displayable)this.video.videoSendScore);
            }
        }
    }
}

