/*
 * Decompiled with CFR 0.152.
 */
package videostop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

class VideoRMS {
    private RecordStore data = null;
    private int recordID;
    boolean isActive;
    int diceColor;
    boolean isSound;
    String playerName;

    VideoRMS() {
        this.open();
    }

    public void open() {
        block3: {
            try {
                this.data = RecordStore.openRecordStore((String)"videoecfg", (boolean)true);
                if (this.data.getNumRecords() == 0) {
                    this.isActive = false;
                    this.diceColor = 0;
                    this.isSound = true;
                    this.playerName = "I-Commerce";
                    break block3;
                }
                RecordEnumeration recordEnumeration = this.data.enumerateRecords(null, null, false);
                this.recordID = recordEnumeration.nextRecordId();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data.getRecord(this.recordID));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.isActive = dataInputStream.readBoolean();
                this.diceColor = dataInputStream.readInt();
                this.isSound = dataInputStream.readBoolean();
                this.playerName = dataInputStream.readUTF();
            }
            catch (Exception exception) {
                this.isActive = false;
                this.diceColor = 0;
                this.isSound = true;
                this.playerName = "I-Commerce";
            }
        }
    }

    public void save() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.isActive);
            dataOutputStream.writeInt(this.diceColor);
            dataOutputStream.writeBoolean(this.isSound);
            dataOutputStream.writeUTF(this.playerName);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.data.getNumRecords() == 0) {
                this.data.addRecord(byArray, 0, byArray.length);
            } else {
                this.data.setRecord(this.recordID, byArray, 0, byArray.length);
            }
            this.data.closeRecordStore();
        }
        catch (Exception exception) {}
    }
}

