/*
 * Decompiled with CFR 0.152.
 */
package videostop;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import videostop.Video;
import videostop.VideoRandom;
import videostop.VideoText;
import videostop.VideoTimerTask;

class VideoScreen
extends Canvas
implements VideoText,
CommandListener {
    private Video video;
    private Image buffer;
    private Graphics gc;
    private Font defaultFont = Font.getDefaultFont();
    private int PosX;
    private int PosY;
    private VideoRandom random = new VideoRandom();
    private int one;
    private int two;
    private int three;
    int score;
    int level;
    int count;
    boolean keyLock;
    private Timer timer;
    private int period;
    private Image[] dices = new Image[6];
    private Image dicesImage;
    private VideoTimerTask changeNumbers;

    VideoScreen(Video video) {
        this.video = video;
        try {
            this.dicesImage = Image.createImage((String)"/dices.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.gc = this.buffer.getGraphics();
        this.PosX = (this.getWidth() - 74) / 2;
        this.PosY = (this.getHeight() - 24) / 2;
        this.addCommand(new Command("Options", 1, 1));
        this.setCommandListener(this);
    }

    public void reset() {
        this.keyLock = true;
        this.score = 0;
        this.level = 1;
        this.count = 20;
        this.period = 900;
        int n = 0;
        while (n < 6) {
            this.dices[n] = Image.createImage((int)24, (int)24);
            this.dices[n].getGraphics().drawImage(this.dicesImage, -24 * n, -24 * this.video.videoRMS.diceColor, 20);
            ++n;
        }
    }

    public void setDices() {
        this.one = this.random.nextInt(6);
        this.two = this.random.nextInt(6);
        this.three = this.random.nextInt(6);
    }

    public void startDices() {
        this.setDices();
        this.changeNumbers = new VideoTimerTask(this);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.changeNumbers, this.period, (long)this.period);
        this.keyLock = false;
    }

    public void stopDices() {
        this.keyLock = true;
        --this.count;
        if (this.one == this.two && this.two == this.three) {
            if (this.video.videoRMS.isSound) {
                this.video.videoSound.playBingo();
            }
            this.score += 10;
        } else if (this.one != this.two && this.two != this.three && this.one != this.three) {
            if (this.video.videoRMS.isSound) {
                this.video.videoSound.playKO();
            }
            this.score -= 5;
        } else {
            if (this.video.videoRMS.isSound) {
                this.video.videoSound.playBingo();
            }
            this.score += 5;
        }
        if (this.score >= 100 || this.count == 0) {
            this.timer.cancel();
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.score >= 100) {
                this.level = 2;
                this.video.display.setCurrent((Displayable)this.video.videoNextLevel);
            } else {
                this.video.display.setCurrent((Displayable)this.video.videoGameOver);
            }
        } else {
            int n = this.period;
            this.period = this.score < 30 ? 900 : (this.score < 60 ? 800 : (this.score < 90 ? 700 : 600));
            if (n != this.period) {
                this.timer.cancel();
                this.changeNumbers = new VideoTimerTask(this);
                this.timer = new Timer();
                this.timer.schedule((TimerTask)this.changeNumbers, this.period, (long)this.period);
            }
            this.setDices();
            this.keyLock = false;
            this.repaint();
            this.serviceRepaints();
        }
    }

    public void keyPressed(int n) {
        if (!this.keyLock) {
            this.stopDices();
        }
    }

    public void drawScreen() {
        this.gc.setColor(255, 255, 255);
        this.gc.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.gc.setColor(0, 0, 0);
        this.gc.setFont(this.defaultFont);
        this.gc.drawString(Integer.toString(this.score), 0, 0, 0x10 | 4);
        this.gc.drawString(Integer.toString(this.count), this.getWidth(), 0, 0x10 | 8);
        this.gc.drawImage(this.dices[this.one], this.PosX, this.PosY, 0x10 | 4);
        this.gc.drawImage(this.dices[this.two], this.PosX + 25, this.PosY, 0x10 | 4);
        this.gc.drawImage(this.dices[this.three], this.PosX + 50, this.PosY, 0x10 | 4);
    }

    public void paint(Graphics graphics) {
        this.drawScreen();
        graphics.drawImage(this.buffer, 0, 0, 0);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getLabel().equals("Options")) {
            this.timer.cancel();
            this.video.display.setCurrent((Displayable)this.video.videoGameOptions);
        }
    }
}

