/*
 * Decompiled with CFR 0.152.
 */
package videostop;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import videostop.Video;
import videostop.VideoRandom;
import videostop.VideoSecondTimerTask;
import videostop.VideoText;

class VideoSecondScreen
extends Canvas
implements VideoText,
CommandListener {
    private Video video;
    private Image buffer;
    private Graphics gc;
    private Font defaultFont = Font.getDefaultFont();
    private int PosX;
    private int PosY;
    private VideoRandom random = new VideoRandom();
    private int one;
    private int two;
    private int three;
    private int four;
    private int five;
    private int six;
    int score;
    private int count;
    boolean keyLock;
    private Timer timer;
    private int period;
    private Image[] dices = new Image[6];
    private Image dicesImage;
    private VideoSecondTimerTask changeNumbers;

    VideoSecondScreen(Video video) {
        this.video = video;
        try {
            this.dicesImage = Image.createImage((String)"/smalldices.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.gc = this.buffer.getGraphics();
        this.PosX = (this.getWidth() - 65) / 2;
        this.PosY = (this.getHeight() - 43 - this.defaultFont.getHeight()) / 2;
        this.PosY += this.defaultFont.getHeight();
        this.addCommand(new Command("Options", 1, 1));
        this.setCommandListener(this);
    }

    public void reset() {
        this.keyLock = true;
        this.score = this.video.videoScreen.score;
        this.count = this.video.videoScreen.count + 20;
        this.period = 1000;
        int n = 0;
        while (n < 6) {
            this.dices[n] = Image.createImage((int)21, (int)21);
            this.dices[n].getGraphics().drawImage(this.dicesImage, -21 * n, -21 * this.video.videoRMS.diceColor, 20);
            ++n;
        }
    }

    public void setDices() {
        this.one = this.random.nextInt(6);
        this.two = this.random.nextInt(6);
        this.three = this.random.nextInt(6);
        this.four = this.random.nextInt(6);
        this.five = this.random.nextInt(6);
        this.six = this.random.nextInt(6);
    }

    public void startDices() {
        this.setDices();
        this.changeNumbers = new VideoSecondTimerTask(this);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.changeNumbers, this.period, (long)this.period);
        this.keyLock = false;
    }

    public int getScore() {
        int n;
        int[] nArray = new int[6];
        int n2 = 0;
        while (n2 < 6) {
            n = 0;
            if (this.one == n2) {
                ++n;
            }
            if (this.two == n2) {
                ++n;
            }
            if (this.three == n2) {
                ++n;
            }
            if (this.four == n2) {
                ++n;
            }
            if (this.five == n2) {
                ++n;
            }
            if (this.six == n2) {
                // empty if block
            }
            nArray[n2] = ++n;
            ++n2;
        }
        n = 0;
        n2 = 3;
        while (n2 <= 6) {
            int n3 = 0;
            while (n3 < 6) {
                if (nArray[n3] == n2) {
                    n = n2;
                }
                ++n3;
            }
            ++n2;
        }
        switch (n) {
            case 3: {
                if (this.video.videoRMS.isSound) {
                    this.video.videoSound.playBingo();
                }
                return 5;
            }
            case 4: {
                if (this.video.videoRMS.isSound) {
                    this.video.videoSound.playBingo();
                }
                return 10;
            }
            case 5: {
                if (this.video.videoRMS.isSound) {
                    this.video.videoSound.playBingo();
                }
                return 20;
            }
            case 6: {
                if (this.video.videoRMS.isSound) {
                    this.video.videoSound.playBingo();
                }
                return 35;
            }
        }
        if (this.video.videoRMS.isSound) {
            this.video.videoSound.playKO();
        }
        return -5;
    }

    public void stopDices() {
        this.keyLock = true;
        --this.count;
        this.score += this.getScore();
        if (this.count == 0) {
            this.timer.cancel();
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.video.display.setCurrent((Displayable)this.video.videoGameOver);
        } else {
            this.setDices();
            this.keyLock = false;
            this.repaint();
            this.serviceRepaints();
        }
    }

    public void keyPressed(int n) {
        if (!this.keyLock) {
            this.stopDices();
        }
    }

    public void drawScreen() {
        this.gc.setColor(255, 255, 255);
        this.gc.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.gc.setColor(0, 0, 0);
        this.gc.setFont(this.defaultFont);
        this.gc.drawString(Integer.toString(this.score), 0, 0, 0x10 | 4);
        this.gc.drawString(Integer.toString(this.count), this.getWidth(), 0, 0x10 | 8);
        this.gc.drawImage(this.dices[this.one], this.PosX, this.PosY, 0x10 | 4);
        this.gc.drawImage(this.dices[this.two], this.PosX + 22, this.PosY, 0x10 | 4);
        this.gc.drawImage(this.dices[this.three], this.PosX + 44, this.PosY, 0x10 | 4);
        this.gc.drawImage(this.dices[this.four], this.PosX, this.PosY + 22, 0x10 | 4);
        this.gc.drawImage(this.dices[this.five], this.PosX + 22, this.PosY + 22, 0x10 | 4);
        this.gc.drawImage(this.dices[this.six], this.PosX + 44, this.PosY + 22, 0x10 | 4);
    }

    public void paint(Graphics graphics) {
        this.drawScreen();
        graphics.drawImage(this.buffer, 0, 0, 0);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getLabel().equals("Options")) {
            this.timer.cancel();
            this.video.display.setCurrent((Displayable)this.video.videoGameOptions);
        }
    }
}

