/*
 * Decompiled with CFR 0.152.
 */
package ru.irnobi.magic;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import ru.irnobi.magic.MagicSuper;
import ru.irnobi.magic.Matrix;

public class Animation
implements Runnable {
    public int iNeedRefreshId = -1;
    private MagicSuper target;
    private byte[][][] arbAmimation = null;
    private Matrix mt;
    private Vector vAnim = new Vector();
    private int iAnimIndex = 0;
    private boolean fGo = false;

    public Animation(MagicSuper _target, Matrix _mt, char c) {
        this.target = _target;
        this.mt = _mt;
        this.createAnimation(String.valueOf(c));
    }

    public Animation(MagicSuper _target, Matrix _mt, String s) {
        this.target = _target;
        this.mt = _mt;
        this.createAnimation(s);
    }

    public void run() {
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.fGo || !this.canRefresh(System.currentTimeMillis())) continue;
            this.target._repaint(this.iNeedRefreshId);
        } while (this.fGo);
    }

    public void free() {
        this.fGo = false;
        this.mt = null;
        this.arbAmimation = null;
        this.vAnim.removeAllElements();
        System.gc();
    }

    public int addAnim(int index, int x, int y) {
        return this.addAnim(index, x, y, false);
    }

    public int addAnim(int index, int x, int y, boolean _cicle) {
        elAnimation el = new elAnimation(index, x, y, true, _cicle);
        this.vAnim.addElement(el);
        this.checkGo();
        return el.id;
    }

    public void delAnim(int id) {
        boolean f = true;
        for (int i = 0; i < this.vAnim.size() && f; ++i) {
            elAnimation el = (elAnimation)this.vAnim.elementAt(i);
            if (el.id != id) continue;
            f = false;
            this.vAnim.removeElement(el);
        }
        this.checkGo();
    }

    public void flyAllAnim(int x, int y) {
        for (int i = 0; i < this.vAnim.size(); ++i) {
            elAnimation el = (elAnimation)this.vAnim.elementAt(i);
            el.x += x;
            el.y += y;
        }
    }

    public void flyAnim(int index, int x, int y) {
        for (int i = 0; i < this.vAnim.size(); ++i) {
            elAnimation el = (elAnimation)this.vAnim.elementAt(i);
            if (el.id != index) continue;
            el.x += x;
            el.y += y;
        }
    }

    public boolean existAnim(int id) {
        boolean f = true;
        for (int i = 0; i < this.vAnim.size() && f; ++i) {
            elAnimation el = (elAnimation)this.vAnim.elementAt(i);
            if (el.id != id) continue;
            f = false;
        }
        return !f;
    }

    public boolean endAnim(int id) {
        boolean f = true;
        boolean fRes = false;
        for (int i = 0; i < this.vAnim.size() && f; ++i) {
            elAnimation el = (elAnimation)this.vAnim.elementAt(i);
            if (el.id != id) continue;
            f = false;
            fRes = el.end;
        }
        return fRes;
    }

    public void delAllAnim() {
        this.vAnim.removeAllElements();
        this.fGo = false;
    }

    public int getWidth(int id) {
        return this.mt.getWidth(this.arbAmimation[id][0][0]);
    }

    public void repaint(Graphics g, int left, int top) {
        for (int i = 0; i < this.vAnim.size(); ++i) {
            elAnimation el = (elAnimation)this.vAnim.elementAt(i);
            this.mt.drawImage(g, this.arbAmimation[el.index][el.curShot][0], el.x + this.arbAmimation[el.index][el.curShot][2] + left, el.y + this.arbAmimation[el.index][el.curShot][3] + top);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAnimation(String s) {
        InputStream inputstream;
        try {
            inputstream = this.getClass().getResourceAsStream("/" + s + ".anm");
        }
        catch (NullPointerException ex) {
            return;
        }
        if (inputstream == null) {
            return;
        }
        DataInputStream di = new DataInputStream(inputstream);
        int iCA = 0;
        try {
            byte b = di.readByte();
            iCA = this.byteToInt(b);
            this.arbAmimation = new byte[iCA][][];
            for (int i = 0; i < iCA; ++i) {
                b = di.readByte();
                int iCS = this.byteToInt(b);
                this.arbAmimation[i] = new byte[iCS][4];
                for (int j = 0; j < iCS; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        this.arbAmimation[i][j][k] = b = di.readByte();
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                di.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            di = null;
        }
    }

    private void checkGo() {
        int i;
        if (this.fGo) {
            boolean f = false;
            for (i = 0; i < this.vAnim.size() && !f; ++i) {
                elAnimation el = (elAnimation)this.vAnim.elementAt(i);
                f = el.move;
            }
            this.fGo = f;
        } else {
            while (i < this.vAnim.size() && !this.fGo) {
                elAnimation el = (elAnimation)this.vAnim.elementAt(i);
                this.fGo = el.move;
                ++i;
            }
            if (this.fGo) {
                new Thread(this).start();
            }
        }
    }

    private boolean canRefresh(long l) {
        boolean f = false;
        for (int i = 0; i < this.vAnim.size(); ++i) {
            elAnimation el = (elAnimation)this.vAnim.elementAt(i);
            if (el.end || (l - el.lStrart) / 20L <= (long)el.arTic[el.curShot]) continue;
            if (el.curShot + 1 != el.count || el.circle) {
                elAnimation.access$508(el);
                if (el.curShot == el.count && el.circle) {
                    el.curShot = (byte)0;
                    el.lStrart = l;
                }
                if (!el.circle) {
                    this.iNeedRefreshId = el.id;
                }
                f = true;
                continue;
            }
            this.target._end(el.id);
            this.vAnim.removeElement(el);
            f = false;
        }
        return f;
    }

    private int byteToInt(byte bt) {
        return bt & 0xF0 | bt & 0xF;
    }

    private int[] getarTic(int index) {
        int[] ar = null;
        int iS = 0;
        ar = new int[this.arbAmimation[index].length];
        for (int i = 0; i < this.arbAmimation[index].length; ++i) {
            ar[i] = iS += this.byteToInt(this.arbAmimation[index][i][1]);
        }
        return ar;
    }

    private class elAnimation {
        private int x;
        private int y;
        private int index;
        private int[] arTic = null;
        private int count;
        private int id;
        private boolean move = false;
        private boolean paint = true;
        private boolean circle = false;
        private boolean end;
        private long lStrart;
        private byte curShot;

        public elAnimation(int _index, int _x, int _y, boolean _move, boolean _circle) {
            this.index = _index;
            this.x = _x;
            this.y = _y;
            this.move = _move;
            if (this.move) {
                this.lStrart = System.currentTimeMillis();
            }
            this.curShot = 0;
            this.arTic = Animation.this.getarTic(this.index);
            this.count = this.arTic.length;
            Animation.this.iAnimIndex++;
            this.id = Animation.this.iAnimIndex;
            this.circle = _circle;
            this.end = false;
        }

        static /* synthetic */ byte access$508(elAnimation x0) {
            byte by = x0.curShot;
            x0.curShot = (byte)(by + 1);
            return by;
        }
    }
}

