/*
 * Decompiled with CFR 0.152.
 */
package ru.irnobi.magic;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Matrix {
    private Image imBack = null;
    private byte[][] arbMatrix = null;
    public boolean ready = false;
    private final int gLT;
    private final int gVH;
    private final int gTH;
    private final int gBR;
    private final int gLV;

    public Matrix(char c) {
        this.gLT = 20;
        this.gVH = 3;
        this.gTH = 17;
        this.gBR = 40;
        this.gLV = 6;
        this.createMatrix(String.valueOf(c));
    }

    public Matrix(String s) {
        this.gLT = 20;
        this.gVH = 3;
        this.gTH = 17;
        this.gBR = 40;
        this.gLV = 6;
        this.createMatrix(s);
    }

    public Matrix(Image im, String s) {
        this.gLT = 20;
        this.gVH = 3;
        this.gTH = 17;
        this.gBR = 40;
        this.gLV = 6;
        this.createMatrix(im, s);
    }

    public Matrix(Image im, char c) {
        this.gLT = 20;
        this.gVH = 3;
        this.gTH = 17;
        this.gBR = 40;
        this.gLV = 6;
        this.createMatrix(im, String.valueOf(c));
    }

    public int getWidth(int i) {
        return i < this.arbMatrix.length ? this.byteToInt(this.arbMatrix[i][2]) : -1;
    }

    public int getHeight(int i) {
        return i < this.arbMatrix.length ? this.byteToInt(this.arbMatrix[i][3]) : -1;
    }

    public void drawImage(Graphics g, int index, int x, int y) {
        this.drawImage(g, index, x, y, 20, -1, -1);
    }

    public void drawImage(Graphics g, int index, int x, int y, int anchor) {
        this.drawImage(g, index, x, y, anchor, -1, -1);
    }

    public void drawImage(Graphics g, int index, int x, int y, int anchor, int max_x, int max_y) {
        if (!this.ready) {
            return;
        }
        if (index >= this.arbMatrix.length) {
            return;
        }
        int iCX = g.getClipX();
        int iCY = g.getClipY();
        int iCW = g.getClipWidth();
        int iCH = g.getClipHeight();
        switch (anchor) {
            case 20: {
                g.setClip(x, y, max_x == -1 ? this.getWidth(index) : (x + this.getWidth(index) > max_x ? max_x - x : this.getWidth(index)), max_y == -1 ? this.getHeight(index) : (y + this.getHeight(index) > max_y ? max_y - y : this.getHeight(index)));
                g.drawImage(this.imBack, x - this.byteToInt(this.arbMatrix[index][0]), y - this.byteToInt(this.arbMatrix[index][1]), 20);
                break;
            }
            case 3: {
                g.setClip(2 * x - this.getWidth(index) >> 1, 2 * y - this.getHeight(index) >> 1, max_x == -1 ? this.getWidth(index) : (x > max_x ? max_x - (2 * x - this.getWidth(index) >> 1) : this.getWidth(index)), max_y == -1 ? this.getHeight(index) : (y > max_y ? max_y - (2 * y - this.getHeight(index) >> 1) : this.getHeight(index)));
                g.drawImage(this.imBack, (2 * x - this.getWidth(index) >> 1) - this.byteToInt(this.arbMatrix[index][0]), (2 * y - this.getHeight(index) >> 1) - this.byteToInt(this.arbMatrix[index][1]), 20);
                break;
            }
            case 17: {
                g.setClip(2 * x - this.getWidth(index) >> 1, y, max_x == -1 ? this.getWidth(index) : (x > max_x ? max_x - (2 * x - this.getWidth(index) >> 1) : this.getWidth(index)), max_y == -1 ? this.getHeight(index) : (y + this.getHeight(index) > max_y ? max_y - y : this.getHeight(index)));
                g.drawImage(this.imBack, (2 * x - this.getWidth(index) >> 1) - this.byteToInt(this.arbMatrix[index][0]), y - this.byteToInt(this.arbMatrix[index][1]), 20);
                break;
            }
            case 6: {
                g.setClip(x, y - (this.getHeight(index) >> 1), max_x == -1 ? this.getWidth(index) : (x + this.getWidth(index) > max_x ? max_x - x : this.getWidth(index)), max_y == -1 ? this.getHeight(index) : (y > max_y ? max_y - (y - (this.getHeight(index) >> 1)) : this.getHeight(index)));
                g.drawImage(this.imBack, x - this.byteToInt(this.arbMatrix[index][0]), y - (this.getHeight(index) >> 1) - this.byteToInt(this.arbMatrix[index][1]), 20);
            }
        }
        g.setClip(iCX, iCY, iCW, iCH);
    }

    public int size() {
        return this.arbMatrix == null ? 0 : this.arbMatrix.length;
    }

    public void free() {
        this.arbMatrix = null;
        this.imBack = null;
        System.gc();
    }

    private void createMatrix(String s) {
        try {
            this.imBack = Image.createImage((String)("/" + s + ".png"));
        }
        catch (IOException ex) {
            this.imBack = null;
        }
        this.LoadMatrix(s);
        this.ready = this.imBack != null && this.size() > 0;
    }

    private void createMatrix(Image im, String s) {
        this.imBack = im;
        this.LoadMatrix(s);
        this.ready = this.imBack != null && this.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void LoadMatrix(String s) {
        InputStream inputstream;
        try {
            inputstream = this.getClass().getResourceAsStream("/" + s + ".img");
        }
        catch (NullPointerException ex) {
            return;
        }
        if (inputstream == null) {
            return;
        }
        DataInputStream di = new DataInputStream(inputstream);
        try {
            byte b = di.readByte();
            int len = this.byteToInt(b);
            this.arbMatrix = new byte[len][4];
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.arbMatrix[i][j] = b = di.readByte();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                di.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            di = null;
        }
    }

    private int byteToInt(byte bt) {
        return bt & 0xF0 | bt & 0xF;
    }
}

