/*
 * Decompiled with CFR 0.152.
 */
package ru.irnobi.txt;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class WorkFont {
    public Image iBuf;
    public int[][] iPoint;
    public int[] iFontSize = new int[3];
    public int iHFont;
    public int iCurrentFont = 0;
    public int iCountFont = 0;
    public Font font = Font.getFont((int)0, (int)0, (int)8);
    private InputStream intext;
    private byte[] bProp;
    private int iColorFont = 0;
    private int iColorBack = 1048575;
    private int iSizeFile;
    private int iImageWidth;
    private int iImageHeight;
    private int iCountLetter;
    private int iLetterByte;
    int[] iB;
    int IW;
    int IH;

    public WorkFont() {
        this.iFontSize[0] = (byte)this.font.getHeight();
        this.font = Font.getFont((int)0, (int)0, (int)0);
        this.iFontSize[1] = (byte)this.font.getHeight();
        this.font = Font.getFont((int)0, (int)0, (int)16);
        this.iFontSize[2] = (byte)this.font.getHeight();
        this.iCountFont = 3;
    }

    public void setColor(int ColorFont, int ColorBack) {
        this.iColorFont = ColorFont;
        this.iColorBack = ColorBack;
    }

    public void loadImage(int iIndexFont) {
        this.iCurrentFont = iIndexFont;
        if (iIndexFont < this.iCountFont) {
            this.iHFont = this.iFontSize[iIndexFont];
        } else {
            this.iCurrentFont = 0;
            this.iHFont = this.iFontSize[0];
        }
        if (this.iCurrentFont == 0) {
            this.font = Font.getFont((int)0, (int)0, (int)8);
        } else if (this.iCurrentFont == 1) {
            this.font = Font.getFont((int)0, (int)0, (int)0);
        } else if (this.iCurrentFont == 2) {
            this.font = Font.getFont((int)0, (int)0, (int)16);
        }
    }

    public void setFontColor(int x) {
        this.iBuf.getRGB(this.iB, 0, this.IW, 0, 0, this.IW, this.IH);
        for (int i = 0; i < this.iB.length; ++i) {
            if ((0xFF000000 & this.iB[i]) == 0) continue;
            this.iB[i] = -16777216 + x;
        }
        this.iBuf = Image.createRGBImage((int[])this.iB, (int)this.IW, (int)this.IH, (boolean)true);
    }

    public int getWCH(char x) {
        return this.iPoint[(byte)x][1];
    }

    public Image getLetter(int iCode) {
        return this.getLetter(iCode, this.iColorFont, this.iColorBack);
    }

    public Image getLetter(int iCode, int ColorFont, int ColorBack) {
        Image img;
        if (iCode > 0) {
            img = Image.createImage((int)this.iPoint[iCode][1], (int)this.iHFont);
            Graphics g = img.getGraphics();
            g.setColor(ColorBack);
            g.fillRect(0, 0, img.getWidth(), this.iHFont);
            g.setColor(ColorFont);
            boolean fStop = false;
            int iYStart = this.iPoint[iCode][2];
            int iXStart = this.iPoint[iCode][0];
            int iXW = this.iPoint[iCode][1];
            this.intext = null;
            this.intext = this.getClass().getResourceAsStream("/fontin" + this.iCurrentFont + ".ar");
            if (this.intext == null) {
                System.out.println("Resource not found");
            } else {
                try {
                    int iSize = this.intext.available();
                    this.bProp = new byte[iSize];
                    this.intext.read(this.bProp);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            short iCountByteWidth = (short)(this.iImageWidth / 8);
            int iX = 0;
            int iY = 0;
            int i = 0;
            while (i < this.bProp.length && !fStop) {
                int iByte = this.byteToInt(this.bProp[i]);
                int iDec = 1;
                if (iYStart < iY) {
                    for (int j = 0; j < 8; ++j) {
                        if (iX >= iXStart && iX <= iXStart + iXW && (iByte & iDec) > 0) {
                            g.drawLine(iX - iXStart, iY - iYStart, iX - iXStart, iY - iYStart);
                        }
                        iDec *= 2;
                        ++iX;
                    }
                } else {
                    iX += 8;
                }
                if (++i % iCountByteWidth == 0) {
                    iX = 0;
                    ++iY;
                }
                if (iY <= iYStart + this.iHFont) continue;
                fStop = true;
            }
            this.bProp = null;
        } else {
            img = Image.createImage((int)4, (int)this.iHFont);
            Graphics g = img.getGraphics();
            g.setColor(ColorBack);
            g.fillRect(0, 0, 4, this.iHFont);
        }
        return img;
    }

    public Image getLetter(int iIndexFont, int iCode, int ColorFont, int ColorBack) {
        Image img;
        if (iCode > 0) {
            int[][] iP = null;
            int ilHFont = 0;
            int iIWidth = 0;
            if (iIndexFont != this.iCurrentFont) {
                int iSFile = 0;
                this.intext = null;
                this.intext = this.getClass().getResourceAsStream("/fontin" + iIndexFont + ".prop");
                this.bProp = new byte[5];
                if (this.intext == null) {
                    System.out.println("Resource not found");
                } else {
                    try {
                        iSFile = this.intext.available();
                        this.intext.read(this.bProp);
                    }
                    catch (IOException ex) {
                        this.intext = null;
                    }
                }
                if (this.intext != null) {
                    ilHFont = this.byteToInt(this.bProp[2]);
                    int iCLetter = this.byteToInt(this.bProp[3]);
                    int iLByte = this.byteToInt(this.bProp[4]);
                    iIWidth = this.byteToInt(this.bProp[0]);
                    this.bProp = new byte[iSFile - 5];
                    iP = new int[iCLetter][iLByte];
                    try {
                        this.intext.read(this.bProp);
                    }
                    catch (IOException ex) {
                        this.intext = null;
                    }
                }
                if (this.intext != null) {
                    for (int i = 0; i < this.bProp.length / 3; ++i) {
                        iP[i][0] = this.byteToInt(this.bProp[i * 3]);
                        iP[i][1] = this.byteToInt(this.bProp[i * 3 + 1]);
                        iP[i][2] = this.byteToInt(this.bProp[i * 3 + 2]);
                    }
                }
            } else {
                iP = this.iPoint;
                ilHFont = this.iHFont;
                iIWidth = this.iImageWidth;
            }
            img = Image.createImage((int)iP[iCode][1], (int)ilHFont);
            Graphics g = img.getGraphics();
            g.setColor(ColorBack);
            g.fillRect(0, 0, img.getWidth(), ilHFont);
            g.setColor(ColorFont);
            boolean fStop = false;
            int iYStart = iP[iCode][2];
            int iXStart = iP[iCode][0];
            int iXW = iP[iCode][1];
            this.intext = null;
            this.intext = this.getClass().getResourceAsStream("/fontin" + iIndexFont + ".ar");
            if (this.intext == null) {
                System.out.println("Resource not found");
            } else {
                try {
                    int iSize = this.intext.available();
                    this.bProp = new byte[iSize];
                    this.intext.read(this.bProp);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            short iCountByteWidth = (short)(iIWidth / 8);
            int iX = 0;
            int iY = 0;
            int i = 0;
            while (i < this.bProp.length && !fStop) {
                int iByte = this.byteToInt(this.bProp[i]);
                int iDec = 1;
                if (iYStart < iY) {
                    for (int j = 0; j < 8; ++j) {
                        if (iX >= iXStart && iX <= iXStart + iXW && (iByte & iDec) > 0) {
                            g.drawLine(iX - iXStart, iY - iYStart, iX - iXStart, iY - iYStart);
                        }
                        iDec *= 2;
                        ++iX;
                    }
                } else {
                    iX += 8;
                }
                if (++i % iCountByteWidth == 0) {
                    iX = 0;
                    ++iY;
                }
                if (iY <= iYStart + ilHFont) continue;
                fStop = true;
            }
            this.bProp = null;
        } else {
            img = Image.createImage((int)4, (int)this.iHFont);
            Graphics g = img.getGraphics();
            g.setColor(ColorBack);
            g.fillRect(0, 0, 4, this.iHFont);
        }
        return img;
    }

    private int byteToInt(byte bt) {
        return bt & 0xF0 | bt & 0xF;
    }

    private int[] addProp(int iProp, int[] iDesc) {
        int[] iAr;
        if (iDesc == null) {
            iAr = new int[]{iProp};
        } else {
            iAr = new int[iDesc.length + 1];
            for (int i = 0; i < iDesc.length; ++i) {
                iAr[i] = iDesc[i];
            }
            iAr[iDesc.length] = iProp;
        }
        return iAr;
    }
}

