/*
 * Decompiled with CFR 0.152.
 */
package handson;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.Menu;
import tinbrain.RM;

public final class Handson {
    public static final String[] HANDSON_LANGUAGE_CODES = new String[]{"en-GB", "fr-FR", "it-IT", "de-DE", "es-ES", "cs-CZ"};
    private static String forcedLocale;
    private static int sLanguagesAvailable;
    private static boolean sMoreGamesBuySetupRead;
    private static boolean sMoreGamesMenu;
    private static boolean sMoreGamesExit;
    private static String sMoreGamesUrl;
    public static String sMoreGamesLabel;
    private static int sOutroTimer;
    private static int sSwitchToOutroTimer;
    private static boolean sDemoModeEnabled;
    private static boolean sHelpMenuTextIsPrepared;
    private static String sMrcUrl;
    private static int sCustomWidth;
    private static int sCustomHeight;
    private static int sRSK;
    private static boolean sUseMrcService;
    private static int sMrcState;
    private static boolean sIsValidLicense;

    public static void init() {
        Handson.loadLanguageSetupFromJad();
        Handson.moreGamesReadBuySetup();
        Handson.demoInit();
        Handson.mrcReadJadParams();
    }

    private static boolean languageIsAvailable(int n) {
        return (sLanguagesAvailable & 1 << n) != 0;
    }

    public static String getForcedLocale() {
        return forcedLocale;
    }

    private static void loadLanguageSetupFromJad() {
        int n = Handson.establishLanguageSetup();
        forcedLocale = n != -1 ? HANDSON_LANGUAGE_CODES[n] : null;
    }

    private static int establishLanguageSetup() {
        int n;
        int n2;
        String string = Menu.readJad("Force-Locale");
        if (string != null) {
            for (n2 = 0; n2 < HANDSON_LANGUAGE_CODES.length; ++n2) {
                if (HANDSON_LANGUAGE_CODES[n2] != string) continue;
                return n2;
            }
        }
        n2 = HANDSON_LANGUAGE_CODES.length;
        int n3 = 0;
        int n4 = -1;
        String string2 = Menu.readJad("HO-LangList");
        if (string2 != null) {
            for (n = 0; n < n2; ++n) {
                if (string2.indexOf(HANDSON_LANGUAGE_CODES[n]) < 0 && (HANDSON_LANGUAGE_CODES[n].compareTo("en-GB") != 0 || string2.indexOf("en-US") < 0) && (HANDSON_LANGUAGE_CODES[n].compareTo("en-US") != 0 || string2.indexOf("en-GB") < 0)) continue;
                sLanguagesAvailable |= 1 << n;
                n4 = n;
                ++n3;
            }
        }
        if (n3 == 1) {
            return n4;
        }
        if (n3 == 0) {
            for (n = 0; n < n2; ++n) {
                sLanguagesAvailable |= 1 << n;
            }
        }
        return -1;
    }

    private static void moreGamesReadBuySetup() {
        if (!sMoreGamesBuySetupRead) {
            String string = Menu.readJad("HO-BuySetup");
            if (string != null) {
                sMoreGamesMenu = string.indexOf("menu") != -1;
                sMoreGamesExit = string.indexOf("exit") != -1;
            } else {
                sMoreGamesExit = false;
                sMoreGamesMenu = false;
            }
            sMoreGamesBuySetupRead = true;
        }
    }

    private static boolean moreGamesIsMenu() {
        return sMoreGamesMenu && sMoreGamesUrl != null;
    }

    private static boolean moreGamesIsExit() {
        return sMoreGamesExit && sMoreGamesUrl != null;
    }

    private static String handsonGetLocaleJadParameter(String string) {
        String string2 = HANDSON_LANGUAGE_CODES[RM.languageIndex];
        string = string + string2;
        return Menu.readJad(string);
    }

    private static void moreGamesReadLabel() {
        int n;
        sMoreGamesLabel = Handson.parseUnicode(Handson.handsonGetLocaleJadParameter("HO-Label-"));
        if (sMoreGamesLabel != null && sMoreGamesLabel.length() == 0) {
            sMoreGamesLabel = null;
        }
        if (sMoreGamesLabel != null && (n = sMoreGamesLabel.length()) > 16) {
            sMoreGamesLabel = sMoreGamesLabel.substring(0, 16);
        }
    }

    private static String moreGamesReadUrl() {
        String string = HANDSON_LANGUAGE_CODES[RM.languageIndex];
        String string2 = "HO-URL-" + string;
        sMoreGamesUrl = Menu.readJad(string2);
        return sMoreGamesUrl;
    }

    public static final String moreGamesGetUrl() {
        return sMoreGamesUrl;
    }

    private static void demoInit() {
        String string = Menu.readJad("HO-Demo") + "";
        sDemoModeEnabled = string == null || string.length() <= 0 || string.compareTo("P3TG0TJ0H") != 0;
    }

    public static boolean demoIsActive() {
        return sDemoModeEnabled;
    }

    private static String parseUnicode(String string) {
        if (string != null && string.indexOf("\\u") >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            char[] cArray = new char[4];
            do {
                if (stringBuffer.charAt(n++) != '\\' || stringBuffer.charAt(n) != 'u') continue;
                stringBuffer.getChars(n + 1, n + 5, cArray, 0);
                stringBuffer.setCharAt(n - 1, (char)Integer.parseInt(new String(cArray), 16));
                stringBuffer.delete(n, n + 5);
            } while (n < stringBuffer.length());
            string = stringBuffer.toString();
        }
        return string;
    }

    private static void prepareHelpMenuText(boolean bl) {
        if (sHelpMenuTextIsPrepared && !bl) {
            return;
        }
        sHelpMenuTextIsPrepared = true;
        if (Handson.demoIsActive()) {
            if (Handson.moreGamesIsMenu()) {
                RM.prepareVarText(22, RM.t(21));
                RM.prepareVarText(24, RM.t(65), RM.t(22));
                return;
            }
            RM.prepareVarText(24, RM.t(65), "");
            return;
        }
        if (Handson.moreGamesIsMenu()) {
            RM.prepareVarText(23, RM.t(21));
            RM.prepareVarText(24, RM.t(65), RM.t(23));
            return;
        }
        RM.setString(24, RM.t(65));
    }

    private static void prepareMenuExpiredScreen() {
        int n = 340;
        if (Handson.moreGamesGetUrl() == null) {
            Menu.setSoftkeys(22, -1, 29);
            n = 341;
        } else {
            Menu.setSoftkeys(22, 28, 29);
        }
        RM.prepareVarText(19, Menu.getMidletInfo(0), RM.t(n));
    }

    public static void onLanguageChanged() {
        Handson.prepareMoreGamesLabel();
        Handson.moreGamesReadUrl();
        Handson.prepareHelpMenuText(true);
    }

    private static void prepareMoreGamesLabel() {
        Handson.moreGamesReadLabel();
        if (sMoreGamesLabel == null || sMoreGamesLabel.length() == 0) {
            sMoreGamesLabel = Handson.demoIsActive() ? new String(RM.t(343)) : new String(RM.t(20));
        }
        RM.prepareVarText(21, sMoreGamesLabel);
    }

    public static boolean performMenuAction$255f299(int n) {
        switch (n) {
            case 40: {
                Menu.changeMenu(24, false);
                return true;
            }
            case 43: {
                Menu.changeMenu(Handson.demoIsActive() ? 22 : 24, false);
                return true;
            }
            case 42: {
                if (Handson.demoIsActive()) {
                    Menu.changeMenu(22, false);
                } else {
                    Menu.performMenuAction(12);
                }
                return true;
            }
        }
        return false;
    }

    public static int evaluateCondition$255f288(int n) {
        switch (n) {
            case 11: {
                if (Handson.demoIsActive()) {
                    return 1;
                }
                return -1;
            }
            case 12: {
                if (!Handson.demoIsActive()) {
                    return 1;
                }
                return -1;
            }
            case 9: {
                if (Handson.demoIsActive()) {
                    return -1;
                }
                if (Handson.moreGamesIsMenu()) {
                    return 1;
                }
                return -1;
            }
            case 10: {
                if (Handson.demoIsActive()) {
                    if (Handson.moreGamesIsMenu()) {
                        return 1;
                    }
                    return -1;
                }
                return -1;
            }
            case 8: {
                if (Handson.getForcedLocale() != null) {
                    return -1;
                }
                return 0;
            }
        }
        return 0;
    }

    public static void prepareMenuChange$255f295(int n) {
        Menu.showUpDownArrows(n == 24);
        if (n == 22) {
            sSwitchToOutroTimer = 5000;
            Handson.prepareMenuExpiredScreen();
            return;
        }
        if (n == 23) {
            Handson.prepareMenuExpiredScreen();
            return;
        }
        if (n == 24) {
            Menu.stopMusic();
            sOutroTimer = 5000;
            if (Handson.demoIsActive()) {
                Menu.setMenuOption(24, 3, (byte)-1);
                Menu.setMenuOption(24, 4, (byte)-1);
                sOutroTimer = 2000;
            } else if (Handson.moreGamesIsExit()) {
                Menu.setMenuOption(24, 3, (byte)30);
            }
            Menu.setMenuCaptionImage(-1);
            return;
        }
        if (n == 28) {
            Handson.prepareLanguageSelectionMenu();
        }
    }

    private static void prepareLanguageSelectionMenu() {
        if (Menu.getMenuItemCount(28) != 0) {
            return;
        }
        if (Handson.languageIsAvailable(0)) {
            Menu.addMenuItem(28, 99, 39, 0, -1);
        }
        if (Handson.languageIsAvailable(1)) {
            Menu.addMenuItem(28, 100, 39, 1, -1);
        }
        if (Handson.languageIsAvailable(2)) {
            Menu.addMenuItem(28, 102, 39, 2, -1);
        }
        if (Handson.languageIsAvailable(3)) {
            Menu.addMenuItem(28, 101, 39, 3, -1);
        }
        if (Handson.languageIsAvailable(4)) {
            Menu.addMenuItem(28, 103, 39, 4, -1);
        }
    }

    public static final boolean menuProcessActions() {
        switch (Menu.getCurrentMenu()) {
            case 22: {
                if ((sSwitchToOutroTimer -= 42) >= 0) break;
                Menu.performMenuAction(40);
                return true;
            }
            case 24: {
                if ((sOutroTimer -= 42) >= 0) break;
                Menu.performMenuAction(12);
                return true;
            }
        }
        return false;
    }

    public static boolean menuDrawOutroScreen(Graphics graphics, int n) {
        if (n != 24) {
            return false;
        }
        int n2 = Menu.getSplashID(0);
        if (!RM.isLoaded(n2) && RM.getType(n2) != 17) {
            RM.preload(n2);
        }
        Menu.drawSplashImage(graphics, 0);
        GCanvas.drawString(graphics, 1, RM.t(347), GCanvas.getWidth() >> 1, 0, 17);
        int n3 = 0;
        int n4 = GCanvas.getFontHeight(1);
        n3 = n4 + 1;
        GCanvas.drawString(graphics, 1, RM.t(348), GCanvas.getWidth() >> 1, n3, 17);
        return true;
    }

    public static boolean mrcUse() {
        return sUseMrcService;
    }

    public static int keycodeRSK() {
        return sRSK;
    }

    private static void mrcReadJadParams() {
        String string = null;
        string = Menu.readJad("Subscription-URL");
        boolean bl = sUseMrcService = string != null && !string.equals("");
        if (sUseMrcService) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append("?");
            string = Menu.readJad("Mserver-SKU-Id");
            stringBuffer.append("p=" + string);
            string = Menu.readJad("Mserver-Carrier-Id");
            stringBuffer.append("&c=" + string);
            string = Menu.readJad("HOM_arSource");
            if (string != null) {
                stringBuffer.append("&source=" + string);
            }
            if ((string = Menu.readJad("HOM_arPrefix")) != null) {
                stringBuffer.append("&uuid=" + string);
                string = Menu.readJad("CarrierDeviceId");
                stringBuffer.append(string);
            }
            string = Menu.readJad("Mserver-User-Id");
            stringBuffer.append("&msisdn=" + string);
            string = Menu.readJad("CarrierDeviceId");
            stringBuffer.append("&subid=" + string);
            sMrcUrl = stringBuffer.toString();
        }
        boolean bl2 = false;
        string = Menu.readJad("WIDTH");
        if (string != null) {
            sCustomWidth = Integer.parseInt(string);
            bl2 = true;
        } else {
            sCustomWidth = GCanvas.getWidth();
        }
        string = Menu.readJad("HEIGHT");
        if (string != null) {
            sCustomHeight = Integer.parseInt(string);
            bl2 = true;
        } else {
            sCustomHeight = GCanvas.getHeight();
        }
        if (bl2) {
            GCanvas.setForcedSize(sCustomWidth, sCustomHeight);
        }
        if ((string = Menu.readJad("RSK")) != null) {
            try {
                sRSK = Integer.parseInt(string);
                return;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static StringBuffer readHttpConnection(String string, String string2) {
        block30: {
            FilterInputStream filterInputStream;
            HttpConnection httpConnection;
            block29: {
                httpConnection = null;
                filterInputStream = null;
                httpConnection = (HttpConnection)Connector.open((String)string);
                httpConnection.setRequestMethod("POST");
                httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                httpConnection.setRequestProperty("Connection", "close");
                Object object = new DataOutputStream(httpConnection.openOutputStream());
                ((OutputStream)object).write(string2.getBytes());
                if (httpConnection.getResponseCode() != 200) break block29;
                object = new StringBuffer();
                filterInputStream = new DataInputStream(httpConnection.openInputStream());
                long l = httpConnection.getLength();
                if (l != -1L) {
                    int n = 0;
                    while ((long)n < l) {
                        int n2 = filterInputStream.read();
                        if (n2 != -1) {
                            ((StringBuffer)object).append((char)n2);
                        } else {
                            while ((n2 = filterInputStream.read()) != -1) {
                                ((StringBuffer)object).append((char)n2);
                            }
                        }
                        ++n;
                    }
                }
                Object object2 = object;
                try {
                    if (httpConnection != null) {
                        httpConnection.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
                return object2;
            }
            try {
                if (httpConnection != null) {
                    httpConnection.close();
                }
                break block30;
            }
            catch (IOException iOException) {}
            break block30;
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (httpConnection != null) {
                            httpConnection.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    try {
                        if (filterInputStream != null) {
                            filterInputStream.close();
                        }
                    }
                    catch (IOException iOException3) {}
                    throw throwable;
                }
                try {
                    if (httpConnection != null) {
                        httpConnection.close();
                    }
                }
                catch (IOException iOException4) {}
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                }
                catch (IOException iOException5) {}
            }
        }
        return null;
    }

    private static boolean login() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sMrcUrl;
        int n = string.indexOf(63);
        if (n > -1) {
            stringBuffer.append(string.substring(n + 1));
            string = string.substring(0, n);
        }
        StringBuffer stringBuffer2 = null;
        stringBuffer2 = Handson.readHttpConnection(string, stringBuffer.toString());
        if (stringBuffer2 != null) {
            if ("X".equals(stringBuffer2.toString())) {
                return false;
            }
            if ("S20500101".equals(stringBuffer2.toString())) {
                return true;
            }
        }
        return false;
    }

    public static void mrcHandleLicense() {
        if (sMrcState != 1) {
            return;
        }
        try {
            sIsValidLicense = Handson.login();
        }
        catch (Exception exception) {}
        if (sIsValidLicense) {
            sMrcState = 3;
            Menu.changeMode(0, -1);
            Menu.splashFinished();
            return;
        }
        sMrcState = 2;
        Menu.changeMenu(27, false);
    }

    public static int drawCustomMenu$26c5357f(int n) {
        return 0;
    }

    public static boolean resumeMusic() {
        int n = Menu.getCurrentMenu();
        return n != 24 && n != 23 && n != 22;
    }

    static {
        sLanguagesAvailable = 0;
        sMoreGamesBuySetupRead = false;
        sMoreGamesMenu = false;
        sMoreGamesExit = false;
        sMoreGamesUrl = null;
        sMoreGamesLabel = null;
        sOutroTimer = 0;
        sSwitchToOutroTimer = 0;
        sDemoModeEnabled = false;
        sHelpMenuTextIsPrepared = false;
        sCustomWidth = -1;
        sCustomHeight = -1;
        sRSK = -7;
        sUseMrcService = false;
        sMrcState = 1;
        sIsValidLicense = false;
    }
}

