/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundSystem {
    private static SoundSystem object = null;
    public static final int SOUND_HIT_BALL_WAV = 0;
    public static final int SOUND_MENU = 0;
    public static final int SOUND_MELODY = 1;
    public static final int SOUND_YOU_SCORED = 2;
    public static final int SOUND_HE_SCORED = 3;
    public static final int SOUND_GAME_START = 4;
    public static final int SING_SOUND = 5;
    public static final int SING_MUSIC = 6;
    public static int whoSing = 6;
    private static String[] soundFile = new String[]{"/Sound/hit_ball.mid", "/Sound/melody.mid", "/Sound/happy.mid", "/Sound/sad.mid", "/Sound/game_start.mid"};
    public static Player[] players = new Player[soundFile.length];
    private static Player player = null;
    private static int index = 0;
    private static String msg = new String();
    public static final int SOUND_ON = 0;
    public static final int SOUND_OFF = 1;
    public static int soundState = 0;
    public static final int MUSIC_ON = 0;
    public static final int MUSIC_OFF = 1;
    public static int musicState = 0;
    private static Player nusicPlayer = null;

    public SoundSystem() {
        if (object == null) {
            object = this;
            this.initSound();
        }
    }

    private void initSound() {
        InputStream is = null;
        for (int i = 0; i < soundFile.length; ++i) {
            try {
                is = this.getClass().getResourceAsStream(soundFile[i]);
                if (is != null) {
                    SoundSystem.players[i] = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                    players[i].realize();
                    players[i].prefetch();
                    continue;
                }
                SoundSystem.players[i] = null;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        nusicPlayer = players[1];
    }

    public static void reset() {
        SoundSystem.close();
        object = null;
        player = null;
    }

    public static void close() {
        for (int i = 0; i < soundFile.length; ++i) {
            if (players[i] != null) {
                players[i].close();
            }
            SoundSystem.players[i] = null;
        }
    }

    public static final SoundSystem getObject() {
        if (object == null) {
            new SoundSystem();
        }
        return object;
    }

    public static void play(int index) {
        if (soundState == 1) {
            return;
        }
        if (whoSing == 6) {
            return;
        }
        try {
            SoundSystem.stopPlayer();
            player = players[index];
            player.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void playMusic() {
        if (musicState == 1) {
            return;
        }
        if (whoSing == 5) {
            return;
        }
        try {
            nusicPlayer.stop();
            nusicPlayer.setLoopCount(-1);
            nusicPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopMusic() {
        try {
            nusicPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void discardPlayer() {
        if (player != null) {
            player.close();
            player = null;
        }
    }

    public static void stopPlayer() {
        if (player != null) {
            try {
                player.stop();
                nusicPlayer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

