/*
 * Decompiled with CFR 0.152.
 */
package Bubble;

import Bubble.AFont;
import Bubble.BubbleIO;
import Bubble.LocalizationSupport;
import Bubble.ScoreEntry;
import Bubble.ScoreScreen;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Scores {
    static final int MAX_SCORE_ENTRIES = 6;
    public static ScoreEntry[] scoreEntries;
    private Font smallBoldItalicFont;
    private Font smallFont;
    ScoreScreen scorescreen;
    int width;
    int height;
    int currentYValue = 53;
    int currentYValue1 = 73;
    int nFontHeight;

    public Scores(ScoreScreen scorescreen) {
        this.scorescreen = scorescreen;
        this.width = scorescreen.width;
        this.height = scorescreen.height;
    }

    public Scores() {
        scoreEntries = new ScoreEntry[6];
        for (int i = 0; i < 6; ++i) {
            Scores.scoreEntries[i] = new ScoreEntry();
            scoreEntries[i].set("Dummy", 0, 0);
        }
        this.smallBoldItalicFont = Font.getFont((int)0, (int)3, (int)8);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
    }

    public void draw(Graphics g, int screenWidth) {
        AFont.drawString(g, LocalizationSupport.getMessage("SCORE_PLAYER"), 3, this.currentYValue, 20);
        AFont.drawString(g, LocalizationSupport.getMessage("SCORE_SCORE"), screenWidth / 2, this.currentYValue, 20);
        AFont.drawString(g, LocalizationSupport.getMessage("SCORE_LEVEL"), screenWidth * 3 / 4, this.currentYValue, 20);
        this.nFontHeight = this.smallFont.getHeight() - 5;
        g.setFont(this.smallFont);
        for (int i = 0; i < 6; ++i) {
            AFont.drawString(g, Scores.scoreEntries[i].playerName, 3, i * this.nFontHeight + this.currentYValue1, 20);
            AFont.drawString(g, "" + Scores.scoreEntries[i].score, screenWidth / 2, i * this.nFontHeight + this.currentYValue1, 20);
            AFont.drawString(g, "" + Scores.scoreEntries[i].level, screenWidth * 3 / 4, i * this.nFontHeight + this.currentYValue1, 20);
        }
    }

    public boolean isScoreHighEnough(int score) {
        return Scores.scoreEntries[5].score < score;
    }

    public void resetScores() {
        for (int i = 0; i < 6; ++i) {
            scoreEntries[i].set("Dummy", 0, 0);
        }
        this.writeScores();
    }

    public void insertHighscore(String name, int score, byte level) {
        int insertHere = 0;
        for (int i = 0; i < 6; ++i) {
            if (score <= Scores.scoreEntries[i].score) continue;
            insertHere = i;
            break;
        }
        for (int n = 5; n > insertHere; --n) {
            scoreEntries[n].set(scoreEntries[n - 1]);
        }
        scoreEntries[insertHere].set(name, score, level);
        this.writeScores();
    }

    public void writeScores() {
        BubbleIO.write("HighScore", this.scoresToByteArray());
    }

    public void readScores() {
        byte[] data = BubbleIO.read("HighScore");
        if (data != null) {
            this.byteArrayToScores(data);
        }
    }

    private byte[] scoresToByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            for (int i = 0; i < 6; ++i) {
                os.writeUTF(Scores.scoreEntries[i].playerName);
                os.writeInt(Scores.scoreEntries[i].score);
                os.writeInt(Scores.scoreEntries[i].level);
            }
            os.close();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        return baos.toByteArray();
    }

    private void byteArrayToScores(byte[] data) {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            for (int i = 0; i < 6; ++i) {
                Scores.scoreEntries[i].playerName = is.readUTF();
                Scores.scoreEntries[i].score = is.readInt();
                Scores.scoreEntries[i].level = is.readInt();
            }
            is.close();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
    }
}

