/*
 * Decompiled with CFR 0.152.
 */
package body.interaction;

import body.RigidBody;
import body.interaction.Contact;
import java.util.Vector;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class Projection {
    protected boolean kolizja;
    protected boolean penetracja;
    protected boolean zblizanie;
    public Vector2d wr = new Vector2d();
    public Vector2d[] dropPos;
    protected Vector2d[] dropVel;
    protected Vector2d[] dropRay;
    public Vector2d[] peakPos;
    protected Vector2d[] peakVel;
    protected Vector2d[] peakRay;
    protected int[] rzut0 = new int[2];
    protected int[] rzut1 = new int[2];
    protected int[] rzutPom0 = new int[2];
    protected int[] rzutPom1 = new int[2];
    protected Vector2d crossVelVec = new Vector2d();
    protected int dist;
    protected int drV;
    protected int vr0sc;
    protected int vr1sc;
    protected int vwzgl;
    protected int dr;

    protected void setNearestNormals(RigidBody body1, RigidBody body2, Vector2d wr) {
        int i;
        wr.setSubFP(body1.pos, body2.pos);
        for (i = 0; i < body1.n.length; ++i) {
            body1.n[i].scaleFP(-this.signumFP(wr.dotFP(body1.n[i])));
        }
        for (i = 0; i < body2.n.length; ++i) {
            body2.n[i].scaleFP(this.signumFP(wr.dotFP(body2.n[i])));
        }
    }

    protected void calculatePeakRayData(RigidBody body, Vector2d peakRay, Vector2d peakPos, Vector2d peakVel) {
        peakPos.setAddFP(body.pos, peakRay);
        this.calculatePointVelocity(body, peakRay, peakVel);
    }

    protected int getDistanceToPlane(RigidBody a, Vector2d p, Vector2d n) {
        Vector2d vec = new Vector2d();
        vec.setSubFP(a.pos, p);
        return vec.dotFP(n);
    }

    protected int calculatePlaneProjectionData(Vector2d pos, Vector2d n, Vector2d p, Vector2d dropRay, Vector2d dropPos, Vector2d dropVel) {
        Vector2d v = new Vector2d();
        v.setSubFP(pos, p);
        this.dist = v.dotFP(n);
        v.setScaleFP(this.dist, n);
        dropRay.setToFP(0, 0);
        dropVel.setToFP(0, 0);
        dropPos.setSubFP(pos, v);
        return this.dist;
    }

    protected void calculateDropRayData(RigidBody body, int[] rzutPom, Vector2d dropRay, Vector2d dropPos, Vector2d dropVel) {
        this.calculateDropRay(rzutPom, body.n, dropRay);
        dropPos.setAddFP(body.pos, dropRay);
        this.calculatePointVelocity(body, dropRay, dropVel);
    }

    protected void calculateDropRay(int[] rzutPom, Vector2d[] bodyN, Vector2d dropRay) {
        int x = MathFP.toFP(0);
        int y = MathFP.toFP(0);
        for (int i = 0; i < bodyN.length; ++i) {
            x += MathFP.mul(rzutPom[i], bodyN[i].x);
            y += MathFP.mul(rzutPom[i], bodyN[i].y);
        }
        dropRay.setFP(x, y);
    }

    public void calculatePointVelocity(RigidBody body, Vector2d ray, Vector2d vel) {
        this.crossVelVec.setCrossFP(body.omega, ray);
        vel.setAddFP(body.vel, this.crossVelVec);
    }

    protected void calculateRigidBodyPointNormalsProjections(int[] rzut, RigidBody body, Vector2d vec) {
        Vector2d v = new Vector2d();
        v.setSubFP(vec, body.pos);
        for (int i = 0; i < body.n.length; ++i) {
            rzut[i] = v.dotFP(body.n[i]);
        }
    }

    protected void setRigidBodyPointRzutyPom(RigidBody body, int[] rzut, int[] rzutPom, int nr) {
        for (int i = 0; i < rzut.length; ++i) {
            if (rzut[i] >= body.halfEdge[i]) {
                rzutPom[i] = body.halfEdge[i];
                continue;
            }
            if (rzut[i] <= -body.halfEdge[i]) {
                rzutPom[i] = -body.halfEdge[i];
                continue;
            }
            if (MathFP.abs(rzut[i]) >= body.halfEdge[i]) continue;
            rzutPom[i] = rzut[i];
        }
    }

    protected boolean checkSimpleCollisionCondition(Contact ct, int dt, int odl0, int odl1) {
        this.kolizja = false;
        this.dr = 0;
        this.vr0sc = ct.v[0].dotFP(ct.n);
        this.vr1sc = ct.v[1].dotFP(ct.n);
        this.vwzgl = MathFP.sub(this.vr0sc, this.vr1sc);
        this.dr = MathFP.mul(MathFP.abs(this.vwzgl), dt);
        this.zblizanie = this.vwzgl < 0;
        this.kolizja = this.getCollision(ct.dist, this.dr, this.vwzgl, odl0, odl1);
        return this.kolizja;
    }

    protected boolean checkIfSurroundingRectsColliding(RigidBody a, RigidBody b) {
        return MathFP.abs(MathFP.sub(a.pos.x, b.pos.x)) <= MathFP.add(a.surrRectHalfSide, b.surrRectHalfSide) && MathFP.abs(MathFP.sub(a.pos.y, b.pos.y)) <= MathFP.add(a.surrRectHalfSide, b.surrRectHalfSide);
    }

    private boolean getCollision(int d, int dr, int vwzgl, int odl1, int odl2) {
        this.kolizja = false;
        this.kolizja = MathFP.sub(d, dr) <= MathFP.add(odl1, odl2) && vwzgl < 0;
        return this.kolizja;
    }

    protected int getProjectionLengthOnVector(Vector2d vec, Vector2d n) {
        return vec.dotFP(n);
    }

    public int restContactsFindingProcedure(Contact ct, int dtFP, int eFP, Vector restCtVec) {
        return 0;
    }

    protected boolean checkIfColliding(Contact ct, int dt) {
        this.penetracja = false;
        this.kolizja = false;
        this.zblizanie = false;
        this.kolizja = this.checkSimpleCollisionCondition(ct, dt, MathFP.toFP(0), MathFP.toFP(0));
        return this.kolizja && this.zblizanie;
    }

    public boolean collContactsFindingProcedure(Contact ct, int dtFP, int eFP, Vector collCtVec) {
        this.penetracja = false;
        this.kolizja = false;
        this.zblizanie = false;
        this.kolizja = this.checkSimpleCollisionCondition(ct, dtFP, MathFP.toFP(0), MathFP.toFP(0));
        if (this.kolizja && this.zblizanie) {
            collCtVec.addElement(ct);
            return true;
        }
        return false;
    }

    public int signumFP(int a) {
        int z = MathFP.toFP(0);
        if (a < MathFP.toFP(0)) {
            z = MathFP.toFP(-1);
        } else if (a == MathFP.toFP(0)) {
            z = MathFP.toFP(0);
        } else if (a > MathFP.toFP(0)) {
            z = MathFP.toFP(1);
        }
        return z;
    }
}

