/*
 * Decompiled with CFR 0.152.
 */
package body.interaction;

import body.Cuboid;
import body.RigidBody;
import body.interaction.Contact;
import body.interaction.Projection;
import maths.Vector2d;

public class ProjectionCuboidCuboid
extends Projection {
    Cuboid cb0;
    Cuboid cb1;
    int numpeaksRayPos = 4;
    int numpeaksVel = 2;
    int numedgepoints = 2;
    int numdrops = 2;
    int numlines = 2;
    int[] nIndex = new int[2];
    int normalIndex;
    int ortoNormalIndex = 0;
    int[] d = new int[3];
    Vector2d[] wrs = new Vector2d[3];

    public void init() {
        int i;
        this.dropPos = new Vector2d[this.numdrops];
        this.dropRay = new Vector2d[this.numdrops];
        this.dropVel = new Vector2d[this.numdrops];
        this.peakPos = new Vector2d[this.numpeaksRayPos];
        this.peakRay = new Vector2d[this.numpeaksRayPos];
        this.peakVel = new Vector2d[this.numpeaksVel];
        for (i = 0; i < this.peakRay.length; ++i) {
            this.peakRay[i] = new Vector2d();
            this.peakPos[i] = new Vector2d();
        }
        for (i = 0; i < this.peakVel.length; ++i) {
            this.peakVel[i] = new Vector2d();
        }
        for (i = 0; i < this.numdrops; ++i) {
            this.dropPos[i] = new Vector2d();
            this.dropVel[i] = new Vector2d();
            this.dropRay[i] = new Vector2d();
        }
        this.crossVelVec = new Vector2d();
        for (i = 0; i < this.wrs.length; ++i) {
            this.wrs[i] = new Vector2d();
        }
    }

    public ProjectionCuboidCuboid() {
        this.init();
    }

    public void setBodyTypes(RigidBody body0, RigidBody body1) {
        this.cb0 = (Cuboid)body0;
        this.cb1 = (Cuboid)body1;
    }

    public void calculateCubesPeakRaysAndProjections(Cuboid cube1, Cuboid cube2, int[] rzut1, int[] rzut2, Vector2d peakRay1, Vector2d peakRay2, Vector2d wr) {
        int i;
        peakRay1.setToFP(0, 0);
        peakRay2.setToFP(0, 0);
        cube1.setScaledNormals();
        cube2.setScaledNormals();
        for (i = 0; i < cube1.nScaled.length; ++i) {
            peakRay1.add(cube1.nScaled[i]);
            peakRay2.add(cube2.nScaled[i]);
        }
        for (i = 0; i < rzut2.length; ++i) {
            rzut2[i] = peakRay1.addVecFP(wr).dotFP(cube2.n[i]);
            rzut1[i] = peakRay2.subVecFP(wr).dotFP(cube1.n[i]);
        }
    }

    public void bodiesProjectionProcedure(RigidBody body0, RigidBody body1) {
        this.cb0 = (Cuboid)body0;
        this.cb1 = (Cuboid)body1;
        this.setNearestNormals(this.cb0, this.cb1, this.wr);
        this.calculateCubesPeakRaysAndProjections(this.cb0, this.cb1, this.rzut0, this.rzut1, this.peakRay[0], this.peakRay[1], this.wr);
        this.setRigidBodyPointRzutyPomL(this.cb0, this.rzut0, this.rzutPom0, 0);
        this.calculateDropRayData(this.cb0, this.rzutPom0, this.dropRay[0], this.dropPos[0], this.dropVel[0]);
        this.calculatePeakRayData(this.cb0, this.peakRay[0], this.peakPos[0], this.peakVel[0]);
        this.setRigidBodyPointRzutyPomL(this.cb1, this.rzut1, this.rzutPom1, 1);
        this.calculateDropRayData(this.cb1, this.rzutPom1, this.dropRay[1], this.dropPos[1], this.dropVel[1]);
        this.calculatePeakRayData(this.cb1, this.peakRay[1], this.peakPos[1], this.peakVel[1]);
        this.d[0] = this.peakPos[1].dist(this.dropPos[0]);
        this.wrs[0].set(this.cb0.n[this.nIndex[0]]);
        this.d[1] = this.peakPos[0].dist(this.dropPos[1]);
        this.wrs[1].set(this.cb1.n[this.nIndex[1]]);
    }

    public void setContacts(Contact[] ccCt, RigidBody a, RigidBody b, int id) {
        this.cb0 = (Cuboid)a;
        this.cb1 = (Cuboid)b;
        this.bodiesProjectionProcedure(this.cb0, this.cb1);
        ccCt[0].setContact(this.cb1, this.cb0, this.peakPos[1], this.dropPos[0], this.peakRay[1], this.dropRay[0], this.peakVel[1], this.dropVel[0], this.wrs[0], this.d[0], id);
        ccCt[1].setContact(this.cb0, this.cb1, this.peakPos[0], this.dropPos[1], this.peakRay[0], this.dropRay[1], this.peakVel[0], this.dropVel[1], this.wrs[1], this.d[1], id);
    }

    public boolean checkIfSurroundingRectsColliding(RigidBody a, RigidBody b) {
        this.cb0 = (Cuboid)a;
        this.cb1 = (Cuboid)b;
        return super.checkIfSurroundingRectsColliding(this.cb0, this.cb1);
    }

    public boolean checkIfColliding(Contact cwCt, int dt) {
        return super.checkIfColliding(cwCt, dt);
    }

    protected void setRigidBodyPointRzutyPomL(RigidBody body, int[] rzut, int[] rzutPom, int nr) {
        for (int i = 0; i < rzut.length; ++i) {
            if (rzut[i] >= body.halfEdge[i]) {
                rzutPom[i] = body.halfEdge[i];
                this.normalIndex = i;
                this.nIndex[nr] = i;
                continue;
            }
            if (rzut[i] <= -body.halfEdge[i]) {
                rzutPom[i] = -body.halfEdge[i];
                this.normalIndex = i;
                this.nIndex[nr] = i;
                continue;
            }
            if (Math.abs(rzut[i]) >= body.halfEdge[i]) continue;
            rzutPom[i] = rzut[i];
        }
    }
}

