/*
 * Decompiled with CFR 0.152.
 */
package body.interaction;

import body.Cuboid;
import body.Cylinder;
import body.RigidBody;
import body.interaction.Contact;
import body.interaction.Projection;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class ProjectionCuboidCylinder
extends Projection {
    Cuboid cuboid;
    Cylinder cylinder;
    int normalIndex;

    public void setBodyTypes(Cuboid cuboid, Cylinder cylinder) {
        this.cuboid = cuboid;
        this.cylinder = cylinder;
    }

    public void init() {
        this.dropRay = new Vector2d[2];
        this.dropPos = new Vector2d[2];
        this.dropVel = new Vector2d[2];
        for (int i = 0; i < this.dropRay.length; ++i) {
            this.dropRay[i] = new Vector2d();
            this.dropPos[i] = new Vector2d();
            this.dropVel[i] = new Vector2d();
        }
    }

    public ProjectionCuboidCylinder() {
        this.init();
    }

    public void bodiesProjectionProcedure(Cuboid body0, Cylinder body1) {
        this.cuboid = body0;
        this.cylinder = body1;
        this.calculateRigidBodyPointNormalsProjections(this.rzut0, this.cuboid, this.cylinder.pos);
        this.setRigidBodyPointRzutyPomL(this.cuboid, this.rzut0, this.rzutPom0, 0);
        this.calculateDropRayData(this.cuboid, this.rzutPom0, this.dropRay[0], this.dropPos[0], this.dropVel[0]);
        this.wr.setSubFP(this.dropPos[0], this.cylinder.pos);
        this.dist = this.wr.lengthFP();
        if (this.dist != 0) {
            this.wr.scaleFP(MathFP.div(MathFP.toFP(1), this.dist));
        }
        this.dropRay[1].setScaleFP(this.cylinder.R, this.wr);
        this.dropPos[1].setAddFP(this.cylinder.pos, this.dropRay[1]);
        this.calculatePointVelocity(this.cylinder, this.dropRay[1], this.dropVel[1]);
        this.dist = this.dropPos[0].dist(this.dropPos[1]);
        this.wr.scaleFP(MathFP.toFP(-1));
    }

    public void setContact(Contact cpCt, RigidBody a, RigidBody b, int id) {
        this.cuboid = (Cuboid)a;
        this.cylinder = (Cylinder)b;
        this.bodiesProjectionProcedure(this.cuboid, this.cylinder);
        cpCt.setContact(this.cylinder, this.cuboid, this.dropPos[1], this.dropPos[0], this.dropRay[1], this.dropRay[0], this.dropVel[1], this.dropVel[0], this.wr, this.dist, id);
    }

    public boolean checkIfSurroundingRectsColliding(RigidBody a, RigidBody b) {
        this.cuboid = (Cuboid)a;
        this.cylinder = (Cylinder)b;
        return super.checkIfSurroundingRectsColliding(this.cuboid, this.cylinder);
    }

    public boolean checkIfColliding(Contact cwCt, int dt) {
        return super.checkIfColliding(cwCt, dt);
    }

    protected void setRigidBodyPointRzutyPomL(RigidBody body, int[] rzut, int[] rzutPom, int nr) {
        for (int i = 0; i < rzut.length; ++i) {
            if (rzut[i] >= body.halfEdge[i]) {
                rzutPom[i] = body.halfEdge[i];
                continue;
            }
            if (rzut[i] <= -body.halfEdge[i]) {
                rzutPom[i] = -body.halfEdge[i];
                continue;
            }
            if (Math.abs(rzut[i]) >= body.halfEdge[i]) continue;
            rzutPom[i] = rzut[i];
        }
    }
}

