/*
 * Decompiled with CFR 0.152.
 */
package body.interaction;

import body.Cuboid;
import body.RigidBody;
import body.WallGeom;
import body.interaction.Contact;
import body.interaction.Projection;
import java.util.Vector;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class ProjectionCuboidWallGeom
extends Projection {
    private Cuboid cuboid;
    private WallGeom wall;

    public ProjectionCuboidWallGeom() {
        this.init();
    }

    public void init() {
        this.dropRay = new Vector2d[2];
        this.dropPos = new Vector2d[2];
        this.dropVel = new Vector2d[2];
        for (int i = 0; i < this.dropRay.length; ++i) {
            this.dropRay[i] = new Vector2d();
            this.dropPos[i] = new Vector2d();
            this.dropVel[i] = new Vector2d();
        }
    }

    public int wallProjectionProcedure(Cuboid cuboid, Vector2d wallN, Vector2d wallP) {
        this.calculateCubePlaneNormalsProjections(this.rzut0, cuboid, wallN);
        this.setCubePlaneRzutyPom(cuboid, this.rzut0, this.rzutPom0);
        this.calculateDropRayData(cuboid, this.rzutPom0, this.dropRay[0], this.dropPos[0], this.dropVel[0]);
        return this.calculatePlaneProjectionData(this.dropPos[0], wallN, wallP, this.dropRay[1], this.dropPos[1], this.dropVel[1]);
    }

    private void setCubePlaneRzutyPom(Cuboid cuboid, int[] rzut, int[] rzutPom) {
        int eps = MathFP.toFP("0.002");
        for (int i = 0; i < rzut.length; ++i) {
            if (rzut[i] > eps) {
                rzutPom[i] = -cuboid.halfEdge[i];
                continue;
            }
            if (rzut[i] < -eps) {
                rzutPom[i] = cuboid.halfEdge[i];
                continue;
            }
            if (MathFP.abs(rzut[i]) > eps) continue;
            rzutPom[i] = 0;
        }
    }

    private void calculateCubePlaneNormalsProjections(int[] rzut, Cuboid cuboid, Vector2d wallN) {
        for (int i = 0; i < cuboid.n.length; ++i) {
            rzut[i] = wallN.dotFP(cuboid.n[i]);
        }
    }

    public void setAndPutContactToVector(int j, Vector consCtVec, Contact cwCt, RigidBody cuboidRB, RigidBody wallRB, int id) {
        this.cuboid = (Cuboid)cuboidRB;
        this.wall = (WallGeom)wallRB;
        this.dist = this.wallProjectionProcedure(this.cuboid, this.wall.n[j], this.wall.p[j]);
        if (this.dist < 0) {
            // empty if block
        }
        cwCt.setContact(this.cuboid, this.wall, this.dropPos[0], this.dropPos[1], this.dropRay[0], this.dropRay[1], this.dropVel[0], this.dropVel[1], this.wall.n[j], this.dist, id);
        consCtVec.addElement(cwCt);
    }

    public boolean checkIfSurrRectColliding(int j, RigidBody cuboidRB, RigidBody wallRB) {
        this.cuboid = (Cuboid)cuboidRB;
        this.wall = (WallGeom)wallRB;
        return this.getDistanceToPlane(this.cuboid, this.wall.p[j], this.wall.n[j]) < this.cuboid.surrRectHalfSide;
    }

    public void setContact(int j, Contact cwCt, RigidBody cuboidRB, RigidBody wallRB, int id) {
        this.cuboid = (Cuboid)cuboidRB;
        this.wall = (WallGeom)wallRB;
        this.dist = this.wallProjectionProcedure(this.cuboid, this.wall.n[j], this.wall.p[j]);
        if (this.dist < 0) {
            this.penetracja = true;
            this.moveBack(this.dist, this.cuboid, this.wall.n[j]);
        } else {
            this.penetracja = false;
            cwCt.setContact(this.cuboid, this.wall, this.dropPos[0], this.dropPos[1], this.dropRay[0], this.dropRay[1], this.dropVel[0], this.dropVel[1], this.wall.n[j], this.dist, id);
        }
    }

    public boolean checkIfColliding(Contact cwCt, int dt) {
        if (!this.penetracja) {
            return super.checkIfColliding(cwCt, dt);
        }
        return false;
    }

    private void moveBack(int dist, RigidBody body, Vector2d normal) {
        body.pos.x = MathFP.sub(body.pos.x, MathFP.mul(dist, normal.x));
        body.pos.y = MathFP.sub(body.pos.y, MathFP.mul(dist, normal.y));
        Vector2d vec = new Vector2d();
        vec.setScaleFP(body.vel.dotFP(normal), normal);
        body.vel.setSubFP(body.vel, vec);
    }
}

