/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ApplicationCanvas;
import game.MenuCanvas;
import game.car.CarInteraction;
import game.car.CarUpgrade;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import utils.ImageSet;
import utils.Sounds;

public class IsoRace
extends MIDlet {
    private Sounds sound;
    public static int SCREEN_WIDTH = 0;
    public static int SCREEN_HEIGHT = 0;
    public static int R_FUNCTION = -7;
    public static int L_FUNCTION = -6;
    public static byte cfg_lang = 0;
    public static byte cfg_game_mode = 0;
    public static byte currentSelectedTrack = 0;
    public static byte championshipTrack = 0;
    public static byte cfg_unlockedTrack = (byte)9;
    public static byte selectedCar = 0;
    public static String[] cfg_nicks = new String[]{"HENRIK", "FREDY", "ALEX", "JOHN", "BELLA", "TONNY", "ANDY", "BOLEK", "LOLEK", "MORYC"};
    public static int[] cfg_scores = new int[]{99000, 67890, 13560, 12345, 900, 800, 400, 300, 100, 80};
    public static boolean cfg_kontynuacja;
    public static boolean cfg_vibration;
    public static boolean cfg_sound;
    public static boolean cfg_music;
    private static Hashtable textMap;
    private ApplicationCanvas canvas = null;
    private MenuCanvas menu = null;
    private CarUpgrade carUpgrade = null;
    private static final String rmsName = "cfgvb36";

    public void startApp() {
        this.readConfiguration();
        if (cfg_music && cfg_sound) {
            cfg_sound = false;
        }
        this.loadSounds(cfg_sound, cfg_music);
        ImageSet.menuImagesLoaded = false;
        ImageSet.gameImagesLoaded = false;
        this.menu = new MenuCanvas(this, false, true, this.sound);
        try {
            ImageSet.loadMenuImages(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.menu.prepareSpritesGraphics();
        this.menu.serviceRepaints();
        this.menu.setFullScreenMode(true);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menu);
        this.menu.openView((byte)0);
        this.menu.start();
        this.carUpgrade = new CarUpgrade(this.sound);
        ImageSet.menuImagesLoaded = true;
        System.gc();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        try {
            this.canvas = null;
            this.saveConfiguration(false);
            this.notifyDestroyed();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBoundleFile(String filePath) {
        textMap.clear();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(filePath));
            String c = null;
            int i = 0;
            while ((c = dis.readUTF()) != null && !"//#[ende]".equals(c) && c != null) {
                textMap.put(c.substring(0, c.indexOf("=")), c.substring(c.indexOf("=") + 1).toUpperCase());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (dis != null) {
                dis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            dis = null;
        }
    }

    public void startRace(byte state) {
        ImageSet.gameImagesLoaded = false;
        this.menu.openView((byte)-25);
        this.menu.stop();
        this.menu = null;
        ImageSet.clearMenuImages();
        ImageSet.menuImagesLoaded = false;
        this.canvas = new ApplicationCanvas(this, this.sound, this.carUpgrade);
        try {
            ImageSet.loadGameImages();
            this.canvas.createGameFonts();
            this.canvas.prepareSprites();
            ImageSet.gameImagesLoaded = true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (cfg_kontynuacja) {
            cfg_game_mode = 1;
            this.canvas.currentTrack = championshipTrack;
        } else {
            this.canvas.currentTrack = currentSelectedTrack;
            championshipTrack = 0;
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        this.canvas.start();
        this.canvas.goTo(state);
        System.gc();
    }

    public void startMenu(boolean skipSplash, boolean fontsBool, byte view, Sounds sound) throws IOException {
        ImageSet.menuImagesLoaded = false;
        if (cfg_game_mode == 1) {
            if (this.canvas.currentTrack > 0) {
                cfg_kontynuacja = true;
                championshipTrack = this.canvas.currentTrack;
            } else {
                cfg_kontynuacja = false;
            }
        } else {
            cfg_kontynuacja = false;
        }
        try {
            this.saveConfiguration(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.canvas.goTo((byte)-25);
        this.canvas.stop();
        this.canvas.clearImages();
        ImageSet.clearGameImages();
        ImageSet.gameImagesLoaded = false;
        this.canvas = null;
        this.menu = new MenuCanvas(this, skipSplash, fontsBool, sound);
        try {
            ImageSet.loadMenuImages(false);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.menu.prepareSpritesGraphics();
        this.menu.serviceRepaints();
        this.menu.setFullScreenMode(true);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menu);
        this.menu.start();
        this.menu.openView(view);
        ImageSet.menuImagesLoaded = true;
        if (this.canvas != null) {
            // empty if block
        }
        System.gc();
    }

    public static String getString(String key) {
        return (String)textMap.get(key);
    }

    public static char[] getCharArray(String key) {
        return ((String)textMap.get(key)).toCharArray();
    }

    public final void makeVibra() {
        try {
            Display.getDisplay((MIDlet)this).vibrate(20);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void makeVibra(int time) {
        try {
            Display.getDisplay((MIDlet)this).vibrate(time);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration(boolean onlyAddRecord) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1);
            DataOutputStream ostream = new DataOutputStream(bstream);
            ostream.writeByte(cfg_lang);
            ostream.writeBoolean(cfg_sound);
            ostream.writeBoolean(cfg_music);
            ostream.writeBoolean(cfg_vibration);
            ostream.writeBoolean(cfg_kontynuacja);
            ostream.writeByte(selectedCar);
            ostream.writeByte(CarInteraction.upgradeLevel[0]);
            ostream.writeByte(CarInteraction.upgradeLevel[1]);
            ostream.writeByte(CarInteraction.upgradeLevel[2]);
            ostream.writeInt(CarInteraction.playerCash);
            ostream.writeInt(CarInteraction.playerScore);
            ostream.writeByte(championshipTrack);
            ostream.writeByte(currentSelectedTrack);
            ostream.writeByte(cfg_unlockedTrack);
            for (int i = 0; i < cfg_nicks.length; ++i) {
                ostream.writeUTF(cfg_nicks[i]);
                ostream.writeInt(cfg_scores[i]);
            }
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(record, 0, record.length);
            } else if (!onlyAddRecord) {
                recordStore.setRecord(1, record, 0, record.length);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {}
            }
        }
    }

    private void loadSounds(boolean sounds, boolean music) {
        this.sound = new Sounds(sounds, music);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfiguration() {
        block16: {
            RecordStore recordStore = null;
            try {
                recordStore = RecordStore.openRecordStore((String)rmsName, (boolean)false);
                if (recordStore == null || recordStore.getNumRecords() <= 0) break block16;
                byte[] record = recordStore.getRecord(1);
                DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
                cfg_lang = istream.readByte();
                cfg_sound = istream.readBoolean();
                cfg_music = istream.readBoolean();
                cfg_vibration = istream.readBoolean();
                cfg_kontynuacja = istream.readBoolean();
                selectedCar = istream.readByte();
                CarInteraction.upgradeLevel[0] = istream.readByte();
                CarInteraction.upgradeLevel[1] = istream.readByte();
                CarInteraction.upgradeLevel[2] = istream.readByte();
                CarInteraction.playerCash = istream.readInt();
                CarInteraction.playerScore = istream.readInt();
                System.out.println("upgradeLevel[0]=" + CarInteraction.upgradeLevel[0]);
                System.out.println("upgradeLevel[1]=" + CarInteraction.upgradeLevel[1]);
                System.out.println("upgradeLevel[2]=" + CarInteraction.upgradeLevel[2]);
                System.out.println("playerCash=" + CarInteraction.playerCash);
                System.out.println("playerScore=" + CarInteraction.playerScore);
                championshipTrack = istream.readByte();
                currentSelectedTrack = istream.readByte();
                cfg_unlockedTrack = istream.readByte();
                if (cfg_kontynuacja && championshipTrack == 0) {
                    cfg_kontynuacja = false;
                }
                try {
                    for (int i = 0; i < cfg_nicks.length; ++i) {
                        IsoRace.cfg_nicks[i] = istream.readUTF();
                        IsoRace.cfg_scores[i] = istream.readInt();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (recordStore != null) {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void putHighScore(String nick, int score) {
        int i;
        int newRecordIndex = -1;
        for (i = 0; i < cfg_nicks.length; ++i) {
            if (score <= cfg_scores[i]) continue;
            newRecordIndex = i;
            break;
        }
        if (newRecordIndex > -1) {
            for (i = cfg_nicks.length - 1; i > newRecordIndex; --i) {
                IsoRace.cfg_nicks[i] = cfg_nicks[i - 1];
                IsoRace.cfg_scores[i] = cfg_scores[i - 1];
            }
            IsoRace.cfg_nicks[newRecordIndex] = nick;
            IsoRace.cfg_scores[newRecordIndex] = score;
        }
    }

    public boolean isNewRecord(int score) {
        for (int i = 0; i < cfg_nicks.length; ++i) {
            if (score <= cfg_scores[i]) continue;
            return true;
        }
        return false;
    }

    static {
        cfg_vibration = true;
        cfg_sound = false;
        cfg_music = false;
        textMap = new Hashtable();
    }
}

