/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.FinalData;
import game.FinalFonts;
import game.IsoRace;
import game.car.CarInteraction;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import net.jscience.math.kvm.MathFP;
import utils.CustomFont;
import utils.ImageSet;
import utils.Sounds;
import utils.SpriteGame;

public class MenuCanvas
extends Canvas
implements Runnable {
    private Sounds sound;
    private int keyCode = 0;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private String[] menuOptionLabels = new String[8];
    private String[] languages = new String[5];
    private String[] settings = new String[3];
    private String[] gameModes = new String[2];
    private String[] chooseCarNames = new String[]{"Blue lightning".toUpperCase(), "Green fury".toUpperCase(), "Red devil".toUpperCase(), "Yellow beast".toUpperCase()};
    private Sprite menuArrowsSprite = null;
    private SpriteGame menuFlamesSprite = null;
    private SpriteGame selectedArrowsSprite = null;
    private int[][] trackLayout;
    private IsoRace mainMidlet;
    private char[] playerNick = "          ".toCharArray();
    private byte nickLetterIndex = 0;
    private byte pressedKeyItem = 0;
    private long lastTimePressedKey = 0L;
    private long lastPressedKeyCode = 0L;
    private Thread animationThread;
    private byte currentView = 0;
    private byte currentMenuOption = 0;
    private long showCoverScreenTime = 0L;
    private boolean scroolingHandler = false;
    private Vector wrappedText = new Vector();
    private boolean lastLine = false;
    private byte startLineDraw = 0;
    private byte selectedOption = 0;
    private int keyPressed = -999;
    private boolean keysBlocked = false;
    private byte begMenuIndex = 0;

    public MenuCanvas(IsoRace midlet, boolean skipSplash, boolean fontsBool, Sounds sound) {
        this.mainMidlet = midlet;
        this.sound = sound;
        if (skipSplash) {
            this.openView((byte)1);
        } else {
            this.openView((byte)0);
        }
        this.setFullScreenMode(true);
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.currentMenuOption = 0;
        this.mainMidlet.getBoundleFile("/text/app_" + FinalData.LANG_CODES[IsoRace.cfg_lang] + ".txt.JUTF");
        this.initLanguage(IsoRace.cfg_lang);
        this.begMenuIndex = IsoRace.cfg_kontynuacja ? (byte)0 : 1;
        if (this.currentMenuOption == 0 && this.begMenuIndex == 1) {
            this.currentMenuOption = (byte)(this.currentMenuOption + 1);
        }
    }

    public void clearSprites() {
        this.menuArrowsSprite = null;
        this.menuFlamesSprite.clearSpriteImages();
        this.menuFlamesSprite = null;
        this.selectedArrowsSprite.clearSpriteImages();
        this.selectedArrowsSprite = null;
    }

    public void prepareSpritesGraphics() {
        this.menuArrowsSprite = new Sprite(ImageSet.getMenuImage("/menu/smallarrows.png"), ImageSet.getMenuImage("/menu/smallarrows.png").getWidth() / 3, ImageSet.getMenuImage("/menu/smallarrows.png").getHeight());
        this.menuArrowsSprite.setFrameSequence(new int[]{0, 1, 2});
        this.menuArrowsSprite.defineReferencePixel(ImageSet.getMenuImage("/menu/smallarrows.png").getWidth() / 2, ImageSet.getMenuImage("/menu/smallarrows.png").getHeight() / 2);
        this.menuFlamesSprite = new SpriteGame(ImageSet.getMenuImage("/menu/flames.png"), ImageSet.getMenuImage("/menu/flames.png").getWidth(), ImageSet.getMenuImage("/menu/flames.png").getHeight() / 3);
        this.menuFlamesSprite.setFrameSequence(new int[]{1, 2, 1}, 20);
        this.menuFlamesSprite.setAnchorImage(3);
        this.selectedArrowsSprite = new SpriteGame(ImageSet.getMenuImage("/menu/select_arrows.png"), ImageSet.getMenuImage("/menu/select_arrows.png").getWidth() / 2, ImageSet.getMenuImage("/menu/select_arrows.png").getHeight());
        this.selectedArrowsSprite.setAnchorImage(3);
        this.selectedArrowsSprite.setFrame(0);
    }

    public void openView(byte view) {
        this.currentView = view;
        int lineWidth = 8 * this.screenWidth / 9;
        switch (view) {
            case 123: {
                this.mainMidlet.startRace((byte)20);
                break;
            }
            case 0: {
                this.showCoverScreenTime = System.currentTimeMillis();
                break;
            }
            case 1: {
                this.begMenuIndex = IsoRace.cfg_kontynuacja ? (byte)0 : 1;
                if (this.currentMenuOption != 0 || this.begMenuIndex != 1) break;
                this.currentMenuOption = (byte)(this.currentMenuOption + 1);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                String helpText = IsoRace.getString("help_text").toUpperCase();
                this.initScrollHandler(helpText, lineWidth, FinalFonts.smallCustomFont);
                break;
            }
            case 6: {
                String aboutText = IsoRace.getString("about_text").toUpperCase();
                this.initScrollHandler(aboutText, lineWidth, FinalFonts.smallCustomFont);
                break;
            }
            case 7: {
                this.selectedOption = IsoRace.cfg_game_mode;
                break;
            }
            case 4: {
                this.selectedOption = IsoRace.cfg_lang;
                break;
            }
            case 10: {
                break;
            }
            case 9: {
                this.selectedOption = 0;
                break;
            }
            case 8: {
                this.selectedOption = 0;
                this.trackLayout = FinalData.trackShapes(this.selectedOption);
                break;
            }
            case 11: {
                this.mainMidlet.startRace((byte)20);
                break;
            }
        }
    }

    private void drawErrorScreen(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g.setColor(255, 0, 0);
        g.drawString("ERROR; CLICK TO RESTORE", 10, this.screenHeight / 2, 0);
    }

    private void drawYesNo(Graphics g, CustomFont font) {
        font.drawString(g, IsoRace.getString("sf_no").toCharArray(), 5, this.screenHeight - 3, 36);
        font.drawString(g, IsoRace.getString("sf_yes").toCharArray(), this.screenWidth - 5, this.screenHeight - 3, 40);
    }

    private void drawBack(Graphics g, CustomFont font) {
        font.drawString(g, IsoRace.getString("m_back").toCharArray(), 5, this.screenHeight - 3, 36);
    }

    private void drawBackCont(Graphics g, CustomFont font) {
        this.drawBack(g, font);
        font.drawString(g, IsoRace.getString("m_next").toCharArray(), this.screenWidth - 5, this.screenHeight - 3, 40);
    }

    private void drawFlamesMark(Graphics g, int y0, int dy, int option) {
        try {
            g.drawImage(ImageSet.getMenuImage("/menu/selectbar.png"), this.screenWidth >> 1, y0 + option * dy, 3);
        }
        catch (Exception e) {
            System.out.println("BRAK FinalData.img_selectbar");
        }
        try {
            this.menuFlamesSprite.setPosition(this.screenWidth >> 1, y0 + option * dy);
            this.menuFlamesSprite.paint(g);
        }
        catch (Exception e) {
            System.out.println("BRAK FinalData.img_flames");
        }
        int x = 55;
        try {
            this.menuArrowsSprite.setPosition((this.screenWidth >> 1) + x, y0 + option * dy - 4);
            this.menuArrowsSprite.paint(g);
            this.menuArrowsSprite.setTransform(2);
            this.menuArrowsSprite.setPosition((this.screenWidth >> 1) - (x + 6), y0 + option * dy - 4);
            this.menuArrowsSprite.paint(g);
            this.menuArrowsSprite.nextFrame();
            this.menuArrowsSprite.setTransform(0);
        }
        catch (Exception e) {
            System.out.println("BRAK FinalData.img_smallarrows");
        }
    }

    public void paint(Graphics g) {
        int heightFontCorrection = 0;
        int y0mainMenu = 0;
        int y0Menu = 0;
        int dyMenu = 0;
        int y0help = 0;
        int helpHeight = 0;
        int x0scores = 0;
        int yExit = 0;
        String kropki = "";
        y0mainMenu = IsoRace.cfg_kontynuacja ? 45 : 55;
        int yNewRecord = 25;
        int[] dy2NewRecord = new int[]{10, 20, 30, 19, 35};
        int yMenuBaner = 30;
        int yFlames = 0;
        CustomFont smallFont = FinalFonts.smallestCustomFont;
        CustomFont font = FinalFonts.mediumCustomFont;
        CustomFont shadowfont = FinalFonts.mediumShadowCustomFont;
        dyMenu = FinalFonts.smallCustomFont.heightFont - 2;
        y0Menu = 55;
        int dyRecords = -3;
        y0help = 30;
        helpHeight = 120;
        int yTitle = 25;
        yExit = 27;
        heightFontCorrection = -5;
        int liczbaNickow = 9;
        x0scores = this.screenWidth / 2 - 5;
        kropki = "........  ";
        int yNicks = 23;
        int yAboutView = 40;
        int aboutViewHeight = 160;
        if (this.currentView != 0) {
            try {
                g.drawImage(ImageSet.getMenuImage(FinalData.img_backgroud), 0, 0, 20);
                g.drawImage(ImageSet.getMenuImage("/menu/topbar.png"), 0, yFlames, 20);
            }
            catch (Exception e) {
                g.setColor(0, 0, 0);
                g.fillRect(0, 0, this.screenWidth, this.screenHeight);
            }
        }
        int[] dyNewRecord = dy2NewRecord;
        switch (this.currentView) {
            case 0: {
                try {
                    g.drawImage(ImageSet.getMenuImage(FinalData.img_splash), 0, 0, 20);
                }
                catch (Exception e) {
                    System.out.println("BRAK img_splash");
                }
                break;
            }
            case 1: {
                try {
                    try {
                        g.drawImage(ImageSet.getMenuImage("/menu/menu_font.png"), this.screenWidth >> 1, yMenuBaner, 33);
                    }
                    catch (Exception e) {
                        System.out.println("BRAK FinalData.img_menu_font");
                    }
                    try {
                        this.drawFlamesMark(g, y0mainMenu, dyMenu, this.currentMenuOption - this.begMenuIndex);
                    }
                    catch (Exception e) {
                        System.out.println("BRAK w drawFlamesMark() ");
                    }
                    try {
                        for (int i = this.begMenuIndex; i < this.menuOptionLabels.length; ++i) {
                            if (i == this.currentMenuOption) {
                                font.drawString(g, this.menuOptionLabels[i].toCharArray(), this.screenWidth >> 1, y0mainMenu + (i - this.begMenuIndex) * dyMenu, 3);
                                continue;
                            }
                            shadowfont.drawString(g, this.menuOptionLabels[i].toCharArray(), this.screenWidth >> 1, y0mainMenu + (i - this.begMenuIndex) * dyMenu, 3);
                        }
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("BRAK fontow");
                        break;
                    }
                }
                catch (Exception e) {
                    g.setColor(0, 0, 0);
                    g.fillRect(0, 0, this.screenWidth, this.screenHeight);
                    for (int i = this.begMenuIndex; i < this.menuOptionLabels.length; ++i) {
                        if (i == this.currentMenuOption) {
                            g.setColor(255, 255, 255);
                        } else {
                            g.setColor(255, 0, 0);
                        }
                        g.drawString(this.menuOptionLabels[i], (this.screenWidth >> 1) - 40, 50 + (i - this.begMenuIndex) * dyMenu, 0);
                    }
                    break;
                }
            }
            case 7: {
                CustomFont fontGameMode = null;
                CustomFont fontGameModeShadow = null;
                try {
                    FinalFonts.bigCustomFont.drawString(g, this.menuOptionLabels[this.currentMenuOption].toCharArray(), this.screenWidth >> 1, yTitle, 33);
                    this.drawFlamesMark(g, y0Menu, dyMenu, this.selectedOption);
                }
                catch (Exception e) {
                    // empty catch block
                }
                switch (IsoRace.cfg_lang) {
                    case 0: {
                        fontGameMode = font;
                        fontGameModeShadow = shadowfont;
                        break;
                    }
                    case 1: {
                        fontGameMode = FinalFonts.smallCustomFont;
                        fontGameModeShadow = FinalFonts.smallShadowCustomFont;
                        break;
                    }
                    case 2: {
                        fontGameMode = FinalFonts.medium2CustomFont;
                        fontGameModeShadow = FinalFonts.medium2ShadowCustomFont;
                        break;
                    }
                    case 3: {
                        fontGameMode = FinalFonts.medium2CustomFont;
                        fontGameModeShadow = FinalFonts.medium2ShadowCustomFont;
                        break;
                    }
                    case 4: {
                        fontGameMode = FinalFonts.medium2CustomFont;
                        fontGameModeShadow = FinalFonts.medium2ShadowCustomFont;
                    }
                }
                try {
                    for (int i = 0; i < this.gameModes.length; ++i) {
                        if (i == this.selectedOption) {
                            fontGameMode.drawString(g, this.gameModes[i].toCharArray(), this.screenWidth >> 1, y0Menu + i * dyMenu, 3);
                            continue;
                        }
                        fontGameModeShadow.drawString(g, this.gameModes[i].toCharArray(), this.screenWidth >> 1, y0Menu + i * dyMenu, 3);
                    }
                    this.drawBackCont(g, smallFont);
                }
                catch (Exception e) {
                    this.drawErrorScreen(g);
                }
                break;
            }
            case 2: {
                CustomFont fontShadowSettings;
                CustomFont fontSettings;
                try {
                    FinalFonts.bigCustomFont.drawString(g, this.menuOptionLabels[this.currentMenuOption].toCharArray(), this.screenWidth >> 1, yTitle, 33);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String txtOpt = null;
                switch (IsoRace.cfg_lang) {
                    case 3: {
                        fontSettings = FinalFonts.smallCustomFont;
                        fontShadowSettings = FinalFonts.smallShadowCustomFont;
                        break;
                    }
                    case 4: {
                        fontSettings = FinalFonts.smallCustomFont;
                        fontShadowSettings = FinalFonts.smallShadowCustomFont;
                        break;
                    }
                    default: {
                        fontSettings = font;
                        fontShadowSettings = shadowfont;
                    }
                }
                if (this.selectedOption > 2) {
                    this.selectedOption = 0;
                }
                try {
                    this.drawFlamesMark(g, y0Menu, dyMenu, this.selectedOption);
                    for (int i = 0; i < this.settings.length; ++i) {
                        if (i == 0) {
                            txtOpt = IsoRace.cfg_music ? this.settings[i] + " " + IsoRace.getString("op_on") : this.settings[i] + " " + IsoRace.getString("op_off");
                        } else if (i == 1) {
                            txtOpt = IsoRace.cfg_sound ? this.settings[i] + " " + IsoRace.getString("op_on") : this.settings[i] + " " + IsoRace.getString("op_off");
                        } else if (i == 2) {
                            String string = txtOpt = IsoRace.cfg_vibration ? this.settings[i] + " " + IsoRace.getString("op_on") : this.settings[i] + " " + IsoRace.getString("op_off");
                        }
                        if (i == this.selectedOption) {
                            fontSettings.drawString(g, txtOpt.toCharArray(), this.screenWidth >> 1, y0Menu + i * dyMenu, 3);
                            continue;
                        }
                        fontShadowSettings.drawString(g, txtOpt.toCharArray(), this.screenWidth >> 1, y0Menu + i * dyMenu, 3);
                    }
                    this.drawBack(g, smallFont);
                }
                catch (Exception e) {
                    this.drawErrorScreen(g);
                }
                break;
            }
            case 3: {
                try {
                    FinalFonts.bigCustomFont.drawString(g, this.menuOptionLabels[this.currentMenuOption].toCharArray(), this.screenWidth >> 1, yTitle, 33);
                    this.drawScrollFrame(g, this.screenWidth / 2, y0help, helpHeight, 17, smallFont, heightFontCorrection);
                    this.drawBack(g, smallFont);
                }
                catch (Exception e) {
                    this.drawErrorScreen(g);
                }
                break;
            }
            case 4: {
                try {
                    FinalFonts.bigCustomFont.drawString(g, this.menuOptionLabels[this.currentMenuOption].toCharArray(), this.screenWidth >> 1, yTitle, 33);
                    this.drawFlamesMark(g, y0Menu, dyMenu, this.selectedOption);
                    for (int i = 0; i < this.languages.length; ++i) {
                        if (i == this.selectedOption) {
                            font.drawString(g, this.languages[i].toCharArray(), this.screenWidth >> 1, y0Menu + i * dyMenu, 3);
                            continue;
                        }
                        shadowfont.drawString(g, this.languages[i].toCharArray(), this.screenWidth >> 1, y0Menu + i * dyMenu, 3);
                    }
                    this.drawBack(g, smallFont);
                }
                catch (Exception e) {
                    this.drawErrorScreen(g);
                }
                break;
            }
            case 5: {
                try {
                    FinalFonts.bigCustomFont.drawString(g, this.menuOptionLabels[this.currentMenuOption].toCharArray(), this.screenWidth >> 1, yTitle, 33);
                    String[] nicks = IsoRace.cfg_nicks;
                    int[] scores = IsoRace.cfg_scores;
                    for (int i = 0; i < liczbaNickow; ++i) {
                        int x;
                        switch (i) {
                            case 0: {
                                x = 20;
                                break;
                            }
                            case 3: {
                                x = 20;
                                break;
                            }
                            default: {
                                x = 21;
                            }
                        }
                        smallFont.drawString(g, (i + 1 + ".").toCharArray(), x, yNicks += smallFont.heightFont + dyRecords, 24);
                        smallFont.drawString(g, nicks[i].toCharArray(), x + 1, yNicks, 20);
                        smallFont.drawString(g, (kropki + scores[i]).toCharArray(), x0scores, yNicks, 20);
                    }
                    this.drawBack(g, smallFont);
                }
                catch (Exception e) {
                    this.drawErrorScreen(g);
                }
                break;
            }
            case 6: {
                try {
                    FinalFonts.bigCustomFont.drawString(g, this.menuOptionLabels[this.currentMenuOption].toCharArray(), this.screenWidth >> 1, yTitle, 33);
                    this.drawScrollFrame(g, this.screenWidth / 2, yAboutView, aboutViewHeight, 17, smallFont, heightFontCorrection);
                    this.drawBack(g, smallFont);
                }
                catch (Exception e) {
                    this.drawErrorScreen(g);
                }
                break;
            }
            case 9: {
                this.drawSelectCarView(g);
                break;
            }
            case 8: {
                int xPt = 0;
                int dyTextArrow = 1;
                int dyTitle = 0;
                CustomFont fontTitle = FinalFonts.mediumCustomFont;
                int tileWidth = 10;
                int tileHeight = 10;
                int tileHalfWidth = 5;
                int tileHalfHeight = 5;
                switch (IsoRace.cfg_lang) {
                    case 1: {
                        dyTextArrow = 0;
                        dyTitle = 0;
                        break;
                    }
                    case 4: {
                        dyTextArrow = 0;
                        dyTitle = 0;
                        break;
                    }
                    default: {
                        dyTextArrow = 1;
                        dyTitle = 0;
                    }
                }
                int yPt = 40;
                int xArrow = 20;
                int yArrow = 125;
                try {
                    switch (IsoRace.cfg_lang) {
                        case 4: {
                            fontTitle.drawString(g, IsoRace.getString("m_ch_lap0").toCharArray(), this.screenWidth >> 1, yTitle + dyTitle, 33);
                            fontTitle.drawString(g, IsoRace.getString("m_ch_lap1").toCharArray(), this.screenWidth >> 1, yTitle + fontTitle.heightFont * 2 / 3 + dyTitle, 33);
                            break;
                        }
                        default: {
                            fontTitle.drawString(g, IsoRace.getString("m_ch_lap").toCharArray(), this.screenWidth >> 1, yTitle + dyTitle, 33);
                        }
                    }
                    g.drawImage(ImageSet.getMenuImage("/menu/selectbar.png"), this.screenWidth >> 1, yArrow + 1, 3);
                    String track = IsoRace.getString("track");
                    String trackNo = " " + (this.selectedOption + 1);
                    String trackBoth = track + trackNo;
                    smallFont.drawString(g, trackBoth.toCharArray(), this.screenWidth >> 1, yArrow + dyTextArrow, 3);
                    Image trackLayoutImg = null;
                    trackLayoutImg = ImageSet.getMenuImage("/track_yellow.png");
                    int xC = g.getClipX();
                    int yC = g.getClipY();
                    int wC = g.getClipWidth();
                    int hC = g.getClipHeight();
                    for (int ptMapY = 0; ptMapY < this.trackLayout.length; ++ptMapY) {
                        xPt = (this.screenWidth >> 1) - this.trackLayout[0].length * (tileWidth - 1) / 2;
                        if (ptMapY % 2 == 0 && ptMapY != 1) {
                            xPt -= tileHalfWidth;
                        }
                        for (int ptMapX = 0; ptMapX < this.trackLayout[0].length; ++ptMapX) {
                            int tileValue = this.trackLayout[ptMapY][ptMapX];
                            g.setClip(xPt, yPt, tileWidth, tileHeight);
                            g.drawImage(trackLayoutImg, xPt - tileValue * tileWidth, yPt, 20);
                            xPt += tileWidth;
                        }
                        yPt += tileHalfHeight;
                    }
                    g.setClip(xC, yC, wC, hC);
                    yPt = 90;
                    if (this.selectedOption > IsoRace.cfg_unlockedTrack) {
                        // empty if block
                    }
                    if (this.selectedOption == 0) {
                        this.selectedArrowsSprite.setFrame(0);
                    } else {
                        this.selectedArrowsSprite.setFrame(0);
                    }
                    this.selectedArrowsSprite.setPosition(xArrow, yArrow);
                    this.selectedArrowsSprite.paint(g, 0);
                    if (this.selectedOption == FinalData.trackNames.length - 1) {
                        this.selectedArrowsSprite.setFrame(0);
                    } else {
                        this.selectedArrowsSprite.setFrame(0);
                    }
                    this.selectedArrowsSprite.setPosition(this.screenWidth - xArrow, yArrow);
                    this.selectedArrowsSprite.paint(g, 2);
                    this.drawBackCont(g, smallFont);
                }
                catch (Exception e) {
                    this.drawErrorScreen(g);
                }
                break;
            }
            case 12: {
                g.drawImage(ImageSet.getMenuImage("/menu/puchar.png"), (this.screenWidth - ImageSet.getMenuImage("/menu/puchar.png").getWidth()) / 2, (this.screenHeight - ImageSet.getMenuImage("/menu/puchar.png").getHeight()) / 2, 20);
                try {
                    FinalFonts.bigCustomFont.drawString(g, IsoRace.getString("n_record").toCharArray(), this.screenWidth >> 1, yNewRecord, 33);
                    FinalFonts.smallCustomFont.drawString(g, IsoRace.getString("congratulations").toCharArray(), this.screenWidth >> 1, yNewRecord += dyNewRecord[0], 17);
                    FinalFonts.smallCustomFont.drawString(g, IsoRace.getString("enter_name").toCharArray(), this.screenWidth >> 1, yNewRecord += dyNewRecord[1], 17);
                }
                catch (Exception e) {
                    // empty catch block
                }
                FinalFonts.mediumCustomFont.drawString(g, this.playerNick, this.screenWidth >> 1, yNewRecord += dyNewRecord[2], 17);
                g.drawImage(ImageSet.getMenuImage("/menu/line.png"), this.screenWidth >> 1, yNewRecord + dyNewRecord[3], 33);
                try {
                    FinalFonts.mediumCustomFont.drawString(g, (IsoRace.getString("t_score") + " " + CarInteraction.playerScore).toCharArray(), this.screenWidth >> 1, yNewRecord += dyNewRecord[4], 17);
                    smallFont.drawString(g, IsoRace.getString("t_delete").toCharArray(), 5, this.screenHeight - 3, 36);
                    smallFont.drawString(g, IsoRace.getString("t_ok").toCharArray(), this.screenWidth - 5, this.screenHeight - 3, 40);
                }
                catch (Exception e) {}
                break;
            }
            case 10: {
                int dyExit = 0;
                switch (IsoRace.cfg_lang) {
                    case 1: {
                        dyExit = 30;
                        break;
                    }
                    case 4: {
                        dyExit = 30;
                        break;
                    }
                    default: {
                        dyExit = 40;
                    }
                }
                CustomFont fontExit = FinalFonts.smallCustomFont;
                try {
                    FinalFonts.bigCustomFont.drawString(g, IsoRace.getString("m_exitgame").toCharArray(), this.screenWidth >> 1, yExit, 33);
                    fontExit.drawString(g, IsoRace.getString("m_quit_confirm_1").toCharArray(), this.screenWidth >> 1, yExit += dyExit, 17);
                    fontExit.drawString(g, IsoRace.getString("m_quit_confirm_2").toCharArray(), this.screenWidth >> 1, yExit += fontExit.heightFont + 2, 17);
                    this.drawYesNo(g, smallFont);
                }
                catch (Exception e) {}
                break;
            }
        }
        this.keysBlocked = false;
    }

    private void checkInput(int keyPressed) {
        if (keyPressed != 48) {
            this.keyCode = keyPressed;
        }
        switch (this.currentView) {
            case 1: {
                if (keyPressed == 1 || keyPressed == 50) {
                    this.currentMenuOption = (byte)(this.currentMenuOption - 1);
                    if (this.currentMenuOption < this.begMenuIndex) {
                        this.currentMenuOption = (byte)(this.menuOptionLabels.length - 1);
                    }
                }
                if (keyPressed == 6 || keyPressed == 56) {
                    this.currentMenuOption = (byte)(this.currentMenuOption + 1);
                    if (this.currentMenuOption == this.menuOptionLabels.length) {
                        this.currentMenuOption = this.begMenuIndex;
                    }
                }
                if (keyPressed != 8 && keyPressed != 53) break;
                this.openView(FinalData.mainMenuViews[this.currentMenuOption]);
                break;
            }
            case 2: {
                if (keyPressed == 1 || keyPressed == 50) {
                    this.selectedOption = (byte)(this.selectedOption - 1);
                    if (this.selectedOption < 0) {
                        this.selectedOption = (byte)(this.settings.length - 1);
                    }
                } else if (keyPressed == 6 || keyPressed == 56) {
                    this.selectedOption = (byte)(this.selectedOption + 1);
                    if (this.selectedOption > this.settings.length - 1) {
                        this.selectedOption = 0;
                    }
                } else if (keyPressed == 8 || keyPressed == 53) {
                    if (this.selectedOption == 0) {
                        if (IsoRace.cfg_music) {
                            IsoRace.cfg_music = false;
                            this.sound.stopMenuMusic();
                            this.sound.closeMenuMusic();
                        } else {
                            if (IsoRace.cfg_sound) {
                                IsoRace.cfg_sound = false;
                                this.sound.stopItemSound();
                                this.sound.closeItemSound();
                            }
                            this.sound.loadMenuMusic();
                            IsoRace.cfg_music = true;
                            this.sound.playMenuMusic();
                        }
                    } else if (this.selectedOption == 1) {
                        if (IsoRace.cfg_sound) {
                            IsoRace.cfg_sound = false;
                            this.sound.stopItemSound();
                            this.sound.closeItemSound();
                        } else {
                            if (IsoRace.cfg_music) {
                                IsoRace.cfg_music = false;
                                this.sound.stopMenuMusic();
                                this.sound.closeMenuMusic();
                            }
                            this.sound.loadItemSound();
                            IsoRace.cfg_sound = true;
                            this.sound.playItemSound();
                        }
                    }
                    if (this.selectedOption == 2) {
                        if (IsoRace.cfg_vibration) {
                            IsoRace.cfg_vibration = false;
                        } else {
                            IsoRace.cfg_vibration = true;
                            this.mainMidlet.makeVibra(300);
                        }
                    }
                }
                if (keyPressed != IsoRace.L_FUNCTION && keyPressed != 42) break;
                this.openView((byte)1);
                break;
            }
            case 3: {
                if (keyPressed == IsoRace.L_FUNCTION || keyPressed == 42) {
                    this.openView((byte)1);
                    break;
                }
                this.scrollHandler(keyPressed);
                break;
            }
            case 4: {
                if (keyPressed == 1 || keyPressed == 50) {
                    this.selectedOption = (byte)(this.selectedOption - 1);
                    if (this.selectedOption < 0) {
                        this.selectedOption = (byte)(this.languages.length - 1);
                    }
                } else if (keyPressed == 6 || keyPressed == 56) {
                    this.selectedOption = (byte)(this.selectedOption + 1);
                    if (this.selectedOption > this.languages.length - 1) {
                        this.selectedOption = 0;
                    }
                } else if (keyPressed == 8 || keyPressed == 53) {
                    this.mainMidlet.getBoundleFile("/text/app_" + FinalData.LANG_CODES[this.selectedOption] + ".txt.JUTF");
                    IsoRace.cfg_lang = this.selectedOption;
                    this.initLanguage(IsoRace.cfg_lang);
                }
                if (keyPressed != IsoRace.L_FUNCTION && keyPressed != 42) break;
                this.openView((byte)1);
                break;
            }
            case 5: {
                if (keyPressed != IsoRace.L_FUNCTION && keyPressed != 42) break;
                this.openView((byte)1);
                break;
            }
            case 6: {
                if (keyPressed != IsoRace.L_FUNCTION && keyPressed != 42) break;
                this.openView((byte)1);
                break;
            }
            case 7: {
                if (keyPressed == 1 || keyPressed == 50) {
                    this.selectedOption = (byte)(this.selectedOption - 1);
                    if (this.selectedOption >= 0) break;
                    this.selectedOption = 1;
                    break;
                }
                if (keyPressed == 6 || keyPressed == 56) {
                    this.selectedOption = (byte)(this.selectedOption + 1);
                    if (this.selectedOption <= 1) break;
                    this.selectedOption = 0;
                    break;
                }
                if (keyPressed == 8 || keyPressed == 53 || keyPressed == IsoRace.R_FUNCTION || keyPressed == 35) {
                    switch (this.selectedOption) {
                        case 0: {
                            IsoRace.cfg_game_mode = 0;
                            this.openView((byte)9);
                            break;
                        }
                        case 1: {
                            IsoRace.cfg_game_mode = 1;
                            this.openView((byte)9);
                        }
                    }
                    break;
                }
                if (keyPressed != IsoRace.L_FUNCTION && keyPressed != 42) break;
                this.openView((byte)1);
                break;
            }
            case 9: {
                if (keyPressed == 2 || keyPressed == 52) {
                    this.selectedOption = (byte)(this.selectedOption - 1);
                    if (this.selectedOption >= 0) break;
                    this.selectedOption = (byte)3;
                    break;
                }
                if (keyPressed == 5 || keyPressed == 54) {
                    this.selectedOption = (byte)(this.selectedOption + 1);
                    if (this.selectedOption <= 3) break;
                    this.selectedOption = 0;
                    break;
                }
                if (keyPressed == IsoRace.L_FUNCTION || keyPressed == 42) {
                    this.openView((byte)7);
                    break;
                }
                if (keyPressed != 8 && keyPressed != 53 && keyPressed != IsoRace.R_FUNCTION && keyPressed != 35) break;
                IsoRace.selectedCar = this.selectedOption;
                System.out.println("  selected Car = " + IsoRace.selectedCar);
                if (IsoRace.cfg_game_mode == 1) {
                    IsoRace.cfg_kontynuacja = false;
                    IsoRace.championshipTrack = 0;
                    IsoRace.currentSelectedTrack = 0;
                    this.openView((byte)11);
                    break;
                }
                if (IsoRace.cfg_game_mode != 0) break;
                this.openView((byte)8);
                break;
            }
            case 8: {
                if (keyPressed == 2 || keyPressed == 52) {
                    this.selectedOption = (byte)(this.selectedOption - 1);
                    if (this.selectedOption < 0) {
                        this.selectedOption = (byte)(FinalData.trackNames.length - 1);
                    }
                    this.trackLayout = FinalData.trackShapes(this.selectedOption);
                    break;
                }
                if (keyPressed == 5 | keyPressed == 54) {
                    this.selectedOption = (byte)(this.selectedOption + 1);
                    if (this.selectedOption > FinalData.trackNames.length - 1) {
                        this.selectedOption = 0;
                    }
                    this.trackLayout = FinalData.trackShapes(this.selectedOption);
                    break;
                }
                if (keyPressed == IsoRace.L_FUNCTION || keyPressed == 42) {
                    this.openView((byte)7);
                    break;
                }
                if (keyPressed != 8 && keyPressed != 53 && keyPressed != IsoRace.R_FUNCTION && keyPressed != 35) break;
                IsoRace.currentSelectedTrack = this.selectedOption;
                IsoRace.cfg_kontynuacja = false;
                this.openView((byte)11);
                break;
            }
            case 10: {
                if (keyPressed == IsoRace.L_FUNCTION || keyPressed == 42) {
                    this.openView((byte)1);
                    break;
                }
                if (keyPressed != IsoRace.R_FUNCTION && keyPressed != 35) break;
                this.mainMidlet.destroyApp(true);
            }
        }
        keyPressed = -999;
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long startTime = 0L;
        long endTime = 0L;
        while (this.animationThread == Thread.currentThread()) {
            if (this.currentView == 0 && System.currentTimeMillis() - this.showCoverScreenTime > 3000L) {
                this.openView((byte)1);
            }
            startTime = System.currentTimeMillis();
            this.serviceRepaints();
            this.repaint();
            endTime = System.currentTimeMillis();
            try {
                MenuCanvas menuCanvas;
                if (endTime - startTime < 25L) {
                    menuCanvas = this;
                    synchronized (menuCanvas) {
                        this.wait(25L - (endTime - startTime));
                        continue;
                    }
                }
                menuCanvas = this;
                synchronized (menuCanvas) {
                    this.wait(2L);
                }
            }
            catch (InterruptedException ex) {
            }
        }
    }

    private void initScrollHandler(String text, int lineWidth, CustomFont customFont) {
        this.wrappedText.removeAllElements();
        this.wrappedText = this.wrap(text, lineWidth, customFont);
        this.scroolingHandler = true;
        this.lastLine = false;
        this.startLineDraw = 0;
    }

    private void drawScrollFrame(Graphics g, int x, int y, int heightText, int aligment, CustomFont font, int heightFontCorrection) {
        this.menuArrowsSprite.nextFrame();
        int startTmpY = y;
        if (this.startLineDraw > 0) {
            this.menuArrowsSprite.setTransform(4);
            this.menuArrowsSprite.setPosition(this.screenWidth >> 1, y);
            this.menuArrowsSprite.paint(g);
        }
        int size = this.wrappedText.size();
        for (int i = this.startLineDraw; i < size; ++i) {
            font.drawString(g, this.wrappedText.elementAt(i).toString().toCharArray(), x, y += font.heightFont + 1 + heightFontCorrection, aligment);
            if (y + startTmpY <= startTmpY + heightText || i >= size - 1) continue;
            this.lastLine = false;
            this.menuArrowsSprite.setTransform(7);
            this.menuArrowsSprite.setPosition(this.screenWidth >> 1, y + 20);
            this.menuArrowsSprite.paint(g);
            return;
        }
        this.lastLine = true;
    }

    public Vector wrap(String textToWrapp, int lineWidth, CustomFont ff) {
        Vector<CharSequence> vector = new Vector<CharSequence>();
        StringBuffer line = new StringBuffer();
        int i = 0;
        int lineSpaceIndex = 0;
        int textCharIndex = 0;
        int lastWhiteSpaceIndex = 0;
        char character = ' ';
        int textLength = textToWrapp.length();
        while (textCharIndex < textLength) {
            character = textToWrapp.charAt(textCharIndex);
            if (character != ' ' && character != '^') {
                i += ff.charSize(character);
            }
            if (character == ' ') {
                lastWhiteSpaceIndex = textCharIndex;
                lineSpaceIndex = line.length();
            }
            ++textCharIndex;
            if (character == '^') {
                i = 0;
                vector.addElement(line.toString().trim());
                line = new StringBuffer();
                continue;
            }
            line.append(character);
            if (i <= lineWidth || this.currentView == 6) continue;
            i = 0;
            textCharIndex = lastWhiteSpaceIndex;
            line.setLength(lineSpaceIndex);
            vector.addElement(line);
            line = new StringBuffer();
        }
        vector.addElement(line.toString().trim());
        return vector;
    }

    private void scrollHandler(int keyCode) {
        if (this.scroolingHandler) {
            if ((keyCode == 50 || 1 == keyCode) && this.startLineDraw > 0) {
                this.startLineDraw = (byte)(this.startLineDraw - 1);
            }
            if (!(keyCode != 56 && 6 != keyCode || this.lastLine)) {
                this.startLineDraw = (byte)(this.startLineDraw + 1);
            }
        }
    }

    private void drawSelectCarView(Graphics g) {
        Image carImage = null;
        try {
            if (this.selectedOption == 0) {
                carImage = ImageSet.getMenuImage("/menu/menu_graycar.png");
            } else if (this.selectedOption == 1) {
                carImage = ImageSet.getMenuImage("/menu/menu_greencar.png");
            } else if (this.selectedOption == 2) {
                carImage = ImageSet.getMenuImage("/menu/menu_redcar.png");
            } else if (this.selectedOption == 3) {
                carImage = ImageSet.getMenuImage("/menu/menu_yellowcar.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int scSPEED = 2;
        int scACC = 10;
        int scDRIVE = 20;
        int div = 1;
        int dist = 1;
        int yTitle = 1;
        boolean yFlames = true;
        int paramFactor = 1;
        int dy = 0;
        int shiftY = 0;
        scDRIVE = 6;
        paramFactor = 2;
        CustomFont fontToCarNames = FinalFonts.smallCustomFont;
        CustomFont fontToParams = FinalFonts.smallestCustomFont;
        CustomFont fontToOpt = FinalFonts.smallestCustomFont;
        yFlames = false;
        yTitle = 25;
        int yCarImage = 32;
        int yArrows = 97;
        int yParams = 115;
        dy = FinalFonts.smallCustomFont.heightFont - 5;
        shiftY = 0;
        switch (IsoRace.cfg_lang) {
            case 0: {
                div = 12;
                dist = 9 * this.screenWidth / 24;
                break;
            }
            case 2: {
                div = 20;
                dist = 9 * this.screenWidth / 24;
                break;
            }
            case 3: {
                div = 20;
                dist = 11 * this.screenWidth / 24;
                break;
            }
            default: {
                div = 20;
                dist = 13 * this.screenWidth / 24;
            }
        }
        switch (IsoRace.cfg_lang) {
            case 0: {
                FinalFonts.bigCustomFont.drawString(g, IsoRace.getString("m_ch_car").toCharArray(), this.screenWidth >> 1, yTitle, 33);
                break;
            }
            case 1: {
                FinalFonts.medium2CustomFont.drawString(g, IsoRace.getString("m_ch_car").toCharArray(), this.screenWidth >> 1, yTitle, 33);
                break;
            }
            case 2: {
                FinalFonts.medium2CustomFont.drawString(g, IsoRace.getString("m_ch_car").toCharArray(), this.screenWidth >> 1, yTitle, 33);
                break;
            }
            case 3: {
                FinalFonts.smallCustomFont.drawString(g, IsoRace.getString("m_ch_car").toCharArray(), this.screenWidth >> 1, yTitle - FinalFonts.smallCustomFont.heightFont / 4, 33);
            }
            case 4: {
                FinalFonts.smallCustomFont.drawString(g, IsoRace.getString("m_ch_car").toCharArray(), this.screenWidth >> 1, yTitle - FinalFonts.smallCustomFont.heightFont / 4, 33);
            }
        }
        try {
            g.drawImage(carImage, this.screenWidth >> 1, yCarImage, 17);
            g.drawImage(ImageSet.getMenuImage("/menu/selectbar.png"), this.screenWidth >> 1, yArrows + 1, 3);
            fontToCarNames.drawString(g, this.chooseCarNames[this.selectedOption].toCharArray(), this.screenWidth / 2, yArrows, 3);
        }
        catch (Exception e) {
            this.drawErrorScreen(g);
        }
        if (this.selectedOption == 0) {
            this.selectedArrowsSprite.setFrame(0);
        } else {
            this.selectedArrowsSprite.setFrame(0);
        }
        this.selectedArrowsSprite.setPosition(this.screenWidth / 12, yArrows);
        this.selectedArrowsSprite.paint(g, 0);
        if (this.selectedOption == 3) {
            this.selectedArrowsSprite.setFrame(0);
        } else {
            this.selectedArrowsSprite.setFrame(0);
        }
        this.selectedArrowsSprite.setPosition(this.screenWidth - this.screenWidth / 12, yArrows);
        this.selectedArrowsSprite.paint(g, 2);
        fontToParams.drawString(g, IsoRace.getString("t_speed").toCharArray(), this.screenWidth / div, yParams + 5, 36);
        fontToParams.drawString(g, IsoRace.getString("t_boots").toCharArray(), this.screenWidth / div, yParams + dy + 5, 36);
        fontToParams.drawString(g, IsoRace.getString("t_drive").toCharArray(), this.screenWidth / div, yParams + 2 * dy + 5, 36);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.drawImage(ImageSet.getMenuImage("/menu/line.png"), this.screenWidth / div, yParams + 5 - shiftY, 36);
        g.drawImage(ImageSet.getMenuImage("/menu/line.png"), this.screenWidth / div, yParams + dy + 5 - shiftY, 36);
        g.drawImage(ImageSet.getMenuImage("/menu/line.png"), this.screenWidth / div, yParams + 2 * dy + 5 - shiftY, 36);
        g.setClip(dist, yParams - shiftY, (MathFP.toInt(FinalData.CARS_SPEED[this.selectedOption]) - 60) * scSPEED / paramFactor, 5);
        g.drawImage(ImageSet.getMenuImage("/menu/powerbar.png"), dist, yParams - shiftY, 20);
        g.setClip(dist, yParams + dy - shiftY, FinalData.CARS_ACCELERATION_FOR_MENU[this.selectedOption] * ImageSet.getMenuImage("/menu/powerbar.png").getWidth() / (scACC * paramFactor), 5);
        g.drawImage(ImageSet.getMenuImage("/menu/powerbar.png"), dist, yParams + dy - shiftY, 20);
        g.setClip(dist, yParams + 2 * dy - shiftY, (95 - FinalData.CARS_TURN_SENSITIVE[this.selectedOption]) * scDRIVE / paramFactor, 5);
        g.drawImage(ImageSet.getMenuImage("/menu/powerbar.png"), dist, yParams + 2 * dy - shiftY, 20);
        g.setClip(clipX, clipY, clipW, clipH);
        this.drawBackCont(g, fontToOpt);
    }

    protected void keyPressed(int keyCode) {
        if (this.keysBlocked) {
            return;
        }
        if (this.currentView == 12) {
            this.enterNickName(keyCode);
        }
        try {
            this.keyPressed = this.getGameAction(keyCode);
        }
        catch (Exception e) {
            this.keyPressed = keyCode;
        }
        if (this.keyPressed == 0) {
            this.keyPressed = keyCode;
        }
        this.checkInput(this.keyPressed);
        this.keysBlocked = true;
    }

    protected void keyReleased(int keyCode) {
        this.keyPressed = -999;
    }

    private void initLanguage(byte lang) {
        this.menuOptionLabels[0] = IsoRace.getString("m_continuation");
        this.menuOptionLabels[1] = IsoRace.getString("m_newgame");
        this.menuOptionLabels[2] = IsoRace.getString("m_settings");
        this.menuOptionLabels[3] = IsoRace.getString("m_help");
        this.menuOptionLabels[4] = IsoRace.getString("m_lang");
        this.menuOptionLabels[5] = IsoRace.getString("m_scores");
        this.menuOptionLabels[6] = IsoRace.getString("m_about");
        this.menuOptionLabels[7] = IsoRace.getString("m_exit");
        this.gameModes[0] = IsoRace.getString("mode_single");
        this.gameModes[1] = IsoRace.getString("mode_chap");
        this.languages[0] = IsoRace.getString("lang_en");
        this.languages[1] = IsoRace.getString("lang_pl");
        this.languages[2] = IsoRace.getString("lang_it");
        this.languages[3] = IsoRace.getString("lang_sp");
        this.languages[4] = IsoRace.getString("lang_fr");
        this.settings[0] = IsoRace.getString("op_music");
        this.settings[1] = IsoRace.getString("op_sound");
        this.settings[2] = IsoRace.getString("op_vibration");
    }

    private void enterNickName(int keyCode) {
        int deltaTime = 1000;
        boolean delete = false;
        if (keyCode >= 50 && keyCode <= 57) {
            if (this.lastPressedKeyCode != (long)keyCode) {
                this.pressedKeyItem = (byte)-1;
                if (this.nickLetterIndex < this.playerNick.length - 1) {
                    this.nickLetterIndex = (byte)(this.nickLetterIndex + 1);
                }
            } else if (this.lastPressedKeyCode == (long)keyCode) {
                if (delete) {
                    this.nickLetterIndex = (byte)(this.nickLetterIndex + 1);
                    this.pressedKeyItem = (byte)-1;
                    delete = false;
                }
                if (System.currentTimeMillis() - this.lastTimePressedKey > (long)deltaTime && this.nickLetterIndex < this.playerNick.length - 1) {
                    this.nickLetterIndex = (byte)(this.nickLetterIndex + 1);
                    this.pressedKeyItem = (byte)-1;
                }
            }
            switch (keyCode) {
                case 50: {
                    this.pressedKeyItem = (byte)(this.pressedKeyItem + 1);
                    if (this.pressedKeyItem > 2) {
                        this.pressedKeyItem = 0;
                    }
                    this.playerNick[this.nickLetterIndex] = FinalData.SMS_KEYS[0].toCharArray()[this.pressedKeyItem];
                    break;
                }
                case 51: {
                    this.pressedKeyItem = (byte)(this.pressedKeyItem + 1);
                    if (this.pressedKeyItem > 2) {
                        this.pressedKeyItem = 0;
                    }
                    this.playerNick[this.nickLetterIndex] = FinalData.SMS_KEYS[1].toCharArray()[this.pressedKeyItem];
                    break;
                }
                case 52: {
                    this.pressedKeyItem = (byte)(this.pressedKeyItem + 1);
                    if (this.pressedKeyItem > 2) {
                        this.pressedKeyItem = 0;
                    }
                    this.playerNick[this.nickLetterIndex] = FinalData.SMS_KEYS[2].toCharArray()[this.pressedKeyItem];
                    break;
                }
                case 53: {
                    this.pressedKeyItem = (byte)(this.pressedKeyItem + 1);
                    if (this.pressedKeyItem > 2) {
                        this.pressedKeyItem = 0;
                    }
                    this.playerNick[this.nickLetterIndex] = FinalData.SMS_KEYS[3].toCharArray()[this.pressedKeyItem];
                    break;
                }
                case 54: {
                    this.pressedKeyItem = (byte)(this.pressedKeyItem + 1);
                    if (this.pressedKeyItem > 2) {
                        this.pressedKeyItem = 0;
                    }
                    this.playerNick[this.nickLetterIndex] = FinalData.SMS_KEYS[4].toCharArray()[this.pressedKeyItem];
                    break;
                }
                case 55: {
                    this.pressedKeyItem = (byte)(this.pressedKeyItem + 1);
                    if (this.pressedKeyItem > 3) {
                        this.pressedKeyItem = 0;
                    }
                    this.playerNick[this.nickLetterIndex] = FinalData.SMS_KEYS[5].toCharArray()[this.pressedKeyItem];
                    break;
                }
                case 56: {
                    this.pressedKeyItem = (byte)(this.pressedKeyItem + 1);
                    if (this.pressedKeyItem > 2) {
                        this.pressedKeyItem = 0;
                    }
                    this.playerNick[this.nickLetterIndex] = FinalData.SMS_KEYS[6].toCharArray()[this.pressedKeyItem];
                    break;
                }
                case 57: {
                    this.pressedKeyItem = (byte)(this.pressedKeyItem + 1);
                    if (this.pressedKeyItem > 3) {
                        this.pressedKeyItem = 0;
                    }
                    this.playerNick[this.nickLetterIndex] = FinalData.SMS_KEYS[7].toCharArray()[this.pressedKeyItem];
                    break;
                }
                case 48: {
                    this.playerNick[this.nickLetterIndex] = 32;
                }
            }
            this.lastPressedKeyCode = keyCode;
            this.lastTimePressedKey = System.currentTimeMillis();
        }
        if (keyCode == IsoRace.L_FUNCTION && this.nickLetterIndex >= 0) {
            this.playerNick[this.nickLetterIndex] = 32;
            this.nickLetterIndex = (byte)(this.nickLetterIndex - 1);
            if (this.nickLetterIndex < 0) {
                this.nickLetterIndex = 0;
            }
            this.lastTimePressedKey = 0L;
            delete = true;
        }
        if (keyCode == IsoRace.R_FUNCTION && !"".equals(String.valueOf(this.playerNick).trim())) {
            this.mainMidlet.putHighScore(String.valueOf(this.playerNick).trim(), CarInteraction.playerScore);
            this.mainMidlet.saveConfiguration(false);
            this.openView((byte)1);
        }
        this.keyPressed = -999;
    }
}

