/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.IsoRace;
import game.MapEngine;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TileMenager {
    private int bufferTilesX;
    private int bufferTilesY;
    private int toplefttileX;
    private int toplefttileY;
    private int xmod;
    private int maskValue;
    private int tileValue;
    private int xPt;
    private int yPt;
    private int ibeg;
    private int iend;
    private int jbeg;
    private int jend;
    private int ptViewX;
    private int ptViewY;
    public int bufferX;
    public int bufferY;
    private int col;
    private int row;

    public TileMenager(int bufferTilesX, int bufferTilesY) {
        this.bufferTilesX = bufferTilesX;
        this.bufferTilesY = bufferTilesY;
    }

    public void reset() {
        this.xmod = 0;
        this.toplefttileX = 0;
        this.toplefttileY = 0;
        this.maskValue = 0;
        this.tileValue = 0;
        this.xPt = 0;
        this.yPt = 0;
        this.ibeg = 0;
        this.iend = 0;
        this.jbeg = 0;
        this.jend = 0;
        this.ptViewX = 0;
        this.ptViewY = 0;
        this.bufferX = 0;
        this.bufferY = 0;
    }

    public void setBufferPos(int ptAnchorViewX, int ptAnchorViewY) {
        try {
            this.ptViewX = ptAnchorViewX;
            this.ptViewY = ptAnchorViewY;
            this.toplefttileX = this.ptViewX / MapEngine.tileWidth;
            this.toplefttileY = this.ptViewY / MapEngine.tileHalfHeight;
            this.xmod = this.ptViewX % MapEngine.tileWidth + MapEngine.tileWidth;
        }
        catch (Exception e) {
            System.out.println("SET BUFFER POS ERROR");
        }
    }

    public void translateBuffer(MapEngine me, Image tilesImg, Graphics g, Graphics bgBuffer, Image imgBgBuffer) {
        int deltax1;
        int i;
        int tx = -this.ptViewX;
        int ty = -this.ptViewY;
        int nbx = this.toplefttileX;
        int nby = this.toplefttileY;
        if (nbx != this.bufferX) {
            while (nbx < this.bufferX) {
                --this.bufferX;
                for (i = this.bufferTilesX - 1; i > 0; --i) {
                    bgBuffer.setClip(i * MapEngine.tileWidth, 0, MapEngine.tileWidth, imgBgBuffer.getHeight());
                    bgBuffer.drawImage(imgBgBuffer, MapEngine.tileWidth, 0, 20);
                }
                bgBuffer.setClip(0, 0, imgBgBuffer.getWidth(), imgBgBuffer.getHeight());
                if (this.bufferX <= 0) continue;
                for (i = 0; i < this.bufferTilesY - 1 && i + this.bufferY < MapEngine.mapHeight; ++i) {
                    this.tileValue = me.getTileValue(this.bufferY + i, this.bufferX);
                    deltax1 = (this.bufferY + i) % 2 * MapEngine.tileHalfWidth;
                    this.xPt = 0 * MapEngine.tileWidth + deltax1;
                    this.yPt = i * MapEngine.tileHalfHeight;
                    this.drawTile(bgBuffer, tilesImg, this.xPt, this.yPt, this.tileValue);
                    this.tileValue = me.getTileValue(this.bufferY + i, this.bufferX - 1);
                    this.xPt = -1 * MapEngine.tileWidth + deltax1;
                    this.drawTile(bgBuffer, tilesImg, this.xPt, this.yPt, this.tileValue);
                }
            }
            while (nbx > this.bufferX) {
                ++this.bufferX;
                for (i = 0; i < this.bufferTilesX - 1; ++i) {
                    bgBuffer.setClip(i * MapEngine.tileWidth, 0, MapEngine.tileWidth, imgBgBuffer.getHeight());
                    bgBuffer.drawImage(imgBgBuffer, -MapEngine.tileWidth, 0, 20);
                }
                bgBuffer.setClip(0, 0, imgBgBuffer.getWidth(), imgBgBuffer.getHeight());
                if (this.bufferX + this.bufferTilesX - 1 >= MapEngine.mapWidth) continue;
                for (i = 0; i < this.bufferTilesY && i + this.bufferY < MapEngine.mapHeight; ++i) {
                    this.tileValue = me.getTileValue(this.bufferY + i, this.bufferX + this.bufferTilesX - 1);
                    deltax1 = (this.bufferY + i) % 2 * MapEngine.tileHalfWidth;
                    this.xPt = (this.bufferTilesX - 1) * MapEngine.tileWidth + deltax1;
                    this.yPt = i * MapEngine.tileHalfHeight;
                    this.drawTile(bgBuffer, tilesImg, this.xPt, this.yPt, this.tileValue);
                    this.tileValue = me.getTileValue(this.bufferY + i, this.bufferX + this.bufferTilesX - 2);
                    this.xPt = (this.bufferTilesX - 2) * MapEngine.tileWidth + deltax1;
                    this.drawTile(bgBuffer, tilesImg, this.xPt, this.yPt, this.tileValue);
                }
            }
        }
        if (nby != this.bufferY) {
            int deltax2;
            while (nby < this.bufferY) {
                --this.bufferY;
                for (i = this.bufferTilesY - 1; i > 0; --i) {
                    bgBuffer.setClip(0, i * MapEngine.tileHalfHeight, imgBgBuffer.getWidth(), MapEngine.tileHalfHeight);
                    bgBuffer.drawImage(imgBgBuffer, 0, MapEngine.tileHalfHeight, 20);
                }
                bgBuffer.setClip(0, 0, imgBgBuffer.getWidth(), imgBgBuffer.getHeight());
                deltax1 = this.bufferY % 2 * MapEngine.tileHalfWidth;
                deltax2 = (this.bufferY - 1) % 2 * MapEngine.tileHalfWidth;
                if (this.bufferY < 1) continue;
                for (i = 0; i < this.bufferTilesX && i + this.bufferX < MapEngine.mapWidth; ++i) {
                    this.tileValue = me.getTileValue(this.bufferY, this.bufferX + i);
                    this.xPt = i * MapEngine.tileWidth + deltax1;
                    this.yPt = 0 * MapEngine.tileHalfHeight;
                    this.drawTile(bgBuffer, tilesImg, this.xPt, this.yPt, this.tileValue);
                    this.tileValue = me.getTileValue(this.bufferY - 1, this.bufferX + i);
                    this.xPt = i * MapEngine.tileWidth + deltax2;
                    this.yPt = -1 * MapEngine.tileHalfHeight;
                    this.drawTile(bgBuffer, tilesImg, this.xPt, this.yPt, this.tileValue);
                }
            }
            while (nby > this.bufferY) {
                ++this.bufferY;
                for (i = 0; i < this.bufferTilesY; ++i) {
                    bgBuffer.setClip(0, i * MapEngine.tileHalfHeight, imgBgBuffer.getWidth(), MapEngine.tileHalfHeight);
                    bgBuffer.drawImage(imgBgBuffer, 0, -MapEngine.tileHalfHeight, 20);
                }
                bgBuffer.setClip(0, 0, imgBgBuffer.getWidth(), imgBgBuffer.getHeight());
                deltax1 = (this.bufferY + this.bufferTilesY - 1) % 2 * MapEngine.tileHalfWidth;
                deltax2 = (this.bufferY + this.bufferTilesY - 2) % 2 * MapEngine.tileHalfWidth;
                if (this.bufferY + this.bufferTilesY - 1 >= MapEngine.mapHeight) continue;
                for (i = 0; i < this.bufferTilesX && i + this.bufferX < MapEngine.mapWidth; ++i) {
                    this.tileValue = me.getTileValue(this.bufferY + this.bufferTilesY - 1, this.bufferX + i);
                    this.xPt = i * MapEngine.tileWidth + deltax1;
                    this.yPt = (this.bufferTilesY - 1) * MapEngine.tileHalfHeight;
                    this.drawTile(bgBuffer, tilesImg, this.xPt, this.yPt, this.tileValue);
                    this.tileValue = me.getTileValue(this.bufferY + this.bufferTilesY - 2, this.bufferX + i);
                    this.xPt = i * MapEngine.tileWidth + deltax2;
                    this.yPt = (this.bufferTilesY - 2) * MapEngine.tileHalfHeight;
                    this.drawTile(bgBuffer, tilesImg, this.xPt, this.yPt, this.tileValue);
                }
            }
        }
        this.bufferX = nbx;
        this.bufferY = nby;
        this.repaintBuffer();
        g.translate(tx, ty);
    }

    public void fillWholeBuffer(Graphics g, Image tilesImg, MapEngine me) {
        this.tileValue = 0;
        this.maskValue = 0;
        me.indexBuff = 0;
        this.ibeg = 0;
        this.iend = MapEngine.mapHeight;
        this.jbeg = 0;
        this.jend = MapEngine.mapWidth;
    }

    public void fillBuffer(Graphics g, Image tilesImg, MapEngine me) {
        int deltay;
        this.tileValue = 0;
        this.maskValue = 0;
        me.indexBuff = 0;
        this.ibeg = Math.max(this.toplefttileY, 0);
        this.iend = Math.min(this.toplefttileY + this.bufferTilesY, MapEngine.mapHeight);
        this.jbeg = Math.max(this.toplefttileX, 0);
        this.jend = Math.min(this.toplefttileX + this.bufferTilesX, MapEngine.mapWidth);
        this.xPt = 0;
        this.yPt = 0;
        g.setClip(0, 0, MapEngine.viewSpaceWidth, MapEngine.viewSpaceHeight);
        if (this.ibeg >= 1) {
            --this.ibeg;
            deltay = -this.ptViewY % MapEngine.tileHalfHeight - MapEngine.tileHalfHeight;
        } else {
            deltay = -this.ptViewY % MapEngine.tileHalfHeight;
        }
        for (int ptMapY = this.ibeg; ptMapY < this.iend; ++ptMapY) {
            int deltax;
            this.yPt = (ptMapY - this.ibeg) * MapEngine.tileHalfHeight + deltay;
            if (ptMapY % 2 == 0 && ptMapY != 1) {
                deltax = -this.xmod;
                this.jbeg = Math.max(this.toplefttileX, 0);
            } else {
                deltax = this.jbeg >= 1 ? -this.xmod - MapEngine.tileHalfWidth : -this.xmod + MapEngine.tileHalfWidth;
            }
            for (int ptMapX = --this.jbeg; ptMapX < this.jend; ++ptMapX) {
                this.xPt = (ptMapX - this.jbeg) * MapEngine.tileWidth + deltax;
                this.tileValue = me.getTileValue(ptMapY, ptMapX);
                this.drawTile(g, tilesImg, this.xPt, this.yPt, this.tileValue);
            }
        }
    }

    public void drawMapElements(Graphics g, MapEngine me) {
        g.setClip(0, 0, IsoRace.SCREEN_WIDTH, IsoRace.SCREEN_HEIGHT);
        this.xPt = 0;
        this.yPt = 0;
        me.indexBuff = 0;
        this.ibeg = Math.max(this.toplefttileY, 0);
        this.iend = Math.min(this.toplefttileY + this.bufferTilesY, MapEngine.mapHeight);
        this.jbeg = Math.max(this.toplefttileX - 1, 0);
        this.jend = Math.min(this.toplefttileX + this.bufferTilesX, MapEngine.mapWidth);
        if (this.ibeg >= 1) {
            --this.ibeg;
            this.yPt = -this.ptViewY % MapEngine.tileHalfHeight - MapEngine.tileHalfHeight;
        } else {
            this.yPt = -this.ptViewY % MapEngine.tileHalfHeight;
        }
        for (int ptMapY = this.ibeg; ptMapY < this.iend; ++ptMapY) {
            if (ptMapY % 2 == 0 && ptMapY != 1) {
                this.xPt = -this.xmod;
                this.jbeg = Math.max(this.toplefttileX - 1, 0);
            } else {
                this.xPt = this.jbeg >= 1 ? -this.xmod - MapEngine.tileHalfWidth : -this.xmod + MapEngine.tileHalfWidth;
            }
            for (int ptMapX = --this.jbeg; ptMapX < this.jend; ++ptMapX) {
                this.maskValue = me.getTileMaskValue(ptMapY, ptMapX);
                me.drawCharacters(g, ptMapX, ptMapY);
                me.drawMapElement(g, this.maskValue, this.xPt, this.yPt, ptMapY, this.iend);
                this.xPt += MapEngine.tileWidth;
            }
            this.yPt += MapEngine.tileHalfHeight;
        }
        me.drawBufferedMapElements(g);
    }

    private void drawTile(Graphics g, Image tilesImg, int xPt, int yPt, int tileValue) {
        g.setClip(xPt, yPt, MapEngine.tileWidth, MapEngine.tileHeight);
        this.col = tileValue % 10;
        this.row = tileValue / 10;
        g.drawImage(tilesImg, xPt - this.col * MapEngine.tileWidth, yPt - this.row * MapEngine.tileHeight, 20);
    }

    private void repaintBuffer() {
    }
}

