/*
 * Decompiled with CFR 0.152.
 */
package game.car;

import body.Cuboid;
import game.FinalData;
import game.IsoRace;
import game.MapCharacter;
import game.MapEngine;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.jscience.math.kvm.MathFP;
import utils.SpriteGame;

public class BaseCar
extends Cuboid
implements MapCharacter {
    protected MapEngine mapEngine = null;
    public SpriteGame sprite;
    protected final int omega0 = MathFP.div(FinalData.FP_CAR_ROT_ANGLE_RAD, MathFP.mul(FinalData.FP_dt, FinalData.FP_OMEGA_FACTOR));
    private final int FP_DALFA_FACTOR = MathFP.toFP("0.9");
    protected final int omegaDecreaseFactor = MathFP.toFP("0.8");
    protected int FP_MAX_SC_F;
    protected int FP_MAX_DELTA_SC_F;
    protected int damp0;
    protected int FP_MAX_VEL;
    protected int FP_PAR_VSCF;
    public int scF;
    protected int damp;
    protected int deltaScFWDvalue;
    protected int deltaScBKWvalue;
    protected int spriteTranform = 0;
    public boolean[] unwalkBool = new boolean[4];
    public int[][] surrPT = new int[4][2];
    public int[][] dropPos = new int[2][2];
    public int[] maskValue = new int[4];
    protected int tilePositionX = 0;
    protected int tilePositionY = 0;
    public long startRace = 0L;
    public long finishRaceTime = 0L;
    public int gfxCurrCP;
    public int gfxPrevCP;
    public int gfxNextCP;
    public int racePosCP;
    public int destCheckPoint = 0;
    public int racePosCPdistance = 0;
    public byte racePosition = 0;
    public boolean finishRace = false;
    public int lapsCounterFlag;
    public int raceLapNumber = 0;
    public int lap = 1;
    public boolean isPlayerCar = false;
    public boolean bkwbool = false;
    public boolean przejsciowka = false;
    protected final int[] frameMapping = new int[32];
    protected static final int[] angleMapping = new int[32];
    public int angleMappingCursor = 0;
    public int prev_angleMappingCursor = 0;
    protected boolean collision = false;

    public void clearSpriteImages() {
        this.sprite.clearSpriteImages();
        this.sprite = null;
    }

    public void setMaxParameters(int newFP_MAX_SC_F, int newdamp0) {
        this.FP_MAX_DELTA_SC_F = MathFP.mul(this.FP_MAX_SC_F, MathFP.toFP("0.1"));
        this.FP_MAX_VEL = MathFP.mul(MathFP.div(newFP_MAX_SC_F, MathFP.sub(MathFP.toFP(1), newdamp0)), MathFP.div(FinalData.FP_dt, this.m));
        this.FP_PAR_VSCF = MathFP.div(this.FP_MAX_DELTA_SC_F, this.FP_MAX_VEL);
    }

    public BaseCar(MapEngine mEngine, Image[] images) {
        super(FinalData.FP_CAR_HALF_WIDTH, FinalData.FP_CAR_HALF_LENGTH);
        this.scF = this.FP_MAX_SC_F;
        this.deltaScFWDvalue = this.FP_MAX_DELTA_SC_F;
        this.deltaScBKWvalue = this.FP_MAX_DELTA_SC_F;
        this.sprite = new SpriteGame(images);
        this.mapEngine = mEngine;
        this.setBaseCarFrameAnglesSequence();
        this.gfxCurrCP = 0;
        this.gfxPrevCP = 0;
        this.gfxNextCP = 1;
        this.bkwbool = false;
        this.racePosCPdistance = 0;
        this.destCheckPoint = 1;
        this.przejsciowka = false;
        this.lapsCounterFlag = 0;
        this.lap = 1;
    }

    private void setBaseCarFrameAnglesSequence() {
        int i;
        int dalfaFP = FinalData.FP_CAR_ROT_ANGLE_RAD;
        for (i = 0; i < 16; ++i) {
            this.frameMapping[i] = i;
            this.frameMapping[31 - i] = i + 1;
        }
        for (i = 0; i < angleMapping.length; ++i) {
            int alfaFP;
            int indexFP = MathFP.toFP(i);
            BaseCar.angleMapping[i] = alfaFP = MathFP.mul(indexFP, dalfaFP);
        }
    }

    public void setCollision(boolean bool) {
        this.collision = bool;
    }

    protected void decreaseOmegaAfterCollision() {
        this.omega = MathFP.mul(this.omega, this.omegaDecreaseFactor);
    }

    public final void initCarRotation(int frame) {
        this.angleMappingCursor = frame;
        this.alfa = angleMapping[this.angleMappingCursor];
        this.sprite.setFrame(this.frameMapping[this.angleMappingCursor]);
        this.setFdirectionFP();
        this.spriteTranform = this.alfa < MathFP.PI ? 2 : 0;
    }

    public void pickClosestAlfaSettingForceDirection() {
        if (this.alfa > MathFP.add(angleMapping[this.angleMappingCursor], MathFP.mul(FinalData.FP_CAR_ROT_ANGLE_RAD, this.FP_DALFA_FACTOR))) {
            while (this.alfa > MathFP.add(angleMapping[this.angleMappingCursor], MathFP.mul(FinalData.FP_CAR_ROT_ANGLE_RAD, this.FP_DALFA_FACTOR))) {
                ++this.angleMappingCursor;
                if (this.angleMappingCursor < angleMapping.length) continue;
                this.angleMappingCursor = 0;
                break;
            }
            this.alfa = angleMapping[this.angleMappingCursor];
            this.setFdirectionFP();
            this.setNormalsTowForce();
            this.setSpriteFrame();
        } else if (this.alfa < MathFP.sub(angleMapping[this.angleMappingCursor], MathFP.mul(FinalData.FP_CAR_ROT_ANGLE_RAD, this.FP_DALFA_FACTOR))) {
            while (this.alfa < MathFP.sub(angleMapping[this.angleMappingCursor], MathFP.mul(FinalData.FP_CAR_ROT_ANGLE_RAD, this.FP_DALFA_FACTOR))) {
                --this.angleMappingCursor;
                if (this.angleMappingCursor > -1) continue;
                this.angleMappingCursor = angleMapping.length - 1;
                break;
            }
            this.alfa = angleMapping[this.angleMappingCursor];
            this.setFdirectionFP();
            this.setNormalsTowForce();
            this.setSpriteFrame();
        }
    }

    private void setSpriteFrame() {
        this.spriteTranform = this.alfa <= MathFP.PI ? 2 : 0;
        try {
            this.sprite.setFrame(this.frameMapping[this.angleMappingCursor]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStartPositionByTile(int xTile, int yTile) {
        int xPt = xTile * MapEngine.tileWidth + 5;
        int yPt = yTile * (MapEngine.tileHeight / 2);
        this.sprite.setPosition(xPt, yPt);
        this.tilePositionX = xTile;
        this.tilePositionY = yTile;
    }

    public void switchLapNo(int maskValue) {
        if (maskValue == 8 && this.lapsCounterFlag == 2) {
            this.lapsCounterFlag = 0;
            ++this.lap;
            this.przejsciowka = false;
        } else if (maskValue == 8 && this.lapsCounterFlag == 1) {
            this.lapsCounterFlag = 0;
        } else if (maskValue == 9) {
            this.lapsCounterFlag = 1;
        } else if (maskValue == 10 && this.lapsCounterFlag == 1) {
            this.lapsCounterFlag = 2;
        }
    }

    public void setRaceLapNumber(int raceLapNumber) {
        this.raceLapNumber = raceLapNumber;
    }

    public void draw(Graphics g) {
        g.setClip(0, 0, IsoRace.SCREEN_WIDTH, IsoRace.SCREEN_HEIGHT);
        if (this.isPlayerCar) {
            int i;
            for (i = 0; i < this.surrPT.length; ++i) {
                int[] nArray = this.surrPT[i];
                nArray[0] = nArray[0] - MapEngine.ptAnchorViewX;
                int[] nArray2 = this.surrPT[i];
                nArray2[1] = nArray2[1] - MapEngine.ptAnchorViewY;
            }
            for (i = 0; i < this.cornerFP.length; ++i) {
                int[] nArray = this.cornerInt[i];
                nArray[0] = nArray[0] - MapEngine.ptAnchorViewX;
                int[] nArray3 = this.cornerInt[i];
                nArray3[1] = nArray3[1] - MapEngine.ptAnchorViewY;
            }
            for (i = 0; i < this.dropPos.length; ++i) {
                int[] nArray = this.dropPos[i];
                nArray[0] = nArray[0] - MapEngine.ptAnchorViewX;
                int[] nArray4 = this.dropPos[i];
                nArray4[1] = nArray4[1] - MapEngine.ptAnchorViewY;
            }
            this.sprite.paintPlayerCar(g, this.spriteTranform, this.sprite.x - MapEngine.ptAnchorViewX, this.sprite.y - MapEngine.ptAnchorViewY, this.surrPT, this.dropPos, this.cornerInt, this.unwalkBool, this.maskValue, this.racePosition);
        } else {
            this.sprite.paintOppCar(g, this.spriteTranform, this.sprite.x - MapEngine.ptAnchorViewX, this.sprite.y - MapEngine.ptAnchorViewY, this.lap, this.racePosCP);
        }
    }

    public int getTileX() {
        return this.tilePositionX;
    }

    public int getTileY() {
        return this.tilePositionY;
    }

    public void setTileX(int x) {
        this.tilePositionX = x;
    }

    public void setTileY(int y) {
        this.tilePositionY = y;
    }
}

