/*
 * Decompiled with CFR 0.152.
 */
package game.car;

import game.ApplicationCanvas;
import game.FinalData;
import game.FinalFonts;
import game.IsoRace;
import game.car.CarInteraction;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import utils.CustomFont;
import utils.ImageSet;
import utils.Sounds;
import utils.SpriteGame;

public class CarUpgrade {
    private Sounds sound;
    private SpriteGame menuFlamesSprite;
    private SpriteGame selectedArrowsSprite;
    private char[][] upgradeText = new char[][]{IsoRace.getCharArray("engine"), IsoRace.getCharArray("nitro"), IsoRace.getCharArray("suspension")};
    private int selectedMenu = 0;
    private SpriteGame partUpgrade = null;
    private int selectedUpgrade = 0;
    private int selectedUpgradeOption = 0;
    private int engineSelectedUpgrade = 1;
    private int nitroSelectedUpgrade = 0;
    private int suspSelectedUpgrade = 0;
    private boolean notEnoughMoney = false;

    public void loadImages() {
    }

    public CarUpgrade(Sounds sound) {
        this.sound = sound;
    }

    public void pressedKey(int keyPressed, boolean qualifiedToNextRace, int playerScore, ApplicationCanvas appCanvas, IsoRace midlet) {
        if (keyPressed == IsoRace.R_FUNCTION || keyPressed == 8) {
            if (qualifiedToNextRace) {
                if (this.selectedMenu == 0) {
                    this.selectedMenu = 1;
                } else if (this.selectedUpgradeOption == CarInteraction.upgradeLevel[this.selectedUpgrade] && this.selectedMenu == 1) {
                    if (CarInteraction.playerCash >= (this.selectedUpgradeOption + 1) * 1000) {
                        this.notEnoughMoney = false;
                        CarInteraction.playerCash -= (this.selectedUpgradeOption + 1) * 1000;
                        int n = this.selectedUpgrade;
                        CarInteraction.upgradeLevel[n] = (byte)(CarInteraction.upgradeLevel[n] + 1);
                        switch (this.selectedUpgrade) {
                            case 0: {
                                this.engineSelectedUpgrade = this.selectedUpgradeOption + 1;
                                break;
                            }
                            case 1: {
                                this.nitroSelectedUpgrade = this.selectedUpgradeOption + 1;
                                break;
                            }
                            case 2: {
                                this.suspSelectedUpgrade = this.selectedUpgradeOption + 1;
                            }
                        }
                    } else {
                        this.notEnoughMoney = true;
                    }
                }
            }
        } else if (keyPressed == 48) {
            CarInteraction.playerCash += 3000;
        } else if (keyPressed == IsoRace.L_FUNCTION || keyPressed == 42) {
            this.notEnoughMoney = false;
            if (appCanvas.currentTrack == FinalData.trackNames.length) {
                appCanvas.goTo((byte)33);
            } else {
                midlet.saveConfiguration(false);
                try {
                    appCanvas.goTo((byte)-25);
                    ImageSet.clearMenuImages();
                    ImageSet.menuImagesLoaded = false;
                    this.clearSprites();
                    ImageSet.loadGameImages();
                    ImageSet.gameImagesLoaded = true;
                }
                catch (IOException e) {
                    System.out.println("clearing loading error");
                }
                System.gc();
                appCanvas.goTo((byte)20);
            }
        } else if (keyPressed == 2) {
            this.notEnoughMoney = false;
            if (this.selectedUpgradeOption > 0 && this.selectedMenu == 1) {
                --this.selectedUpgradeOption;
                switch (this.selectedUpgrade) {
                    case 0: {
                        this.engineSelectedUpgrade = this.selectedUpgradeOption + 1;
                        break;
                    }
                    case 1: {
                        this.nitroSelectedUpgrade = this.selectedUpgradeOption + 1;
                        break;
                    }
                    case 2: {
                        this.suspSelectedUpgrade = this.selectedUpgradeOption + 1;
                    }
                }
            } else if (this.selectedMenu == 0) {
                --this.selectedUpgrade;
                if (this.selectedUpgrade < 0) {
                    this.selectedUpgrade = 2;
                }
                this.selectedUpgradeOption = CarInteraction.upgradeLevel[this.selectedUpgrade];
                this.partUpgrade = new SpriteGame(ImageSet.getMenuImage(FinalData.upg_parts[this.selectedUpgrade]), FinalData.upgradeFramesWidth[this.selectedUpgrade], FinalData.upgradeFramesHeight[this.selectedUpgrade]);
                switch (this.selectedUpgrade) {
                    case 0: {
                        this.engineSelectedUpgrade = CarInteraction.upgradeLevel[0] + 1;
                        if (this.engineSelectedUpgrade > 3) {
                            --this.engineSelectedUpgrade;
                        }
                        this.nitroSelectedUpgrade = CarInteraction.upgradeLevel[1];
                        this.suspSelectedUpgrade = CarInteraction.upgradeLevel[2];
                        break;
                    }
                    case 1: {
                        this.engineSelectedUpgrade = CarInteraction.upgradeLevel[0];
                        this.nitroSelectedUpgrade = CarInteraction.upgradeLevel[1] + 1;
                        if (this.nitroSelectedUpgrade > 3) {
                            --this.nitroSelectedUpgrade;
                        }
                        this.suspSelectedUpgrade = CarInteraction.upgradeLevel[2];
                        break;
                    }
                    case 2: {
                        this.engineSelectedUpgrade = CarInteraction.upgradeLevel[0];
                        this.nitroSelectedUpgrade = CarInteraction.upgradeLevel[1];
                        this.suspSelectedUpgrade = CarInteraction.upgradeLevel[2] + 1;
                        if (this.suspSelectedUpgrade <= 3) break;
                        --this.suspSelectedUpgrade;
                    }
                }
            }
        } else if (keyPressed == 5) {
            this.notEnoughMoney = false;
            if (this.selectedUpgradeOption < 2 && this.selectedMenu == 1) {
                ++this.selectedUpgradeOption;
                switch (this.selectedUpgrade) {
                    case 0: {
                        this.engineSelectedUpgrade = this.selectedUpgradeOption + 1;
                        break;
                    }
                    case 1: {
                        this.nitroSelectedUpgrade = this.selectedUpgradeOption + 1;
                        break;
                    }
                    case 2: {
                        this.suspSelectedUpgrade = this.selectedUpgradeOption + 1;
                    }
                }
            } else if (this.selectedMenu == 0) {
                ++this.selectedUpgrade;
                if (this.selectedUpgrade > this.upgradeText.length - 1) {
                    this.selectedUpgrade = 0;
                }
                this.selectedUpgradeOption = CarInteraction.upgradeLevel[this.selectedUpgrade];
                this.partUpgrade = new SpriteGame(ImageSet.getMenuImage(FinalData.upg_parts[this.selectedUpgrade]), FinalData.upgradeFramesWidth[this.selectedUpgrade], FinalData.upgradeFramesHeight[this.selectedUpgrade]);
                switch (this.selectedUpgrade) {
                    case 0: {
                        this.engineSelectedUpgrade = CarInteraction.upgradeLevel[0] + 1;
                        if (this.engineSelectedUpgrade > 3) {
                            --this.engineSelectedUpgrade;
                        }
                        this.nitroSelectedUpgrade = CarInteraction.upgradeLevel[1];
                        this.suspSelectedUpgrade = CarInteraction.upgradeLevel[2];
                        break;
                    }
                    case 1: {
                        this.engineSelectedUpgrade = CarInteraction.upgradeLevel[0];
                        this.nitroSelectedUpgrade = CarInteraction.upgradeLevel[1] + 1;
                        if (this.nitroSelectedUpgrade > 3) {
                            --this.nitroSelectedUpgrade;
                        }
                        this.suspSelectedUpgrade = CarInteraction.upgradeLevel[2];
                        break;
                    }
                    case 2: {
                        this.engineSelectedUpgrade = CarInteraction.upgradeLevel[0];
                        this.nitroSelectedUpgrade = CarInteraction.upgradeLevel[1];
                        this.suspSelectedUpgrade = CarInteraction.upgradeLevel[2] + 1;
                        if (this.suspSelectedUpgrade <= 3) break;
                        --this.suspSelectedUpgrade;
                    }
                }
            }
        } else if (keyPressed == 1) {
            this.notEnoughMoney = false;
            ++this.selectedMenu;
            if (this.selectedMenu > 1) {
                this.selectedMenu = 0;
            }
        } else if (keyPressed == 6) {
            this.notEnoughMoney = false;
            --this.selectedMenu;
            if (this.selectedMenu < 0) {
                this.selectedMenu = 1;
            }
        }
    }

    public void drawCarUpgradeScreen(Graphics g, CarInteraction carInter) throws IOException {
        CustomFont fontParams = null;
        CustomFont fontTitle = null;
        CustomFont fontNEM = null;
        CustomFont boughtFont = null;
        g.setColor(0);
        g.fillRect(0, 0, IsoRace.SCREEN_WIDTH, IsoRace.SCREEN_HEIGHT);
        g.drawImage(ImageSet.getMenuImage(FinalData.img_backgroud), 0, 0, 20);
        g.drawImage(ImageSet.getMenuImage("/menu/topbar.png"), 0, IsoRace.SCREEN_HEIGHT / 64, 20);
        int yTitle = 0;
        int dyTitle = 0;
        int x0 = IsoRace.SCREEN_WIDTH / 12;
        int x = 0;
        int shiftUPGRADE = 0;
        int dyNotEnMon = 0;
        int yCash = 25 * IsoRace.SCREEN_HEIGHT / 100;
        int yUpgrImage = 40 * IsoRace.SCREEN_HEIGHT / 100;
        int yCharacteristic = 55;
        int yArrows = 85 * IsoRace.SCREEN_HEIGHT / 100;
        switch (IsoRace.cfg_lang) {
            case 0: {
                x0 = IsoRace.SCREEN_WIDTH / 12;
                x = 10 * IsoRace.SCREEN_WIDTH / 24;
                break;
            }
            case 4: {
                x0 = IsoRace.SCREEN_WIDTH / 18;
                x = 12 * IsoRace.SCREEN_WIDTH / 24;
                break;
            }
            default: {
                x0 = IsoRace.SCREEN_WIDTH / 18;
                x = 10 * IsoRace.SCREEN_WIDTH / 24;
            }
        }
        fontNEM = FinalFonts.smallestCustomFont;
        dyNotEnMon = FinalFonts.smallestCustomFont.heightFont - 5;
        fontParams = FinalFonts.smallestCustomFont;
        yCharacteristic = 58;
        int shiftYcharacteristics = 1;
        boughtFont = FinalFonts.smallShadowCustomFont;
        switch (IsoRace.cfg_lang) {
            case 0: {
                x = 10 * IsoRace.SCREEN_WIDTH / 24;
                fontTitle = FinalFonts.bigCustomFont;
                yTitle = fontTitle.heightFont / 4;
                break;
            }
            case 1: {
                x = 12 * IsoRace.SCREEN_WIDTH / 24;
                fontTitle = FinalFonts.smallCustomFont;
                yTitle = fontTitle.heightFont / 2;
                shiftUPGRADE = 15;
                break;
            }
            case 2: {
                x = 10 * IsoRace.SCREEN_WIDTH / 24;
                fontTitle = FinalFonts.bigCustomFont;
                yTitle = fontTitle.heightFont / 4;
                shiftUPGRADE = 15;
                break;
            }
            case 3: {
                x = 12 * IsoRace.SCREEN_WIDTH / 24;
                fontTitle = FinalFonts.smallCustomFont;
                yTitle = fontTitle.heightFont / 2;
                shiftUPGRADE = 15;
                break;
            }
            case 4: {
                x = 12 * IsoRace.SCREEN_WIDTH / 24;
                fontTitle = FinalFonts.bigCustomFont;
                yTitle = fontTitle.heightFont / 4;
                shiftUPGRADE = 15;
            }
        }
        fontTitle.drawString(g, IsoRace.getCharArray("upgrade_car"), IsoRace.SCREEN_WIDTH >> 1, yTitle + dyTitle, 17);
        String cash0String = IsoRace.getString("your_cash");
        String cash1String = " " + CarInteraction.playerCash;
        String cashString = cash0String + cash1String;
        FinalFonts.smallCustomFont.drawString(g, cashString.toCharArray(), 11 * IsoRace.SCREEN_WIDTH / 12, yCash, 40);
        g.drawImage(ImageSet.getMenuImage("/menu/selectbar.png"), IsoRace.SCREEN_WIDTH >> 1, yUpgrImage, 3);
        this.menuFlamesSprite.setPosition(IsoRace.SCREEN_WIDTH >> 1, yUpgrImage);
        this.menuFlamesSprite.paint(g);
        this.partUpgrade.setPosition(IsoRace.SCREEN_WIDTH - this.partUpgrade.getFrameWidth() >> 1, yUpgrImage - (this.partUpgrade.getFrameHeight() >> 1));
        this.partUpgrade.setFrame(this.selectedUpgradeOption);
        this.partUpgrade.paint(g);
        if (this.selectedUpgradeOption <= CarInteraction.upgradeLevel[this.selectedUpgrade]) {
            if (this.selectedUpgradeOption < CarInteraction.upgradeLevel[this.selectedUpgrade]) {
                boughtFont.drawString(g, IsoRace.getCharArray("bought"), IsoRace.SCREEN_WIDTH / 2, yUpgrImage, 3);
            } else if (this.selectedUpgradeOption == CarInteraction.upgradeLevel[this.selectedUpgrade] && this.notEnoughMoney) {
                fontNEM.drawString(g, IsoRace.getCharArray("nem_0"), IsoRace.SCREEN_WIDTH / 2, yUpgrImage - 10, 3);
                fontNEM.drawString(g, IsoRace.getCharArray("nem_1"), IsoRace.SCREEN_WIDTH / 2, yUpgrImage - 10 + dyNotEnMon, 3);
                fontNEM.drawString(g, IsoRace.getCharArray("nem_2"), IsoRace.SCREEN_WIDTH / 2, yUpgrImage - 10 + 2 * dyNotEnMon, 3);
            }
        }
        if (this.selectedUpgradeOption == 0 || this.selectedMenu == 0) {
            this.selectedArrowsSprite.setFrame(1);
        } else {
            this.selectedArrowsSprite.setFrame(0);
        }
        this.selectedArrowsSprite.setPosition(IsoRace.SCREEN_WIDTH / 12, yUpgrImage);
        this.selectedArrowsSprite.paint(g, 0);
        if (this.selectedUpgradeOption == 3) {
            this.selectedUpgradeOption = 2;
        }
        if (this.selectedUpgradeOption == 2 || this.selectedMenu == 0) {
            this.selectedArrowsSprite.setFrame(1);
        } else {
            this.selectedArrowsSprite.setFrame(0);
        }
        this.selectedArrowsSprite.setPosition(11 * IsoRace.SCREEN_WIDTH / 12, yUpgrImage);
        this.selectedArrowsSprite.paint(g, 2);
        fontParams.drawString(g, IsoRace.getCharArray("t_speed"), x0, shiftYcharacteristics + yCharacteristic * IsoRace.SCREEN_HEIGHT / 100, 36);
        fontParams.drawString(g, IsoRace.getCharArray("t_boots"), x0, shiftYcharacteristics + (yCharacteristic + 6) * IsoRace.SCREEN_HEIGHT / 100, 36);
        fontParams.drawString(g, IsoRace.getCharArray("t_drive"), x0, shiftYcharacteristics + (yCharacteristic + 12) * IsoRace.SCREEN_HEIGHT / 100, 36);
        fontParams.drawString(g, IsoRace.getCharArray("t_price"), x0, shiftYcharacteristics + (yCharacteristic + 18) * IsoRace.SCREEN_HEIGHT / 100, 36);
        int priceWidth = FinalFonts.smallCustomFont.stringWidth(IsoRace.getCharArray("t_price"));
        fontParams.drawString(g, (" " + (this.selectedUpgradeOption + 1) * 1000).toCharArray(), x0 + priceWidth, shiftYcharacteristics + (yCharacteristic + 18) * IsoRace.SCREEN_HEIGHT / 100, 36);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.drawImage(ImageSet.getMenuImage("/menu/line.png"), x0, yCharacteristic * IsoRace.SCREEN_HEIGHT / 100, 36);
        g.drawImage(ImageSet.getMenuImage("/menu/line.png"), x0, (yCharacteristic + 6) * IsoRace.SCREEN_HEIGHT / 100, 36);
        g.drawImage(ImageSet.getMenuImage("/menu/line.png"), x0, (yCharacteristic + 12) * IsoRace.SCREEN_HEIGHT / 100, 36);
        g.drawImage(ImageSet.getMenuImage("/menu/line.png"), x0, (yCharacteristic + 18) * IsoRace.SCREEN_HEIGHT / 100, 36);
        g.setClip(x, yCharacteristic * IsoRace.SCREEN_HEIGHT / 100 - 1 - ImageSet.getMenuImage("/menu/powerbar.png").getHeight(), this.engineSelectedUpgrade * 20, 5);
        g.drawImage(ImageSet.getMenuImage("/menu/powerbar.png"), x, yCharacteristic * IsoRace.SCREEN_HEIGHT / 100 - 1, 36);
        g.setClip(x, (yCharacteristic + 6) * IsoRace.SCREEN_HEIGHT / 100 - 1 - ImageSet.getMenuImage("/menu/powerbar.png").getHeight(), this.nitroSelectedUpgrade * 20, 5);
        g.drawImage(ImageSet.getMenuImage("/menu/powerbar.png"), x, (yCharacteristic + 6) * IsoRace.SCREEN_HEIGHT / 100 - 1, 36);
        g.setClip(x, (yCharacteristic + 12) * IsoRace.SCREEN_HEIGHT / 100 - 1 - ImageSet.getMenuImage("/menu/powerbar.png").getHeight(), this.suspSelectedUpgrade * 20, 5);
        g.drawImage(ImageSet.getMenuImage("/menu/powerbar.png"), x, (yCharacteristic + 12) * IsoRace.SCREEN_HEIGHT / 100 - 1, 36);
        g.setClip(clipX, clipY, clipW, clipH);
        g.drawImage(ImageSet.getMenuImage("/menu/line.png"), 0, yArrows, 36);
        if (this.selectedMenu == 1) {
            this.selectedArrowsSprite.setFrame(1);
        } else {
            this.selectedArrowsSprite.setFrame(0);
        }
        this.selectedArrowsSprite.setPosition(IsoRace.SCREEN_WIDTH / 12, yArrows);
        this.selectedArrowsSprite.paint(g, 0);
        if (this.selectedMenu == 1) {
            this.selectedArrowsSprite.setFrame(1);
        } else {
            this.selectedArrowsSprite.setFrame(0);
        }
        this.selectedArrowsSprite.setPosition(11 * IsoRace.SCREEN_WIDTH / 12, yArrows);
        this.selectedArrowsSprite.paint(g, 2);
        this.menuFlamesSprite.setPosition(IsoRace.SCREEN_WIDTH >> 1, yArrows);
        this.menuFlamesSprite.paint(g);
        FinalFonts.bigCustomFont.drawString(g, this.upgradeText[this.selectedUpgrade], IsoRace.SCREEN_WIDTH >> 1, yArrows, 3);
        fontParams.drawString(g, IsoRace.getCharArray("continue"), 5, IsoRace.SCREEN_HEIGHT - 3, 36);
        if (this.selectedUpgradeOption == CarInteraction.upgradeLevel[this.selectedUpgrade] && this.selectedMenu == 1) {
            fontParams.drawString(g, IsoRace.getCharArray("upgrade"), shiftUPGRADE + IsoRace.SCREEN_WIDTH / 2, IsoRace.SCREEN_HEIGHT - 3, 33);
        }
    }

    private void clearSprites() {
        this.menuFlamesSprite.clearSpriteImages();
        this.menuFlamesSprite = null;
        this.partUpgrade.clearSpriteImages();
        this.partUpgrade = null;
    }

    private void prepareSprites() {
        this.menuFlamesSprite = new SpriteGame(ImageSet.getMenuImage("/menu/flames.png"), ImageSet.getMenuImage("/menu/flames.png").getWidth(), ImageSet.getMenuImage("/menu/flames.png").getHeight() / 3);
        this.menuFlamesSprite.setFrameSequence(new int[]{1, 2, 1}, 20);
        this.menuFlamesSprite.setAnchorImage(3);
        this.selectedArrowsSprite = new SpriteGame(ImageSet.getMenuImage("/menu/select_arrows.png"), ImageSet.getMenuImage("/menu/select_arrows.png").getWidth() / 2, ImageSet.getMenuImage("/menu/select_arrows.png").getHeight());
        this.selectedArrowsSprite.setAnchorImage(3);
        this.selectedArrowsSprite.setFrame(0);
        this.partUpgrade = new SpriteGame(ImageSet.getMenuImage(FinalData.upg_parts[this.selectedUpgrade]), FinalData.upgradeFramesWidth[this.selectedUpgrade], FinalData.upgradeFramesHeight[this.selectedUpgrade]);
    }

    public void initUpgradeScreen() {
        this.prepareSprites();
    }

    public void increaseCash(CarInteraction carInter, byte pos) {
        if (pos == 1) {
            CarInteraction.playerCash += 1200;
            CarInteraction.playerCash += CarInteraction.cash;
        } else if (pos == 2) {
            CarInteraction.playerCash += 800;
            CarInteraction.playerCash += CarInteraction.cash;
        }
    }
}

