/*
 * Decompiled with CFR 0.152.
 */
package game.car;

import game.FinalData;
import game.MapEngine;
import game.car.BaseCar;
import javax.microedition.lcdui.Image;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class OpponentCar
extends BaseCar {
    private boolean autoDriver;
    private int currentSensorValue = -1;
    public int dest_x;
    public int dest_y;
    private int[] tileCoords;
    private int omegaValue;
    int dotDirFproduct;
    int dotDirFproductSq;
    Vector2d dir = new Vector2d();
    Vector2d dest = new Vector2d();
    final int accuracy = MathFP.toFP("0.99");

    public OpponentCar(MapEngine mEngine, Image[] images) {
        super(mEngine, images);
        this.setMotionParameters();
    }

    public void initCar(int frame, int maxSpeed, String FP_acc) {
        super.initCarRotation(frame);
        this.setNormals();
        this.setCorners();
    }

    private void setMotionParameters() {
        this.damp = MathFP.toFP("0.85");
        this.scF = FinalData.FP_SC_F_OPP_FINAL;
        int omegaPar = MathFP.toFP("2.5");
        this.omegaValue = MathFP.mul(MathFP.div(MathFP.mul(this.scF, omegaPar), MathFP.toFP(100)), this.omega0);
    }

    public void evaluateVelocity() {
        if (this.collision && this.autoDriver) {
            this.decreaseOmegaAfterCollision();
            if (this.omega < MathFP.div(this.omega0, MathFP.toFP(3))) {
                this.collision = false;
            }
        }
        this.evaluateScaledForceVelEulerFP(FinalData.FP_dt, this.scF, this.damp);
    }

    public void evaluatePositionRotation() {
        this.evaluatePosEulerFP(FinalData.FP_dt);
        this.evaluateRotationAngleFP(FinalData.FP_dt);
        this.pickClosestAlfaSettingForceDirection();
        this.setCorners();
        for (int i = 0; i < this.cornerFP.length; ++i) {
            this.cornerInt[i][0] = MathFP.toInt(this.cornerFP[i].x);
            this.cornerInt[i][1] = MathFP.toInt(MathFP.mul(this.cornerFP[i].y, FinalData.FP_CAM_HEIGHT));
        }
        this.sprite.x = MathFP.toInt(this.pos.x);
        this.sprite.y = MathFP.toInt(MathFP.mul(FinalData.FP_CAM_HEIGHT, this.pos.y));
        this.tileCoords = MapEngine.getTilePositionFromFP(this.pos);
        this.currentSensorValue = this.mapEngine.getTileMaskValueByTile(this.tileCoords[0], this.tileCoords[1]);
        this.tilePositionX = this.tileCoords[0];
        this.tilePositionY = this.tileCoords[1];
        this.sensorValueAction();
    }

    public void integrateEquationOfMotion() {
    }

    public void autoDriverDerby(BaseCar playerCar) {
        if (!this.collision) {
            this.dest.set(playerCar.pos);
            this.dir.setSubFP(this.dest, this.pos);
            this.dir.scaleFP(MathFP.toFP("0.1"));
            this.dir.normalize();
            this.dotDirFproduct = this.fnormal.dotFP(this.dir);
            this.omega = this.dotDirFproduct >= this.accuracy ? 0 : (this.fnormal.crossFP(this.dir) > 0 ? this.omegaValue : -this.omegaValue);
        }
    }

    public void autoDriver() {
        if (this.autoDriver) {
            if (!this.collision) {
                this.dest.setToFP(this.dest_x, this.dest_y);
                this.dir.setSubFP(this.dest, this.pos);
                this.dir.scaleFP(MathFP.toFP("0.1"));
                this.dir.normalize();
                this.dotDirFproduct = this.fnormal.dotFP(this.dir);
                this.omega = this.dotDirFproduct >= this.accuracy ? 0 : (this.fnormal.crossFP(this.dir) > 0 ? this.omegaValue : -this.omegaValue);
            }
        } else {
            this.decreaseOmegaAfterCollision();
        }
    }

    private void sensorValueAction() {
        switch (this.currentSensorValue) {
            case 8: {
                this.switchLapNo(this.currentSensorValue);
                break;
            }
            case 9: {
                this.switchLapNo(this.currentSensorValue);
                break;
            }
            case 10: {
                this.switchLapNo(this.currentSensorValue);
            }
        }
    }

    public void setAutoDriver(boolean bool) {
        this.autoDriver = bool;
    }

    public boolean getAutoDriver() {
        return this.autoDriver;
    }
}

