/*
 * Decompiled with CFR 0.152.
 */
package maths;

import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class Matrix2d {
    public int m00;
    public int m01;
    public int m10;
    public int m11;

    public Matrix2d() {
        this.m00 = MathFP.toFP(this.m00);
        this.m01 = MathFP.toFP(this.m01);
        this.m10 = MathFP.toFP(this.m10);
        this.m11 = MathFP.toFP(this.m11);
    }

    public Matrix2d(int m00, int m01, int m10, int m11) {
        this.setFP(m00, m01, m10, m11);
    }

    public void setFP(int m00, int m01, int m10, int m11) {
        this.m00 = m00;
        this.m01 = m01;
        this.m10 = m10;
        this.m11 = m11;
    }

    public void mulFP(Vector2d vec) {
        vec.setFP(MathFP.add(MathFP.mul(this.m00, vec.x), MathFP.mul(this.m01, vec.y)), MathFP.add(MathFP.mul(this.m10, vec.x), MathFP.mul(this.m11, vec.y)));
    }

    public void setRotMatrixFP(int alfa) {
        this.m00 = MathFP.cos(alfa);
        this.m01 = -MathFP.sin(alfa);
        this.m10 = -this.m01;
        this.m11 = this.m00;
    }

    public void rotateFP(int alfa, Vector2d vec) {
        this.setRotMatrixFP(alfa);
        this.mulFP(vec);
    }

    public void mulSetFP(Vector2d vec, Vector2d finalvec) {
        vec.setFP(MathFP.add(MathFP.mul(this.m00, finalvec.x), MathFP.mul(this.m01, finalvec.y)), MathFP.add(MathFP.mul(this.m10, finalvec.x), MathFP.mul(this.m11, finalvec.y)));
    }

    public void rotateFP(int alfa, Vector2d vec, Vector2d finalvec) {
        this.setRotMatrixFP(alfa);
        vec.setFP(MathFP.add(MathFP.mul(this.m00, finalvec.x), MathFP.mul(this.m01, finalvec.y)), MathFP.add(MathFP.mul(this.m10, finalvec.x), MathFP.mul(this.m11, finalvec.y)));
    }

    public Vector2d rotateVecFP(int alfa, Vector2d vec) {
        Vector2d newVec = new Vector2d(vec.x, vec.y);
        this.setRotMatrixFP(alfa);
        this.mulFP(newVec);
        return newVec;
    }
}

