/*
 * Decompiled with CFR 0.152.
 */
package maths;

import maths.Matrix2d;
import net.jscience.math.kvm.MathFP;

public class Vector2d {
    public int x;
    public int y;

    public Vector2d(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d() {
        this.x = MathFP.toFP(this.x);
        this.y = MathFP.toFP(this.y);
    }

    public void set(Vector2d vec) {
        this.setFP(vec.x, vec.y);
    }

    public void setToFP(int x, int y) {
        this.x = MathFP.toFP(x);
        this.y = MathFP.toFP(y);
    }

    public void setFP(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int lengthFP() {
        int sq = MathFP.toFP(2);
        return MathFP.sqrt(MathFP.add(MathFP.pow(MathFP.abs(this.x), sq), MathFP.pow(MathFP.abs(this.y), sq)));
    }

    public int lengthSquaredFP() {
        int sq = MathFP.toFP(2);
        return MathFP.add(MathFP.pow(MathFP.abs(this.x), sq), MathFP.pow(MathFP.abs(this.y), sq));
    }

    public void scaleFP(int sc) {
        this.x = MathFP.mul(this.x, sc);
        this.y = MathFP.mul(this.y, sc);
    }

    public void divFP(int sc) {
        this.x = MathFP.div(this.x, sc);
        this.y = MathFP.div(this.y, sc);
    }

    public Vector2d scaleVecFP(int sc) {
        Vector2d vec = new Vector2d();
        vec.set(this);
        vec.scaleFP(sc);
        return vec;
    }

    public void setScaleFP(int sc, Vector2d vec) {
        this.x = MathFP.mul(vec.x, sc);
        this.y = MathFP.mul(vec.y, sc);
    }

    public void setAddFP(Vector2d v1, Vector2d v2) {
        this.setFP(MathFP.add(v1.x, v2.x), MathFP.add(v1.y, v2.y));
    }

    public void setSubFP(Vector2d v1, Vector2d v2) {
        this.setFP(MathFP.sub(v1.x, v2.x), MathFP.sub(v1.y, v2.y));
    }

    public void setMulFP(Matrix2d mat, Vector2d finalvec) {
        mat.mulSetFP(this, finalvec);
    }

    public void normalize() {
        int l = this.lengthFP();
        this.divFP(l);
    }

    public int crossFP(Vector2d vec) {
        return MathFP.sub(MathFP.mul(this.x, vec.y), MathFP.mul(this.y, vec.x));
    }

    public void setCrossFP(int omega, Vector2d vec) {
        this.setFP(MathFP.mul(MathFP.toFP(-1), MathFP.mul(omega, vec.y)), MathFP.mul(omega, vec.x));
    }

    public int dotFP(Vector2d vec) {
        return MathFP.add(MathFP.mul(this.x, vec.x), MathFP.mul(this.y, vec.y));
    }

    public int dist(Vector2d vec) {
        Vector2d r = new Vector2d();
        r.setSubFP(this, vec);
        return r.lengthFP();
    }

    public void add(Vector2d vec) {
        this.x = MathFP.add(vec.x, this.x);
        this.y = MathFP.add(vec.y, this.y);
    }

    public Vector2d addVecFP(Vector2d v) {
        Vector2d vec = new Vector2d();
        vec.setAddFP(this, v);
        return vec;
    }

    public void sub(Vector2d vec) {
        this.x = MathFP.sub(this.x, vec.x);
        this.y = MathFP.sub(this.y, vec.y);
    }

    public Vector2d subVecFP(Vector2d v) {
        Vector2d vec = new Vector2d();
        vec.setSubFP(this, v);
        return vec;
    }
}

