/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class Sounds
implements PlayerListener {
    private String pickupsoundPath = "/mp3/pickup-sound2.mp3";
    private String menumusicPath = "/mp3/menu2.mp3";
    private static final int NUM_ITEMS_SOUNDS = 3;
    private Player itemPlayer;
    private Player menuMusicPlayer;

    public void printSupportedAudio() {
        System.out.println("****************************************************************************");
        System.out.println("Loading sounds");
        System.out.println("****************************************************************************");
        String[] contenttypes = new String[]{"audio/x-wav", "audio/basic", "audio/mpeg", "audio/midi", "audio/x-tone-seq"};
        String[] array = Manager.getSupportedContentTypes(null);
        System.out.println("Supported content types:");
        for (int m = 0; m < array.length; ++m) {
            System.out.println(array[m]);
        }
        System.out.println("****************************************************************************");
        for (int i = 0; i < contenttypes.length; ++i) {
            System.out.println(contenttypes[i]);
            String[] protocols = Manager.getSupportedProtocols((String)contenttypes[i]);
            for (int j = 0; j < protocols.length; ++j) {
                System.out.println(protocols[j]);
            }
            System.out.println("****************************************************************************");
        }
    }

    public Sounds(boolean sounds, boolean music) {
        if (sounds) {
            this.loadItemSound(this.pickupsoundPath, "audio/mpeg");
        } else if (music) {
            this.loadMenuMusic(this.menumusicPath, "audio/mpeg");
            this.playMenuMusic();
        }
    }

    public void loadMenuMusic() {
        this.loadMenuMusic(this.menumusicPath, "audio/mpeg");
    }

    public void loadItemSound() {
        this.loadItemSound(this.pickupsoundPath, "audio/mpeg");
    }

    public void closeMenuMusic() {
        if (this.menuMusicPlayer != null) {
            try {
                this.menuMusicPlayer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeItemSound() {
        if (this.itemPlayer != null) {
            try {
                this.itemPlayer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadMenuMusic(String filePath, String contenttype) {
        try {
            this.menuMusicPlayer = this.loadSound(filePath, contenttype);
            if (this.menuMusicPlayer != null) {
                this.menuMusicPlayer.setLoopCount(255);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadItemSound(String filePath, String contenttype) {
        try {
            this.itemPlayer = this.loadSound(filePath, contenttype);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Player loadSound(String filePath, String contenttype) {
        Player p = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(filePath);
            p = Manager.createPlayer((InputStream)in, (String)contenttype);
            p.realize();
            p.prefetch();
        }
        catch (Exception ex) {
            System.out.println("Could not load sound in " + filePath);
            System.out.println(ex.getClass());
            System.out.println(ex.getMessage());
        }
        return p;
    }

    public void playItemSound() {
        this.playSound(this.itemPlayer);
    }

    public void playMenuMusic() {
        this.playSound(this.menuMusicPlayer);
    }

    public void stopMenuMusic() {
        try {
            this.menuMusicPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopItemSound() {
        try {
            this.itemPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void playSound(Player p) {
        if (p != null && p.getState() == 300) {
            try {
                p.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void playerUpdate(Player p, String event, Object eventData) {
        if (event == "endOfMedia") {
            try {
                p.stop();
                p.setMediaTime(0L);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public int getItemPlayerState() {
        return this.itemPlayer.getState();
    }

    public int getMusicPlayerState() {
        return this.menuMusicPlayer.getState();
    }

    public void stopSounds() {
        try {
            this.menuMusicPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

