/*
 * Decompiled with CFR 0.152.
 */
package body;

import maths.Matrix2d;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class RigidBody {
    public int m;
    public int m_inv;
    protected int I;
    public int I_inv;
    public int R;
    public Vector2d[] n;
    public int[] halfEdge;
    public int surrRectHalfSide;
    protected Matrix2d rotM;
    public int torque;
    public Vector2d f;
    protected Vector2d fnormal;
    public Vector2d velFromAcc;
    public Vector2d pos;
    public Vector2d vel;
    public int v;
    public int omega;
    protected int alfa;
    protected final Vector2d oyVec = new Vector2d(MathFP.toFP(0), MathFP.toFP(-1));
    protected final Vector2d oxVec = new Vector2d(MathFP.toFP(1), MathFP.toFP(0));

    public RigidBody() {
        this.initFPvalues();
        this.createVectorsFP();
    }

    private void createVectorsFP() {
        this.pos = new Vector2d();
        this.vel = new Vector2d();
        this.fnormal = new Vector2d();
        this.f = new Vector2d();
        this.velFromAcc = new Vector2d();
        this.rotM = new Matrix2d();
        this.rotM.setRotMatrixFP(this.alfa);
    }

    private void initFPvalues() {
        this.omega = MathFP.toFP(this.omega);
        this.alfa = MathFP.toFP(this.alfa);
        this.m = MathFP.toFP(this.m);
        this.m_inv = MathFP.toFP(this.m_inv);
        this.I = MathFP.toFP(this.I);
        this.I_inv = MathFP.toFP(this.I_inv);
        this.R = MathFP.toFP(this.R);
        this.v = MathFP.toFP(this.v);
    }

    protected void setParametersFP(int m, int I, int R) {
        this.m = m;
        this.m_inv = MathFP.div(MathFP.toFP(1), m);
        this.I = I;
        this.I_inv = MathFP.div(MathFP.toFP(1), I);
        this.R = R;
    }

    public void setForce(Vector2d force) {
        this.f.set(force);
    }

    protected void setFdirectionFP() {
        this.rotM.rotateFP(this.alfa, this.fnormal, this.oyVec);
    }

    public void evaluateVelEulerFP(int dt, int damp) {
        this.velFromAcc.setScaleFP(MathFP.mul(this.m_inv, dt), this.f);
        this.vel.x = MathFP.add(MathFP.mul(damp, this.vel.x), MathFP.mul(this.f.x, MathFP.mul(this.m_inv, dt)));
        this.vel.y = MathFP.add(MathFP.mul(damp, this.vel.y), MathFP.mul(this.f.y, MathFP.mul(this.m_inv, dt)));
    }

    public void evaluateScaledForceVelEulerFP(int dt, int scF, int damp) {
        this.vel.x = MathFP.add(MathFP.mul(damp, this.vel.x), MathFP.mul(MathFP.mul(this.fnormal.x, scF), MathFP.mul(this.m_inv, dt)));
        this.vel.y = MathFP.add(MathFP.mul(damp, this.vel.y), MathFP.mul(MathFP.mul(this.fnormal.y, scF), MathFP.mul(this.m_inv, dt)));
    }

    public void evaluatePosEulerFP(int dt) {
        this.pos.x = MathFP.add(this.pos.x, MathFP.mul(this.vel.x, dt));
        this.pos.y = MathFP.add(this.pos.y, MathFP.mul(this.vel.y, dt));
    }

    public void evaluateRotationAngleFP(int dt) {
        this.alfa = MathFP.add(this.alfa, MathFP.mul(this.omega, dt));
    }

    public void setBodyPosFP(int x, int y) {
        this.pos.setFP(x, y);
    }

    public void setBodyPosFP(Vector2d pos) {
        this.pos.setFP(pos.x, pos.y);
    }

    public void setBodyVelFP(Vector2d vel) {
        this.vel.setFP(vel.x, vel.y);
    }

    public void setOmega(int omegaFP) {
        this.omega = omegaFP;
    }

    public void computeVFP() {
        this.v = this.vel.lengthFP();
    }

    public int toRadians(int alfaFP) {
        return MathFP.mul(MathFP.div(alfaFP, MathFP.toFP(180)), MathFP.PI);
    }

    public int toDegrees(int alfaFP) {
        return MathFP.mul(MathFP.div(alfaFP, MathFP.PI), MathFP.toFP(180));
    }
}

