/*
 * Decompiled with CFR 0.152.
 */
package body.interaction;

import body.RigidBody;
import body.interaction.Contact;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class Collision {
    private RigidBody a;
    private RigidBody b;
    private Vector2d ray0;
    private Vector2d ray1;
    private Vector2d vel0;
    private Vector2d vel1;
    private Vector2d n;
    private Vector2d vwzgl = new Vector2d();
    private int[] crossProductSc = new int[2];
    public int J;

    public void rigidBodyInfMassPointCollisionProcedure(Contact ct, int eFP) {
        this.a = ct.a;
        this.ray0 = ct.r[0];
        this.vel0 = ct.v[0];
        this.n = ct.n;
        this.rigidBodyInfMassPointCollisionProcedure(this.a, this.ray0, this.vel0, this.n, eFP);
    }

    public void rigidBodiesCollisionProcedure(Contact ct, int eFP) {
        this.a = ct.a;
        this.b = ct.b;
        this.ray0 = ct.r[0];
        this.ray1 = ct.r[1];
        this.vel0 = ct.v[0];
        this.vel1 = ct.v[1];
        this.n = ct.n;
        this.rigidBodiesCollisionProcedure(this.a, this.b, this.ray0, this.ray1, this.vel0, this.vel1, this.n, eFP);
    }

    private void rigidBodyInfMassPointCollisionProcedure(RigidBody body0, Vector2d ray0, Vector2d vel0, Vector2d n, int eFP) {
        this.vwzgl.set(vel0);
        this.crossProductSc[0] = ray0.crossFP(n);
        int num = MathFP.mul(MathFP.add(MathFP.toFP(1), eFP), this.vwzgl.dotFP(n));
        int denom = body0.m_inv;
        this.J = -MathFP.div(num, denom += MathFP.mul(MathFP.pow(MathFP.abs(this.crossProductSc[0]), MathFP.toFP(2)), body0.I_inv));
        this.changeBodyAngularLinearVelocity(body0, -this.J, n, this.crossProductSc[0]);
    }

    private void rigidBodiesCollisionProcedure(RigidBody body0, RigidBody body1, Vector2d ray0, Vector2d ray1, Vector2d vel0, Vector2d vel1, Vector2d wr, int eFP) {
        this.vwzgl.setSubFP(vel0, vel1);
        this.crossProductSc[0] = ray0.crossFP(wr);
        this.crossProductSc[1] = ray1.crossFP(wr);
        int num = MathFP.mul(MathFP.add(MathFP.toFP(1), eFP), this.vwzgl.dotFP(wr));
        int denom = MathFP.add(body0.m_inv, body1.m_inv);
        this.J = -MathFP.div(num, denom += MathFP.add(MathFP.mul(MathFP.pow(MathFP.abs(this.crossProductSc[0]), MathFP.toFP(2)), body0.I_inv), MathFP.mul(MathFP.pow(MathFP.abs(this.crossProductSc[1]), MathFP.toFP(2)), body1.I_inv)));
        this.changeBodyAngularLinearVelocity(body0, -this.J, wr, this.crossProductSc[0]);
        this.changeBodyAngularLinearVelocity(body1, this.J, wr, this.crossProductSc[1]);
    }

    private void changeBodyAngularLinearVelocity(RigidBody body, int J, Vector2d wr, int crossProductSc) {
        int J_m_inv = MathFP.mul(J, body.m_inv);
        int J_I_inv = MathFP.mul(J, body.I_inv);
        body.vel.x = MathFP.sub(body.vel.x, MathFP.mul(wr.x, J_m_inv));
        body.vel.y = MathFP.sub(body.vel.y, MathFP.mul(wr.y, J_m_inv));
        body.omega = MathFP.sub(body.omega, MathFP.mul(J_I_inv, crossProductSc));
    }

    private void changeBodyLinearVelocity(RigidBody body, int J, Vector2d wr) {
        int J_m_inv = MathFP.mul(J, body.m_inv);
        body.vel.x = MathFP.sub(body.vel.x, MathFP.mul(wr.x, J_m_inv));
        body.vel.y = MathFP.sub(body.vel.y, MathFP.mul(wr.y, J_m_inv));
    }

    public void halfRigidBodyCollisionProcedure(Contact ct, int eFP) {
        this.a = ct.a;
        this.b = ct.b;
        this.ray0 = ct.r[0];
        this.ray1 = ct.r[1];
        this.vel0 = ct.v[0];
        this.vel1 = ct.v[1];
        this.n = ct.n;
        this.halfRigidBodyCollisionProcedure(this.a, this.b, this.ray0, this.ray1, this.vel0, this.vel1, this.n, eFP);
    }

    public void halfRigidBodyCollisionProcedure(RigidBody lightBody, RigidBody heavyBody, Vector2d ray0, Vector2d ray1, Vector2d vel0, Vector2d vel1, Vector2d wr, int eFP) {
        this.vwzgl.setSubFP(vel0, vel1);
        this.crossProductSc[1] = ray1.crossFP(wr);
        int num = MathFP.mul(MathFP.add(MathFP.toFP(1), eFP), this.vwzgl.dotFP(wr));
        int denom = MathFP.add(heavyBody.m_inv, lightBody.m_inv);
        this.J = -MathFP.div(num, denom += MathFP.add(MathFP.toFP(0), MathFP.mul(MathFP.pow(MathFP.abs(this.crossProductSc[1]), MathFP.toFP(2)), heavyBody.I_inv)));
        this.changeBodyLinearVelocity(lightBody, -this.J, wr);
    }
}

