/*
 * Decompiled with CFR 0.152.
 */
package body.interaction;

import body.RigidBody;
import body.interaction.Contact;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class CollisionWithRestContact {
    private RigidBody a;
    private RigidBody b;
    private Vector2d ray0;
    private Vector2d ray1;
    private Vector2d vel0;
    private Vector2d vel1;
    private Vector2d n;
    private Vector2d vwzgl = new Vector2d();
    private int[] crossProductSc = new int[2];
    public int J;

    public void rigidBodiesCollisionProcedure(Contact[] ct, int eFP) {
        for (int i = 0; i < ct.length; ++i) {
            this.rigidBodiesCollisionProcedure(ct[i], eFP);
        }
    }

    public void rigidBodiesCollisionProcedure(Contact ct, int eFP) {
        this.a = ct.a;
        this.b = ct.b;
        this.ray0 = ct.r[0];
        this.ray1 = ct.r[1];
        this.vel0 = ct.v[0];
        this.vel1 = ct.v[1];
        this.n = ct.n;
        this.rigidBodiesCollisionProcedure(this.a, this.b, this.ray0, this.ray1, this.vel0, this.vel1, this.n, eFP);
    }

    private void rigidBodiesCollisionProcedure(RigidBody body0, RigidBody body1, Vector2d ray0, Vector2d ray1, Vector2d vel0, Vector2d vel1, Vector2d wr, int eFP) {
        int desiredDeltaVelocity;
        this.vwzgl.setSubFP(vel0, vel1);
        this.crossProductSc[0] = ray0.crossFP(wr);
        this.crossProductSc[1] = ray1.crossFP(wr);
        int contactVelocity = this.vwzgl.dotFP(wr);
        int velocityFromAcc = -body0.velFromAcc.dotFP(wr);
        int num = desiredDeltaVelocity = MathFP.mul(MathFP.add(MathFP.toFP(1), eFP), contactVelocity) - MathFP.mul(MathFP.add(MathFP.toFP(1), eFP), velocityFromAcc += body1.velFromAcc.dotFP(wr));
        int denom = MathFP.add(body0.m_inv, body1.m_inv);
        this.J = -MathFP.div(num, denom += MathFP.add(MathFP.mul(MathFP.pow(MathFP.abs(this.crossProductSc[0]), MathFP.toFP(2)), body0.I_inv), MathFP.mul(MathFP.pow(MathFP.abs(this.crossProductSc[1]), MathFP.toFP(2)), body1.I_inv)));
        this.changeBodyAngularLinearVelocity(body0, -this.J, wr, this.crossProductSc[0]);
        this.changeBodyAngularLinearVelocity(body1, this.J, wr, this.crossProductSc[1]);
    }

    private void changeBodyAngularLinearVelocity(RigidBody body, int J, Vector2d wr, int crossProductSc) {
        int J_m_inv = MathFP.mul(J, body.m_inv);
        int J_I_inv = MathFP.mul(J, body.I_inv);
        body.vel.x = MathFP.sub(body.vel.x, MathFP.mul(wr.x, J_m_inv));
        body.vel.y = MathFP.sub(body.vel.y, MathFP.mul(wr.y, J_m_inv));
        body.omega = MathFP.sub(body.omega, MathFP.mul(J_I_inv, crossProductSc));
    }
}

