/*
 * Decompiled with CFR 0.152.
 */
package body.interaction;

import body.RigidBody;
import body.interaction.Collision;
import body.interaction.Contact;
import maths.LPsolver;
import maths.LUfactor;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public class RestingContact {
    private Collision coll;
    LPsolver lp;
    LUfactor lu;
    public int[][] aFP;
    public int[] bFP;
    public int[] AFP;
    int[] fFP;
    public int[] bvFP;
    int[] jFP;
    public int n;
    boolean restingcontact = false;
    private int torqueONa;
    private int torqueONb;
    private Vector2d forceONa;
    private Vector2d forceONb;
    private Vector2d aLinear;
    private Vector2d bLinear;
    private Vector2d aAngular;
    private Vector2d bAngular;
    private Vector2d a_ext;
    private Vector2d b_ext;
    private Vector2d a_vel;
    private Vector2d b_vel;
    private Vector2d ndot;

    public void setRestingContact(boolean bool) {
        this.restingcontact = bool;
    }

    public boolean getRestingContact() {
        return this.restingcontact;
    }

    public RestingContact(Collision coll) {
        this.coll = coll;
        this.lu = new LUfactor();
        this.lp = new LPsolver();
        this.forceONa = new Vector2d();
        this.forceONb = new Vector2d();
        this.aAngular = new Vector2d();
        this.bAngular = new Vector2d();
        this.a_ext = new Vector2d();
        this.b_ext = new Vector2d();
        this.a_vel = new Vector2d();
        this.b_vel = new Vector2d();
    }

    public void setEpsilon(int g, int dtFP) {
    }

    public void setNumberOfCollContacts(int nCt) {
        this.n = nCt;
        this.AFP = new int[this.n];
        this.aFP = new int[this.n][this.n];
        this.bvFP = new int[this.n];
        this.jFP = new int[this.n];
    }

    public void setNumberOfContacts(int nCt) {
        this.n = nCt;
        this.aFP = new int[this.n][this.n];
        this.bFP = new int[this.n];
        this.fFP = new int[this.n];
        this.AFP = new int[this.n];
    }

    private void compute_a(Contact[] ct) {
        for (int i = 0; i < ct.length; ++i) {
            for (int j = 0; j < ct.length; ++j) {
                if (ct[i].a != ct[j].a && ct[i].a != ct[j].b && ct[i].b != ct[j].a && ct[i].b != ct[j].b) {
                    this.aFP[i][j] = MathFP.toFP(0);
                    continue;
                }
                this.forceONa.setToFP(0, 0);
                this.forceONb.setToFP(0, 0);
                this.torqueONa = MathFP.toFP(0);
                this.torqueONb = MathFP.toFP(0);
                if (ct[i].a == ct[j].a) {
                    this.forceONa.set(ct[j].n);
                    this.torqueONa = ct[j].r[0].crossFP(ct[j].n);
                } else if (ct[i].a == ct[j].b) {
                    this.forceONa.setScaleFP(MathFP.toFP(-1), ct[j].n);
                    this.torqueONa = ct[j].r[1].crossFP(ct[j].n);
                }
                if (ct[i].b == ct[j].a) {
                    this.forceONb.set(ct[j].n);
                    this.torqueONb = ct[j].r[0].crossFP(ct[j].n);
                } else if (ct[i].b == ct[j].b) {
                    this.forceONb.setScaleFP(MathFP.toFP(-1), ct[j].n);
                    this.torqueONb = ct[j].r[1].crossFP(ct[j].n);
                }
                this.aLinear = this.forceONa.scaleVecFP(ct[i].a.m_inv);
                this.bLinear = this.forceONb.scaleVecFP(ct[i].b.m_inv);
                this.aAngular.setCrossFP(this.torqueONa, ct[i].r[0]);
                this.aAngular.scaleFP(ct[i].a.I_inv);
                this.bAngular.setCrossFP(this.torqueONb, ct[i].r[1]);
                this.aAngular.scaleFP(ct[i].b.I_inv);
                this.aFP[i][j] = ct[i].n.dotFP(this.aLinear.addVecFP(this.aAngular).subVecFP(this.bLinear.addVecFP(this.bAngular)));
            }
        }
    }

    private Vector2d compute_ndot(Contact ct) {
        Vector2d nderivative = new Vector2d();
        nderivative.setCrossFP(ct.b.omega, ct.n);
        return nderivative;
    }

    private void compute_b(Contact[] ct) {
        for (int i = 0; i < ct.length; ++i) {
            RigidBody A = ct[i].a;
            RigidBody B = ct[i].b;
            this.a_ext.setCrossFP(MathFP.mul(A.torque, A.I_inv), ct[i].r[0]);
            this.a_ext.add(A.f.scaleVecFP(A.m_inv));
            this.b_ext.setCrossFP(MathFP.mul(B.torque, B.I_inv), ct[i].r[1]);
            this.b_ext.add(B.f.scaleVecFP(B.m_inv));
            this.a_vel.setCrossFP(A.omega, ct[i].r[0]);
            this.a_vel.setCrossFP(A.omega, this.a_vel);
            this.b_vel.setCrossFP(B.omega, ct[i].r[1]);
            this.b_vel.setCrossFP(B.omega, this.b_vel);
            int k1 = ct[i].n.dotFP(this.a_ext.addVecFP(this.a_vel).subVecFP(this.b_ext.addVecFP(this.b_vel)));
            this.ndot = this.compute_ndot(ct[i]);
            int k2 = this.ndot.scaleVecFP(MathFP.toFP(2)).dotFP(ct[i].v[0].subVecFP(ct[i].v[1]));
            this.bFP[i] = k1 + k2;
        }
    }

    public void compute_v() {
    }

    public void compute_bv(Contact[] ct, int eFP) {
        Vector2d vwzgl = new Vector2d();
        for (int i = 0; i < ct.length; ++i) {
            vwzgl.setSubFP(ct[i].v[0], ct[i].v[1]);
            this.bvFP[i] = MathFP.mul(MathFP.add(MathFP.toFP(1), eFP), vwzgl.dotFP(ct[i].n));
        }
    }

    public void computeContactForces(Contact[] ct) {
        int i;
        this.setNumberOfContacts(ct.length);
        this.compute_a(ct);
        this.compute_b(ct);
        this.lu.solve(this.aFP, this.bFP, this.fFP);
        for (int i2 = 0; i2 < this.AFP.length; ++i2) {
            for (int j = 0; j < this.AFP.length; ++j) {
                int n = i2;
                this.AFP[n] = this.AFP[n] + MathFP.mul(this.aFP[i2][j], this.fFP[j]);
            }
            int n = i2;
            this.AFP[n] = this.AFP[n] + this.bFP[i2];
        }
        for (i = 0; i < ct.length; ++i) {
            System.out.println("f[" + i + "]=" + this.fFP[i] + " A[" + i + "]=" + this.AFP[i]);
            Vector2d forceVec = ct[i].n.scaleVecFP(this.fFP[i]);
            ct[i].a.f.add(forceVec);
            ct[i].a.torque += ct[i].r[0].crossFP(forceVec);
            ct[i].b.f.sub(forceVec);
            ct[i].a.torque -= ct[i].r[1].crossFP(forceVec);
        }
        for (i = 0; i < ct.length; ++i) {
        }
    }

    public void computeJimpulses(Contact[] ct, int eFP) {
        this.setNumberOfCollContacts(ct.length);
        this.compute_a(ct);
        this.compute_bv(ct, eFP);
        this.lu.solve(this.aFP, this.bvFP, this.jFP);
        for (int i = 0; i < ct.length; ++i) {
        }
    }
}

