/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.FinalData;
import game.FinalFonts;
import game.IsoRace;
import game.MapEngine;
import game.TrackFinalData;
import game.car.BaseCar;
import game.car.Car;
import game.car.CarInteraction;
import game.car.CarUpgrade;
import game.car.Cone;
import game.car.InsertSort;
import game.car.OpponentCar;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import net.jscience.math.kvm.MathFP;
import utils.CustomFont;
import utils.ImageSet;
import utils.Sounds;

public class ApplicationCanvas
extends Canvas
implements Runnable {
    private Sounds sound;
    private IsoRace midlet = null;
    private MapEngine mapEngine;
    private Car playerCar;
    private OpponentCar[] opponentCar;
    private Cone[] cone;
    private Vector carVec;
    private TrackFinalData tfdata;
    private CarInteraction carInter;
    private CarUpgrade carUpgrade;
    public byte currentTrack = 0;
    private int krok = 0;
    private int currentScreen = 0;
    private int keyPressed = -999;
    private int gameAction = -999;
    private boolean keysBlocked = false;
    private int[][] checkPointsCoordinates;
    private char[] laps;
    private char[] cars;
    private int[][] trackLayout;
    private byte raceState = 0;
    private char[] drawLapLimitOPT;
    private boolean pickUpFuel;
    private boolean qualifiedToNextRace = false;
    private byte coutDownTime = 0;
    private Image startLights = null;
    private boolean pause = false;
    private byte pauseSelectedOption = 0;
    private CustomFont inGameBigNumbers = null;
    private CustomFont speedNumbers = null;
    private CustomFont inGameSmallNumbers = null;
    private Sprite menuArrowsSprite = null;
    private static Random random = new Random();
    private Thread animationThread;
    private int cpOppCarSqRadius;
    private int playersFinished = 0;
    private int[] gfxPos = new int[4];
    private int numOfCheckPts;
    boolean mapPainting = false;
    private boolean cheat = false;

    public ApplicationCanvas(IsoRace midlet, Sounds sounds, CarUpgrade carUpgrade) {
        this.midlet = midlet;
        this.sound = sounds;
        this.setFullScreenMode(true);
        this.laps = "/2".toCharArray();
        this.cars = "/4".toCharArray();
        IsoRace.SCREEN_WIDTH = this.getWidth();
        IsoRace.SCREEN_HEIGHT = this.getHeight();
        this.mapEngine = new MapEngine(FinalData.TILE_WIDTH, FinalData.TILE_HEIGHT, IsoRace.SCREEN_WIDTH, IsoRace.SCREEN_HEIGHT);
        this.carInter = new CarInteraction(sounds);
        this.carUpgrade = carUpgrade;
        this.setPortingParameters();
    }

    private void setPortingParameters() {
        this.cpOppCarSqRadius = 2025;
    }

    public static int getRandom(int a, int b) {
        return a + Math.abs(random.nextInt()) % (1 + b - a);
    }

    protected void paint(Graphics g) {
        switch (this.currentScreen) {
            case 20: {
                this.drawBriefingScreen(g);
                break;
            }
            case 30: {
                this.drawGameScreen(g);
                break;
            }
            case 31: {
                try {
                    this.carUpgrade.drawCarUpgradeScreen(g, this.carInter);
                    break;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.pause) {
            this.drawPauseMenu(g);
        }
        this.keysBlocked = false;
    }

    private void drawGFX(Graphics g) {
        int carIconWidth = ImageSet.getGameImage(FinalData.gfx[0]).getWidth();
        int carIconHeight = ImageSet.getGameImage(FinalData.gfx[0]).getHeight();
        int deltaX = 0;
        int deltaY = 0;
        deltaX = 0;
        deltaY = 1;
        int dx = carIconWidth / 2 + deltaX + (IsoRace.SCREEN_WIDTH - ImageSet.getGameImage("/gfx/topline.png").getWidth()) / 2;
        g.drawImage(ImageSet.getGameImage("/gfx/topline.png"), IsoRace.SCREEN_WIDTH / 2 + deltaX, ImageSet.getGameImage("/gfx/topline.png").getHeight() / 2 + deltaY, 17);
        for (int i = FinalData.gfx.length - 1; i >= 0; --i) {
            if (i == IsoRace.selectedCar) continue;
            g.drawRegion(ImageSet.getGameImage(FinalData.gfx[i]), 0, 0, carIconWidth, carIconHeight, 0, this.gfxPos[i] + dx, ImageSet.getGameImage("/gfx/topline.png").getHeight() / 2 - 1, 17);
        }
        int spriteTrans = this.playerCar.bkwbool ? 2 : 0;
        g.drawRegion(ImageSet.getGameImage(FinalData.gfx[IsoRace.selectedCar]), 0, 0, carIconWidth, carIconHeight, spriteTrans, this.gfxPos[IsoRace.selectedCar] + dx, ImageSet.getGameImage("/gfx/topline.png").getHeight() / 2 - 1, 17);
    }

    private void drawGameScreen(Graphics g) {
        g.setClip(0, 0, IsoRace.SCREEN_WIDTH, IsoRace.SCREEN_HEIGHT);
        this.mapEngine.drawMapStragged(g, this.playerCar);
        this.drawGFX(g);
        g.setColor(0);
        g.fillRect(0, 0, IsoRace.SCREEN_WIDTH, 5);
        if (this.pickUpFuel && this.krok % 20 > 10) {
            FinalFonts.smallCustomFont.drawString(g, IsoRace.getString("t_pickup_fuel").toCharArray(), IsoRace.SCREEN_WIDTH >> 1, 80, 17);
        }
        int lapInfoPosX = IsoRace.SCREEN_WIDTH - 31;
        int raceInfoPosX = 1;
        int dxPos = 12;
        int dxLap = 12;
        int shiftXfuelBar = 3;
        int shiftXspeedNum = 10;
        int yFuelSpeed = IsoRace.SCREEN_HEIGHT - 2;
        int dyCars = 1;
        int dyLap = 1;
        this.inGameBigNumbers.drawString(g, String.valueOf(this.playerCar.racePosition).toCharArray(), raceInfoPosX, IsoRace.SCREEN_HEIGHT / 32, 24);
        g.drawImage(ImageSet.getGameImage("/txt_pos.png"), raceInfoPosX + dxPos, IsoRace.SCREEN_HEIGHT / 32, 20);
        this.inGameSmallNumbers.drawString(g, this.cars, raceInfoPosX + dxPos, IsoRace.SCREEN_HEIGHT / 16 + dyCars, 20);
        if (this.carInter.lapOnTrack < this.playerCar.lap) {
            this.inGameBigNumbers.drawString(g, this.carInter.lapsOnTrack, lapInfoPosX, IsoRace.SCREEN_HEIGHT / 32, 24);
        } else {
            this.inGameBigNumbers.drawString(g, String.valueOf(this.playerCar.lap).toCharArray(), lapInfoPosX, IsoRace.SCREEN_HEIGHT / 32, 24);
        }
        g.drawImage(ImageSet.getGameImage("/txt_lap.png"), lapInfoPosX + dxLap, IsoRace.SCREEN_HEIGHT / 32, 20);
        this.inGameSmallNumbers.drawString(g, this.drawLapLimitOPT, lapInfoPosX + dxLap, IsoRace.SCREEN_HEIGHT / 16 + dyLap, 20);
        if (this.carInter.roadSignTime > 0) {
            g.drawRegion(ImageSet.getGameImage("/roadSigns.png"), 0, 0, ImageSet.getGameImage("/roadSigns.png").getWidth(), ImageSet.getGameImage("/roadSigns.png").getHeight(), this.carInter.roadSignsType[this.carInter.roadSignsIndex], IsoRace.SCREEN_WIDTH / 2, IsoRace.SCREEN_HEIGHT / 8, 17);
            --this.carInter.roadSignTime;
        }
        g.drawRegion(ImageSet.getGameImage("/fuel_speed_bar_BG.png"), 0, 0, ImageSet.getGameImage("/fuel_speed_bar_BG.png").getWidth(), ImageSet.getGameImage("/fuel_speed_bar_BG.png").getHeight(), 2, 5, yFuelSpeed, 36);
        if (this.playerCar.fuel > 0) {
            g.drawRegion(ImageSet.getGameImage("/fuel_speed_bar.png"), this.playerCar.fuel / 1000 * ImageSet.getGameImage("/fuel_speed_bar.png").getWidth() / 11, 0, ImageSet.getGameImage("/fuel_speed_bar.png").getWidth() / 11, ImageSet.getGameImage("/fuel_speed_bar.png").getHeight(), 2, 5 + shiftXfuelBar, yFuelSpeed - 4, 36);
        }
        g.drawImage(ImageSet.getGameImage("/txt_fuel.png"), 5, yFuelSpeed, 36);
        g.drawRegion(ImageSet.getGameImage("/fuel_speed_bar_BG.png"), 0, 0, ImageSet.getGameImage("/fuel_speed_bar_BG.png").getWidth(), ImageSet.getGameImage("/fuel_speed_bar_BG.png").getHeight(), 0, IsoRace.SCREEN_WIDTH - 5, yFuelSpeed, 40);
        if (MathFP.toInt(this.playerCar.v) > 0) {
            g.drawRegion(ImageSet.getGameImage("/fuel_speed_bar.png"), Math.min(MathFP.toInt(this.playerCar.vwzgl), 10) * ImageSet.getGameImage("/fuel_speed_bar.png").getWidth() / 11, 0, ImageSet.getGameImage("/fuel_speed_bar.png").getWidth() / 11, ImageSet.getGameImage("/fuel_speed_bar.png").getHeight(), 0, IsoRace.SCREEN_WIDTH - 5 - 3, yFuelSpeed - 4, 40);
            this.speedNumbers.drawString(g, String.valueOf(MathFP.toInt(this.playerCar.v)).toCharArray(), IsoRace.SCREEN_WIDTH - shiftXspeedNum, yFuelSpeed, 40);
        } else {
            this.speedNumbers.drawString(g, "0".toCharArray(), IsoRace.SCREEN_WIDTH - shiftXspeedNum, yFuelSpeed, 40);
        }
        if (this.raceState == 10) {
            this.drawSummaryRace(g);
        } else if (this.raceState != 10 && !this.pause && this.startLights != null && this.currentTrack != 5) {
            g.drawImage(this.startLights, this.mapEngine.startPoleX + 11, this.mapEngine.startPoleY + 37, 20);
            g.drawImage(this.startLights, this.mapEngine.startPoleX + 19, this.mapEngine.startPoleY + 33, 20);
            g.drawImage(this.startLights, this.mapEngine.startPoleX + 27, this.mapEngine.startPoleY + 29, 20);
        }
    }

    private void drawBriefingScreen(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, IsoRace.SCREEN_WIDTH, IsoRace.SCREEN_HEIGHT);
        int xPt = 0;
        int tileWidth = 0;
        int tileHeight = 0;
        int tileHalfWidth = 0;
        int tileHalfHeight = 0;
        int xC = g.getClipX();
        int yC = g.getClipY();
        int wC = g.getClipWidth();
        int hC = g.getClipHeight();
        CustomFont fontToOpt = FinalFonts.smallestCustomFont;
        tileWidth = 10;
        tileHeight = 10;
        tileHalfWidth = 5;
        tileHalfHeight = 5;
        int yPt = 30;
        int s = IsoRace.SCREEN_HEIGHT / 2 + 15;
        if (ImageSet.getGameImage(FinalData.img_backgroud) == null || ImageSet.getGameImage("/track_yellow.png") == null || this.trackLayout == null) {
            this.goTo((byte)20);
        }
        try {
            g.drawImage(ImageSet.getGameImage(FinalData.img_backgroud), 0, 0, 20);
            Image trackLayoutImg = ImageSet.getGameImage("/track_yellow.png");
            for (int ptMapY = 0; ptMapY < this.trackLayout.length; ++ptMapY) {
                xPt = (IsoRace.SCREEN_WIDTH >> 1) - this.trackLayout[0].length * (tileWidth - 1) / 2;
                if (ptMapY % 2 == 0 && ptMapY != 1) {
                    xPt -= tileHalfWidth;
                }
                for (int ptMapX = 0; ptMapX < this.trackLayout[0].length; ++ptMapX) {
                    int tileValue = this.trackLayout[ptMapY][ptMapX];
                    g.setClip(xPt, yPt, tileWidth, tileHeight);
                    g.drawImage(trackLayoutImg, xPt - tileValue * tileWidth, yPt, 20);
                    xPt += tileWidth;
                }
                yPt += tileHalfHeight;
            }
            g.setClip(xC, yC, wC, hC);
            String track = IsoRace.getString("track");
            String trackNo = " " + (this.currentTrack + 1);
            String trackBoth = track + trackNo;
            FinalFonts.mediumCustomFont.drawString(g, trackBoth.toCharArray(), IsoRace.SCREEN_WIDTH >> 1, s += 30, 17);
        }
        catch (Exception e) {
            // empty catch block
        }
        fontToOpt.drawString(g, IsoRace.getCharArray("start_race"), IsoRace.SCREEN_WIDTH - 8, IsoRace.SCREEN_HEIGHT - 5, 40);
    }

    private void drawCheckPoints(Graphics g) {
        int i;
        g.setColor(255, 0, 0);
        for (i = 0; i < this.opponentCar.length; ++i) {
            g.drawLine(this.opponentCar[i].sprite.x - MapEngine.ptAnchorViewX, this.opponentCar[i].sprite.y - MapEngine.ptAnchorViewY, this.checkPointsCoordinates[this.opponentCar[i].destCheckPoint][0] - MapEngine.ptAnchorViewX, this.checkPointsCoordinates[this.opponentCar[i].destCheckPoint][1] - MapEngine.ptAnchorViewY);
        }
        for (i = 0; i < this.checkPointsCoordinates.length; ++i) {
            g.fillRect(this.checkPointsCoordinates[i][0] - MapEngine.ptAnchorViewX, this.checkPointsCoordinates[i][1] - MapEngine.ptAnchorViewY, 12, 12);
        }
        g.setColor(0, 0, 0);
        for (i = 0; i < this.checkPointsCoordinates.length; ++i) {
            g.drawString(" " + i, this.checkPointsCoordinates[i][0] - MapEngine.ptAnchorViewX - 2, this.checkPointsCoordinates[i][1] - MapEngine.ptAnchorViewY - 2, 0);
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.raceState == 10 || this.pause) {
            System.out.println("keyCode=" + keyCode);
        }
        if (this.keysBlocked) {
            return;
        }
        try {
            this.keyPressed = this.getGameAction(keyCode);
            this.playerCar.pressedKey(this.keyPressed);
            if (keyCode == 48 && this.currentScreen == 30) {
                this.cheat = true;
                this.preapareFinishRace();
            }
        }
        catch (Exception e) {
            this.keyPressed = keyCode;
        }
        if (this.keyPressed == 0) {
            this.keyPressed = keyCode;
        }
        if (this.currentScreen == 31) {
            this.carUpgrade.pressedKey(this.keyPressed, this.qualifiedToNextRace, CarInteraction.playerScore, this, this.midlet);
        }
        this.checkUserInput(this.keyPressed);
        this.keysBlocked = true;
    }

    protected void keyReleased(int keyCode) {
        this.keyPressed = -999;
        if (this.currentScreen == 30) {
            try {
                this.gameAction = this.getGameAction(keyCode);
                this.playerCar.releasedKey(this.gameAction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        while (currentThread == this.animationThread) {
            if (!this.pause && this.currentScreen == 30) {
                if (this.playerCar.fuel <= 0) {
                    this.raceState = (byte)10;
                }
                switch (this.raceState) {
                    case 10: {
                        break;
                    }
                    case 31: {
                        break;
                    }
                    case 21: {
                        this.countDown();
                        break;
                    }
                    default: {
                        ++this.krok;
                        this.step();
                    }
                }
            }
            this.repaint();
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void countDown() {
        if (this.coutDownTime > 0) {
            try {
                Thread.sleep(1000L);
                this.coutDownTime = (byte)(this.coutDownTime - 1);
                if (IsoRace.cfg_vibration && this.coutDownTime >= 0) {
                    this.midlet.makeVibra((3 - this.coutDownTime) * 80);
                }
                if (this.coutDownTime == 1) {
                    this.startLights = ImageSet.getGameImage("/startLight_yellow.png");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            long time;
            this.playerCar.startRace = time = System.currentTimeMillis();
            for (int i = 0; i < this.opponentCar.length; ++i) {
                this.opponentCar[i].startRace = time;
            }
            this.raceState = 0;
            this.startLights = null;
        }
    }

    private void step() {
        int i;
        this.calculateGFXpos(this.playerCar);
        for (i = 0; i < this.opponentCar.length; ++i) {
            this.calculateGFXpos(this.opponentCar[i]);
            this.calculateDCP(this.opponentCar[i]);
        }
        this.setGFXforPainting();
        this.sortCars();
        for (i = 0; i < this.cone.length; ++i) {
            this.cone[i].evaluateVelocity();
        }
        for (i = 0; i < this.opponentCar.length; ++i) {
            this.opponentCar[i].autoDriver();
            this.opponentCar[i].evaluateVelocity();
        }
        this.playerCar.stepControl();
        this.playerCar.evaluateVelocity();
        this.carInter.checkCarsCollisionWithCones(this.playerCar, this.cone);
        this.carInter.checkCarsCollision(this.playerCar, this.opponentCar);
        for (i = 0; i < this.cone.length; ++i) {
            this.cone[i].evaluatePosition();
        }
        for (i = 0; i < this.opponentCar.length; ++i) {
            this.opponentCar[i].evaluatePositionRotation();
        }
        this.playerCar.evaluatePositionRotation();
        for (i = 0; i < this.opponentCar.length; ++i) {
            this.carInter.checkOpponentCarCollisionWithMap(this.mapEngine, this.opponentCar[i]);
        }
        this.carInter.checkCarCollisionWithMap(this.mapEngine, this.playerCar);
        if (IsoRace.cfg_vibration && this.playerCar.itemCollected) {
            this.midlet.makeVibra(200);
            this.playerCar.itemCollected = false;
        }
        MapEngine.scrollMap(this.playerCar);
        for (i = 0; i < this.opponentCar.length; ++i) {
            if (this.opponentCar[i].lap <= this.carInter.lapOnTrack) continue;
            this.opponentCar[i].finishRaceTime = System.currentTimeMillis();
            this.opponentCar[i].scF = 0;
            if (this.opponentCar[i].finishRace) continue;
            this.opponentCar[i].setAutoDriver(false);
            this.opponentCar[i].finishRace = true;
            this.carVec.removeElement(this.opponentCar[i]);
            ++this.playersFinished;
        }
        if (this.playerCar.lap > this.carInter.lapOnTrack) {
            this.playerCar.finishRaceTime = System.currentTimeMillis();
            this.playerCar.scF = 0;
            if (this.playerCar.nitro) {
                this.playerCar.setNitroOff();
            }
            if (!this.playerCar.finishRace) {
                this.playerCar.finishRace = true;
                this.carVec.removeElement(this.playerCar);
                ++this.playersFinished;
            }
            this.preapareFinishRace();
        }
        this.pickUpFuel = this.playerCar.fuel < 2000 && this.playerCar.fuel > 0 && this.playerCar.v > 0;
    }

    private void preapareFinishRace() {
        this.raceState = (byte)10;
        if (1 == IsoRace.cfg_game_mode && this.currentTrack < FinalData.trackNames.length - 1) {
            if (!this.cheat) {
                this.countPlayerRacePosition();
            } else {
                this.playerCar.racePosition = 1;
                this.cheat = false;
            }
            if (this.playerCar.racePosition == 1) {
                this.qualifiedToNextRace = true;
                IsoRace.championshipTrack = this.currentTrack = (byte)(this.currentTrack + 1);
                IsoRace.cfg_kontynuacja = true;
                this.midlet.saveConfiguration(false);
                CarInteraction.playerScore += 1000;
                CarInteraction.playerScore += CarInteraction.cash;
                this.carUpgrade.increaseCash(this.carInter, this.playerCar.racePosition);
                CarInteraction.cash = 0;
            } else {
                CarInteraction.cash = 0;
            }
        } else if (1 == IsoRace.cfg_game_mode && this.currentTrack == FinalData.trackNames.length - 1) {
            if (this.cheat) {
                this.playerCar.racePosition = 1;
                this.cheat = false;
            }
            if (this.playerCar.racePosition == 1) {
                this.goTo((byte)33);
                this.currentScreen = 33;
                CarInteraction.playerScore += 1000;
                CarInteraction.playerScore += CarInteraction.cash;
                IsoRace.cfg_kontynuacja = false;
                IsoRace.championshipTrack = 0;
                IsoRace.currentSelectedTrack = 0;
                this.currentTrack = 0;
                try {
                    this.midlet.startMenu(true, false, (byte)12, this.sound);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                CarInteraction.cash = 0;
            }
        }
    }

    private void sortCars() {
        InsertSort.sortCars(this.carVec, this.playersFinished);
    }

    private void countPlayerRacePosition() {
        this.sortCars();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkUserInput(int keyPressed) {
        switch (this.currentScreen) {
            case 20: {
                if (keyPressed != IsoRace.R_FUNCTION && keyPressed != 8 && keyPressed != 53 || !ImageSet.gameImagesLoaded) return;
                this.goTo((byte)30);
                return;
            }
            case 31: {
                return;
            }
            case 30: {
                if (this.raceState == 10) {
                    if (keyPressed == IsoRace.R_FUNCTION || keyPressed == 8 || keyPressed == 53) {
                        if (IsoRace.cfg_game_mode == 0) {
                            try {
                                this.midlet.startMenu(true, false, (byte)1, this.sound);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        } else if (IsoRace.cfg_game_mode == 1) {
                            if (this.qualifiedToNextRace) {
                                if (this.currentTrack == FinalData.trackNames.length) {
                                    this.goTo((byte)33);
                                } else {
                                    this.goTo((byte)-25);
                                    ImageSet.clearGameImages();
                                    ImageSet.gameImagesLoaded = false;
                                    this.clearImages();
                                    try {
                                        ImageSet.loadUpgradeScreenImages();
                                        ImageSet.menuImagesLoaded = true;
                                        this.carUpgrade.initUpgradeScreen();
                                        this.currentScreen = 31;
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            } else {
                                this.goTo((byte)20);
                            }
                        }
                    }
                } else if (keyPressed == IsoRace.R_FUNCTION) {
                    this.pause = true;
                    return;
                }
                if (!this.pause) return;
                this.navigationPauseMenu(keyPressed);
                return;
            }
        }
    }

    public void goTo(byte screenID) {
        switch (screenID) {
            case 20: {
                this.trackLayout = FinalData.trackShapes(this.currentTrack);
                break;
            }
            case 30: {
                System.gc();
                this.prepareTrack(this.currentTrack);
                break;
            }
        }
        this.currentScreen = screenID;
        if (this.currentScreen == 30) {
            this.trackLayout = null;
        }
    }

    public void createGameFonts() {
        int i;
        this.inGameBigNumbers = CustomFont.getFont(ImageSet.getGameImage("/gameFonts/bigNum.png"), "12345", 5, (int)IsoRace.cfg_lang);
        this.inGameBigNumbers.isMonospace = false;
        this.inGameSmallNumbers = CustomFont.getFont(ImageSet.getGameImage("/gameFonts/smallNum.png"), "123456789/", 10, (int)IsoRace.cfg_lang);
        this.inGameSmallNumbers.isMonospace = false;
        this.speedNumbers = CustomFont.getFont(ImageSet.getGameImage("/gameFonts/speedNum.png"), "0123456789", 10, (int)IsoRace.cfg_lang);
        this.speedNumbers.isMonospace = false;
        byte[] characterSizesBig = new byte[5];
        byte[] characterSizesSmall = new byte[10];
        byte[] characterSizesSpeed = new byte[10];
        this.inGameBigNumbers.heightFont = 13;
        byte sizeBig = 0;
        this.inGameSmallNumbers.heightFont = 9;
        int sizeSmall = 6;
        this.speedNumbers.heightFont = 9;
        int sizeSpeed = 5;
        for (i = 0; i < characterSizesBig.length; ++i) {
            characterSizesBig[i] = sizeBig;
        }
        for (i = 0; i < characterSizesSmall.length; ++i) {
            characterSizesSmall[i] = sizeSmall;
        }
        for (i = 0; i < characterSizesSpeed.length; ++i) {
            characterSizesSpeed[i] = sizeSpeed;
        }
        this.inGameBigNumbers.setCharacterSizes(characterSizesBig);
        this.inGameSmallNumbers.setCharacterSizes(characterSizesSmall);
        this.speedNumbers.setCharacterSizes(characterSizesSpeed);
    }

    private void createPlayerCar() {
        if (IsoRace.selectedCar == 0) {
            this.playerCar = new Car(this.sound, this.mapEngine, ImageSet.getCarImages(0));
        }
        if (IsoRace.selectedCar == 1) {
            this.playerCar = new Car(this.sound, this.mapEngine, ImageSet.getCarImages(1));
        }
        if (IsoRace.selectedCar == 2) {
            this.playerCar = new Car(this.sound, this.mapEngine, ImageSet.getCarImages(2));
        }
        if (IsoRace.selectedCar == 3) {
            this.playerCar = new Car(this.sound, this.mapEngine, ImageSet.getCarImages(3));
        }
    }

    private void drawPauseMenu(Graphics g) {
        int xtext = 0;
        int dy = 0;
        int dyPointer = 0;
        int yGap = 0;
        dy = 0;
        dyPointer = 3;
        yGap = 9;
        switch (IsoRace.cfg_lang) {
            case 3: {
                xtext = (IsoRace.SCREEN_WIDTH >> 1) - 40;
                break;
            }
            case 4: {
                xtext = (IsoRace.SCREEN_WIDTH >> 1) - 40;
                break;
            }
            default: {
                xtext = (IsoRace.SCREEN_WIDTH >> 1) - 35;
            }
        }
        int frameWidth = IsoRace.SCREEN_WIDTH - 10;
        int frameHeight = 120;
        int yStart = 25;
        int xFrame = 5;
        CustomFont font = FinalFonts.smallestCustomFont;
        int shiftYtext = 6;
        int yFrame = yStart;
        g.setColor(723723);
        g.fillRoundRect(xFrame, yFrame, frameWidth, frameHeight, 15, 15);
        g.setColor(16765440);
        g.drawRoundRect(xFrame + 1, yFrame + 1, frameWidth - 2, frameHeight - 1, 15, 15);
        g.setColor(12461570);
        g.drawRoundRect(xFrame, yFrame, frameWidth, frameHeight + 1, 15, 15);
        FinalFonts.mediumCustomFont.drawString(g, IsoRace.getString("pause").toCharArray(), IsoRace.SCREEN_WIDTH >> 1, yStart += shiftYtext, 17);
        this.menuArrowsSprite.setTransform(2);
        this.menuArrowsSprite.setPosition(xtext - 11, (yStart += font.heightFont + yGap) + dyPointer + this.pauseSelectedOption * (font.heightFont + dy));
        this.menuArrowsSprite.paint(g);
        font.drawString(g, IsoRace.getString("backgame").toCharArray(), xtext, yStart, 20);
        font.drawString(g, IsoRace.getString("exittomenu").toCharArray(), xtext, yStart += font.heightFont + dy, 20);
        String vibraTxt = IsoRace.cfg_vibration ? IsoRace.getString("vibra_on") : IsoRace.getString("vibra_off");
        font.drawString(g, vibraTxt.toCharArray(), xtext, yStart += font.heightFont + dy, 20);
        String soundTxt = IsoRace.cfg_sound ? IsoRace.getString("sound_on") : IsoRace.getString("sound_off");
        font.drawString(g, soundTxt.toCharArray(), xtext, yStart += font.heightFont + dy, 20);
        String musicTxt = IsoRace.cfg_music ? IsoRace.getString("music_on") : IsoRace.getString("music_off");
        font.drawString(g, musicTxt.toCharArray(), xtext, yStart += font.heightFont + dy, 20);
        font.drawString(g, IsoRace.getString("restart").toCharArray(), xtext, yStart += font.heightFont + dy, 20);
    }

    private void drawClikTo(String s, int y, Graphics g, CustomFont fontClick) {
        int yStart = y;
        switch (IsoRace.cfg_lang) {
            case 0: {
                fontClick.drawString(g, IsoRace.getCharArray("clicktocont"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                break;
            }
            case 4: {
                fontClick.drawString(g, IsoRace.getCharArray("clickto"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                fontClick.drawString(g, IsoRace.getCharArray(s), IsoRace.SCREEN_WIDTH >> 1, yStart += fontClick.heightFont - 5, 17);
                break;
            }
            default: {
                fontClick.drawString(g, IsoRace.getCharArray("clickto"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                fontClick.drawString(g, IsoRace.getCharArray(s), IsoRace.SCREEN_WIDTH >> 1, yStart += fontClick.heightFont - 3, 17);
            }
        }
    }

    private void drawSummaryRace(Graphics g) {
        int dy = 0;
        int dyInfo = 0;
        CustomFont fontClick = null;
        CustomFont fontTitle = null;
        CustomFont fontQualify = null;
        CustomFont fontNoQualify = null;
        int yStart = 20;
        switch (IsoRace.cfg_lang) {
            case 1: {
                fontTitle = FinalFonts.mediumCustomFont;
                dy = 3;
                dyInfo = -3;
                break;
            }
            case 3: {
                fontTitle = FinalFonts.smallCustomFont;
                dy = 3;
                dyInfo = -3;
                break;
            }
            case 4: {
                fontTitle = FinalFonts.smallCustomFont;
                dy = 2;
                dyInfo = -3;
                break;
            }
            default: {
                fontTitle = FinalFonts.mediumCustomFont;
                dy = 3;
                dyInfo = -3;
            }
        }
        fontClick = FinalFonts.smallCustomFont;
        fontQualify = FinalFonts.smallestCustomFont;
        fontNoQualify = FinalFonts.smallestCustomFont;
        int frameWidth = IsoRace.SCREEN_WIDTH - 3;
        int frameHeight = 125;
        int deltay = 2;
        if (this.playerCar.fuel <= 0) {
            yStart = 40;
            FinalFonts.smallCustomFont.drawString(g, IsoRace.getCharArray("nofuel"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
            FinalFonts.smallCustomFont.drawString(g, IsoRace.getCharArray("endrace"), IsoRace.SCREEN_WIDTH >> 1, yStart += FinalFonts.smallCustomFont.heightFont + 10, 17);
            yStart += FinalFonts.smallCustomFont.heightFont + 10;
            if (IsoRace.cfg_game_mode == 0) {
                this.drawClikTo("tocont", yStart, g, fontClick);
            } else {
                this.drawClikTo("torestart", yStart, g, fontClick);
            }
            return;
        }
        g.setColor(723723);
        g.fillRoundRect((IsoRace.SCREEN_WIDTH - frameWidth) / 2, yStart + deltay, frameWidth, frameHeight, 15, 15);
        g.setColor(16765440);
        g.drawRoundRect((IsoRace.SCREEN_WIDTH - frameWidth) / 2 + 1, yStart + deltay + 1, frameWidth - 2, frameHeight - 1, 15, 15);
        g.setColor(12461570);
        g.drawRoundRect((IsoRace.SCREEN_WIDTH - frameWidth) / 2, yStart + deltay, frameWidth, frameHeight + 1, 15, 15);
        fontTitle.drawString(g, IsoRace.getCharArray("t_rc_finished"), IsoRace.SCREEN_WIDTH >> 1, yStart += 2 * dy, 17);
        yStart += FinalFonts.smallCustomFont.heightFont + 4 * dy;
        if (IsoRace.cfg_game_mode == 0) {
            FinalFonts.smallCustomFont.drawString(g, IsoRace.getCharArray("youfinished"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
            FinalFonts.smallCustomFont.drawString(g, (IsoRace.getString("t_in") + " " + this.playerCar.racePosition + IsoRace.getString("num_suf_" + this.playerCar.racePosition) + " " + IsoRace.getString("t_position")).toCharArray(), IsoRace.SCREEN_WIDTH >> 1, yStart += FinalFonts.smallCustomFont.heightFont + dyInfo, 17);
            FinalFonts.smallCustomFont.drawString(g, IsoRace.getCharArray("congratulations"), IsoRace.SCREEN_WIDTH >> 1, yStart += FinalFonts.smallCustomFont.heightFont + dyInfo, 17);
            this.drawClikTo("tocont", yStart += FinalFonts.smallCustomFont.heightFont + 2 * dy, g, fontClick);
        } else if (IsoRace.cfg_game_mode == 1) {
            if (this.qualifiedToNextRace) {
                switch (IsoRace.cfg_lang) {
                    case 4: {
                        fontQualify.drawString(g, IsoRace.getCharArray("youqualified1"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                        fontQualify.drawString(g, IsoRace.getCharArray("youqualified2"), IsoRace.SCREEN_WIDTH >> 1, yStart += fontQualify.heightFont + dyInfo, 17);
                        break;
                    }
                    default: {
                        fontQualify.drawString(g, IsoRace.getCharArray("youqualified"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                    }
                }
                fontQualify.drawString(g, IsoRace.getCharArray("youfinished"), IsoRace.SCREEN_WIDTH >> 1, yStart += fontQualify.heightFont + dyInfo, 17);
                fontQualify.drawString(g, (IsoRace.getString("t_in") + " " + this.playerCar.racePosition + IsoRace.getString("num_suf_" + this.playerCar.racePosition) + " " + IsoRace.getString("t_position")).toCharArray(), IsoRace.SCREEN_WIDTH >> 1, yStart += fontQualify.heightFont + dyInfo, 17);
                fontQualify.drawString(g, (IsoRace.getString("points") + " " + CarInteraction.playerScore).toCharArray(), IsoRace.SCREEN_WIDTH >> 1, yStart += fontQualify.heightFont + dyInfo, 17);
                this.drawClikTo("tocont", yStart += FinalFonts.smallCustomFont.heightFont + 2 * dy, g, fontClick);
            } else {
                switch (IsoRace.cfg_lang) {
                    case 0: {
                        FinalFonts.smallCustomFont.drawString(g, IsoRace.getCharArray("sorry"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                        yStart += FinalFonts.smallCustomFont.heightFont + dyInfo;
                        break;
                    }
                    case 2: {
                        fontNoQualify.drawString(g, IsoRace.getCharArray("sorry"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                        yStart += FinalFonts.smallCustomFont.heightFont + dyInfo;
                        break;
                    }
                    case 3: {
                        fontNoQualify.drawString(g, IsoRace.getCharArray("sorry"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                        yStart += FinalFonts.smallCustomFont.heightFont + dyInfo;
                    }
                }
                switch (IsoRace.cfg_lang) {
                    case 4: {
                        fontNoQualify.drawString(g, IsoRace.getCharArray("noqualify1a"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                        fontNoQualify.drawString(g, IsoRace.getCharArray("noqualify2a"), IsoRace.SCREEN_WIDTH >> 1, yStart += fontNoQualify.heightFont + dyInfo, 17);
                        fontNoQualify.drawString(g, IsoRace.getCharArray("noqualify3a"), IsoRace.SCREEN_WIDTH >> 1, yStart += fontNoQualify.heightFont + dyInfo, 17);
                        break;
                    }
                    default: {
                        fontNoQualify.drawString(g, IsoRace.getCharArray("noqualify"), IsoRace.SCREEN_WIDTH >> 1, yStart, 17);
                    }
                }
                fontNoQualify.drawString(g, IsoRace.getCharArray("tonextrace"), IsoRace.SCREEN_WIDTH >> 1, yStart += fontNoQualify.heightFont + dyInfo, 17);
                yStart += fontNoQualify.heightFont + dyInfo;
                this.drawClikTo("torestart", yStart += fontNoQualify.heightFont + 2 * dy, g, fontClick);
            }
        }
    }

    private void navigationPauseMenu(int keyCode) {
        if (keyCode == 1 || keyCode == 50) {
            this.pauseSelectedOption = (byte)(this.pauseSelectedOption - 1);
            if (this.pauseSelectedOption < 0) {
                this.pauseSelectedOption = (byte)5;
            }
        } else if (keyCode == 6 || keyCode == 56) {
            this.pauseSelectedOption = (byte)(this.pauseSelectedOption + 1);
            if (this.pauseSelectedOption > 5) {
                this.pauseSelectedOption = 0;
            }
        } else if (keyCode == 8 || keyCode == 53) {
            if (this.pauseSelectedOption == 0) {
                this.pause = false;
            } else if (this.pauseSelectedOption == 1) {
                try {
                    this.midlet.startMenu(true, false, (byte)1, this.sound);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else if (this.pauseSelectedOption == 2) {
                if (IsoRace.cfg_vibration) {
                    IsoRace.cfg_vibration = false;
                } else {
                    IsoRace.cfg_vibration = true;
                    this.midlet.makeVibra(300);
                }
            } else if (this.pauseSelectedOption == 3) {
                if (IsoRace.cfg_sound) {
                    IsoRace.cfg_sound = false;
                    this.sound.stopItemSound();
                    this.sound.closeItemSound();
                } else {
                    if (IsoRace.cfg_music) {
                        IsoRace.cfg_music = false;
                        this.sound.stopMenuMusic();
                        this.sound.closeMenuMusic();
                    }
                    this.sound.loadItemSound();
                    IsoRace.cfg_sound = true;
                }
            } else if (this.pauseSelectedOption == 4) {
                if (IsoRace.cfg_music) {
                    IsoRace.cfg_music = false;
                    this.sound.stopMenuMusic();
                    this.sound.closeMenuMusic();
                } else {
                    if (IsoRace.cfg_sound) {
                        IsoRace.cfg_sound = false;
                        this.sound.stopItemSound();
                        this.sound.closeItemSound();
                    }
                    this.sound.loadMenuMusic();
                    IsoRace.cfg_music = true;
                    this.sound.playMenuMusic();
                }
            } else if (this.pauseSelectedOption == 5) {
                CarInteraction.cash = 0;
                this.pause = false;
                this.goTo((byte)20);
            }
        }
        this.keyPressed = -999;
    }

    private void prepareTrack(int trackNo) {
        int i;
        System.out.println("  selected Car = " + IsoRace.selectedCar);
        this.createPlayerCar();
        if (IsoRace.cfg_game_mode == 0) {
            this.playerCar.initCar(IsoRace.selectedCar, false);
            CarInteraction.playerCash = 0;
            CarInteraction.playerScore = 0;
        } else if (IsoRace.cfg_game_mode == 1) {
            if (trackNo == 0) {
                this.playerCar.initCar(IsoRace.selectedCar, false);
                CarInteraction.playerCash = 0;
                CarInteraction.playerScore = 0;
            }
            if (trackNo > 0 && IsoRace.cfg_kontynuacja) {
                this.playerCar.initCar(IsoRace.selectedCar, true);
            }
        }
        this.krok = 0;
        this.playersFinished = 0;
        this.carVec = new Vector();
        this.opponentCar = new OpponentCar[3];
        int initFrame = 28;
        this.mapEngine.load("/track" + (trackNo + 1) + ".map", "/tiles_base.png");
        this.carInter.lapOnTrack = 2;
        CarInteraction.cash = 0;
        this.currentTrack = (byte)trackNo;
        this.tfdata = new TrackFinalData(this.opponentCar.length);
        this.tfdata.setCarsInitData(trackNo);
        this.tfdata.setTrackInitData(trackNo);
        int[][] checkPointOnLevel = this.tfdata.checkPointOnLevel;
        this.carInter.roadSignsType = this.tfdata.roadSignsType;
        this.checkPointsCoordinates = this.prepareCheckPointsCoordinates(checkPointOnLevel);
        this.numOfCheckPts = this.tfdata.numOfCheckPts;
        switch (trackNo) {
            case 0: {
                this.playerCar.setRaceLapNumber(this.carInter.lapOnTrack);
                CarInteraction.playerScore = 0;
            }
        }
        this.playerCar.setBodyPosFP(this.tfdata.getInitCarPos().x, this.tfdata.getInitCarPos().y);
        this.playerCar.setStartPositionByTile(MathFP.toInt(this.tfdata.getInitCarPos().x), MathFP.toInt(this.tfdata.getInitCarPos().y));
        this.playerCar.setRaceLapNumber(this.carInter.lapOnTrack);
        this.playerCar.racePosition = (byte)2;
        this.playerCar.initCarRotation(initFrame);
        this.tfdata.fitCarTilePos();
        this.playerCar.setBodyPosFP(this.tfdata.getInitCarPos());
        this.playerCar.fuel = 10000;
        this.playerCar.reset();
        this.carVec.addElement(this.playerCar);
        for (i = 0; i < this.opponentCar.length; ++i) {
            this.opponentCar[i] = i == IsoRace.selectedCar - 1 ? new OpponentCar(this.mapEngine, ImageSet.getCarImages(0)) : new OpponentCar(this.mapEngine, ImageSet.getCarImages(i + 1));
            this.opponentCar[i].setStartPositionByTile(MathFP.toInt(this.tfdata.getInitOppCarPos((int)i).x), MathFP.toInt(this.tfdata.getInitOppCarPos((int)i).y));
            this.opponentCar[i].setBodyPosFP(this.tfdata.getInitOppCarPos(i));
            this.tfdata.fitOppCarTilePos(i);
            this.opponentCar[i].setBodyPosFP(this.tfdata.getInitOppCarPos(i));
            this.opponentCar[i].initCar(initFrame, 7, "0.5");
            this.opponentCar[i].dest_x = this.checkPointsCoordinates[this.opponentCar[i].destCheckPoint][0];
            this.opponentCar[i].dest_y = 2 * this.checkPointsCoordinates[this.opponentCar[i].destCheckPoint][1];
            this.opponentCar[i].setAutoDriver(true);
            this.carVec.addElement(this.opponentCar[i]);
        }
        this.startLights = ImageSet.getGameImage("/startLight_red.png");
        this.drawLapLimitOPT = ("/" + this.carInter.lapOnTrack).toCharArray();
        this.raceState = (byte)21;
        this.coutDownTime = (byte)3;
        this.qualifiedToNextRace = false;
        this.carInter.lapsOnTrack = ("" + this.playerCar.lap).toCharArray();
        this.cone = new Cone[MapEngine.numberOfCones];
        this.tfdata.fitConesTilesPos();
        for (i = 0; i < this.cone.length; ++i) {
            this.cone[i] = new Cone(ImageSet.getGameImage("/cone.png"), MathFP.toFP(10));
            this.cone[i].setBodyPosFP(this.tfdata.getConePos(i));
        }
        this.mapEngine.referCones(this.cone);
        this.mapEngine.referCars(this.opponentCar, this.playerCar);
        MapEngine.scrollMap(this.playerCar);
        this.calculateGFXpos(this.playerCar);
        for (i = 0; i < this.opponentCar.length; ++i) {
            this.calculateGFXpos(this.opponentCar[i]);
            this.calculateDCP(this.opponentCar[i]);
        }
        this.sortCars();
        for (i = 0; i < this.gfxPos.length; ++i) {
            this.gfxPos[i] = 0;
        }
    }

    private int[][] prepareCheckPointsCoordinates(int[][] checkPointTileCoordinates) {
        int[][] tempCoordinates = new int[checkPointTileCoordinates.length][2];
        for (int i = 0; i < tempCoordinates.length; ++i) {
            int tileX = checkPointTileCoordinates[i][0];
            int tileY = checkPointTileCoordinates[i][1];
            tempCoordinates[i][0] = tileX * MapEngine.tileWidth;
            tempCoordinates[i][1] = tileY * MapEngine.tileHalfHeight;
            if (tileY % 2 == 0) continue;
            int[] nArray = tempCoordinates[i];
            nArray[0] = nArray[0] + MapEngine.tileHalfWidth;
        }
        return tempCoordinates;
    }

    private void calculateDCP(OpponentCar car) {
        int dy;
        int xCP = this.checkPointsCoordinates[car.destCheckPoint][0];
        int yCP = 2 * this.checkPointsCoordinates[car.destCheckPoint][1];
        int x = car.sprite.x;
        int y = 2 * car.sprite.y;
        int dx = Math.abs(x - xCP);
        int r = dx * dx + (dy = Math.abs(y - yCP)) * dy;
        if (r <= this.cpOppCarSqRadius) {
            ++car.destCheckPoint;
            if (car.destCheckPoint == this.numOfCheckPts) {
                car.destCheckPoint = 0;
            }
            car.dest_x = this.checkPointsCoordinates[car.destCheckPoint][0];
            car.dest_y = 2 * this.checkPointsCoordinates[car.destCheckPoint][1];
        }
    }

    private void calculateGFXpos(BaseCar car) {
        int dist2toNext;
        int x = car.sprite.x;
        int y = car.sprite.y * 2;
        if (car.gfxCurrCP == 0) {
            car.gfxNextCP = 1;
            car.gfxPrevCP = this.numOfCheckPts - 1;
        } else if (car.gfxCurrCP == this.numOfCheckPts - 1) {
            car.gfxPrevCP = this.numOfCheckPts - 2;
            car.gfxNextCP = 0;
        }
        int xCP = this.checkPointsCoordinates[car.gfxPrevCP][0];
        int yCP = this.checkPointsCoordinates[car.gfxPrevCP][1] * 2;
        int dx = Math.abs(x - xCP);
        int dy = Math.abs(y - yCP);
        int dist2toPrev = dx * dx + dy * dy;
        xCP = this.checkPointsCoordinates[car.gfxCurrCP][0];
        yCP = this.checkPointsCoordinates[car.gfxCurrCP][1] * 2;
        dx = Math.abs(x - xCP);
        dy = Math.abs(y - yCP);
        int dist2toCurr = dx * dx + dy * dy;
        xCP = this.checkPointsCoordinates[car.gfxNextCP][0];
        yCP = this.checkPointsCoordinates[car.gfxNextCP][1] * 2;
        dx = Math.abs(x - xCP);
        dy = Math.abs(y - yCP);
        car.racePosCPdistance = dist2toNext = dx * dx + dy * dy;
        car.racePosCP = car.przejsciowka ? this.numOfCheckPts + car.gfxNextCP : car.gfxNextCP;
        if (dist2toNext < dist2toCurr) {
            car.bkwbool = false;
            if (car.gfxCurrCP == this.numOfCheckPts - 2) {
                car.gfxPrevCP = this.numOfCheckPts - 2;
                car.gfxCurrCP = this.numOfCheckPts - 1;
                car.gfxNextCP = 0;
                car.przejsciowka = true;
            } else if (car.gfxCurrCP == this.numOfCheckPts - 1) {
                car.gfxPrevCP = this.numOfCheckPts - 1;
                car.gfxCurrCP = 0;
                car.gfxNextCP = 1;
            } else if (car.gfxCurrCP == 0) {
                car.gfxPrevCP = 0;
                car.gfxCurrCP = 1;
                car.gfxNextCP = 2;
            } else {
                ++car.gfxCurrCP;
                ++car.gfxNextCP;
                ++car.gfxPrevCP;
            }
        } else if (dist2toPrev < dist2toCurr) {
            car.bkwbool = true;
            if (car.gfxCurrCP == 1) {
                car.gfxPrevCP = this.numOfCheckPts - 1;
                car.gfxCurrCP = 0;
                car.gfxNextCP = 1;
            } else if (car.gfxCurrCP == 0) {
                car.gfxPrevCP = this.numOfCheckPts - 2;
                car.gfxCurrCP = this.numOfCheckPts - 1;
                car.gfxNextCP = 0;
            } else if (car.gfxCurrCP == this.numOfCheckPts - 1) {
                car.gfxPrevCP = this.numOfCheckPts - 3;
                car.gfxCurrCP = this.numOfCheckPts - 2;
                car.gfxNextCP = this.numOfCheckPts - 1;
            } else {
                --car.gfxCurrCP;
                --car.gfxNextCP;
                --car.gfxPrevCP;
            }
        }
    }

    private void setGFXforPainting() {
        this.gfxPos[IsoRace.selectedCar] = this.playerCar.gfxCurrCP;
        this.gfxPos[IsoRace.selectedCar] = this.gfxPos[IsoRace.selectedCar] * ImageSet.getGameImage("/gfx/topline.png").getWidth() / this.numOfCheckPts;
        if (IsoRace.selectedCar == 0) {
            for (int i = 1; i < this.gfxPos.length; ++i) {
                this.gfxPos[i] = this.opponentCar[i - 1].gfxCurrCP;
                this.gfxPos[i] = this.gfxPos[i] * ImageSet.getGameImage("/gfx/topline.png").getWidth() / this.numOfCheckPts;
            }
        } else {
            this.gfxPos[0] = this.opponentCar[IsoRace.selectedCar - 1].gfxCurrCP;
            this.gfxPos[0] = this.gfxPos[0] * ImageSet.getGameImage("/gfx/topline.png").getWidth() / this.numOfCheckPts;
            for (int i = 1; i < this.gfxPos.length; ++i) {
                if (i == IsoRace.selectedCar) continue;
                this.gfxPos[i] = this.opponentCar[i - 1].gfxCurrCP;
                this.gfxPos[i] = this.gfxPos[i] * ImageSet.getGameImage("/gfx/topline.png").getWidth() / this.numOfCheckPts;
            }
        }
    }

    public void clearImages() {
        this.startLights = null;
        this.clearTilesImg();
        this.clearCarImages();
    }

    private void clearTilesImg() {
        this.mapEngine.clearImages();
    }

    private void clearCarImages() {
        if (this.playerCar != null) {
            this.playerCar.clearSpriteImages();
            this.playerCar.sprite = null;
        }
        if (this.opponentCar != null) {
            for (int i = 0; i < this.opponentCar.length; ++i) {
                if (this.opponentCar[i] == null) continue;
                this.opponentCar[i].clearSpriteImages();
                this.opponentCar[i].sprite = null;
            }
        }
    }

    public void prepareSprites() {
        this.menuArrowsSprite = new Sprite(ImageSet.getGameImage("/menu/smallarrows.png"), 7, 9);
        this.menuArrowsSprite.setFrameSequence(new int[]{0, 1, 2});
        this.menuArrowsSprite.defineReferencePixel(ImageSet.getGameImage("/menu/smallarrows.png").getWidth(), ImageSet.getGameImage("/menu/smallarrows.png").getHeight() / 2);
    }
}

