/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ApplicationCanvas;
import game.FinalData;
import game.IsoRace;
import game.TileMenager;
import game.car.Car;
import game.car.Cone;
import game.car.OpponentCar;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import maths.Point2d;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;
import utils.ImageSet;

public final class MapEngine {
    private TileMenager tileMgr;
    private static Vector2d[] n = new Vector2d[2];
    private boolean bigTrackImageLoaded;
    private Image imgBgBuffer;
    private Graphics bgBuffer;
    public static int numberOfCones = 0;
    public static Vector conesTilesVec;
    private Cone[] cone;
    private Car car;
    private OpponentCar[] oppCar;
    private int[][] mapTiles = null;
    private int[][] mapMask = null;
    public static int tileWidth;
    public static int tileHeight;
    public static int tileHalfWidth;
    public static int tileHalfHeight;
    public static int mapWidth;
    public static int mapHeight;
    public static int bufferTilesX;
    public static int bufferTilesY;
    private static int bufferX;
    private static int bufferY;
    public static int viewSpaceWidth;
    public static int viewSpaceHeight;
    private static int viewSpaceHalfWidth;
    private static int viewSpaceHalfHeight;
    public static int boardSpaceWidth;
    public static int boardSpaceHeight;
    public static int FPboardSpaceWidth;
    public static int FPboardSpaceHeight;
    private static int anchorSpaceWidth;
    private static int anchorSpaceHeight;
    public static int ptAnchorViewX;
    public static int ptAnchorViewY;
    private int xMPt;
    private int yMPt;
    private Image tilesImg = null;
    private int twiceTileHeight = 0;
    private static final int BUFFERED_OBJECTS_LIMIT = 10;
    int[] posXBuff = new int[10];
    int[] posYBuff = new int[10];
    int[] typeBuff = new int[10];
    int indexBuff = 0;
    public int startPoleX = 0;
    public int startPoleY = 0;

    public void clearImages() {
        this.tilesImg = null;
        this.imgBgBuffer = null;
    }

    public MapEngine(int tWidth, int tHeight, int viewWidth, int viewHeight) {
        tileWidth = tWidth;
        tileHeight = tHeight;
        tileHalfWidth = tWidth >> 1;
        tileHalfHeight = tHeight >> 1;
        this.twiceTileHeight = tileHeight + tileHeight;
        viewSpaceWidth = viewWidth;
        viewSpaceHeight = viewHeight;
        viewSpaceHalfWidth = viewWidth >> 1;
        viewSpaceHalfHeight = viewHeight >> 1;
        bufferTilesX = viewWidth / tileWidth + 1 + 1;
        bufferTilesY = viewHeight / (tileHeight >> 1) + 3;
        if (viewWidth % tileWidth >= tileHalfWidth) {
            ++bufferTilesX;
        }
        MapEngine.n[0] = new Vector2d();
        MapEngine.n[1] = new Vector2d();
        n[0].setToFP(1, 1);
        n[0].normalize();
        n[1].setToFP(1, -1);
        n[1].normalize();
    }

    public void load(String mapPath, String tilesImagePath) {
        this.startPoleX = 0;
        this.startPoleY = 0;
        try {
            int column;
            int row;
            this.bigTrackImageLoaded = false;
            this.tilesImg = Image.createImage((String)tilesImagePath);
            DataInputStream stream = new DataInputStream(this.getClass().getResourceAsStream(mapPath));
            mapWidth = stream.readByte();
            mapHeight = stream.readByte();
            boardSpaceWidth = mapWidth * tileWidth;
            boardSpaceHeight = mapHeight * tileHalfHeight;
            FPboardSpaceWidth = MathFP.toFP(boardSpaceWidth);
            FPboardSpaceHeight = MathFP.mul(MathFP.toFP(boardSpaceHeight), MathFP.toFP(2));
            anchorSpaceWidth = boardSpaceWidth - viewSpaceWidth;
            anchorSpaceHeight = boardSpaceHeight - viewSpaceHeight;
            ptAnchorViewX = 0;
            ptAnchorViewY = 0;
            System.out.println("Map size: " + mapWidth + "x" + mapHeight);
            System.out.println("Tile size: " + tileWidth + "x" + tileHeight);
            System.out.println("World size: " + boardSpaceWidth + "x" + boardSpaceHeight);
            System.out.println("View space size: " + viewSpaceWidth + "x" + viewSpaceHeight);
            System.out.println("Half view space size: " + viewSpaceHalfWidth + "x" + viewSpaceHalfHeight);
            System.out.println("View tiles: " + bufferTilesX + "x" + bufferTilesY);
            System.out.println("Anchor space size: " + anchorSpaceWidth + "x" + anchorSpaceHeight);
            this.mapTiles = new int[mapHeight][mapWidth];
            this.mapMask = new int[mapHeight][mapWidth];
            for (row = 0; row < mapHeight; ++row) {
                for (column = 0; column < mapWidth; ++column) {
                    this.mapTiles[row][column] = stream.readByte();
                }
            }
            numberOfCones = 0;
            conesTilesVec = new Vector();
            for (row = 0; row < mapHeight; ++row) {
                for (column = 0; column < mapWidth; ++column) {
                    this.mapMask[row][column] = this.getMaskValue(stream.readByte(), row, column);
                    if (this.mapMask[row][column] != 30) continue;
                    ++numberOfCones;
                    Point2d coneTile = new Point2d(column, row);
                    conesTilesVec.addElement(coneTile);
                }
            }
            this.autoFillerMask();
            this.createBufferedImage();
            System.out.println("numberOfCones=" + numberOfCones);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createBufferedImage() {
        if (this.imgBgBuffer == null) {
            this.imgBgBuffer = Image.createImage((int)(bufferTilesX * tileWidth), (int)(bufferTilesY * tileHalfHeight));
            this.bgBuffer = this.imgBgBuffer.getGraphics();
            this.tileMgr = new TileMenager(bufferTilesX, bufferTilesY);
            if (!this.bigTrackImageLoaded) {
                this.tileMgr.fillBuffer(this.bgBuffer, this.tilesImg, this);
            }
        } else {
            Image imgBgBuffer2;
            this.imgBgBuffer = imgBgBuffer2 = Image.createImage((int)(bufferTilesX * tileWidth), (int)(bufferTilesY * tileHalfHeight));
            this.bgBuffer = imgBgBuffer2.getGraphics();
            this.tileMgr = new TileMenager(bufferTilesX, bufferTilesY);
            this.tileMgr.reset();
            if (!this.bigTrackImageLoaded) {
                this.tileMgr.fillBuffer(this.bgBuffer, this.tilesImg, this);
            }
        }
    }

    private void autoFillerMask() {
        int tileValue = 0;
        for (int row = 0; row < mapHeight; ++row) {
            for (int column = 0; column < mapWidth; ++column) {
                tileValue = this.mapTiles[row][column];
                if (this.mapMask[row][column] != 0) continue;
                if (tileValue == 1 || tileValue == 2 || tileValue == 3 || tileValue == 4) {
                    this.mapMask[row][column] = 43;
                }
                if (tileValue != 0 && tileValue != 34 && tileValue != 31 && tileValue != 28 && tileValue != 25 && tileValue != 80 && tileValue != 78 && tileValue != 46 && tileValue != 49 && tileValue != 52 && tileValue != 61 && tileValue != 76 && tileValue != 43 && tileValue != 89) continue;
                this.mapMask[row][column] = 42;
            }
        }
    }

    public int getMaskValue(int value, int row, int column) {
        int tileMapValue;
        int returnValue = value;
        if (value == 1) {
            return 1;
        }
        if (value == 2) {
            return 2;
        }
        if (value == 3) {
            return 3;
        }
        if (value == 4) {
            return 4;
        }
        if (value == 5) {
            if (row - 12 > 0) {
                this.mapMask[row - 12][column] = 60;
            }
            return 64;
        }
        if (value == 6) {
            if (row - 8 > 0) {
                this.mapMask[row - 8][column] = 61;
            }
            return 65;
        }
        if (value == 8) {
            return 100 + ApplicationCanvas.getRandom(1, 6);
        }
        if (value == 9) {
            return 30;
        }
        if (value == 10) {
            return 67;
        }
        if (value == 11) {
            return 69;
        }
        if (value == 12) {
            return 70;
        }
        if (value == 13) {
            return 68;
        }
        if (value == 14) {
            return 71;
        }
        if (value == 15) {
            return 72;
        }
        if (value == 16) {
            return 73;
        }
        if (value == 17) {
            return 74;
        }
        if (value == 18) {
            return 75;
        }
        if (value == 20) {
            return 80;
        }
        if (value == 21) {
            if (row - 6 > 0) {
                this.mapMask[row - 6][column] = 62;
            }
            return 66;
        }
        if (value == 22) {
            return 76;
        }
        if (value == 23) {
            return 77;
        }
        if (value == 24) {
            return 78;
        }
        if (value == 25) {
            return 79;
        }
        if (value == 29) {
            return 9;
        }
        if (value == 30) {
            return 10;
        }
        if (value == 0 && ((tileMapValue = this.mapTiles[row][column]) == 5 || tileMapValue == 6 || tileMapValue == 7 || tileMapValue == 15 || tileMapValue == 16 || tileMapValue == 17)) {
            return 8;
        }
        tileMapValue = this.mapTiles[row][column];
        if (93 <= tileMapValue && tileMapValue <= 97) {
            return 5;
        }
        if (tileMapValue == 98) {
            return 7;
        }
        return returnValue;
    }

    public static void setViewPoint(int tileX, int tileY) {
        if (tileX < 0 || tileX > mapWidth) {
            throw new IllegalStateException("Argument 'tileX' is out of map range. Missing value:" + tileX);
        }
        if (tileY < 0 || tileY > mapHeight) {
            throw new IllegalStateException("Argument 'tileY' is out of map range. Missing value:" + tileX);
        }
        int yPt = tileY * tileHalfHeight;
        int xPt = tileX * tileWidth;
        ptAnchorViewX = xPt * (boardSpaceWidth - viewSpaceWidth) / boardSpaceWidth;
        ptAnchorViewY = yPt * (boardSpaceHeight - viewSpaceHeight) / boardSpaceHeight;
        if (ptAnchorViewX < viewSpaceWidth >> 1) {
            ptAnchorViewX = 0;
        }
        if (ptAnchorViewY < viewSpaceHeight >> 1) {
            ptAnchorViewY = 0;
        }
    }

    public static final void scrollMap(Car car) {
        ptAnchorViewX = car.sprite.x * (boardSpaceWidth - viewSpaceWidth) / boardSpaceWidth;
        ptAnchorViewY = car.sprite.y * (boardSpaceHeight - viewSpaceHeight) / boardSpaceHeight;
    }

    public void drawMapStragged(Graphics g, Car playerCar) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, IsoRace.SCREEN_WIDTH, IsoRace.SCREEN_HEIGHT);
        this.tileMgr.setBufferPos(ptAnchorViewX, ptAnchorViewY);
        this.tileMgr.translateBuffer(this, this.tilesImg, g, this.bgBuffer, this.imgBgBuffer);
        bufferX = this.tileMgr.bufferX;
        bufferY = this.tileMgr.bufferY;
        g.drawImage(this.imgBgBuffer, bufferX * tileWidth, bufferY * tileHalfHeight, 20);
        g.translate(-g.getTranslateX(), -g.getTranslateY());
        this.tileMgr.drawMapElements(g, this);
        g.setClip(0, 0, IsoRace.SCREEN_WIDTH, IsoRace.SCREEN_HEIGHT);
    }

    public void referCones(Cone[] cone) {
        this.cone = cone;
    }

    public void referCars(OpponentCar[] oppCar, Car car) {
        this.car = car;
        this.oppCar = oppCar;
    }

    public void drawCharacters(Graphics g, int ptMapX, int ptMapY) {
        int i;
        for (i = 0; i < numberOfCones; ++i) {
            if (ptMapY != this.cone[i].getTileY() || ptMapX != this.cone[i].getTileX()) continue;
            this.cone[i].draw(g);
        }
        if (ptMapY == this.car.getTileY() && ptMapX == this.car.getTileX()) {
            this.car.draw(g);
        }
        for (i = 0; i < this.oppCar.length; ++i) {
            if (ptMapY != this.oppCar[i].getTileY() || ptMapX != this.oppCar[i].getTileX()) continue;
            this.oppCar[i].draw(g);
        }
    }

    public void drawBufferedMapElements(Graphics g) {
        for (int i = 0; i < this.indexBuff; ++i) {
            if (this.typeBuff[i] == 64) {
                g.setClip(this.posXBuff[i], this.posYBuff[i], 96, 144);
                g.drawImage(ImageSet.getGameImage("img_tree1"), this.posXBuff[i], this.posYBuff[i], 20);
                continue;
            }
            if (this.typeBuff[i] == 65) {
                g.setClip(this.posXBuff[i], this.posYBuff[i], 96, 117);
                g.drawImage(ImageSet.getGameImage("img_tree2"), this.posXBuff[i], this.posYBuff[i], 20);
                continue;
            }
            if (this.typeBuff[i] != 66) continue;
            g.setClip(this.posXBuff[i], this.posYBuff[i], 64, 82);
            g.drawImage(ImageSet.getGameImage("img_tree3"), this.posXBuff[i], this.posYBuff[i], 20);
        }
    }

    public void drawMapElement(Graphics g, int maskValue, int xPt, int yPt, int ptMapY, int iend) {
        if (maskValue > 0 && maskValue < 5) {
            this.yMPt = yPt - tileHeight;
            this.xMPt = xPt;
            g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth + 1);
            g.drawImage(ImageSet.getGameImage("/colectible_items.png"), this.xMPt - (maskValue - 1) * tileWidth, this.yMPt, 20);
        } else if (maskValue > 100) {
            int frameV = maskValue - 100;
            this.yMPt = yPt - (tileHeight + 6);
            this.xMPt = xPt + tileHalfHeight;
            g.setClip(this.xMPt, this.yMPt, tileHeight, tileWidth + 6);
            g.drawImage(ImageSet.getGameImage("/peoples.png"), this.xMPt - frameV * tileHeight, this.yMPt, 20);
        } else {
            switch (maskValue) {
                case 30: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    break;
                }
                case 67: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - tileWidth, this.yMPt, 20);
                    break;
                }
                case 69: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - 2 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 70: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - 3 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 68: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - 4 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 71: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - 5 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 72: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - 6 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 73: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - 7 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 74: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - 8 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 75: {
                    this.yMPt = yPt - tileHeight;
                    this.xMPt = xPt;
                    g.setClip(this.xMPt, this.yMPt, tileWidth, tileWidth);
                    g.drawImage(ImageSet.getGameImage("/elements32.png"), this.xMPt - 9 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 64: {
                    this.yMPt = yPt - (ImageSet.getGameImage("img_tree1").getHeight() + 3) + this.twiceTileHeight;
                    this.xMPt = xPt + tileHalfWidth - ImageSet.getGameImage("img_tree1").getWidth() / 2;
                    g.setClip(this.xMPt, this.yMPt, ImageSet.getGameImage("img_tree1").getWidth(), ImageSet.getGameImage("img_tree1").getHeight() + 7);
                    g.drawImage(ImageSet.getGameImage("img_tree1"), this.xMPt, this.yMPt, 20);
                    break;
                }
                case 80: {
                    this.yMPt = yPt - (ImageSet.getGameImage("/startpole_1.png").getHeight() - 2) + this.twiceTileHeight;
                    this.xMPt = xPt + tileHalfWidth - (ImageSet.getGameImage("/startpole_1.png").getWidth() - 8) / 2;
                    g.setClip(this.xMPt, this.yMPt, ImageSet.getGameImage("/startpole_1.png").getWidth(), ImageSet.getGameImage("/startpole_1.png").getHeight());
                    g.drawImage(ImageSet.getGameImage("/startpole_1.png"), this.xMPt, this.yMPt, 20);
                    this.startPoleX = this.xMPt;
                    this.startPoleY = this.yMPt;
                    break;
                }
                case 60: {
                    if (ptMapY + 12 < iend) break;
                    this.posYBuff[this.indexBuff] = yPt - (ImageSet.getGameImage("img_tree1").getHeight() + 3) + this.twiceTileHeight + 6 * tileHeight;
                    this.posXBuff[this.indexBuff] = xPt + tileHalfWidth - ImageSet.getGameImage("img_tree1").getWidth() / 2;
                    this.typeBuff[this.indexBuff] = 64;
                    ++this.indexBuff;
                    break;
                }
                case 65: {
                    this.yMPt = yPt - (ImageSet.getGameImage("img_tree2").getHeight() + 1) + this.twiceTileHeight;
                    this.xMPt = xPt + tileHalfWidth - ImageSet.getGameImage("img_tree2").getWidth() / 2;
                    g.setClip(this.xMPt, this.yMPt, ImageSet.getGameImage("img_tree2").getWidth(), ImageSet.getGameImage("img_tree2").getHeight());
                    g.drawImage(ImageSet.getGameImage("img_tree2"), this.xMPt, this.yMPt, 20);
                    break;
                }
                case 61: {
                    if (ptMapY + 8 < iend) break;
                    this.posYBuff[this.indexBuff] = yPt - (ImageSet.getGameImage("img_tree2").getHeight() + 1) + this.twiceTileHeight + 4 * tileHeight;
                    this.posXBuff[this.indexBuff] = xPt + tileHalfWidth - ImageSet.getGameImage("img_tree2").getWidth() / 2;
                    this.typeBuff[this.indexBuff] = 65;
                    ++this.indexBuff;
                    break;
                }
                case 66: {
                    this.yMPt = yPt - (ImageSet.getGameImage("img_tree3").getHeight() - tileHeight);
                    this.xMPt = xPt - tileHalfWidth;
                    g.setClip(this.xMPt, this.yMPt, ImageSet.getGameImage("img_tree3").getWidth(), ImageSet.getGameImage("img_tree3").getHeight());
                    g.drawImage(ImageSet.getGameImage("img_tree3"), this.xMPt, this.yMPt, 20);
                    break;
                }
                case 62: {
                    if (ptMapY + 6 < iend) break;
                    this.posYBuff[this.indexBuff] = yPt - ImageSet.getGameImage("img_tree3").getHeight() + this.twiceTileHeight + 2 * tileHeight;
                    this.posXBuff[this.indexBuff] = xPt - tileHalfWidth;
                    this.typeBuff[this.indexBuff] = 66;
                    ++this.indexBuff;
                    break;
                }
                case 76: {
                    this.yMPt = yPt - (ImageSet.getGameImage("/elements64.png").getHeight() - tileHeight);
                    this.xMPt = xPt - tileHalfWidth;
                    g.setClip(this.xMPt, this.yMPt, 2 * tileWidth, ImageSet.getGameImage("/elements64.png").getHeight());
                    g.drawImage(ImageSet.getGameImage("/elements64.png"), this.xMPt, this.yMPt, 20);
                    break;
                }
                case 77: {
                    this.yMPt = yPt - (ImageSet.getGameImage("/elements64.png").getHeight() - tileHeight);
                    this.xMPt = xPt - tileHalfWidth;
                    g.setClip(this.xMPt, this.yMPt, 2 * tileWidth, ImageSet.getGameImage("/elements64.png").getHeight());
                    g.drawImage(ImageSet.getGameImage("/elements64.png"), this.xMPt - 2 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 78: {
                    this.yMPt = yPt - (ImageSet.getGameImage("/elements64.png").getHeight() - tileHeight);
                    this.xMPt = xPt - tileHalfWidth;
                    g.setClip(this.xMPt, this.yMPt, 2 * tileWidth, ImageSet.getGameImage("/elements64.png").getHeight());
                    g.drawImage(ImageSet.getGameImage("/elements64.png"), this.xMPt - 4 * tileWidth, this.yMPt, 20);
                    break;
                }
                case 79: {
                    this.yMPt = yPt - (ImageSet.getGameImage("/elements64.png").getHeight() - tileHeight);
                    this.xMPt = xPt - tileHalfWidth;
                    g.setClip(this.xMPt, this.yMPt, 2 * tileWidth, ImageSet.getGameImage("/elements64.png").getHeight());
                    g.drawImage(ImageSet.getGameImage("/elements64.png"), this.xMPt - 6 * tileWidth, this.yMPt, 20);
                }
            }
        }
    }

    public static final int[] getTilePositionFromFP(Vector2d pos) {
        int[] coords = new int[2];
        int[] dot = new int[2];
        Vector2d PK = new Vector2d();
        Vector2d r = new Vector2d();
        int xT = MathFP.toInt(pos.x) / tileWidth;
        int yT = 2 * (MathFP.toInt(pos.y) / tileWidth);
        PK.setToFP(tileWidth * xT + tileHeight, tileWidth * (yT / 2) + tileHeight);
        r.setSubFP(pos, PK);
        dot[0] = r.dotFP(n[0]);
        dot[1] = r.dotFP(n[1]);
        if (MathFP.abs(dot[0]) <= FinalData.FP_TILE_HALF_SIDE && MathFP.abs(dot[1]) <= FinalData.FP_TILE_HALF_SIDE) {
            coords[0] = xT;
            coords[1] = yT;
        } else if (dot[0] < -FinalData.FP_TILE_HALF_SIDE && MathFP.abs(dot[1]) <= FinalData.FP_TILE_HALF_SIDE) {
            coords[0] = xT - 1;
            coords[1] = yT - 1;
        } else if (MathFP.abs(dot[0]) <= FinalData.FP_TILE_HALF_SIDE && dot[1] < -FinalData.FP_TILE_HALF_SIDE) {
            coords[0] = xT - 1;
            coords[1] = yT + 1;
        } else if (MathFP.abs(dot[0]) <= FinalData.FP_TILE_HALF_SIDE && dot[1] > FinalData.FP_TILE_HALF_SIDE) {
            coords[0] = xT;
            coords[1] = yT - 1;
        } else if (dot[0] > FinalData.FP_TILE_HALF_SIDE && MathFP.abs(dot[1]) <= FinalData.FP_TILE_HALF_SIDE) {
            coords[0] = xT;
            coords[1] = yT + 1;
        }
        return coords;
    }

    public int getTileValue(int ptMapY, int ptMapX) {
        return this.mapTiles[ptMapY][ptMapX];
    }

    public int getTileMaskValue(int ptMapY, int ptMapX) {
        return this.mapMask[ptMapY][ptMapX];
    }

    public int getTileMaskValueByTile(int xTile, int yTile) {
        return this.mapMask[yTile < 0 ? 0 : yTile][xTile < 0 ? 0 : xTile];
    }

    public void clearMaskValue(int tileX, int tileY) {
        this.mapMask[tileY][tileX] = 0;
    }

    static {
        mapWidth = 0;
        mapHeight = 0;
        bufferTilesX = 0;
        bufferTilesY = 0;
        viewSpaceWidth = 0;
        viewSpaceHeight = 0;
        viewSpaceHalfWidth = 0;
        viewSpaceHalfHeight = 0;
        boardSpaceWidth = 1;
        boardSpaceHeight = 1;
        anchorSpaceWidth = 0;
        anchorSpaceHeight = 0;
        ptAnchorViewX = 0;
        ptAnchorViewY = 0;
    }
}

