/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.FinalData;
import game.MapEngine;
import maths.Point2d;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;

public final class TrackFinalData {
    private Vector2d[] oppCarPos;
    private Vector2d carPos;
    public int numOfCheckPts;
    public int[][] checkPointOnLevel;
    public int[] roadSignsType;
    private Vector2d[] conePos;

    public TrackFinalData(int numberOfCars) {
        this.oppCarPos = new Vector2d[numberOfCars];
        for (int i = 0; i < this.oppCarPos.length; ++i) {
            this.oppCarPos[i] = new Vector2d();
        }
        this.carPos = new Vector2d();
    }

    public void setCarsInitData(int numOfTrack) {
        switch (numOfTrack) {
            case 0: {
                this.carPos.setToFP(11, 65);
                this.oppCarPos[0].setToFP(11, 69);
                this.oppCarPos[1].setToFP(13, 69);
                this.oppCarPos[2].setToFP(13, 73);
                break;
            }
            case 1: {
                this.carPos.setToFP(15, 59);
                this.oppCarPos[0].setToFP(15, 63);
                this.oppCarPos[1].setToFP(17, 63);
                this.oppCarPos[2].setToFP(17, 67);
                break;
            }
            case 2: {
                this.carPos.setToFP(14, 57);
                this.oppCarPos[0].setToFP(14, 61);
                this.oppCarPos[1].setToFP(16, 61);
                this.oppCarPos[2].setToFP(16, 65);
                break;
            }
            case 3: {
                this.carPos.setToFP(10, 75);
                this.oppCarPos[0].setToFP(10, 79);
                this.oppCarPos[1].setToFP(12, 79);
                this.oppCarPos[2].setToFP(12, 83);
                break;
            }
            case 4: {
                this.carPos.setToFP(31, 47);
                this.oppCarPos[0].setToFP(29, 39);
                this.oppCarPos[1].setToFP(29, 43);
                this.oppCarPos[2].setToFP(31, 43);
                break;
            }
            case 5: {
                this.carPos.setToFP(40, 29);
                this.oppCarPos[0].setToFP(38, 29);
                this.oppCarPos[1].setToFP(38, 25);
                this.oppCarPos[2].setToFP(40, 33);
                break;
            }
            case 6: {
                this.carPos.setToFP(52, 41);
                this.oppCarPos[0].setToFP(50, 33);
                this.oppCarPos[1].setToFP(50, 37);
                this.oppCarPos[2].setToFP(52, 37);
                break;
            }
            case 7: {
                this.carPos.setToFP(52, 41);
                this.oppCarPos[0].setToFP(50, 33);
                this.oppCarPos[1].setToFP(50, 37);
                this.oppCarPos[2].setToFP(52, 37);
                break;
            }
            case 8: {
                this.carPos.setToFP(49, 65);
                this.oppCarPos[0].setToFP(47, 57);
                this.oppCarPos[1].setToFP(47, 61);
                this.oppCarPos[2].setToFP(49, 61);
                break;
            }
            case 9: {
                this.carPos.setToFP(39, 37);
                this.oppCarPos[0].setToFP(37, 29);
                this.oppCarPos[1].setToFP(37, 33);
                this.oppCarPos[2].setToFP(39, 33);
            }
        }
    }

    public void setTrackInitData(int trackNo) {
        switch (trackNo) {
            case 0: {
                int[][] checkPointOnLevel1 = new int[][]{{10, 66}, {9, 64}, {7, 56}, {7, 49}, {11, 36}, {20, 16}, {24, 13}, {28, 21}, {27, 33}, {18, 47}, {17, 57}, {21, 68}, {16, 77}, {13, 74}};
                int[] roadSignsTypeTemp1 = new int[]{0, 2, 5, 3, 1, 3, 6, 0};
                this.checkPointOnLevel = checkPointOnLevel1;
                this.roadSignsType = roadSignsTypeTemp1;
                break;
            }
            case 1: {
                int[][] checkPointOnLevel2 = new int[][]{{14, 60}, {10, 53}, {3, 41}, {4, 31}, {13, 12}, {18, 14}, {33, 42}, {32, 57}, {24, 74}, {18, 71}};
                int[] roadSignsTypeTemp2 = new int[]{0, 2, 5, 3, 6, 0};
                this.checkPointOnLevel = checkPointOnLevel2;
                this.roadSignsType = roadSignsTypeTemp2;
                MapEngine.setViewPoint(15, 59);
                break;
            }
            case 2: {
                int[][] checkPointOnLevel3 = new int[][]{{13, 58}, {9, 51}, {6, 46}, {3, 39}, {4, 29}, {10, 17}, {18, 24}, {25, 15}, {31, 25}, {29, 40}, {32, 54}, {29, 67}, {24, 75}, {19, 70}};
                int[] roadSignsTypeTemp3 = new int[]{0, 2, 5, 3, 1, 3, 3, 0};
                this.checkPointOnLevel = checkPointOnLevel3;
                this.roadSignsType = roadSignsTypeTemp3;
                MapEngine.setViewPoint(14, 57);
                break;
            }
            case 3: {
                int[][] checkPointOnLevel4 = new int[][]{{9, 76}, {5, 70}, {4, 66}, {4, 60}, {29, 5}, {46, 40}, {41, 50}, {32, 42}, {17, 65}, {25, 82}, {18, 95}};
                int[] roadSignsTypeTemp4 = new int[]{0, 2, 5, 3, 6, 2, 1, 3, 4, 0};
                this.checkPointOnLevel = checkPointOnLevel4;
                this.roadSignsType = roadSignsTypeTemp4;
                MapEngine.setViewPoint(10, 75);
                break;
            }
            case 4: {
                int[][] checkPointOnLevel5 = new int[][]{{30, 43}, {28, 38}, {23, 32}, {17, 38}, {9, 52}, {5, 41}, {9, 27}, {19, 7}, {24, 8}, {33, 27}, {38, 43}, {38, 51}};
                int[] roadSignsTypeTemp5 = new int[]{0, 2, 5, 3, 6, 2, 1, 3, 4, 0};
                this.checkPointOnLevel = checkPointOnLevel5;
                this.roadSignsType = roadSignsTypeTemp5;
                MapEngine.setViewPoint(31, 53);
                break;
            }
            case 5: {
                int dx = 5;
                int dy = 10;
                int[][] checkPointOnLevel6 = new int[][]{{37 + dx, 26 + dy}, {27 + dx, 9 + dy}, {24 + dx, 12 + dy}, {5 + dx, 50 + dy}, {5 + dx, 64 + dy}, {12 + dx, 81 + dy}, {16 + dx, 79 + dy}, {16 + dx, 67 + dy}, {15 + dx, 60 + dy}, {15 + dx, 48 + dy}, {21 + dx, 52 + dy}, {28 + dx, 57 + dy}, {30 + dx, 49 + dy}, {29 + dx, 45 + dy}, {25 + dx, 37 + dy}, {25 + dx, 26 + dy}, {30 + dx, 27 + dy}, {38 + dx, 45 + dy}, {44 + dx, 46 + dy}, {42 + dx, 32 + dy}};
                int[] roadSignsTypeTemp6 = new int[]{0, 2, 5, 3, 6, 2, 1, 3, 4, 0};
                this.checkPointOnLevel = checkPointOnLevel6;
                this.roadSignsType = roadSignsTypeTemp6;
                MapEngine.setViewPoint(41, 26);
                break;
            }
            case 6: {
                int[][] checkPointOnLevel7 = new int[][]{{53, 41}, {44, 22}, {40, 14}, {33, 13}, {23, 38}, {18, 37}, {11, 25}, {4, 27}, {6, 42}, {17, 71}, {24, 68}, {35, 40}, {41, 42}, {47, 60}, {54, 57}};
                int[] roadSignsTypeTemp7 = new int[]{0, 2, 5, 3, 6, 2, 1, 3, 4, 0};
                this.checkPointOnLevel = checkPointOnLevel7;
                this.roadSignsType = roadSignsTypeTemp7;
                MapEngine.setViewPoint(52, 41);
                break;
            }
            case 7: {
                int[][] checkPointOnLevel8 = new int[][]{{53, 39}, {44, 20}, {40, 12}, {33, 12}, {23, 38}, {15, 34}, {11, 25}, {4, 27}, {6, 42}, {17, 71}, {27, 90}, {32, 80}, {28, 63}, {35, 40}, {41, 42}, {47, 60}, {54, 57}};
                int[] roadSignsTypeTemp8 = new int[]{0, 2, 5, 3, 6, 2, 1, 3, 4, 0};
                this.checkPointOnLevel = checkPointOnLevel8;
                this.roadSignsType = roadSignsTypeTemp8;
                MapEngine.setViewPoint(54, 35);
                break;
            }
            case 8: {
                int[][] checkPointOnLevel9 = new int[][]{{50, 63}, {44, 52}, {44, 50}, {46, 38}, {53, 25}, {51, 11}, {45, 13}, {39, 28}, {33, 24}, {27, 9}, {18, 13}, {19, 28}, {26, 38}, {24, 53}, {16, 66}, {17, 83}, {25, 84}, {32, 65}, {38, 66}, {44, 81}, {51, 79}};
                int[] roadSignsTypeTemp9 = new int[]{0, 2, 5, 3, 6, 2, 1, 3, 4, 0};
                this.checkPointOnLevel = checkPointOnLevel9;
                this.roadSignsType = roadSignsTypeTemp9;
                MapEngine.setViewPoint(49, 65);
                break;
            }
            case 9: {
                int[][] checkPointOnLevel10 = new int[][]{{36, 26}, {27, 10}, {21, 9}, {21, 20}, {26, 28}, {24, 42}, {17, 42}, {11, 26}, {4, 27}, {6, 43}, {26, 84}, {32, 87}, {31, 76}, {27, 69}, {28, 56}, {34, 55}, {43, 75}, {50, 74}, {52, 67}};
                int[] roadSignsTypeTemp10 = new int[]{0, 2, 5, 3, 6, 2, 1, 3, 4, 0};
                this.checkPointOnLevel = checkPointOnLevel10;
                this.roadSignsType = roadSignsTypeTemp10;
                MapEngine.setViewPoint(39, 33);
            }
        }
        this.numOfCheckPts = this.checkPointOnLevel.length;
    }

    public Vector2d getInitOppCarPos(int i) {
        return this.oppCarPos[i];
    }

    public Vector2d getInitCarPos() {
        return this.carPos;
    }

    public Vector2d getConePos(int i) {
        return this.conePos[i];
    }

    public void fitOppCarTilePos(int i) {
        this.oppCarPos[i].x = MathFP.add(MathFP.mul(this.oppCarPos[i].x, MathFP.toFP(FinalData.TILE_WIDTH)), MathFP.toFP(5));
        this.oppCarPos[i].y = MathFP.div(MathFP.mul(this.oppCarPos[i].y, MathFP.toFP(FinalData.TILE_HEIGHT)), MathFP.toFP(2));
        this.oppCarPos[i].y = MathFP.div(this.oppCarPos[i].y, FinalData.FP_CAM_HEIGHT);
    }

    public void fitCarTilePos() {
        this.carPos.x = MathFP.add(MathFP.mul(this.carPos.x, MathFP.toFP(FinalData.TILE_WIDTH)), MathFP.toFP(5));
        this.carPos.y = MathFP.div(MathFP.mul(this.carPos.y, MathFP.toFP(FinalData.TILE_HEIGHT)), MathFP.toFP(2));
        this.carPos.y = MathFP.div(this.carPos.y, FinalData.FP_CAM_HEIGHT);
    }

    public void fitConesTilesPos() {
        this.conePos = new Vector2d[MapEngine.numberOfCones];
        for (int i = 0; i < this.conePos.length; ++i) {
            int xTile = ((Point2d)MapEngine.conesTilesVec.elementAt((int)i)).x;
            int yTile = ((Point2d)MapEngine.conesTilesVec.elementAt((int)i)).y;
            this.conePos[i] = new Vector2d();
            if (yTile % 2 == 0) {
                this.conePos[i].setToFP(xTile * FinalData.TILE_WIDTH + FinalData.TILE_WIDTH / 2, (yTile + 1) * FinalData.TILE_WIDTH / 2);
            } else if (yTile % 2 == 1) {
                this.conePos[i].setToFP(xTile * FinalData.TILE_WIDTH + FinalData.TILE_WIDTH, (yTile + 1) * FinalData.TILE_WIDTH / 2);
            }
            this.conePos[i].x = MathFP.sub(this.conePos[i].x, MathFP.toFP(1));
            this.conePos[i].y = MathFP.sub(this.conePos[i].y, MathFP.toFP(5));
        }
    }
}

