/*
 * Decompiled with CFR 0.152.
 */
package game.car;

import game.FinalData;
import game.MapEngine;
import game.car.BaseCar;
import game.car.CarInteraction;
import javax.microedition.lcdui.Image;
import net.jscience.math.kvm.MathFP;
import utils.Sounds;

public class Car
extends BaseCar {
    private Sounds sounds;
    public boolean itemCollected = false;
    public int vwzgl;
    private int omegaValue = this.omega0;
    private int prevdamp;
    private int prevscF;
    private boolean turnleft = false;
    private boolean turnright = false;
    private boolean fwd = false;
    private boolean bkw = false;
    public boolean nitro = false;
    public int nitroSpeedTime;
    public int nitroTime;
    private int nitroUpgrade;
    public boolean oilSplash = false;
    public int oilSplashTime;
    public int oilTime;
    public int fuel = 10000;
    public boolean scrollMap = true;

    public Car(Sounds sounds, MapEngine engine, Image[] images) {
        super(engine, images);
        this.isPlayerCar = true;
        this.sounds = sounds;
    }

    public void initCar(int config, boolean kontynuacja) {
        this.setOriginalParameters(config);
        if (!kontynuacja) {
            CarInteraction.upgradeLevel[0] = 0;
            CarInteraction.upgradeLevel[1] = 0;
            CarInteraction.upgradeLevel[2] = 0;
        } else {
            this.setUpgradeParams(CarInteraction.upgradeLevel);
        }
    }

    private int getDamp(int turnSensitive) {
        return MathFP.div(MathFP.toFP(turnSensitive), MathFP.toFP(100));
    }

    public void setOriginalParameters(int config) {
        this.FP_MAX_SC_F = FinalData.FP_SC_F_FINAL;
        this.damp0 = MathFP.toFP("0.85");
        this.FP_MAX_VEL = MathFP.mul(MathFP.div(this.FP_MAX_SC_F, MathFP.sub(MathFP.toFP(1), this.damp0)), MathFP.div(FinalData.FP_dt, this.m));
        if (config == 1 || config == 2) {
            int speed0 = FinalData.CARS_SPEED[0];
            for (int i = 1; i < 3; ++i) {
                if (i != config) continue;
                this.damp0 = this.getDamp(FinalData.CARS_TURN_SENSITIVE[i]);
                int p0 = MathFP.sub(MathFP.toFP(1), this.damp0);
                int p1 = MathFP.div(FinalData.CARS_SPEED[i], speed0);
                int p2 = MathFP.mul(this.FP_MAX_VEL, MathFP.div(this.m, FinalData.FP_dt));
                this.FP_MAX_SC_F = MathFP.mul(MathFP.mul(p0, p1), p2);
                this.FP_MAX_VEL = MathFP.mul(MathFP.div(this.FP_MAX_SC_F, MathFP.sub(MathFP.toFP(1), this.damp0)), MathFP.div(FinalData.FP_dt, this.m));
            }
        }
        this.FP_MAX_DELTA_SC_F = MathFP.mul(this.FP_MAX_SC_F, MathFP.toFP("0.1"));
        this.FP_PAR_VSCF = MathFP.div(this.FP_MAX_DELTA_SC_F, this.FP_MAX_VEL);
        this.nitroTime = this.nitroSpeedTime = 50;
        this.nitroUpgrade = MathFP.toFP(10);
        this.oilTime = this.oilSplashTime = 20;
    }

    public void reset() {
        this.fuel = 10000;
        this.scF = this.FP_MAX_SC_F;
        this.damp = this.damp0;
        this.setMaxParameters(this.FP_MAX_SC_F, this.damp0);
        this.setMotionParameters();
        this.vel.setToFP(0, 0);
        this.setNormals();
        this.setCorners();
        if (this.nitro) {
            this.setNitroOff();
        }
        if (this.oilSplash) {
            this.setOilSplashOff();
        }
        this.gfxCurrCP = 0;
        this.gfxPrevCP = 0;
        this.gfxNextCP = 1;
        this.bkwbool = false;
        this.przejsciowka = false;
        this.racePosCP = 1;
        this.lapsCounterFlag = 0;
        this.lap = 1;
    }

    public void setUpgradeParams(byte[] upgradeLevel) {
        if (upgradeLevel[0] > 0) {
            this.FP_MAX_SC_F += upgradeLevel[0] * MathFP.toFP(5);
        }
        if (upgradeLevel[1] > 0) {
            this.nitroUpgrade += upgradeLevel[1] * MathFP.toFP(5);
        }
        if (upgradeLevel[2] > 0) {
            int sc = MathFP.toFP("1.5");
            for (int i = 0; i < upgradeLevel[2]; ++i) {
                this.damp0 = MathFP.toFP(1) - MathFP.mul(sc, MathFP.sub(MathFP.toFP(1), this.damp0));
                this.FP_MAX_SC_F = MathFP.mul(sc, this.FP_MAX_SC_F);
            }
        }
        this.setMaxParameters(this.FP_MAX_SC_F, this.damp0);
        this.setMotionParameters();
    }

    public void stepControl() {
        if (this.fwd) {
            this.setMotionParameters();
            this.scF += this.deltaScFWDvalue;
        } else if (this.bkw) {
            this.setMotionParameters();
            this.scF -= this.deltaScBKWvalue;
        }
        if (this.oilSplash) {
            if (this.oilTime <= 0) {
                this.setOilSplashOff();
            } else {
                --this.oilTime;
            }
        }
        if (this.turnleft) {
            this.omega = -this.omegaValue;
        } else if (this.turnright) {
            this.omega = this.omegaValue;
        }
        if (this.fuel > 0) {
            this.fuel -= MathFP.toInt(MathFP.div(this.v, MathFP.toFP(5)));
        }
        if (this.nitro) {
            if (this.nitroTime <= 0) {
                this.setNitroOff();
            } else {
                --this.nitroTime;
            }
        }
    }

    public void evaluateVelocity() {
        if (MathFP.abs(this.scF) > this.FP_MAX_SC_F) {
            this.scF = this.FP_MAX_SC_F;
        }
        if (this.collision) {
            this.decreaseOmegaAfterCollision();
        }
        this.evaluateScaledForceVelEulerFP(FinalData.FP_dt, this.scF, this.damp);
        this.v = this.vel.lengthFP();
        this.vwzgl = MathFP.mul(MathFP.toFP(10), MathFP.div(this.v, this.FP_MAX_VEL));
    }

    public void evaluatePositionRotation() {
        this.evaluatePosEulerFP(FinalData.FP_dt);
        this.evaluateRotationAngleFP(FinalData.FP_dt);
        this.pickClosestAlfaSettingForceDirection();
        this.setCorners();
        for (int i = 0; i < this.cornerFP.length; ++i) {
            this.cornerInt[i][0] = MathFP.toInt(this.cornerFP[i].x);
            this.cornerInt[i][1] = MathFP.toInt(MathFP.mul(this.cornerFP[i].y, FinalData.FP_CAM_HEIGHT));
        }
        this.sprite.x = MathFP.toInt(this.pos.x);
        this.sprite.y = MathFP.toInt(MathFP.mul(FinalData.FP_CAM_HEIGHT, this.pos.y));
    }

    private void setOmegaValue() {
        this.omegaValue = this.vel.dotFP(this.fnormal) < 0 ? MathFP.mul(MathFP.div(MathFP.mul(this.scF, MathFP.toFP("2.2")), this.FP_MAX_SC_F), this.omega0) : MathFP.mul(MathFP.div(MathFP.mul(this.scF, MathFP.toFP("1.8")), this.FP_MAX_SC_F), this.omega0);
    }

    private void setMotionParameters() {
        this.damp = MathFP.abs(this.scF) <= this.FP_MAX_SC_F ? MathFP.abs(MathFP.mul(MathFP.div(this.scF, this.FP_MAX_SC_F), this.damp0)) : this.damp0;
        if (this.vel.dotFP(this.fnormal) < 0) {
            if (MathFP.abs(this.scF) > MathFP.mul(this.FP_MAX_SC_F, MathFP.toFP("0.8"))) {
                this.deltaScBKWvalue = 0;
                this.deltaScFWDvalue = this.FP_MAX_DELTA_SC_F;
            } else {
                this.deltaScBKWvalue = this.FP_MAX_DELTA_SC_F;
            }
        } else if (this.scF <= this.FP_MAX_SC_F) {
            this.deltaScFWDvalue = MathFP.add(MathFP.mul(-this.FP_PAR_VSCF, this.v), this.FP_MAX_DELTA_SC_F);
            this.deltaScBKWvalue = MathFP.add(this.deltaScFWDvalue, MathFP.div(this.FP_MAX_DELTA_SC_F, MathFP.toFP(5)));
        } else {
            this.scF = this.FP_MAX_SC_F;
            this.deltaScFWDvalue = 0;
            this.deltaScBKWvalue = MathFP.div(this.scF, MathFP.toFP(5));
        }
        this.setOmegaValue();
    }

    public void pressedKey(int keyCode) {
        switch (keyCode) {
            case 1: {
                if (this.collision) {
                    this.restoreSteering();
                }
                if (this.oilSplash) break;
                this.setMotionParameters();
                this.fwd = true;
                this.bkw = false;
                break;
            }
            case 6: {
                if (this.collision) {
                    this.restoreSteering();
                }
                if (this.oilSplash) break;
                this.setMotionParameters();
                this.bkw = true;
                this.fwd = false;
                break;
            }
            case 2: {
                if (this.collision) {
                    this.restoreSteering();
                }
                if (!this.oilSplash) {
                    this.setOmegaValue();
                }
                this.omega = -this.omegaValue;
                this.turnleft = true;
                this.turnright = false;
                break;
            }
            case 5: {
                if (this.collision) {
                    this.restoreSteering();
                }
                if (!this.oilSplash) {
                    this.setOmegaValue();
                }
                this.omega = this.omegaValue;
                this.turnleft = false;
                this.turnright = true;
            }
        }
    }

    public void releasedKey(int gameKeyCode) {
        switch (gameKeyCode) {
            case 1: {
                this.fwd = false;
                break;
            }
            case 6: {
                this.bkw = false;
                break;
            }
            case 2: {
                this.omega = 0;
                this.turnleft = false;
                break;
            }
            case 5: {
                this.omega = 0;
                this.turnright = false;
            }
        }
    }

    private void restoreSteering() {
        this.scF = this.prevscF;
        this.damp = this.prevdamp;
        this.collision = false;
    }

    public void setParamsAfterCollision() {
        if (this.vel.dotFP(this.fnormal) > 0) {
            if (!this.collision && !this.oilSplash) {
                this.prevdamp = this.damp;
                this.prevscF = this.scF;
            }
            if (!this.fwd) {
                this.damp = MathFP.toFP("0.9");
                this.scF = MathFP.mul(MathFP.div(this.m, FinalData.FP_dt), MathFP.mul(this.v, MathFP.sub(MathFP.toFP(1), this.damp)));
            }
        }
    }

    private void integrateEquationOfMotion() {
    }

    public void turnOff() {
        this.scF = 0;
        this.vel.setFP(0, 0);
    }

    public void gasUp(int count) {
        this.fuel += count;
        if (this.fuel > 10000) {
            this.fuel = 10000;
        }
    }

    public void setNitroOn() {
        if (this.oilSplash) {
            this.setOilSplashOff();
        }
        if (this.collision) {
            this.restoreSteering();
        }
        this.nitro = true;
        this.vel.scaleFP(MathFP.div(this.FP_MAX_VEL, this.v));
        this.vel.scaleFP(MathFP.toFP("1.5"));
        this.scF = this.FP_MAX_SC_F = MathFP.add(this.FP_MAX_SC_F, this.nitroUpgrade);
        this.damp = this.damp0;
        if (this.fwd) {
            this.fwd = false;
        }
    }

    public void setNitroOff() {
        this.nitro = false;
        this.scF = this.FP_MAX_SC_F = MathFP.sub(this.FP_MAX_SC_F, this.nitroUpgrade);
        this.nitroTime = this.nitroSpeedTime;
    }

    public void setOilSplashOn() {
        if (this.nitro) {
            this.setNitroOff();
        }
        if (this.collision) {
            this.restoreSteering();
        }
        if (!this.oilSplash) {
            this.oilTime = this.oilSplashTime;
            this.prevdamp = this.damp;
            this.prevscF = this.scF;
        }
        if (!this.fwd && !this.bkw) {
            this.damp = MathFP.toFP(1);
            this.scF = 0;
        } else {
            this.fwd = false;
            this.bkw = false;
            this.damp = MathFP.toFP(1);
            this.scF = 0;
        }
        this.oilSplash = true;
    }

    public void setOilSplashOff() {
        this.oilSplash = false;
        this.scF = this.prevscF;
        this.damp = this.prevdamp;
        this.oilTime = this.oilSplashTime;
    }
}

