/*
 * Decompiled with CFR 0.152.
 */
package game.car;

import body.interaction.Collision;
import body.interaction.Contact;
import body.interaction.ProjectionCuboidCuboid;
import body.interaction.ProjectionCuboidCylinder;
import game.FinalData;
import game.IsoRace;
import game.MapEngine;
import game.car.BaseCar;
import game.car.Car;
import game.car.Cone;
import game.car.OpponentCar;
import game.car.WallCubic;
import maths.Vector2d;
import net.jscience.math.kvm.MathFP;
import utils.Sounds;

public class CarInteraction {
    private Sounds sounds;
    public static byte[] upgradeLevel = new byte[]{0, 0, 0};
    public static int playerScore;
    public static int playerCash;
    public static int cash;
    public int[] cashPerTrack = new int[]{6, 5, 6, 5, 5, 5, 5, 5, 4, 4};
    public int lapOnTrack;
    public char[] lapsOnTrack;
    public int roadSign;
    public int roadSignTime;
    public int roadSignsIndex;
    public int[] roadSignsType;
    public static byte collisionNoWayPoint;
    private int e = MathFP.toFP("1.0");
    private WallCubic wallCubic;
    private Collision coll;
    private ProjectionCuboidCuboid ccProjection;
    private ProjectionCuboidCylinder cpProjection;
    private Contact[] ccCt;
    private Contact cpCt;
    private boolean oilSplash = false;
    int oilCounter = 0;
    int coneInteractionCounter = 0;

    public CarInteraction(Sounds sounds) {
        this.sounds = sounds;
        this.coll = new Collision();
        this.ccProjection = new ProjectionCuboidCuboid();
        this.cpProjection = new ProjectionCuboidCylinder();
        this.ccCt = new Contact[2];
        this.cpCt = new Contact();
        for (int i = 0; i < this.ccCt.length; ++i) {
            this.ccCt[i] = new Contact();
        }
        this.wallCubic = new WallCubic();
    }

    private void collideWithTileCoveredByCenter(MapEngine mapEngine, WallCubic wall, BaseCar car, int xTile, int yTile) {
        int maskValue = mapEngine.getTileMaskValueByTile(xTile, yTile);
        if (maskValue == 43 || maskValue > 64) {
            wall.setPos(xTile, yTile, FinalData.TILE_WIDTH);
            int[] consN = new int[2];
            Vector2d vec = new Vector2d();
            Vector2d velVec = new Vector2d();
            vec.setSubFP(car.pos, wall.pos);
            int nr = this.getInitCollNormal(1000, wall, car, vec, consN, true);
            if (this.checkTilePointedByNormal(nr, xTile, yTile, mapEngine)) {
                nr = nr == consN[0] ? consN[1] : consN[0];
            }
            this.moveCenterBack(car, wall, nr, velVec);
        }
    }

    private void collideWithTileCoveredByCorner(int i, MapEngine mapEngine, WallCubic wall, BaseCar car, int xTile, int yTile) {
        int maskValue;
        car.maskValue[i] = maskValue = mapEngine.getTileMaskValueByTile(xTile, yTile);
        wall.setPos(xTile, yTile, FinalData.TILE_WIDTH);
        if (car.isPlayerCar) {
            car.surrPT[i][0] = MathFP.toInt(wall.pos.x);
            car.surrPT[i][1] = MathFP.toInt(MathFP.mul(wall.pos.y, FinalData.FP_CAM_HEIGHT));
            this.collectItemEvent(maskValue, mapEngine, (Car)car, xTile, yTile);
            this.obstacleInteractionEvent(maskValue, mapEngine, (Car)car, xTile, yTile);
        }
        if (maskValue == 43 || maskValue > 64) {
            car.unwalkBool[i] = true;
            int[] consN = new int[2];
            Vector2d vec = new Vector2d();
            Vector2d velVec = new Vector2d();
            vec.setSubFP(car.cornerFP[i], wall.pos);
            int nr = this.getInitCollNormal(i, wall, car, vec, consN, false);
            if (this.checkTilePointedByNormal(nr, xTile, yTile, mapEngine)) {
                nr = nr == consN[0] ? consN[1] : consN[0];
            }
            this.moveBack(nr, car, wall, vec, velVec);
        } else {
            car.unwalkBool[i] = false;
        }
    }

    private boolean checkTilePointedByNormal(int nr, int xTile, int yTile, MapEngine mapEngine) {
        int[] tilePos = new int[2];
        if (yTile % 2 == 0) {
            switch (nr) {
                case 0: {
                    tilePos[0] = xTile;
                    tilePos[1] = yTile + 1;
                    break;
                }
                case 1: {
                    tilePos[0] = xTile;
                    tilePos[1] = yTile - 1;
                    break;
                }
                case 2: {
                    tilePos[0] = xTile - 1;
                    tilePos[1] = yTile + 1;
                    break;
                }
                case 3: {
                    tilePos[0] = xTile - 1;
                    tilePos[1] = yTile - 1;
                }
            }
        } else if (yTile % 2 == 1) {
            switch (nr) {
                case 0: {
                    tilePos[0] = xTile + 1;
                    tilePos[1] = yTile + 1;
                    break;
                }
                case 1: {
                    tilePos[0] = xTile + 1;
                    tilePos[1] = yTile - 1;
                    break;
                }
                case 2: {
                    tilePos[0] = xTile;
                    tilePos[1] = yTile + 1;
                    break;
                }
                case 3: {
                    tilePos[0] = xTile;
                    tilePos[1] = yTile - 1;
                }
            }
        }
        int maskValue = mapEngine.getTileMaskValueByTile(tilePos[0], tilePos[1]);
        return maskValue == 43 || maskValue > 64;
    }

    private int getInitCollNormal(int i, WallCubic wall, BaseCar car, Vector2d r, int[] consN, boolean center) {
        int y;
        int x;
        int nr = 0;
        if (center) {
            x = car.pos.x;
            y = car.pos.y;
        } else {
            x = car.cornerFP[i].x;
            y = car.cornerFP[i].y;
        }
        for (int j = 0; j < 2; ++j) {
            consN[j] = r.dotFP(wall.n[j]) >= 0 ? j : 3 - j;
        }
        if (wall.pos.x < x && wall.pos.y < y) {
            nr = 0;
        } else if (wall.pos.x < x && wall.pos.y > y) {
            nr = 1;
        } else if (wall.pos.x > x && wall.pos.y < y) {
            nr = 2;
        } else if (wall.pos.x > x && wall.pos.y > y) {
            nr = 3;
        }
        return nr;
    }

    private void moveBack(int nr, BaseCar car, WallCubic wall, Vector2d vec, Vector2d velVec) {
        int dot = vec.dotFP(wall.n[nr]);
        car.pos.add(wall.n[nr].scaleVecFP(MathFP.sub(FinalData.FP_TILE_HALF_SIDE, dot)));
        velVec.setScaleFP(car.vel.dotFP(wall.n[nr]), wall.n[nr]);
        car.vel.sub(velVec);
    }

    private void moveCenterBack(BaseCar car, WallCubic wall, int nr, Vector2d velVec) {
        car.pos.add(wall.n[nr].scaleVecFP(FinalData.FP_TILE_HALF_SIDE));
        velVec.setScaleFP(car.vel.dotFP(wall.n[nr]), wall.n[nr]);
        car.vel.sub(velVec);
    }

    public void checkCarCollisionWithMap(MapEngine mapEngine, Car car) {
        int i;
        collisionNoWayPoint = 0;
        this.oilSplash = false;
        int[] coords = MapEngine.getTilePositionFromFP(car.pos);
        this.centerSensorEvent(car, mapEngine, coords[0], coords[1]);
        car.setTileX(coords[0]);
        car.setTileY(coords[1]);
        this.collideWithTileCoveredByCenter(mapEngine, this.wallCubic, car, coords[0], coords[1]);
        if (this.checkPossibleCollisionWithMapEdges(car)) {
            for (i = 0; i < car.cornerInt.length; ++i) {
                this.checkCornerCollisionWithMapEdges(i, car);
            }
        }
        for (i = 0; i < car.cornerInt.length; ++i) {
            coords = MapEngine.getTilePositionFromFP(car.cornerFP[i]);
            this.collideWithTileCoveredByCorner(i, mapEngine, this.wallCubic, car, coords[0], coords[1]);
        }
        if (this.oilSplash && !car.oilSplash) {
            car.setOilSplashOn();
        }
    }

    private boolean checkPossibleCollisionWithMapEdges(BaseCar car) {
        return car.pos.x < FinalData.FP_TILE_WIDTH + car.surrRectHalfSide || car.pos.y < FinalData.FP_TILE_WIDTH + car.surrRectHalfSide || car.pos.x > MapEngine.FPboardSpaceWidth - FinalData.FP_TILE_WIDTH - car.surrRectHalfSide || car.pos.y > MapEngine.FPboardSpaceHeight - FinalData.FP_TILE_WIDTH - car.surrRectHalfSide;
    }

    private void checkCornerCollisionWithMapEdges(int i, BaseCar car) {
        if (car.cornerFP[i].x < FinalData.FP_TILE_WIDTH) {
            int dr = FinalData.FP_TILE_WIDTH - car.cornerFP[i].x;
            car.pos.x += dr;
            car.vel.x = 0;
        } else if (car.cornerFP[i].y < FinalData.FP_TILE_WIDTH) {
            int dr = FinalData.FP_TILE_WIDTH - car.cornerFP[i].y;
            car.pos.y += dr;
            car.vel.y = 0;
        } else if (car.cornerFP[i].x > MapEngine.FPboardSpaceWidth - FinalData.FP_TILE_WIDTH) {
            int dr = car.cornerFP[i].x - MapEngine.FPboardSpaceWidth + FinalData.FP_TILE_WIDTH;
            car.pos.x -= dr;
            car.vel.x = 0;
        } else if (car.cornerFP[i].y > MapEngine.FPboardSpaceHeight - FinalData.FP_TILE_WIDTH) {
            int dr = car.cornerFP[i].y - MapEngine.FPboardSpaceHeight + FinalData.FP_TILE_WIDTH;
            car.pos.y -= dr;
            car.vel.y = 0;
        }
    }

    public void checkOpponentCarCollisionWithMap(MapEngine mapEngine, OpponentCar oppCar) {
        int i;
        int[] coords = MapEngine.getTilePositionFromFP(oppCar.pos);
        this.collideWithTileCoveredByCenter(mapEngine, this.wallCubic, oppCar, coords[0], coords[1]);
        if (this.checkPossibleCollisionWithMapEdges(oppCar)) {
            for (i = 0; i < oppCar.cornerInt.length; ++i) {
                this.checkCornerCollisionWithMapEdges(i, oppCar);
            }
        }
        for (i = 0; i < oppCar.cornerInt.length; ++i) {
            coords = MapEngine.getTilePositionFromFP(oppCar.cornerFP[i]);
            this.collideWithTileCoveredByCorner(i, mapEngine, this.wallCubic, oppCar, coords[0], coords[1]);
        }
    }

    private void centerSensorEvent(Car playerCar, MapEngine mapEngine, int xTile, int yTile) {
        int maskValue = mapEngine.getTileMaskValueByTile(xTile, yTile);
        this.collectItemEvent(maskValue, mapEngine, playerCar, xTile, yTile);
        this.obstacleInteractionEvent(maskValue, mapEngine, playerCar, xTile, yTile);
        switch (maskValue) {
            case 8: {
                playerCar.switchLapNo(maskValue);
                if (playerCar.lap > this.lapOnTrack) break;
                this.lapsOnTrack = ("" + playerCar.lap).toCharArray();
                break;
            }
            case 9: {
                playerCar.switchLapNo(maskValue);
                break;
            }
            case 10: {
                playerCar.switchLapNo(maskValue);
                break;
            }
            case 40: {
                this.roadSign = 1;
                this.roadSignTime = 10;
                this.roadSignsIndex = 0;
                break;
            }
            case 41: {
                this.roadSign = 2;
                this.roadSignTime = 10;
                this.roadSignsIndex = 1;
                break;
            }
        }
    }

    private void obstacleInteractionEvent(int maskValue, MapEngine mapEngine, Car playerCar, int xTile, int yTile) {
        switch (maskValue) {
            case 7: {
                break;
            }
            case 42: {
                break;
            }
            case 5: {
                ++this.oilCounter;
                this.oilSplash = true;
            }
        }
    }

    private void collectItemEvent(int maskValue, MapEngine mapEngine, Car playerCar, int xTile, int yTile) {
        switch (maskValue) {
            case 2: {
                if (playerCar.nitro) break;
                if (IsoRace.cfg_sound) {
                    this.sounds.playItemSound();
                }
                mapEngine.clearMaskValue(xTile, yTile);
                playerCar.setNitroOn();
                playerCar.itemCollected = true;
                break;
            }
            case 3: {
                if (playerCar.fuel >= 8000) break;
                if (IsoRace.cfg_sound) {
                    this.sounds.playItemSound();
                }
                mapEngine.clearMaskValue(xTile, yTile);
                playerCar.gasUp(2000);
                playerCar.itemCollected = true;
                break;
            }
            case 4: {
                if (IsoRace.cfg_sound) {
                    this.sounds.playItemSound();
                }
                mapEngine.clearMaskValue(xTile, yTile);
                cash += 100;
                playerCar.itemCollected = true;
            }
        }
    }

    public void checkCarsCollisionWithCones(Car playerCar, Cone[] cone) {
        for (int i = 0; i < cone.length; ++i) {
            if (!this.cpProjection.checkIfSurroundingRectsColliding(playerCar, cone[i])) continue;
            this.cpProjection.setContact(this.cpCt, playerCar, cone[i], 0);
            if (!this.cpProjection.checkIfColliding(this.cpCt, FinalData.FP_dt)) continue;
            ++this.coneInteractionCounter;
            this.coll.halfRigidBodyCollisionProcedure(this.cpCt, this.e);
        }
    }

    public void checkCarsCollision(Car playerCar, OpponentCar[] oppCar) {
        int i;
        for (i = 0; i < oppCar.length; ++i) {
            if (!this.ccProjection.checkIfSurroundingRectsColliding(playerCar, oppCar[i])) continue;
            this.ccProjection.setContacts(this.ccCt, playerCar, oppCar[i], 0);
            for (int k = 0; k < this.ccCt.length; ++k) {
                if (!this.ccProjection.checkIfColliding(this.ccCt[k], FinalData.FP_dt)) continue;
                playerCar.setParamsAfterCollision();
                this.coll.rigidBodiesCollisionProcedure(this.ccCt[k], this.e);
                playerCar.setCollision(true);
                oppCar[i].setCollision(true);
            }
        }
        for (i = 0; i < oppCar.length; ++i) {
            for (int j = i + 1; j < oppCar.length; ++j) {
                if (!this.ccProjection.checkIfSurroundingRectsColliding(oppCar[i], oppCar[j])) continue;
                this.ccProjection.setContacts(this.ccCt, oppCar[i], oppCar[j], 0);
                for (int k = 0; k < this.ccCt.length; ++k) {
                    if (!this.ccProjection.checkIfColliding(this.ccCt[k], FinalData.FP_dt)) continue;
                    this.coll.rigidBodiesCollisionProcedure(this.ccCt[k], this.e);
                    oppCar[i].setCollision(true);
                    oppCar[j].setCollision(true);
                }
            }
        }
    }

    static {
        collisionNoWayPoint = 0;
    }
}

