/*
 * Decompiled with CFR 0.152.
 */
package game.car;

import body.Cylinder;
import game.FinalData;
import game.MapCharacter;
import game.MapEngine;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.jscience.math.kvm.MathFP;
import utils.SpriteGame;

public class Cone
extends Cylinder
implements MapCharacter {
    public SpriteGame sprite;
    private int radiusFP;
    private int[] coords;
    private int tilePositionX = 0;
    private int tilePositionY = 0;
    private int damp = MathFP.toFP("0.95");

    public Cone(Image image, int radiusFP) {
        super(radiusFP);
        this.radiusFP = radiusFP;
        this.sprite = new SpriteGame(image);
    }

    public void evaluateVelocity() {
        this.evaluateVelEulerFP(FinalData.FP_dt, this.damp);
    }

    public void evaluatePosition() {
        this.evaluatePosEulerFP(FinalData.FP_dt);
        this.sprite.x = MathFP.toInt(this.pos.x);
        this.sprite.y = MathFP.toInt(MathFP.mul(FinalData.FP_CAM_HEIGHT, this.pos.y));
        this.coords = MapEngine.getTilePositionFromFP(this.pos);
        this.setTileX(this.coords[0]);
        this.setTileY(this.coords[1]);
    }

    public void integrateEquationOfMotion() {
    }

    public void draw(Graphics g) {
        this.sprite.paintCone(g, 0, this.sprite.x - MapEngine.ptAnchorViewX, this.sprite.y - MapEngine.ptAnchorViewY);
    }

    public int getTileX() {
        return this.tilePositionX;
    }

    public int getTileY() {
        return this.tilePositionY;
    }

    public void setTileX(int x) {
        this.tilePositionX = x;
    }

    public void setTileY(int y) {
        this.tilePositionY = y;
    }
}

