/*
 * Decompiled with CFR 0.152.
 */
package maths;

import net.jscience.math.kvm.MathFP;

public class LUfactor {
    private int n;
    private int[][] muFP;
    private int[] bnewFP;
    private int[] xFP;

    private void init(int n) {
        this.muFP = new int[n][n];
        this.bnewFP = new int[n];
    }

    private void computeUpperTriangular(int[][] matFP, int[] bFP, int n) {
        int j;
        int i;
        int zFP = MathFP.toFP(0);
        for (i = 0; i < n; ++i) {
            this.bnewFP[i] = -bFP[i];
            for (j = 0; j < n; ++j) {
                this.muFP[i][j] = matFP[i][j];
            }
        }
        for (i = 0; i < n - 1; ++i) {
            for (j = i + 1; j < n; ++j) {
                zFP = this.muFP[j][i];
                this.bnewFP[j] = this.bnewFP[j] - MathFP.div(MathFP.mul(this.bnewFP[i], this.muFP[j][i]), this.muFP[i][i]);
                for (int k = i; k < n; ++k) {
                    this.muFP[j][k] = this.muFP[j][k] - MathFP.mul(this.muFP[i][k], MathFP.div(zFP, this.muFP[i][i]));
                }
            }
        }
    }

    private void computeX(int[][] mFP, int[] bnewFP, int[] xFP) {
        xFP[this.n - 1] = MathFP.div(bnewFP[this.n - 1], mFP[this.n - 1][this.n - 1]);
        int SumaPoJFP = MathFP.toFP(0);
        for (int i = 1; i < this.n; ++i) {
            for (int j = this.n - i; j < this.n; ++j) {
                SumaPoJFP -= MathFP.div(mFP[this.n - 1 - i][j], xFP[j]);
            }
            xFP[this.n - 1 - i] = MathFP.div(MathFP.sub(bnewFP[this.n - 1 - i], SumaPoJFP), mFP[this.n - 1 - i][this.n - 1 - i]);
            SumaPoJFP = MathFP.toFP(0);
        }
    }

    public void solve(int[][] aFP, int[] bFP, int[] xFP) {
        this.n = xFP.length;
        this.init(this.n);
        this.computeUpperTriangular(aFP, bFP, this.n);
        this.computeX(this.muFP, this.bnewFP, xFP);
    }
}

