/*
 * Decompiled with CFR 0.152.
 */
package utils;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CustomFont {
    private byte[] characterSizes = null;
    public int heightFont;
    public int width;
    private Image image;
    private String templateStr;
    private int charInLines = 0;
    private int spaceWidth = 0;
    public boolean isMonospace = false;

    public static CustomFont getFont(Image img, String template, int charInLines, int lang) {
        return new CustomFont(img, template, charInLines, lang);
    }

    public static CustomFont getFont(String filename, String template, int charInLines, int lang) {
        Image img;
        try {
            img = Image.createImage((String)filename);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException("Could not locate font: " + filename + " : " + t);
        }
        return new CustomFont(img, template, charInLines, lang);
    }

    private CustomFont(Image inImage, String template, int charInLines, int lang) {
        this.image = inImage;
        this.templateStr = template;
        try {
            this.charInLines = charInLines;
            this.width = this.image.getWidth() / charInLines;
            this.spaceWidth = this.width / 2;
            int liczbaWierszy = template.length() / charInLines;
            if (template.length() % charInLines != 0) {
                ++liczbaWierszy;
            }
            this.heightFont = this.image.getHeight() / liczbaWierszy;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException("Specified font is invalid: " + t);
        }
    }

    public int stringWidth(char[] chars) {
        int w = 0;
        if (this.isMonospace) {
            return (chars.length - 1) * this.width;
        }
        for (int z = chars.length - 1; z >= 0; --z) {
            if (chars[z] == ' ') {
                w += this.spaceWidth;
                continue;
            }
            int charIndex = this.templateStr.indexOf(chars[z]);
            w += this.characterSizes[charIndex];
        }
        return w;
    }

    public int charSize(char c) {
        int charIndex = this.templateStr.indexOf(c);
        return this.characterSizes[charIndex];
    }

    public int drawString(Graphics g, char[] data, int x, int y, int anchor) {
        int startX = 0;
        if ((anchor & 8) != 0) {
            x -= this.stringWidth(data);
        } else if ((anchor & 1) != 0) {
            x -= this.stringWidth(data) / 2;
        }
        startX = x;
        if ((anchor & 0x20) != 0) {
            y -= this.heightFont;
        } else if ((anchor & 2) != 0) {
            y -= this.heightFont / 2;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int charIndex = -1;
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            if (c == ' ') {
                x += this.spaceWidth;
                continue;
            }
            charIndex = this.templateStr.indexOf(c);
            g.setClip(x, y, this.width, this.heightFont);
            if (charIndex >= this.charInLines) {
                g.drawImage(this.image, x - this.width * (charIndex % this.charInLines), y - charIndex / this.charInLines * this.heightFont, 20);
            } else {
                g.drawImage(this.image, x - this.width * charIndex, y, 20);
            }
            if (this.isMonospace) {
                x += this.width;
                continue;
            }
            try {
                x += this.characterSizes[charIndex];
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        g.setClip(clipX, clipY, clipW, clipH);
        return startX;
    }

    public void setCharacterSizes(byte[] characterSizes) {
        this.characterSizes = characterSizes;
    }
}

