/*
 * Decompiled with CFR 0.152.
 */
package utils;

import game.FinalData;
import game.FinalFonts;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class ImageSet {
    public static boolean gameImagesLoaded = false;
    public static boolean menuImagesLoaded = false;
    public static Hashtable menuFontsImages = new Hashtable();
    public static Hashtable menuImages = new Hashtable();
    public static Hashtable gameImages = new Hashtable();
    public static Image[][] carsImages = new Image[4][17];

    public static final Image loadImage(String path) throws IOException {
        try {
            return Image.createImage((String)path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void addMenuFontImageToMap(String path) throws IOException {
        if (!menuFontsImages.containsKey(path)) {
            menuFontsImages.put(path, ImageSet.loadImage(path));
        }
    }

    public static final void addMenuImageToMap(String path) throws IOException {
        if (!menuImages.containsKey(path)) {
            menuImages.put(path, ImageSet.loadImage(path));
        }
    }

    public static final void addGameImageToMap(String path) throws IOException {
        if (!gameImages.containsKey(path)) {
            gameImages.put(path, ImageSet.loadImage(path));
        }
    }

    public static final void addMenuFontImageToMap(String key, String path) throws IOException {
        if (!menuFontsImages.containsKey(key)) {
            menuFontsImages.put(key, ImageSet.loadImage(path));
        }
    }

    public static final void addMenuImageToMap(String key, String path) throws IOException {
        if (!menuImages.containsKey(key)) {
            menuImages.put(key, ImageSet.loadImage(path));
        }
    }

    public static final void addGameImageToMap(String key, String path) throws IOException {
        if (!gameImages.containsKey(key)) {
            gameImages.put(key, ImageSet.loadImage(path));
        }
    }

    public static final Image getMenuFontImage(String key) {
        return (Image)menuFontsImages.get(key);
    }

    public static final Image getMenuImage(String key) {
        return (Image)menuImages.get(key);
    }

    public static final Image getGameImage(String key) {
        return (Image)gameImages.get(key);
    }

    public static final void removeMenuImageFromMap(String key) {
        menuImages.remove(key);
    }

    public static final void removeGameImageFromMap(String key) {
        gameImages.remove(key);
    }

    public static final void removeMenuFontImageFromMap(String key) {
        menuFontsImages.remove(key);
    }

    public static final Image getImageRegion(Image source, int x, int y, int width, int height) {
        Image result = Image.createImage((int)width, (int)height);
        result.getGraphics().drawImage(source, -x, -y, 20);
        return result;
    }

    public static void clearGameImages() {
        gameImages.clear();
        gameImages = null;
        carsImages = null;
        System.gc();
    }

    public static void clearMenuImages() {
        menuImages.clear();
        menuImages = null;
        System.gc();
    }

    public static void clearMenuFonts() {
        menuFontsImages.clear();
    }

    public static final void loadCarsImages(String pathPrefix, int num, int frames) throws IOException {
        int i = 0;
        for (i = 0; i < frames; ++i) {
            ImageSet.carsImages[num][i] = ImageSet.loadImage(pathPrefix + "" + i + ".png");
        }
    }

    public static final Image[] getCarImages(int numOfCar) {
        return carsImages[numOfCar];
    }

    public static void loadGameImages() throws IOException {
        gameImages = new Hashtable();
        carsImages = new Image[4][17];
        System.out.println("****LOADING GAME IMAGES****");
        ImageSet.addGameImageToMap("/gameFonts/bigNum.png");
        ImageSet.addGameImageToMap("/gameFonts/smallNum.png");
        ImageSet.addGameImageToMap("/gameFonts/speedNum.png");
        ImageSet.addGameImageToMap("/txt_lap.png");
        ImageSet.addGameImageToMap("/txt_pos.png");
        ImageSet.addGameImageToMap("/txt_fuel.png");
        ImageSet.addGameImageToMap("/menu/smallarrows.png");
        ImageSet.addGameImageToMap("/fuel_speed_bar.png");
        ImageSet.addGameImageToMap("/fuel_speed_bar_BG.png");
        ImageSet.addGameImageToMap("/colectible_items.png");
        ImageSet.addGameImageToMap("/elements32.png");
        ImageSet.addGameImageToMap("/elements64.png");
        ImageSet.addGameImageToMap("/cone.png");
        ImageSet.addGameImageToMap("/peoples.png");
        ImageSet.addGameImageToMap("img_tree1", "/tree1_1.png");
        ImageSet.addGameImageToMap("img_tree2", "/tree2_1.png");
        ImageSet.addGameImageToMap("img_tree3", "/tree3_1.png");
        ImageSet.addGameImageToMap("/startpole_1.png");
        ImageSet.addGameImageToMap("/startLight_yellow.png");
        ImageSet.addGameImageToMap("/startLight_red.png");
        ImageSet.addGameImageToMap("/roadSigns.png");
        ImageSet.addGameImageToMap("/gfx/topline.png");
        for (int i = 0; i < FinalData.gfx.length; ++i) {
            ImageSet.addGameImageToMap(FinalData.gfx[i]);
        }
        ImageSet.loadCarsImages("/cars/gray/gray_", 0, 17);
        ImageSet.loadCarsImages("/cars/green/green_", 1, 17);
        ImageSet.loadCarsImages("/cars/red/red_", 2, 17);
        ImageSet.loadCarsImages("/cars/yellow/yellow_", 3, 17);
        ImageSet.addGameImageToMap(FinalData.img_backgroud);
        ImageSet.addGameImageToMap("/track_yellow.png");
        System.out.println("****GAME IMAGES LOADED****");
        System.gc();
    }

    public static void loadMenuImages(boolean fonts) throws IOException {
        menuImages = new Hashtable();
        System.out.println("****LOADING MENU IMAGES*******************");
        try {
            ImageSet.addMenuImageToMap(FinalData.img_splash);
            ImageSet.addMenuImageToMap(FinalData.img_backgroud);
            ImageSet.addMenuImageToMap("/menu/topbar.png");
            ImageSet.addMenuImageToMap("/menu/menu_font.png");
            ImageSet.addMenuImageToMap("/menu/smallarrows.png");
            ImageSet.addMenuImageToMap("/menu/selectbar.png");
            ImageSet.addMenuImageToMap("/menu/flames.png");
            ImageSet.addMenuImageToMap("/menu/line.png");
            ImageSet.addMenuImageToMap("/menu/powerbar.png");
            ImageSet.addMenuImageToMap("/menu/puchar.png");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ImageSet.addMenuImageToMap("/menu/select_arrows.png");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ImageSet.addMenuImageToMap("/menu/menu_yellowcar.png");
            ImageSet.addMenuImageToMap("/menu/menu_redcar.png");
            ImageSet.addMenuImageToMap("/menu/menu_greencar.png");
            ImageSet.addMenuImageToMap("/menu/menu_graycar.png");
            ImageSet.addMenuImageToMap("/menu/select_arrows.png");
            ImageSet.addMenuImageToMap("/track_yellow.png");
            ImageSet.addMenuImageToMap("/track_gray.png");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fonts) {
            try {
                FinalFonts.loadFonts();
                FinalFonts.initFonts();
            }
            catch (Exception e) {
                System.out.println("FONTY NIEZALOADOWANE");
                System.out.println("" + e.getMessage());
            }
        }
        System.out.println("****MENU IMAGES LOADED****************");
        System.gc();
    }

    public static void loadUpgradeScreenImages() throws IOException {
        menuImages = new Hashtable();
        ImageSet.addMenuImageToMap(FinalData.img_backgroud);
        ImageSet.addMenuImageToMap("/menu/topbar.png");
        ImageSet.addMenuImageToMap("/menu/selectbar.png");
        ImageSet.addMenuImageToMap("/menu/line.png");
        ImageSet.addMenuImageToMap("/menu/powerbar.png");
        ImageSet.addMenuImageToMap("/menu/menu_font.png");
        ImageSet.addMenuImageToMap("/menu/flames.png");
        ImageSet.addMenuImageToMap("/menu/select_arrows.png");
        for (int i = 0; i < FinalData.upg_parts.length; ++i) {
            ImageSet.addMenuImageToMap(FinalData.upg_parts[i]);
        }
    }
}

