/*
 * Decompiled with CFR 0.152.
 */
package utils;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteGame {
    private Image spriteImage;
    private Image[] spriteImages;
    public int x = 0;
    public int y = 0;
    private int currentFrame = 0;
    protected int widthFrame;
    protected int heightFrame;
    protected int anchor = 20;
    protected int[] framesSequence = null;
    protected int sequenceIndex = 0;
    protected int totalFrames = 0;
    protected long timePerFrame = 0L;
    protected boolean horizontalOrientation = true;
    private long lastFrameChange = 0L;

    public void clearSpriteImages() {
        this.spriteImages = null;
        this.spriteImage = null;
    }

    public SpriteGame(Image spriteImage) {
        this.spriteImage = spriteImage;
        this.widthFrame = spriteImage.getWidth();
        this.heightFrame = spriteImage.getHeight();
    }

    public SpriteGame(Image spriteImage, int fWidth, int fHeight) {
        this.spriteImage = spriteImage;
        this.widthFrame = fWidth;
        this.heightFrame = fHeight;
        if (fWidth == spriteImage.getWidth()) {
            this.totalFrames = spriteImage.getHeight() / fHeight;
            this.horizontalOrientation = false;
        } else if (fHeight == spriteImage.getHeight()) {
            this.totalFrames = spriteImage.getWidth() / fWidth;
            this.horizontalOrientation = true;
        } else {
            throw new IllegalStateException("Wrong sprite image size.");
        }
        this.framesSequence = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        this.sequenceIndex = 0;
    }

    public SpriteGame(Image[] images) {
        this.spriteImages = images;
        this.framesSequence = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        this.sequenceIndex = 0;
    }

    public void paint(Graphics g) {
        if (this.spriteImages != null) {
            g.drawImage(this.spriteImages[this.currentFrame], this.x / 1000, this.y / 1000, this.anchor);
        } else {
            int cx = g.getClipX();
            int cy = g.getClipY();
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            int xDrawCorner = this.transformX(this.x, this.anchor);
            int yDrawCorner = this.transformY(this.y, this.anchor);
            g.setClip(xDrawCorner, yDrawCorner, this.widthFrame, this.heightFrame);
            if (this.currentFrame != 3) {
                g.drawRegion(this.spriteImage, this.currentFrame * this.widthFrame, 0, this.widthFrame, this.heightFrame, 0, xDrawCorner, yDrawCorner, 20);
            } else {
                g.drawRegion(this.spriteImage, 2 * this.widthFrame, 0, this.widthFrame, this.heightFrame, 0, xDrawCorner, yDrawCorner, 20);
            }
            g.setClip(cx, cy, cw, ch);
        }
    }

    public void paint(Graphics g, int spriteTransform) {
        int xDrawCorner = this.transformX(this.x, this.anchor);
        int yDrawCorner = this.transformY(this.y, this.anchor);
        if (this.spriteImages != null) {
            this.widthFrame = this.spriteImages[this.currentFrame].getWidth();
            this.heightFrame = this.spriteImages[this.currentFrame].getHeight();
            g.drawRegion(this.spriteImages[this.currentFrame], 0, 0, this.widthFrame, this.heightFrame, spriteTransform, xDrawCorner, yDrawCorner, 20);
        } else {
            int cx = g.getClipX();
            int cy = g.getClipY();
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            g.setClip(xDrawCorner, yDrawCorner, this.widthFrame, this.heightFrame);
            g.drawRegion(this.spriteImage, this.currentFrame * this.widthFrame, 0, this.widthFrame, this.heightFrame, spriteTransform, xDrawCorner, yDrawCorner, 20);
            g.setClip(cx, cy, cw, ch);
        }
    }

    public void paintOppCar(Graphics g, int spriteTransform, int xPos, int yPos, int lap, int cp) {
        int xDrawCorner = this.transformX(xPos, this.anchor);
        int yDrawCorner = this.transformY(yPos, this.anchor);
        this.widthFrame = this.spriteImages[this.currentFrame].getWidth();
        this.heightFrame = this.spriteImages[this.currentFrame].getHeight();
        g.drawRegion(this.spriteImages[this.currentFrame], 0, 0, this.widthFrame, this.heightFrame, spriteTransform, xDrawCorner, yDrawCorner, 3);
    }

    public void paintCone(Graphics g, int spriteTransform, int xPos, int yPos) {
        int xDrawCorner = this.transformX(xPos, this.anchor);
        int yDrawCorner = this.transformY(yPos, this.anchor);
        g.setClip(xDrawCorner - this.widthFrame / 2, yDrawCorner - this.heightFrame / 2, this.widthFrame, this.heightFrame);
        g.drawRegion(this.spriteImage, 0, 0, this.widthFrame, this.heightFrame, spriteTransform, xDrawCorner, yDrawCorner, 3);
    }

    public void paintPlayerCar(Graphics g, int spriteTransform, int xPos, int yPos, int[][] surround, int[][] dropPos, int[][] corner, boolean[] unwalkBool, int[] maskValue, int racePosition) {
        int xDrawCorner = this.transformX(xPos, this.anchor);
        int yDrawCorner = this.transformY(yPos, this.anchor);
        this.widthFrame = this.spriteImages[this.currentFrame].getWidth();
        this.heightFrame = this.spriteImages[this.currentFrame].getHeight();
        g.drawRegion(this.spriteImages[this.currentFrame], 0, 0, this.widthFrame, this.heightFrame, spriteTransform, xDrawCorner, yDrawCorner, 3);
        g.setColor(255, 255, 255);
    }

    public void setFrameSequence(int[] sequence, int timeFrame) {
        if (sequence.length == 1) {
            this.currentFrame = sequence[0];
        } else {
            this.framesSequence = sequence;
            this.sequenceIndex = 0;
            this.timePerFrame = timeFrame;
        }
    }

    public void setFrame(int frame) {
        this.currentFrame = frame;
    }

    public int getFrameWidth() {
        if (this.spriteImages != null) {
            return this.spriteImages[this.currentFrame].getWidth();
        }
        return this.widthFrame;
    }

    public int getFrameHeight() {
        if (this.spriteImages != null) {
            return this.spriteImages[this.currentFrame].getHeight();
        }
        return this.heightFrame;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setAnchorImage(int anchor) {
        this.anchor = anchor;
    }

    private int transformY(int yo, int anchorPoint) {
        if ((0x20 & anchorPoint) != 0) {
            return yo - this.heightFrame;
        }
        if ((2 & anchorPoint) != 0) {
            return yo - this.heightFrame / 2;
        }
        return yo;
    }

    private int transformX(int x, int anchorPoint) {
        if ((8 & anchorPoint) != 0) {
            return x - this.widthFrame;
        }
        if ((1 & anchorPoint) != 0) {
            return x - this.widthFrame / 2;
        }
        return x;
    }
}

