/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.RandSync;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBillboardObject;
import baltorogames.project_gameplay.CGTrack;
import baltorogames.project_gameplay.CGTrackNode;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.CarEngine2D;
import baltorogames.project_gameplay.DebugConsole;
import baltorogames.project_gameplay.FXUtility;
import baltorogames.project_gameplay.MyGame;
import baltorogames.project_gameplay.Vector2FX;
import baltorogames.project_gameplay.Vector3FX;
import baltorogames.project_gui.End14MileScreen;
import baltorogames.project_gui.EndCompetitionScreen;
import baltorogames.project_gui.EndTimeAttackScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.io.DataInputStream;

public class CGEngine {
    public static final int MAX_NUMBER_OF_PLAYERS = 4;
    public static final int TOURNAMENT_TYPE_SINGLE_COMPETITION = 1;
    public static final int TOURNAMENT_TYPE_CHAMPIONSHIPS = 2;
    public static final int TOURNAMENT_TYPE_TIMEATTACK = 3;
    public static final int RACE_TYPE_RACE = 0;
    public static final int RACE_TYPE_14MILE = 1;
    public static final int RACE_TYPE_TIMEATTACK = 2;
    public static final int WEATHER_SUNNY = 0;
    public static final int WEATHER_CLOUDY = 1;
    public static final int WEATHER_NIGHT = 2;
    public static final int WEATHER_RAINY = 3;
    public static final int TIMEATTACK_CASH_FOR_GOLD = 100;
    public static final int TIMEATTACK_CASH_FOR_SILVER = 60;
    public static final int TIMEATTACK_CASH_FOR_BRONZE = 40;
    public static final int TIMEATTACK_FP_FOR_GOLD = 220;
    public static final int TIMEATTACK_FP_FOR_SILVER = 170;
    public static final int TIMEATTACK_FP_FOR_BRONZE = 145;
    public static final int MILE14_CASH_FOR_GOLD = 100;
    public static final int MILE14_FP_FOR_GOLD = 320;
    public static final int[] RACE_CASH_FOR_POS = new int[]{200, 100, 80, 60, 50, 40, 20, 10, 0, 0, 0, 0};
    public static final int[] RACE_FP_FOR_POS = new int[]{560, 480, 400, 320, 240, 160, 80, 0};
    public static final int[] RACE_POINTS_FOR_POS = new int[]{8, 7, 6, 5, 4, 3, 2, 1};
    public static final int FAME_POINTS_RADAR = -15;
    public static final int FAME_POINTS_AHEAD = 15;
    public static final int[] timeAttack_GoldTime = new int[]{200000, 20000, 200000, 200000, 20000, 200000, 200000, 20000, 200000, 200000, 20000, 200000, 200000, 20000, 200000};
    public static final int[] timeAttack_SilverTime = new int[]{25000, 25000, 210000, 25000, 25000, 210000, 25000, 25000, 210000, 25000, 25000, 210000, 25000, 25000, 210000};
    public static final int[] timeAttack_BronzeTime = new int[]{30000, 30000, 225000, 30000, 30000, 225000, 30000, 30000, 225000, 30000, 30000, 225000, 30000, 30000, 225000};
    public static int[] raceIDtoRaceType = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int[] trackLength = new int[]{245760000, 20480000, 245760000, 0xFA00000, 20480000, 0xFA00000, 266240000, 20480000, 266240000, 292044800, 20480000, 292044800, 282624000, 20480000, 282624000};
    public static CGTexture[] m_RadarTexture = null;
    public static CGTexture m_RadarPhotoTexture = null;
    public static CGTexture[] m_CountDownTextures = null;
    public static CGTexture m_TachoMPH_Texture = null;
    public static CGTexture m_TachoRPM_Texture = null;
    public static CGTexture m_Nitro_Texture = null;
    public static int m_RadarEventTime = 0;
    public static boolean m_bPause = false;
    public static int m_nStateTime = 0;
    private static long _currentVelocity = 0L;
    public static int selectedGameMode = 0;
    public static int selectedRaceType = 0;
    public static int selectedTrack = 0;
    public static CarEngine2D testApp = new CarEngine2D();
    public static int m_nCurrentRacePos = 8;
    public static int m_nInitFamePoints;
    public static int m_nCurrrentFamePoints;

    public static void Load1(DataInputStream dataInputStream) {
        CGEngine.Destroy();
        int n = selectedTrack * 3 + selectedRaceType;
        int n2 = 80 * ApplicationData.screenHeight / 320;
        int n3 = 82 * ApplicationData.screenHeight / 320;
        if (n3 <= n2) {
            n3 = n2 + 1;
        }
        int n4 = 21;
        int n5 = 38400 / ApplicationData.screenHeight;
        testApp.SetCameraSettings(ApplicationData.screenWidth, ApplicationData.screenHeight, n2, n3, n5, ApplicationData.screenWidth * 4096 / 240, n4);
        testApp.Load(dataInputStream, n);
    }

    public static void Load2(DataInputStream dataInputStream) {
        int n;
        int n2 = selectedTrack * 3 + selectedRaceType;
        if (!DebugConsole.debug_short_track) {
            testApp.GetTrack().SetFinishDistance(trackLength[n2]);
        } else {
            testApp.GetTrack().SetFinishDistance(0xBB8000L);
        }
        int n3 = n2 / 3;
        if (selectedRaceType == 1) {
            n3 = 10;
        }
        if (n3 != CGTrack.m_nLastTrackIndex) {
            CGEngine.GenerateObjects_Level1();
            CGEngine.GenerateGrandstands();
            CGEngine.GenerateFarBuildings();
            CGEngine.GenerateObjects_Level2();
            CGEngine.GenerateObjects_Level3();
        }
        CGTrack.m_nLastTrackIndex = n3;
        if (selectedRaceType == 1) {
            CGTrack.m_nLastTrackIndex = 10;
        }
        CGEngine.testApp.m_nTranslateScreenY = n = 0;
        if (selectedRaceType == 0) {
            testApp.SetupBolids(8);
        } else if (selectedRaceType == 1) {
            testApp.SetupBolids(2);
        } else {
            testApp.SetupBolids(1);
        }
        testApp.SetupLaps(1);
        if (selectedRaceType == 1) {
            testApp.GetBolid(0).SetManualGear(true);
        }
        long l = 4096L;
        long l2 = 4096L;
        long l3 = 4096L;
        testApp.GetBolid(0).SetPowerFactorHuman(4096L + 5L * l / 10L);
        testApp.GetBolid(0).SetNitroFactorHuman(5324L + 4L * l2 / 10L);
        testApp.GetBolid(0).SetHandlingFactorHuman(4096L + 12L * l3 / 10L);
        m_nStateTime = 0;
        _currentVelocity = 0L;
        m_bPause = false;
        if (m_CountDownTextures == null) {
            m_CountDownTextures = new CGTexture[4];
            CGEngine.m_CountDownTextures[0] = TextureManager.AddTexture("/gameplay/start_01.png");
            CGEngine.m_CountDownTextures[1] = TextureManager.AddTexture("/gameplay/start_02.png");
            CGEngine.m_CountDownTextures[2] = TextureManager.AddTexture("/gameplay/start_03.png");
            CGEngine.m_CountDownTextures[3] = TextureManager.AddTexture("/gameplay/start_04.png");
        }
        m_TachoMPH_Texture = TextureManager.AddTexture("/gameplay/tacho.png");
        m_TachoRPM_Texture = TextureManager.AddTexture("/gameplay/tachorpm.png");
        m_Nitro_Texture = TextureManager.AddTexture("/gameplay/nitro_active.png");
        m_nCurrentRacePos = 8;
        m_nInitFamePoints = CGUserCareer.GetFamePoints();
        m_nCurrrentFamePoints = 0;
    }

    public static int Init() {
        FXUtility.Init();
        CGTexture.m_NrOfMipMapsForObjects = 10;
        CGTexture.m_NrOfMipMapsForBolids = 7;
        CGTexture.m_NrOfMipMapsForObjects = 8;
        CGTexture.m_NrOfMipMapsForBolids = 6;
        return 1;
    }

    public static void Destroy() {
    }

    public static void RadarEvent() {
        m_RadarEventTime = 1;
    }

    public static void Update(int n) {
        if (m_bPause) {
            return;
        }
        CGEngine.testApp.m_fxDeltaTime = n * 4096 / 1000;
        m_nStateTime += n;
        _currentVelocity = CGEngine.testApp.GetHumanBolid().m_fxCurrentVelocity;
        if (m_RadarEventTime > 0 && (m_RadarEventTime += n) > 2000) {
            m_RadarEventTime = 0;
        }
        if (CGEngine.testApp.m_nGameState == 0) {
            if (m_nStateTime >= 3000) {
                testApp.Go();
                m_nStateTime = 0;
            }
        } else if (testApp.GetGameState() == 1) {
            if (ApplicationData.isUpPressed() || MyGame.upTouchKeyPressed) {
                testApp.GetHumanBolid().Sterring_Nitro();
            } else if (ApplicationData.isDownPressed() || MyGame.downTouchKeyPressed) {
                testApp.GetHumanBolid().Sterring_Down();
                testApp.GetHumanBolid().SetBreak(1);
            } else {
                testApp.GetHumanBolid().Sterring_Up();
            }
            if (selectedRaceType != 1) {
                if (ApplicationData.isLeftPressed() || MyGame.leftTouchKeyPressed) {
                    testApp.GetHumanBolid().Sterring_Left();
                } else if (ApplicationData.isRightPressed() || MyGame.rightTouchKeyPressed) {
                    testApp.GetHumanBolid().Sterring_Right();
                } else {
                    testApp.GetHumanBolid().SetStraight(0);
                }
            }
        } else if (CGEngine.testApp.m_nGameState == 2 && m_nStateTime >= 2000) {
            ApplicationData.generalGameMode = 3;
            if (selectedRaceType == 0) {
                UIScreen.SetCurrentScreen(new EndCompetitionScreen());
            } else if (selectedRaceType == 1) {
                UIScreen.SetCurrentScreen(new End14MileScreen());
            } else if (selectedRaceType == 2) {
                UIScreen.SetCurrentScreen(new EndTimeAttackScreen());
            }
        }
        int n2 = testApp.GetGameState();
        testApp.Step();
        if (n2 == 1 && testApp.GetGameState() == 2) {
            m_nStateTime = 0;
            System.out.println("FINISH!!!");
        }
    }

    public static void Render() {
        if (m_bPause) {
            return;
        }
        if (CGEngine.testApp.m_nGameState == 0) {
            if (m_nStateTime < 1000) {
                if (m_CountDownTextures != null && m_CountDownTextures[0] != null) {
                    Graphic2D.DrawImage(m_CountDownTextures[0], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("03"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
                }
            } else if (m_nStateTime < 2000) {
                if (m_CountDownTextures != null && m_CountDownTextures[1] != null) {
                    Graphic2D.DrawImage(m_CountDownTextures[1], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("02"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
                }
            } else if (m_CountDownTextures != null && m_CountDownTextures[2] != null) {
                Graphic2D.DrawImage(m_CountDownTextures[2], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
            } else {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("01"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
            }
        } else if (CGEngine.testApp.m_nGameState == 1) {
            int n;
            if (m_nStateTime < 1000) {
                if (m_CountDownTextures != null && m_CountDownTextures[3] != null) {
                    Graphic2D.DrawImage(m_CountDownTextures[3], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("GO"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
                }
            }
            if (selectedRaceType == 0) {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + _currentVelocity / 4096L / 3L), ApplicationData.screenWidth - m_TachoMPH_Texture.GetWidth() / 2, ApplicationData.screenHeight - ObjectsCache.menuSbPAUSE.GetHeight() - m_TachoMPH_Texture.GetHeight(), 33, 0);
                long l = CGEngine.testApp.GetBolid((int)0).m_fxCurrentDistanceFromStart;
                n = CGEngine.testApp.m_nNrOfBolids;
                for (int i = 1; i < CGEngine.testApp.m_nNrOfBolids; ++i) {
                    if (l <= CGEngine.testApp.GetBolid((int)i).m_fxCurrentDistanceFromStart) continue;
                    --n;
                }
                if (n < m_nCurrentRacePos) {
                    m_nCurrrentFamePoints += 15;
                }
                m_nCurrentRacePos = n;
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(" " + n + " / 8"), 0, ApplicationData.defaultFont.getFontHeight() / 2, 20, 0);
            } else if (selectedRaceType == 1) {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                if (testApp.GetBolid(0).GetManualGear() && testApp.GetBolid(0).IsMaxManualVelocity()) {
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_GEAR_UP"), ApplicationData.screenWidth / 2, 4 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                }
            } else if (selectedRaceType == 2) {
                int n2 = selectedTrack * 3 + selectedRaceType;
                if (m_nStateTime < timeAttack_GoldTime[n2]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_GoldTime[n2] - m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_GOLD_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else if (m_nStateTime < timeAttack_SilverTime[n2]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_SilverTime[n2] - m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_SILVER_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else if (m_nStateTime < timeAttack_BronzeTime[n2]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_BronzeTime[n2] - m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_BRONZE_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("00:00:00"), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                }
            }
            int n3 = ApplicationData.screenWidth - m_TachoMPH_Texture.GetWidth();
            int n4 = ApplicationData.screenHeight - ObjectsCache.menuSbPAUSE.GetHeight() - m_TachoMPH_Texture.GetHeight();
            if (selectedRaceType == 1) {
                Graphic2D.DrawImage(m_TachoRPM_Texture, n3, n4, 20);
            } else {
                Graphic2D.DrawImage(m_TachoMPH_Texture, n3, n4, 20);
            }
            n = 1;
            long l = testApp.GetBolid(0).GetCurrentNitroLevel();
            if (l >= 4096L) {
                l = 4096L;
                if (ApplicationData.getAppTime() % 400L < 200L) {
                    n = 0;
                }
            }
            if (n == 1) {
                int n5 = (int)l * m_Nitro_Texture.GetHeight() / 4096;
                Graphic2D.DrawR(m_Nitro_Texture, 0, m_Nitro_Texture.GetHeight() - n5, m_Nitro_Texture.GetWidth(), m_Nitro_Texture.GetHeight(), n3, n4 + m_TachoMPH_Texture.GetHeight() - n5, 0);
            }
            long l2 = 0L;
            l2 = selectedRaceType == 1 ? testApp.GetBolid(0).GetTachoRPM() * 270L / 4096L : testApp.GetBolid(0).GetTachoVelocity() * 270L / 4096L;
            long l3 = FXUtility.m_VectorFromAngleX[(int)l2] * (long)m_TachoMPH_Texture.GetWidth() / 5L;
            long l4 = FXUtility.m_VectorFromAngleY[(int)l2] * (long)m_TachoMPH_Texture.GetWidth() / 5L;
            Graphic2D.DrawLine(0xFFFFFF, n3 + m_TachoMPH_Texture.GetWidth() / 2, n4 + m_TachoMPH_Texture.GetHeight() / 2, n3 + m_TachoMPH_Texture.GetWidth() / 2 - (int)(l3 / 4096L), n4 + m_TachoMPH_Texture.GetHeight() / 2 + (int)(l4 / 4096L));
        } else if (CGEngine.testApp.m_nGameState == 2) {
            if (selectedRaceType == 0) {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                int n = testApp.GetBolid(0).GetTotalTime();
                int n6 = CGEngine.testApp.m_nNrOfBolids;
                for (int i = 1; i < CGEngine.testApp.m_nNrOfBolids; ++i) {
                    if (n >= testApp.GetBolid(i).GetTotalTime()) continue;
                    --n6;
                }
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(" " + n6 + " / 8"), 0, ApplicationData.defaultFont.getFontHeight() / 2, 20, 0);
            } else if (selectedRaceType == 1) {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
            } else if (selectedRaceType == 2) {
                int n = selectedTrack * 3 + selectedRaceType;
                if (testApp.GetBolid(0).GetTotalTime() < timeAttack_GoldTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_GoldTime[n] - testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_GOLD_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else if (testApp.GetBolid(0).GetTotalTime() < timeAttack_SilverTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_SilverTime[n] - testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_SILVER_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else if (testApp.GetBolid(0).GetTotalTime() < timeAttack_BronzeTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_BronzeTime[n] - testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_BRONZE_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("00:00:00"), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                }
            }
        }
    }

    public static void GenerateObjects_Level1() {
        CGBillboardObject cGBillboardObject;
        Vector3FX vector3FX = new Vector3FX();
        Vector2FX vector2FX = new Vector2FX();
        CGTrackNode cGTrackNode = null;
        cGTrackNode = testApp.GetTrack().FindPlaceOnTrack3D(2048000L, 0L, null, vector3FX, vector2FX);
        if (cGTrackNode != null) {
            cGBillboardObject = CGBillboardObject.CreateBillboardObject(19, vector3FX.x, vector3FX.y, vector3FX.z);
            cGBillboardObject.m_fxDistanceFromStart = 2048000L;
            cGTrackNode.m_pTrackPiece.AddObject(cGBillboardObject);
        }
        if ((cGTrackNode = testApp.GetTrack().FindPlaceOnTrack3D(CGEngine.testApp.GetTrack().m_fxTrackFinishDist, 0L, null, vector3FX, vector2FX)) != null) {
            cGBillboardObject = CGBillboardObject.CreateBillboardObject(19, vector3FX.x, vector3FX.y, vector3FX.z);
            cGBillboardObject.m_fxDistanceFromStart = CGEngine.testApp.GetTrack().m_fxTrackFinishDist;
            cGTrackNode.m_pTrackPiece.AddObject(cGBillboardObject);
        }
    }

    public static void GenerateObjects_Level2() {
        CGBillboardObject cGBillboardObject;
        Vector3FX vector3FX = new Vector3FX();
        Vector2FX vector2FX = new Vector2FX();
        CGTrackNode cGTrackNode = null;
        long l = 4096000L;
        do {
            if ((cGTrackNode = testApp.GetTrack().FindPlaceOnTrack3D(l, 4200L, null, vector3FX, vector2FX)) == null) continue;
            cGBillboardObject = CGBillboardObject.CreateBillboardObject(23, vector3FX.x, vector3FX.y, vector3FX.z);
            cGBillboardObject.m_fxDistanceFromStart = l;
            cGTrackNode.m_pTrackPiece.AddObject(cGBillboardObject);
        } while ((l += 2048000L) <= CGEngine.testApp.GetTrack().m_fxTrackLength);
        l = 4096000L;
        do {
            if ((cGTrackNode = testApp.GetTrack().FindPlaceOnTrack3D(l, -4200L, null, vector3FX, vector2FX)) == null) continue;
            cGBillboardObject = CGBillboardObject.CreateBillboardObject(24, vector3FX.x, vector3FX.y, vector3FX.z);
            cGBillboardObject.m_fxDistanceFromStart = l;
            cGTrackNode.m_pTrackPiece.AddObject(cGBillboardObject);
        } while ((l += 2048000L) <= CGEngine.testApp.GetTrack().m_fxTrackLength);
        l = 0x7D0000L;
        do {
            if ((cGTrackNode = testApp.GetTrack().FindPlaceOnTrack3D(l, -2000L, null, vector3FX, vector2FX)) == null) continue;
            cGBillboardObject = CGBillboardObject.CreateBillboardObject(21, vector3FX.x, vector3FX.y, vector3FX.z);
            cGBillboardObject.m_fxDistanceFromStart = l;
            cGTrackNode.m_pTrackPiece.AddObject(cGBillboardObject);
        } while ((l += (long)((3200 + RandSync.nextInt() % 1000) * 4096)) <= CGEngine.testApp.GetTrack().m_fxTrackLength);
    }

    public static void GenerateObjects_Level3() {
        Vector3FX vector3FX = new Vector3FX();
        Vector2FX vector2FX = new Vector2FX();
        CGTrackNode cGTrackNode = null;
        long l = 409600L;
        do {
            long l2 = 8000 + RandSync.nextInt() % 4000;
            if (RandSync.nextInt() % 2 == 0) {
                l2 = -l2;
            }
            if ((cGTrackNode = testApp.GetTrack().FindPlaceOnTrack3D(l, l2, null, vector3FX, vector2FX)) == null) continue;
            int n = RandSync.nextInt() % 2;
            int n2 = -1;
            if (n == 0) {
                n2 = 22;
                if (l2 < 0L) {
                    n2 = 22;
                }
            } else if (n == 1) {
                n2 = 14;
                if (l2 < 0L) {
                    n2 = 14;
                }
            }
            CGBillboardObject cGBillboardObject = CGBillboardObject.CreateBillboardObject(n2, vector3FX.x, vector3FX.y, vector3FX.z);
            cGBillboardObject.m_fxDistanceFromStart = l;
            cGTrackNode.m_pTrackPiece.AddObject(cGBillboardObject);
        } while ((l += (long)((400 + RandSync.nextInt() % 100) * 4096)) <= CGEngine.testApp.GetTrack().m_fxTrackLength);
    }

    public static void GenerateGrandstands() {
        Vector3FX vector3FX = new Vector3FX();
        Vector2FX vector2FX = new Vector2FX();
        CGTrackNode cGTrackNode = null;
        long l = 4096000L;
        do {
            long l2 = 7000L;
            if (RandSync.nextInt() % 2 == 0) {
                l2 = -l2;
            }
            if ((cGTrackNode = testApp.GetTrack().FindPlaceOnTrack3D(l, l2, null, vector3FX, vector2FX)) == null) continue;
            int n = RandSync.nextInt() % 3;
            int n2 = -1;
            if (n == 0) {
                n2 = 17;
                if (l2 < 0L) {
                    n2 = 18;
                }
            } else if (n == 1) {
                n2 = 15;
                if (l2 < 0L) {
                    n2 = 16;
                }
            } else {
                n2 = 12;
                if (l2 < 0L) {
                    n2 = 13;
                }
            }
            CGBillboardObject cGBillboardObject = CGBillboardObject.CreateBillboardObject(n2, vector3FX.x, vector3FX.y, vector3FX.z);
            cGBillboardObject.m_fxDistanceFromStart = l;
            cGTrackNode.m_pTrackPiece.AddObject(cGBillboardObject);
        } while ((l += (long)((1000 + RandSync.nextInt() % 500) * 4096)) <= CGEngine.testApp.GetTrack().m_fxTrackLength);
    }

    public static void GenerateFarBuildings() {
        Vector3FX vector3FX = new Vector3FX();
        Vector2FX vector2FX = new Vector2FX();
        CGTrackNode cGTrackNode = null;
        long l = 6144000L;
        do {
            long l2 = 18000 + RandSync.nextInt() % 2000;
            if (RandSync.nextInt() % 2 == 0) {
                l2 = -l2;
            }
            if ((cGTrackNode = testApp.GetTrack().FindPlaceOnTrack3D(l, l2, null, vector3FX, vector2FX)) == null) continue;
            int n = RandSync.nextInt() % 2;
            int n2 = -1;
            if (n == 0) {
                n2 = 8;
                if (l2 < 0L) {
                    n2 = 9;
                }
            } else if (n == 1) {
                n2 = 10;
                if (l2 < 0L) {
                    n2 = 11;
                }
            }
            CGBillboardObject cGBillboardObject = CGBillboardObject.CreateBillboardObject(n2, vector3FX.x, vector3FX.y, vector3FX.z);
            cGBillboardObject.m_fxDistanceFromStart = l;
            cGTrackNode.m_pTrackPiece.AddObject(cGBillboardObject);
        } while ((l += (long)((1000 + RandSync.nextInt() % 500) * 4096)) <= CGEngine.testApp.GetTrack().m_fxTrackLength);
    }
}

