/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.BestScores;
import baltorogames.project_gameplay.CGUserCareer;

public class DebugConsole {
    private static final int KEY_0_INT_CODE = 48;
    private static int debugCode;
    private static int debugDigit;
    public static boolean debug_short_track;
    public static boolean debug_switch_coll;
    public static boolean debug_switch_FPS;
    public static boolean debug_switch_MEM;
    public static boolean debug_switch_3D;
    public static boolean debug_switch_2D;
    public static boolean debug_switch_logic;
    public static boolean debug_switch_tracksOnly;
    public static boolean debug_switch_background;
    public static boolean debug_switch_BT;
    public static boolean debug_switch_MEMOPT;
    public static boolean debug_force_LOD;
    public static boolean debug_show_2DMAP;
    public static boolean debug_checkpoints_enabled;

    public static void trackDebugCommand(int n) {
        switch (n) {
            case 42: {
                DebugConsole.clear();
                break;
            }
            case 35: {
                DebugConsole.executeDebugCommand();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int n2 = n - 48;
                if (debugDigit == 3) {
                    debugCode = 0;
                    debugDigit = 0;
                }
                if (debugDigit == 0) {
                    debugCode += n2 * 100;
                }
                if (debugDigit == 1) {
                    debugCode += n2 * 10;
                }
                if (debugDigit == 2) {
                    debugCode += n2;
                }
                ++debugDigit;
            }
        }
    }

    private static void clear() {
        debugCode = 0;
        debugDigit = 0;
    }

    private static void executeDebugCommand() {
        switch (debugCode) {
            case 111: {
                debug_show_2DMAP = !debug_show_2DMAP;
                break;
            }
            case 123: {
                debug_short_track = !debug_short_track;
                break;
            }
            case 222: {
                debug_force_LOD = !debug_force_LOD;
                break;
            }
            case 999: {
                debug_switch_FPS = !debug_switch_FPS;
                break;
            }
            case 444: {
                debug_switch_coll = !debug_switch_coll;
                break;
            }
            case 888: {
                BestScores.unlockAllLevelsAndKarts();
                break;
            }
            case 777: {
                debug_switch_MEM = !debug_switch_MEM;
                break;
            }
            case 765: {
                debug_checkpoints_enabled = !debug_checkpoints_enabled;
                break;
            }
            case 555: {
                debug_switch_MEMOPT = !debug_switch_MEMOPT;
                break;
            }
            case 100: {
                debug_switch_3D = !debug_switch_3D;
                break;
            }
            case 101: {
                debug_switch_2D = !debug_switch_2D;
                break;
            }
            case 102: {
                debug_switch_logic = !debug_switch_logic;
                break;
            }
            case 103: {
                debug_switch_tracksOnly = !debug_switch_tracksOnly;
                break;
            }
            case 104: {
                debug_switch_background = !debug_switch_background;
                break;
            }
            case 666: {
                debug_switch_BT = !debug_switch_BT;
                break;
            }
            case 300: {
                CGUserCareer.AddPoints(5000);
            }
        }
    }

    public static void draw() {
        if (debug_switch_FPS) {
            Graphic2D.SetColor(0xFF7070);
            Graphic2D.DrawDebugString("W: " + ApplicationData.screenWidth, 0, 110, 0);
            Graphic2D.DrawDebugString("H: " + ApplicationData.screenHeight, 0, 125, 0);
        }
        if (debug_switch_MEM) {
            long l = Runtime.getRuntime().freeMemory() / 1024L;
            long l2 = Runtime.getRuntime().totalMemory() / 1024L;
            float f = 1.0f - (float)l / (float)l2;
            int n = (int)(f * (float)ApplicationData.screenWidth);
            Graphic2D.SetColor(0x40F040);
            Graphic2D.FillRect(0, 0, ApplicationData.screenWidth, 8);
            Graphic2D.SetColor(0xFF4040);
            Graphic2D.FillRect(0, 0, n, 8);
            Graphic2D.DrawDebugString("totalMem: " + l2, 0, 16, 0);
        }
    }

    static {
        debugDigit = 0;
        debug_short_track = false;
        debug_switch_coll = true;
        debug_switch_FPS = false;
        debug_switch_MEM = false;
        debug_switch_3D = true;
        debug_switch_2D = true;
        debug_switch_logic = true;
        debug_switch_tracksOnly = false;
        debug_switch_background = true;
        debug_switch_BT = false;
        debug_switch_MEMOPT = false;
        debug_force_LOD = false;
        debug_show_2DMAP = true;
        debug_checkpoints_enabled = true;
    }
}

