/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.TouchCommand;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIWindowCaption;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import java.util.Vector;

public abstract class UIScreen {
    public static int ID_BUTTON_OK = 1;
    public static int ID_BUTTON_CANCEL = 2;
    protected static UIScreen m_CurrentScreen = null;
    protected String windowCaptionText;
    protected UIWindowCaption windowCaptionThick;
    protected int lifeTime = 0;
    protected boolean readyForClose = false;
    protected int userPositionX;
    protected int userPositionY;
    protected int userWidth;
    protected int userHeight;
    protected int positionX;
    protected int positionY;
    protected int width;
    protected int height;
    protected int clientAreaX;
    protected int clientAreaY;
    protected int clientAreaWidth;
    protected int clientAreaHeight;
    protected boolean showCaption = false;
    protected boolean showScrollbars = false;
    protected boolean showHScrollbars = false;
    protected int YScrollOffset = 0;
    protected UIScreen parentScreen = null;
    protected Vector buttonsVector = new Vector();
    private boolean bDrawParent = false;
    public int wndAreaHeight = 85;

    public static void SetCurrentScreen(UIScreen uIScreen) {
        m_CurrentScreen = uIScreen;
        if (m_CurrentScreen != null) {
            m_CurrentScreen.onFocusBack();
            m_CurrentScreen.onUpdate(0);
        }
    }

    public static UIScreen GetCurrentScreen() {
        return m_CurrentScreen;
    }

    public void SetDrawParent(boolean bl) {
        this.bDrawParent = bl;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public boolean isReadyForClose() {
        return this.readyForClose;
    }

    protected void addButton(UIButton uIButton) {
        this.buttonsVector.addElement(uIButton);
    }

    protected UIButton findByID(int n) {
        int n2 = this.buttonsVector.size();
        for (int i = 0; i < n2; ++i) {
            UIButton uIButton = (UIButton)this.buttonsVector.elementAt(i);
            if (uIButton.getID() != n) continue;
            return uIButton;
        }
        return null;
    }

    protected boolean removeByID(int n) {
        int n2 = this.buttonsVector.size();
        for (int i = 0; i < n2; ++i) {
            UIButton uIButton = (UIButton)this.buttonsVector.elementAt(i);
            if (uIButton.getID() != n) continue;
            this.buttonsVector.removeElementAt(i);
            return true;
        }
        return false;
    }

    protected boolean removeButtons(int n) {
        int n2 = this.buttonsVector.size();
        for (int i = n2 - 1; i >= 0; --i) {
            UIButton uIButton = (UIButton)this.buttonsVector.elementAt(i);
            if (uIButton.getID() < n) continue;
            this.buttonsVector.removeElementAt(i);
        }
        return true;
    }

    protected UIButton findButton(int n, int n2) {
        int n3 = this.buttonsVector.size();
        for (int i = 0; i < n3; ++i) {
            UIButton uIButton = (UIButton)this.buttonsVector.elementAt(i);
            if (!uIButton.ckeckTouch(n, n2)) continue;
            return uIButton;
        }
        return null;
    }

    protected UIButton findSelectedButton() {
        int n = this.buttonsVector.size();
        for (int i = 0; i < n; ++i) {
            UIButton uIButton = (UIButton)this.buttonsVector.elementAt(i);
            if (!uIButton.isSelected) continue;
            return uIButton;
        }
        return null;
    }

    protected UIButton findCheckedButton() {
        int n = this.buttonsVector.size();
        for (int i = 0; i < n; ++i) {
            UIButton uIButton = (UIButton)this.buttonsVector.elementAt(i);
            if (!uIButton.isChecked) continue;
            return uIButton;
        }
        return null;
    }

    protected void unselectAllButtons() {
        int n = this.buttonsVector.size();
        for (int i = 0; i < n; ++i) {
            ((UIButton)this.buttonsVector.elementAt(i)).setSelect(false);
        }
    }

    protected void uncheckAllButtons() {
        int n = this.buttonsVector.size();
        for (int i = 0; i < n; ++i) {
            ((UIButton)this.buttonsVector.elementAt(i)).setCheck(false);
        }
    }

    public void setCaption(String string) {
        this.windowCaptionText = string;
    }

    public void setCaptionThick(UIWindowCaption uIWindowCaption) {
        this.windowCaptionThick = uIWindowCaption;
    }

    public void setParent(UIScreen uIScreen) {
        this.parentScreen = uIScreen;
    }

    public UIScreen getParent() {
        return this.parentScreen;
    }

    public void setPositionX(int n) {
        this.positionX = n;
    }

    public void setPositionY(int n) {
        this.positionY = n;
    }

    public void setPosition(int n, int n2) {
        this.positionX = n;
        this.positionY = n2;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void showCaption(boolean bl) {
        this.showCaption = bl;
    }

    public void showScrollbars(boolean bl) {
        this.showScrollbars = bl;
    }

    public void showHScrollbars(boolean bl) {
        this.showHScrollbars = bl;
    }

    public void setSoftButtonImage(CGTexture cGTexture, CGTexture cGTexture2, CGTexture cGTexture3, CGTexture cGTexture4) {
        UIButton uIButton;
        int n;
        int n2;
        int n3;
        int n4;
        this.removeByID(ID_BUTTON_OK);
        if (cGTexture != null) {
            n4 = cGTexture.GetWidth();
            n3 = cGTexture.GetHeight();
            n2 = 0;
            n = ApplicationData.screenHeight - n3;
            uIButton = new UIButton(n2, n, cGTexture, cGTexture2, cGTexture, ID_BUTTON_OK);
            this.addButton(uIButton);
        }
        this.removeByID(ID_BUTTON_CANCEL);
        if (cGTexture3 != null) {
            n4 = cGTexture3.GetWidth();
            n3 = cGTexture3.GetHeight();
            n2 = ApplicationData.screenWidth - n4;
            n = ApplicationData.screenHeight - n3;
            uIButton = new UIButton(n2, n, cGTexture3, cGTexture4, cGTexture3, ID_BUTTON_CANCEL);
            this.addButton(uIButton);
        }
    }

    protected void drawWindowsCaption() {
    }

    protected void drawButtons() {
        if (UIScreen.GetCurrentScreen() == this) {
            Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
            int n = this.buttonsVector.size();
            for (int i = 0; i < n; ++i) {
                ((UIButton)this.buttonsVector.elementAt(i)).draw();
            }
        } else {
            Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
            int n = this.buttonsVector.size();
            for (int i = 0; i < n; ++i) {
                UIButton uIButton = (UIButton)this.buttonsVector.elementAt(i);
                if (uIButton == null || uIButton.getID() == ID_BUTTON_OK || uIButton.getID() == ID_BUTTON_CANCEL) continue;
                uIButton.draw();
            }
        }
    }

    public abstract void draw();

    public abstract void drawWindowBackground();

    public abstract void drawWindowForeground();

    public void autoSize() {
    }

    public void onFocusBack() {
        this.unselectAllButtons();
    }

    public boolean leftSelectSoftButton() {
        UIButton uIButton = this.findByID(ID_BUTTON_OK);
        this.unselectAllButtons();
        if (uIButton != null) {
            uIButton.setSelect(true);
            uIButton.setCheck(true);
            return true;
        }
        return false;
    }

    public boolean rightSelectSoftButton() {
        UIButton uIButton = this.findByID(ID_BUTTON_CANCEL);
        this.unselectAllButtons();
        if (uIButton != null) {
            uIButton.setSelect(true);
            uIButton.setCheck(true);
            return true;
        }
        return false;
    }

    public boolean selectFireAction() {
        return this.leftSelectSoftButton();
    }

    public boolean selectLeftAction() {
        return false;
    }

    public boolean selectRightAction() {
        return false;
    }

    public boolean selectUpAction() {
        return false;
    }

    public boolean selectDownAction() {
        return false;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean rightSoftButton() {
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (bl) {
            UIButton uIButton = this.findByID(n);
            this.unselectAllButtons();
            uIButton.setSelect(true);
            uIButton.setCheck(true);
            return true;
        }
        return false;
    }

    public boolean onUpAction() {
        return false;
    }

    public boolean onDownAction() {
        return false;
    }

    public boolean onLeftAction() {
        return false;
    }

    public boolean onRightAction() {
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean onKeyAction(int n) {
        return false;
    }

    public boolean onKeyDownAction(int n) {
        return false;
    }

    public boolean keyEvent(KeyCommand keyCommand) {
        if (!keyCommand.pressed) {
            this.unselectAllButtons();
            if (keyCommand.keyCode == ApplicationData.SoftButton1_Code) {
                return this.leftSoftButton();
            }
            if (keyCommand.keyCode == ApplicationData.SoftButton2_Code) {
                return this.rightSoftButton();
            }
            if (keyCommand.keyCode == 8) {
                return this.onFireAction();
            }
            if (keyCommand.keyCode == 1) {
                return this.onUpAction();
            }
            if (keyCommand.keyCode == 6) {
                return this.onDownAction();
            }
            if (keyCommand.keyCode == 2) {
                return this.onLeftAction();
            }
            if (keyCommand.keyCode == 5) {
                return this.onRightAction();
            }
            return this.onKeyAction(keyCommand.keyCode);
        }
        if (keyCommand.keyCode == ApplicationData.SoftButton1_Code) {
            return this.leftSelectSoftButton();
        }
        if (keyCommand.keyCode == ApplicationData.SoftButton2_Code) {
            return this.rightSelectSoftButton();
        }
        if (keyCommand.keyCode == 8) {
            return this.selectFireAction();
        }
        if (keyCommand.keyCode == 2) {
            return this.selectLeftAction();
        }
        if (keyCommand.keyCode == 5) {
            return this.selectRightAction();
        }
        if (keyCommand.keyCode == 6) {
            return this.selectDownAction();
        }
        if (keyCommand.keyCode == 1) {
            return this.selectUpAction();
        }
        return this.onKeyDownAction(keyCommand.keyCode);
    }

    public boolean keyTouchEvent(TouchCommand touchCommand) {
        if (touchCommand.onPressed == 1) {
            UIButton uIButton = this.findButton(touchCommand.areaX, touchCommand.areaY);
            if (uIButton != null) {
                int n = uIButton.getID();
                this.actionSoftButton(n, true);
                return true;
            }
        } else {
            UIButton uIButton = this.findButton(touchCommand.areaX, touchCommand.areaY);
            if (uIButton != null && (uIButton.getSelect() || uIButton.getCheck())) {
                this.unselectAllButtons();
                int n = uIButton.getID();
                if (n == ID_BUTTON_OK) {
                    return this.leftSoftButton();
                }
                if (n == ID_BUTTON_CANCEL) {
                    return this.rightSoftButton();
                }
                return this.actionSoftButton(n, false);
            }
        }
        return false;
    }

    public void paint() {
        if (this.bDrawParent && this.parentScreen != null) {
            this.parentScreen.paint();
        }
        this.drawWindowBackground();
        this.drawWindowsCaption();
        if (this.windowCaptionThick != null) {
            this.windowCaptionThick.draw();
        }
        this.updateSize();
        this.draw();
        this.drawButtons();
        this.drawWindowForeground();
    }

    public void onUpdate(int n) {
        this.lifeTime += n;
    }

    public UIScreen() {
        this.updateSize();
    }

    public void updateSize() {
        int n = ApplicationData.screenHeight - 32 - this.wndAreaHeight;
        this.positionX = 0;
        this.positionY = n;
        this.width = ApplicationData.screenWidth;
        this.height = this.wndAreaHeight;
    }
}

