/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGAchievements {
    public static final int eAchievements_50KicksInSurvival = 0;
    public static final int eAchievements_150KicksInSurvival = 1;
    public static final int eAchievements_10PointsOneKick = 2;
    public static final int eAchievements_15PointsOneKick = 3;
    public static final int eAchievements_CompleteBasketBall = 4;
    public static final int eAchievements_CompleteBeachBall = 5;
    public static final int eAchievements_UnlockAllLevels = 6;
    public static final int eAchievements_50KicksInTimed = 7;
    public static final int eAchievements_100KicksInTimed = 8;
    public static final int eAchievements_BallDestroyed = 9;
    public static final int eAchievements_CompleteAll = 10;
    public static final int eMaxAchievements = 11;
    protected static boolean[] arrAchievementsCompleted = new boolean[11];
    protected static boolean m_bLoaded = false;

    public static void Reset() {
        for (int i = 0; i < 11; ++i) {
            CGAchievements.arrAchievementsCompleted[i] = false;
        }
    }

    public static void completeAchievement(int n) {
        if (!arrAchievementsCompleted[n]) {
            CGAchievements.arrAchievementsCompleted[n] = true;
            AchievementPopup.NewAchievement(n);
            CGAchievements.checkAllAchievementsCompleted();
        }
    }

    public static boolean isAchievementCompleted(int n) {
        return arrAchievementsCompleted[n];
    }

    protected static void checkAllAchievementsCompleted() {
        for (int i = 0; i <= 9; ++i) {
            if (arrAchievementsCompleted[i]) continue;
            return;
        }
        CGAchievements.completeAchievement(10);
    }

    public static void Load() {
        BGStore bGStore = BGStore.openStoreToRead("Achievements");
        if (bGStore == null) {
            System.out.println("No Achievements store!!!!!!!!!!!!!!!!!!!!!!!");
            m_bLoaded = true;
            return;
        }
        try {
            DataInputStream dataInputStream = bGStore.getInStream();
            if (dataInputStream != null && dataInputStream.available() > 0) {
                for (int i = 0; i < 11; ++i) {
                    CGAchievements.arrAchievementsCompleted[i] = dataInputStream.readBoolean();
                }
            }
            bGStore.close();
            m_bLoaded = true;
        }
        catch (Exception exception) {
            CGAchievements.Reset();
            m_bLoaded = true;
            return;
        }
    }

    public static void Save() {
        if (!m_bLoaded) {
            System.out.println("No Achievements loaded!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        BGStore bGStore = BGStore.openStoreToWrite("Achievements");
        if (bGStore == null) {
            return;
        }
        try {
            DataOutputStream dataOutputStream = bGStore.getOutStream();
            for (int i = 0; i < 11; ++i) {
                dataOutputStream.writeBoolean(arrAchievementsCompleted[i]);
            }
            bGStore.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

