/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.RoadLineParams;
import javax.microedition.lcdui.Image;

public class RoadRenderer {
    private int[] imageBuff;
    private int imageX = 256;
    private int imageY = 2;
    public RoadLineParams[] arrRoadLineParams;
    public int m_R = 255;
    public int m_G = 128;
    public int m_B = 64;
    public int m_Color1 = 50;
    public int m_Color2 = 65;
    public int m_nColor1_R;
    public int m_nColor1_G;
    public int m_nColor1_B;
    public int m_nColor2_R;
    public int m_nColor2_G;
    public int m_nColor2_B;
    public int m_nEnvironment = -1;
    private int m_InitRoadSize;
    public int m_nLandShaftY;
    public int m_nLandAltitude = 0;
    public int m_nType = 0;

    public void Setup(int n, long[] lArray, int n2) {
        this.m_InitRoadSize = n;
        this.arrRoadLineParams = new RoadLineParams[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)((long)n * lArray[i]) / 4096;
            this.arrRoadLineParams[i] = new RoadLineParams();
            if (this.m_nType < 2) {
                this.arrRoadLineParams[i].Setup(i, n2, n3, this.imageX, this.imageY, this.imageBuff);
                continue;
            }
            long l = 0L;
            int n4 = 4096 * (3 * n2) / 4;
            if (i * 4096 > n4) {
                l = 4096 * (4096 * i - n4) / (4096 * n2 - n4);
            }
            this.arrRoadLineParams[i].SetupColor(i, n2, n3);
        }
        this.imageBuff = null;
    }

    public void PrepareBuffer(Image image) {
        if (this.m_nType < 2) {
            int n = image.getWidth();
            int n2 = image.getWidth();
            int n3 = image.getHeight();
            this.imageBuff = new int[n2 * n3];
            image.getRGB(this.imageBuff, 0, n, 0, 0, n2, n3);
            this.imageX = n2;
            this.imageY = n3;
        }
    }

    void DrawLand(int n) {
        long l = this.m_nColor1_R;
        long l2 = this.m_nColor1_G;
        long l3 = this.m_nColor1_B;
        long l4 = this.m_nColor2_R;
        long l5 = this.m_nColor2_G;
        long l6 = this.m_nColor2_B;
        if (CGEngine.testApp.roadLineParamsSize > this.m_nLandAltitude) {
            this.m_nLandAltitude = CGEngine.testApp.roadLineParamsSize;
        }
        int n2 = 0;
        long l7 = 0L;
        for (n2 = n; n2 >= n - this.m_nLandAltitude; --n2) {
            long l8 = 4096L * l7 / (long)this.m_nLandShaftY;
            int n3 = (int)((l8 * l + (4096L - l8) * l4) / 4096L);
            int n4 = (int)((l8 * l2 + (4096L - l8) * l5) / 4096L);
            int n5 = (int)((l8 * l3 + (4096L - l8) * l6) / 4096L);
            int n6 = n3 << 16 | n4 << 8 | n5;
            Graphic2D.DrawLine(n6, 0, n2, CGEngine.testApp.m_Camera.m_nScreenXSize, n2);
            ++l7;
        }
    }

    public void RenderRoadLine2Image(Image image, int n, int n2) {
        Graphic2D.DrawImage(image, n, n2, 20);
    }

    void DrawLine(int n, int n2, long l, int n3, int n4, long l2) {
        int n5 = (int)((long)this.imageX * (l2 - 4096L * (l2 / 4096L)) / 4096L);
        long l3 = CGEngine.testApp.m_Camera.GetScaleForDistance(l);
        int n6 = (int)(l3 * (long)this.m_InitRoadSize / 4096L);
        if (this.m_nType == 0) {
            this.RenderRoadLine2Image(this.arrRoadLineParams[n2].m_array[n5 % this.imageY], n3 - n6 / 2, n4);
        } else if (this.m_nType == 1) {
            if (l2 % 128L > 64L) {
                this.RenderRoadLine2Image(this.arrRoadLineParams[n2].m_array[0], n3 - n6 / 2, n4);
            } else {
                this.RenderRoadLine2Image(this.arrRoadLineParams[n2].m_array[1], n3 - n6 / 2, n4);
            }
        } else {
            Graphic2D.DrawLine(this.arrRoadLineParams[n2].m_color, n3 - n6 / 2, n4, n3 + n6 / 2, n4);
        }
    }

    public void SetImage(Image image) {
        this.PrepareBuffer(image);
    }
}

