/*
 * Decompiled with CFR 0.152.
 */
package com.sprintpcs.media;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class Clip {
    private int priority;
    private int vibration;
    private InputStream is = null;
    private String url = null;
    private String type = null;
    private byte[] data = null;

    public Clip(byte[] resource, String MIME, int priority, int vibration) throws IOException {
        this.data = resource;
        this.type = MIME;
        this.priority = priority;
        this.vibration = vibration;
    }

    public Clip(String resource, String MIME, int priority, int vibration) throws IOException {
        this.url = resource;
        this.type = MIME;
        this.priority = priority;
        this.vibration = vibration;
    }

    Player getPlayer() {
        InputStream is = null;
        Player player = null;
        try {
            if (this.url != null) {
                if (this.url.startsWith("resource:")) {
                    is = this.getClass().getResourceAsStream("/" + this.url.substring(9));
                    player = Manager.createPlayer((InputStream)is, (String)this.type);
                } else {
                    player = Manager.createPlayer((String)this.url);
                }
            } else if (this.data != null) {
                is = new ByteArrayInputStream(this.data);
                player = Manager.createPlayer((InputStream)is, (String)this.type);
            }
            player.realize();
            player.prefetch();
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException e2) {
            System.out.println("Catching an IOException when trying to creat a clip: " + e2.getMessage());
            e2.printStackTrace();
        }
        catch (Exception e3) {
            System.out.println("clip.getPlayer failed" + e3.getMessage());
        }
        return player;
    }

    int getPriority() {
        return this.priority;
    }

    int getVibration() {
        return this.vibration;
    }
}

