/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public final class SoundManager
implements Runnable {
    private static SoundManager self = null;
    private Thread soundThread;
    private boolean Enable = false;
    private Player[] Players;
    private Player LastSound;
    private Player SoundMelody;
    private int loopCount = 1;
    private boolean isRunning;
    private static int priority = 1;
    public static boolean SoundIsOn = false;

    static void init(String[] soundNames) {
        self = new SoundManager(soundNames);
    }

    private SoundManager(String[] soundNames) {
        this.Players = new Player[soundNames.length];
        for (int i = 0; i < soundNames.length; ++i) {
            this.Players[i] = this.createPlayer(soundNames[i]);
        }
        this.isRunning = true;
        this.soundThread = new Thread(this);
        this.soundThread.setPriority(priority);
        this.soundThread.start();
    }

    public void run() {
        while (this.isRunning) {
            if (this.Enable && this.playSM(this.SoundMelody)) {
                this.Enable = false;
                this.SoundMelody = null;
            }
            Thread.yield();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Player createPlayer(String fileName) {
        Player newPlayer = null;
        String[] soundTypes = new String[]{"audio/midi", "audio/amr", "audio/x-wav", "audio/mmf"};
        String[] fileExtensions = new String[]{".mid", ".amr", ".wav", ".mmf"};
        for (int i = 0; newPlayer == null && i < soundTypes.length; ++i) {
            try {
                newPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(String.valueOf(String.valueOf(fileName)).concat(String.valueOf(String.valueOf(fileExtensions[i])))), (String)soundTypes[i]);
                newPlayer.prefetch();
                newPlayer.realize();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newPlayer;
    }

    static void play(int index, boolean repeat) {
        if (self != null) {
            self.playSM(index, repeat);
        }
    }

    private void playSM(int index, boolean repeat) {
        if (!SoundIsOn || this.Players[index] == null) {
            return;
        }
        this.loopCount = repeat ? -1 : 1;
        this.SoundMelody = this.Players[index];
        this.Enable = true;
    }

    private boolean playSM(Player NewSound) {
        if (this.LastSound != null) {
            if (this.LastSound.getState() == 400) {
                return false;
            }
        }
        try {
            NewSound.setLoopCount(this.loopCount);
            NewSound.start();
            this.LastSound = NewSound;
        }
        catch (MediaException e) {
            this.LastSound = NewSound;
            this.stopSM();
            boolean bl = false;
            return bl;
        }
        return true;
    }

    static void stop() {
        if (self != null) {
            self.stopSM();
        }
    }

    private void stopSM() {
        this.Enable = false;
        if (this.LastSound != null) {
            if (this.LastSound.getState() == 400) {
                try {
                    this.LastSound.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
            this.LastSound = null;
        }
    }

    static void destroy() {
        if (self != null) {
            self.destroySM();
        }
    }

    private void destroySM() {
        this.stopSM();
        this.isRunning = false;
        this.Players = null;
        try {
            this.soundThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.soundThread = null;
    }

    static void start(String strPriority) {
        if (strPriority.equals("NORM_PRIORITY")) {
            priority = 5;
        } else if (strPriority.equals("MAX_PRIORITY")) {
            priority = 10;
        }
    }

    static void setSound(boolean on) {
        SoundIsOn = on;
        if (!SoundIsOn) {
            self.stopSM();
        }
    }

    static boolean SoundIsOn() {
        return SoundIsOn;
    }
}

