/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;

public class BackpackModel
extends AgeableListModel<LivingEntity>
implements IBackpackModel {
    private static final Map<EntityType<?>, Vec3> entityTranslations = new HashMap();
    private static final ResourceLocation BACKPACK_ENTITY_TEXTURE;
    private static final ResourceLocation TANK_GLASS_TEXTURE;
    public static final float CHILD_Y_OFFSET = 0.3f;
    public static final float CHILD_Z_OFFSET = 0.1f;
    public static final float CHILD_SCALE = 0.55f;
    private static final String CLOTH_PART = "cloth";
    private static final String RIGHT_POUCHES_BORDER_PART = "rightPouchesBorder";
    private static final String LEFT_POUCHES_BORDER_PART = "leftPouchesBorder";
    private static final String FRONT_POUCH_BORDER_PART = "frontPouchBorder";
    private static final String FRONT_POUCH_PART = "frontPouch";
    private static final String RIGHT_POUCHES_PART = "rightPouches";
    private static final String LEFT_POUCHES_PART = "leftPouches";
    private static final String BORDER_PART = "border";
    private static final String FABRIC_FRONT_PART = "fabricFront";
    private static final String FABRIC_RIGHT_PART = "fabricRight";
    private static final String FABRIC_LEFT_PART = "fabricLeft";
    private static final String FABRIC_PART = "fabric";
    private static final String BATTERY_BORDER_PART = "batteryBorder";
    private static final String BATTERY_PART = "battery";
    private static final String LEFT_TANK_BORDER_PART = "leftTankBorder";
    private static final String LEFT_TANK_PART = "leftTank";
    private static final String RIGHT_TANK_BORDER_PART = "rightTankBorder";
    private static final String RIGHT_TANK_PART = "rightTank";
    private static final String BODY_CLIPS_PART = "bodyClips_";
    private static final String LEFT_POUCHES_CLIPS_PART = "leftPouchesClips_";
    private static final String RIGHT_POUCHES_CLIPS_PART = "rightPouchesClips_";
    private static final String FRONT_POUCH_CLIPS_PART = "frontPouchClips_";
    private static final String BATTERY_CLIPS_PART = "batteryClips_";
    private static final String LEFT_TANK_GLASS_PART = "leftTankGlass";
    private static final String RIGHT_TANK_GLASS_PART = "rightTankGlass";
    private static final String BATTERY_CHARGE_PART = "battery_charge_";
    private final Map<Item, ModelPart> clipsBody;
    private final Map<Item, ModelPart> clipsLeftPouches;
    private final Map<Item, ModelPart> clipsRightPouches;
    private final Map<Item, ModelPart> clipsFrontPouch;
    private final Map<Item, ModelPart> clipsBattery;
    private final Map<FluidBarCacheKey, ModelPart> fluidLevelsLeft = new HashMap<FluidBarCacheKey, ModelPart>();
    private final Map<FluidBarCacheKey, ModelPart> fluidLevelsRight = new HashMap<FluidBarCacheKey, ModelPart>();
    private final Map<Integer, ModelPart> batteryCharges;
    public final ModelPart cloth;
    private final ModelPart rightPouchesBorder;
    private final ModelPart leftPouchesBorder;
    private final ModelPart frontPouchBorder;
    private final ModelPart frontPouch;
    private final ModelPart rightPouches;
    private final ModelPart leftPouches;
    public final ModelPart border;
    private final ModelPart fabricFront;
    private final ModelPart fabricRight;
    private final ModelPart fabricLeft;
    public final ModelPart fabric;
    private final ModelPart battery;
    private final ModelPart batteryBorder;
    private final ModelPart leftTank;
    private final ModelPart leftTankBorder;
    private final ModelPart rightTank;
    private final ModelPart rightTankBorder;
    public final ModelPart leftTankGlass;
    public final ModelPart rightTankGlass;

    public BackpackModel(ModelPart part) {
        this.cloth = part.m_171324_(CLOTH_PART);
        this.rightPouchesBorder = part.m_171324_(RIGHT_POUCHES_BORDER_PART);
        this.leftPouchesBorder = part.m_171324_(LEFT_POUCHES_BORDER_PART);
        this.frontPouchBorder = part.m_171324_(FRONT_POUCH_BORDER_PART);
        this.frontPouch = part.m_171324_(FRONT_POUCH_PART);
        this.rightPouches = part.m_171324_(RIGHT_POUCHES_PART);
        this.leftPouches = part.m_171324_(LEFT_POUCHES_PART);
        this.border = part.m_171324_(BORDER_PART);
        this.fabricFront = part.m_171324_(FABRIC_FRONT_PART);
        this.fabricRight = part.m_171324_(FABRIC_RIGHT_PART);
        this.fabricLeft = part.m_171324_(FABRIC_LEFT_PART);
        this.fabric = part.m_171324_(FABRIC_PART);
        this.battery = part.m_171324_(BATTERY_PART);
        this.batteryBorder = part.m_171324_(BATTERY_BORDER_PART);
        this.leftTank = part.m_171324_(LEFT_TANK_PART);
        this.leftTankBorder = part.m_171324_(LEFT_TANK_BORDER_PART);
        this.rightTank = part.m_171324_(RIGHT_TANK_PART);
        this.rightTankBorder = part.m_171324_(RIGHT_TANK_BORDER_PART);
        ImmutableMap.Builder clipsBodyBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsLeftPouchesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsRightPouchesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsFrontPouchBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsBatteryBuilder = ImmutableMap.builder();
        BackpackModel.getBackpackItems().values().forEach(backpackItem -> {
            clipsBodyBuilder.put(backpackItem, (Object)part.m_171324_(BackpackModel.getTierPartName(backpackItem, BODY_CLIPS_PART)));
            clipsLeftPouchesBuilder.put(backpackItem, (Object)part.m_171324_(BackpackModel.getTierPartName(backpackItem, LEFT_POUCHES_CLIPS_PART)));
            clipsRightPouchesBuilder.put(backpackItem, (Object)part.m_171324_(BackpackModel.getTierPartName(backpackItem, RIGHT_POUCHES_CLIPS_PART)));
            clipsFrontPouchBuilder.put(backpackItem, (Object)part.m_171324_(BackpackModel.getTierPartName(backpackItem, FRONT_POUCH_CLIPS_PART)));
            clipsBatteryBuilder.put(backpackItem, (Object)part.m_171324_(BackpackModel.getTierPartName(backpackItem, BATTERY_CLIPS_PART)));
        });
        ImmutableMap.Builder batteryChargeBuilder = ImmutableMap.builder();
        for (int pixels = 1; pixels < 5; ++pixels) {
            batteryChargeBuilder.put((Object)pixels, (Object)part.m_171324_(BATTERY_CHARGE_PART + pixels));
        }
        this.batteryCharges = batteryChargeBuilder.build();
        this.clipsBody = clipsBodyBuilder.build();
        this.clipsLeftPouches = clipsLeftPouchesBuilder.build();
        this.clipsRightPouches = clipsRightPouchesBuilder.build();
        this.clipsFrontPouch = clipsFrontPouchBuilder.build();
        this.clipsBattery = clipsBatteryBuilder.build();
        ModelPart modelPart = this.getGlassModelPart();
        this.leftTankGlass = modelPart.m_171324_(LEFT_TANK_GLASS_PART);
        this.rightTankGlass = modelPart.m_171324_(RIGHT_TANK_GLASS_PART);
    }

    @Nonnull
    private ModelPart getGlassModelPart() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partDefinition = meshdefinition.m_171576_();
        partDefinition.m_171599_(LEFT_TANK_GLASS_PART, CubeListBuilder.m_171558_().m_171514_(18, 5).m_171481_(-15.0f, 3.5f, -2.5f, 4.0f, 10.0f, 0.0f).m_171514_(0, 0).m_171481_(-15.0f, 3.5f, -2.5f, 0.0f, 10.0f, 5.0f).m_171514_(10, 5).m_171481_(-15.0f, 3.5f, 2.5f, 4.0f, 10.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(RIGHT_TANK_GLASS_PART, CubeListBuilder.m_171558_().m_171514_(18, 5).m_171506_(11.0f, 3.5f, -2.5f, 4.0f, 10.0f, 0.0f, true).m_171514_(0, 0).m_171506_(15.0f, 3.5f, -2.5f, 0.0f, 10.0f, 5.0f, true).m_171514_(10, 5).m_171506_(11.0f, 3.5f, 2.5f, 4.0f, 10.0f, 0.0f, true), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return partDefinition.m_171583_(32, 32);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partDefinition = meshdefinition.m_171576_();
        partDefinition.m_171599_(CLOTH_PART, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -13.25f, -3.25f, 7.0f, 4.0f, 6.0f).m_171514_(0, 10).m_171481_(-5.0f, -13.0f, -3.0f, 10.0f, 13.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(RIGHT_POUCHES_BORDER_PART, CubeListBuilder.m_171558_().m_171514_(44, 0).m_171506_(5.0f, -2.0f, -2.5f, 2.0f, 1.0f, 5.0f, true), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(LEFT_POUCHES_BORDER_PART, CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-7.0f, -2.0f, -2.5f, 2.0f, 1.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(FRONT_POUCH_BORDER_PART, CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-4.0f, -2.0f, -5.0f, 8.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(FRONT_POUCH_PART, CubeListBuilder.m_171558_().m_171514_(25, 0).m_171481_(-4.0f, -1.0f, -5.0f, 8.0f, 1.0f, 2.0f).m_171514_(13, 2).m_171481_(-4.0f, -4.0f, -5.0f, 8.0f, 2.0f, 2.0f).m_171514_(13, 0).m_171481_(-4.0f, -6.0f, -5.0f, 8.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(RIGHT_POUCHES_PART, CubeListBuilder.m_171558_().m_171514_(32, 5).m_171481_(5.0f, -1.0f, -2.5f, 2.0f, 1.0f, 5.0f).m_171514_(32, 13).m_171481_(5.0f, -4.0f, -2.5f, 2.0f, 2.0f, 5.0f).m_171514_(32, 11).m_171481_(5.0f, -6.0f, -2.5f, 2.0f, 1.0f, 5.0f).m_171514_(32, 22).m_171481_(5.0f, -9.0f, -2.5f, 1.0f, 2.0f, 5.0f).m_171514_(32, 20).m_171481_(5.0f, -11.0f, -2.5f, 1.0f, 1.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(LEFT_POUCHES_PART, CubeListBuilder.m_171558_().m_171514_(32, 5).m_171506_(-7.0f, -1.0f, -2.5f, 2.0f, 1.0f, 5.0f, true).m_171514_(32, 13).m_171506_(-7.0f, -4.0f, -2.5f, 2.0f, 2.0f, 5.0f, true).m_171514_(32, 11).m_171506_(-7.0f, -6.0f, -2.5f, 2.0f, 1.0f, 5.0f, true).m_171514_(32, 22).m_171506_(-6.0f, -9.0f, -2.5f, 1.0f, 2.0f, 5.0f, true).m_171514_(32, 20).m_171506_(-6.0f, -11.0f, -2.5f, 1.0f, 1.0f, 5.0f, true), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(BORDER_PART, CubeListBuilder.m_171558_().m_171514_(44, 7).m_171481_(-3.5f, -9.25f, -3.25f, 7.0f, 1.0f, 1.0f).m_171514_(50, 20).m_171481_(3.5f, -13.25f, -3.25f, 1.0f, 5.0f, 6.0f).m_171514_(50, 9).m_171481_(-4.5f, -13.25f, -3.25f, 1.0f, 5.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(FABRIC_FRONT_PART, CubeListBuilder.m_171558_().m_171514_(0, 55).m_171506_(-0.75f, 3.0f, 1.0f, 8.0f, 1.0f, 2.0f, true), PartPose.m_171419_((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.m_171599_(FABRIC_RIGHT_PART, CubeListBuilder.m_171558_().m_171514_(32, 49).m_171506_(8.25f, -2.0f, 3.5f, 1.0f, 1.0f, 5.0f, true).m_171514_(8, 45).m_171506_(8.25f, 3.0f, 3.5f, 2.0f, 1.0f, 5.0f, true), PartPose.m_171419_((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.m_171599_(FABRIC_LEFT_PART, CubeListBuilder.m_171558_().m_171514_(32, 49).m_171481_(-2.75f, -2.0f, 3.5f, 1.0f, 1.0f, 5.0f).m_171514_(8, 45).m_171481_(-3.75f, 3.0f, 3.5f, 2.0f, 1.0f, 5.0f), PartPose.m_171419_((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.m_171599_(FABRIC_PART, CubeListBuilder.m_171558_().m_171514_(54, 0).m_171481_(1.25f, -4.75f, 5.75f, 1.0f, 1.0f, 1.0f).m_171514_(58, 0).m_171481_(4.25f, -4.75f, 5.75f, 1.0f, 1.0f, 1.0f).m_171514_(44, 0).m_171506_(1.25f, -5.75f, 5.75f, 4.0f, 1.0f, 1.0f, true).m_171514_(16, 44).m_171481_(0.0f, -5.5f, 2.5f, 1.0f, 4.0f, 7.0f).m_171514_(0, 44).m_171481_(5.5f, -5.5f, 2.5f, 1.0f, 4.0f, 7.0f), PartPose.m_171419_((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.m_171599_(BATTERY_BORDER_PART, CubeListBuilder.m_171558_().m_171514_(28, 38).m_171481_(-4.25f, -5.25f, -6.25f, 1.0f, 1.0f, 4.0f).m_171514_(28, 43).m_171481_(-3.5f, -5.25f, -6.25f, 7.0f, 1.0f, 1.0f).m_171514_(33, 38).m_171481_(-4.25f, -1.25f, -6.25f, 1.0f, 1.0f, 4.0f).m_171514_(33, 38).m_171481_(3.25f, -5.25f, -6.25f, 1.0f, 1.0f, 4.0f).m_171514_(27, 45).m_171481_(-3.5f, -1.25f, -6.25f, 7.0f, 1.0f, 1.0f).m_171514_(39, 37).m_171481_(3.25f, -1.25f, -6.25f, 1.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(BATTERY_PART, CubeListBuilder.m_171558_().m_171514_(28, 29).m_171481_(-4.0f, -6.0f, -6.0f, 8.0f, 6.0f, 3.0f).m_171514_(28, 53).m_171481_(-2.0f, -6.25f, -4.5f, 1.0f, 1.0f, 1.0f).m_171514_(28, 53).m_171481_(-0.75f, -6.25f, -4.5f, 1.0f, 1.0f, 1.0f).m_171514_(28, 53).m_171481_(-2.0f, -8.0f, -3.25f, 1.0f, 1.0f, 1.0f).m_171514_(28, 53).m_171481_(-0.75f, -8.0f, -3.25f, 1.0f, 1.0f, 1.0f).m_171514_(0, 58).m_171488_(-2.0f, -7.4f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(6, 58).m_171488_(-0.75f, -7.4f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(0, 61).m_171488_(-2.0f, -8.0f, -4.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).m_171514_(6, 61).m_171488_(-0.75f, -8.0f, -4.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(LEFT_TANK_BORDER_PART, CubeListBuilder.m_171558_().m_171514_(50, 43).m_171481_(-8.0f, -9.5f, -2.0f, 3.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(LEFT_TANK_PART, CubeListBuilder.m_171558_().m_171514_(54, 27).m_171481_(-5.5f, -7.5f, -2.0f, 1.0f, 6.0f, 4.0f).m_171514_(50, 37).m_171481_(-8.0f, -1.5f, -2.0f, 3.0f, 1.0f, 4.0f).m_171514_(50, 42).m_171481_(-8.0f, -8.5f, -2.0f, 3.0f, 1.0f, 4.0f).m_171514_(50, 37).m_171481_(-8.0f, -10.5f, -2.0f, 3.0f, 1.0f, 4.0f).m_171514_(52, 48).m_171481_(-7.5f, -11.5f, -1.5f, 3.0f, 1.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(RIGHT_TANK_BORDER_PART, CubeListBuilder.m_171558_().m_171514_(50, 43).m_171506_(5.0f, -9.5f, -2.0f, 3.0f, 1.0f, 4.0f, true), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_(RIGHT_TANK_PART, CubeListBuilder.m_171558_().m_171514_(54, 27).m_171506_(4.5f, -7.5f, -2.0f, 1.0f, 6.0f, 4.0f, true).m_171514_(50, 37).m_171506_(5.0f, -1.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).m_171514_(50, 42).m_171506_(5.0f, -8.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).m_171514_(50, 37).m_171506_(5.0f, -10.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).m_171514_(52, 48).m_171506_(4.5f, -11.5f, -1.5f, 3.0f, 1.0f, 3.0f, true), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        for (int pixels = 1; pixels < 5; ++pixels) {
            partDefinition.m_171599_(BATTERY_CHARGE_PART + pixels, CubeListBuilder.m_171558_().m_171514_(18, 55).m_171481_(-2.0f, 21.0f, -6.01f, (float)pixels, 1.0f, 1.0f), PartPose.f_171404_);
        }
        BackpackModel.getBackpackItems().forEach((idx, item) -> {
            BackpackModel.addBodyClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addLeftPouchesClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addRightPouchesClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addFrontPouchClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addBatteryClips(partDefinition, item, 30 + idx * 3);
        });
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static Map<Integer, Item> getBackpackItems() {
        return new LinkedHashMap<Integer, BackpackItem>(Map.of(0, (BackpackItem)((Object)ModItems.BACKPACK.get()), 1, (BackpackItem)((Object)ModItems.IRON_BACKPACK.get()), 2, (BackpackItem)((Object)ModItems.GOLD_BACKPACK.get()), 3, (BackpackItem)((Object)ModItems.DIAMOND_BACKPACK.get()), 4, (BackpackItem)((Object)ModItems.NETHERITE_BACKPACK.get())));
    }

    @Override
    public <L extends LivingEntity, M extends EntityModel<L>> void render(M parentModel, LivingEntity livingEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int clothColor, int borderColor, Item backpackItem, RenderInfo renderInfo) {
        IRenderedTankUpgrade.TankRenderInfo tankRenderInfo;
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)BACKPACK_ENTITY_TEXTURE));
        Set tankPositions = renderInfo.getTankRenderInfos().keySet();
        boolean showLeftTank = tankPositions.contains(TankPosition.LEFT);
        boolean showRightTank = tankPositions.contains(TankPosition.RIGHT);
        Optional batteryRenderInfo = renderInfo.getBatteryRenderInfo();
        float borderRed = (float)(borderColor >> 16 & 0xFF) / 255.0f;
        float borderGreen = (float)(borderColor >> 8 & 0xFF) / 255.0f;
        float borderBlue = (float)(borderColor & 0xFF) / 255.0f;
        float clothRed = (float)(clothColor >> 16 & 0xFF) / 255.0f;
        float clothGreen = (float)(clothColor >> 8 & 0xFF) / 255.0f;
        float clothBlue = (float)(clothColor & 0xFF) / 255.0f;
        if (showLeftTank) {
            this.leftTank.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.leftTankBorder.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, borderRed, borderGreen, borderBlue, 1.0f);
        } else {
            this.fabricLeft.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.clipsLeftPouches.get(backpackItem).m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.leftPouches.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, clothRed, clothGreen, clothBlue, 1.0f);
            this.leftPouchesBorder.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, borderRed, borderGreen, borderBlue, 1.0f);
        }
        if (showRightTank) {
            this.rightTank.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.rightTankBorder.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, borderRed, borderGreen, borderBlue, 1.0f);
        } else {
            this.fabricRight.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.clipsRightPouches.get(backpackItem).m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.rightPouches.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, clothRed, clothGreen, clothBlue, 1.0f);
            this.rightPouchesBorder.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, borderRed, borderGreen, borderBlue, 1.0f);
        }
        if (batteryRenderInfo.isPresent()) {
            this.battery.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.batteryBorder.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, borderRed, borderGreen, borderBlue, 1.0f);
            this.clipsBattery.get(backpackItem).m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            batteryRenderInfo.ifPresent(info -> this.renderBatteryCharge(poseStack, buffer, packedLight, info.getChargeRatio()));
        } else {
            this.fabricFront.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.clipsFrontPouch.get(backpackItem).m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            this.frontPouch.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, clothRed, clothGreen, clothBlue, 1.0f);
            this.frontPouchBorder.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, borderRed, borderGreen, borderBlue, 1.0f);
        }
        this.fabric.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
        this.clipsBody.get(backpackItem).m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
        this.cloth.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, clothRed, clothGreen, clothBlue, 1.0f);
        this.border.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, borderRed, borderGreen, borderBlue, 1.0f);
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.6f, 0.5f);
        if (showLeftTank) {
            vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)TANK_GLASS_TEXTURE));
            this.leftTankGlass.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            tankRenderInfo = (IRenderedTankUpgrade.TankRenderInfo)renderInfo.getTankRenderInfos().get(TankPosition.LEFT);
            tankRenderInfo.getFluid().ifPresent(f -> this.renderFluid(poseStack, buffer, packedLight, (FluidStack)f, tankRenderInfo.getFillRatio(), true));
        }
        if (showRightTank) {
            vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)TANK_GLASS_TEXTURE));
            this.rightTankGlass.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
            tankRenderInfo = (IRenderedTankUpgrade.TankRenderInfo)renderInfo.getTankRenderInfos().get(TankPosition.RIGHT);
            tankRenderInfo.getFluid().ifPresent(f -> this.renderFluid(poseStack, buffer, packedLight, (FluidStack)f, tankRenderInfo.getFillRatio(), false));
        }
        poseStack.m_85849_();
    }

    @Override
    public void renderBatteryCharge(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float chargeRatio) {
        ModelPart charge = this.batteryCharges.get((int)(chargeRatio * 4.0f));
        if (charge == null) {
            return;
        }
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)BACKPACK_ENTITY_TEXTURE));
        charge.m_104301_(matrixStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
    }

    @Override
    public void renderFluid(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, FluidStack fluidStack, float fill, boolean left) {
        if (Mth.m_14033_((float)fill, (float)0.0f)) {
            return;
        }
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation texture = renderProperties.getStillTexture(fluidStack);
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_));
        ModelPart fluidBox = this.getFluidBar(still, (int)(fill * 10.0f), left);
        int color = renderProperties.getTintColor(fluidStack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        fluidBox.m_104306_(matrixStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private ModelPart getFluidBar(TextureAtlasSprite still, int fill, boolean left) {
        int atlasWidth = (int)((float)still.m_245424_().m_246492_() / (still.m_118410_() - still.m_118409_()));
        int atlasHeight = (int)((float)still.m_245424_().m_245330_() / (still.m_118412_() - still.m_118411_()));
        int u = (int)(still.m_118409_() * (float)atlasWidth);
        int v = (int)(still.m_118411_() * (float)atlasHeight);
        FluidBarCacheKey key = new FluidBarCacheKey(u, v, fill);
        Map<FluidBarCacheKey, ModelPart> fluidLevels = left ? this.fluidLevelsLeft : this.fluidLevelsRight;
        return fluidLevels.computeIfAbsent(key, k -> {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partDefinition = meshdefinition.m_171576_();
            partDefinition.m_171599_("fluid_fill", CubeListBuilder.m_171558_().m_171514_(u, v).m_171506_(left ? -14.5f : 11.0f, 13.5f - (float)fill, -2.0f, 3.5f, (float)fill, 4.0f, !left), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
            ModelPart root = partDefinition.m_171583_(atlasWidth, atlasHeight);
            return root.m_171324_("fluid_fill");
        });
    }

    @Override
    public EquipmentSlot getRenderEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    @Override
    public <L extends LivingEntity, M extends EntityModel<L>> void translateRotateAndScale(M parentModel, LivingEntity livingEntity, PoseStack matrixStack, boolean wearsArmor) {
        if (livingEntity.m_6047_()) {
            matrixStack.m_85837_(0.0, 0.2, 0.0);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(28.647888f));
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        float zOffset = wearsArmor ? -0.35f : -0.3f;
        float yOffset = -0.75f;
        if (livingEntity.m_6162_()) {
            zOffset += 0.1f;
            yOffset = 0.3f;
        }
        matrixStack.m_252880_(0.0f, yOffset, zOffset);
        if (livingEntity instanceof Player) {
            return;
        }
        if (livingEntity.m_6162_()) {
            matrixStack.m_85841_(0.55f, 0.55f, 0.55f);
        }
        if (entityTranslations.containsKey(livingEntity.m_6095_())) {
            Vec3 translVector = entityTranslations.get(livingEntity.m_6095_());
            matrixStack.m_85837_(translVector.m_7096_(), translVector.m_7098_(), translVector.m_7094_());
        }
    }

    private static void addBodyClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.m_171599_(BackpackModel.getTierPartName(backpackItem, BODY_CLIPS_PART), CubeListBuilder.m_171558_().m_171514_(22, yTextureOffset).m_171481_(-3.25f, -9.5f, -3.5f, 1.0f, 2.0f, 1.0f).m_171514_(25, yTextureOffset).m_171481_(2.25f, -9.5f, -3.5f, 1.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static String getTierPartName(Item backpackItem, String partNamePrefix) {
        return partNamePrefix + ForgeRegistries.ITEMS.getKey((Object)backpackItem).m_135815_();
    }

    private static void addLeftPouchesClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.m_171599_(BackpackModel.getTierPartName(backpackItem, LEFT_POUCHES_CLIPS_PART), CubeListBuilder.m_171558_().m_171514_(18, yTextureOffset).m_171481_(-6.25f, -10.0f, -0.5f, 1.0f, 2.0f, 1.0f).m_171514_(6, yTextureOffset).m_171481_(-7.25f, -5.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addRightPouchesClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.m_171599_(BackpackModel.getTierPartName(backpackItem, RIGHT_POUCHES_CLIPS_PART), CubeListBuilder.m_171558_().m_171514_(6, yTextureOffset).m_171506_(6.25f, -5.0f, -0.5f, 1.0f, 2.0f, 1.0f, true).m_171514_(18, yTextureOffset).m_171506_(5.25f, -10.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addFrontPouchClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.m_171599_(BackpackModel.getTierPartName(backpackItem, FRONT_POUCH_CLIPS_PART), CubeListBuilder.m_171558_().m_171514_(0, yTextureOffset).m_171481_(2.0f, -5.0f, -5.25f, 1.0f, 2.0f, 1.0f).m_171514_(3, yTextureOffset).m_171481_(-3.0f, -5.0f, -5.25f, 1.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addBatteryClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.m_171599_(BackpackModel.getTierPartName(backpackItem, BATTERY_CLIPS_PART), CubeListBuilder.m_171558_().m_171514_(24, yTextureOffset).m_171488_(1.0f, -5.25f, -6.15f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.2f)).m_171514_(21, yTextureOffset).m_171488_(1.0f, -1.25f, -6.15f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    protected Iterable<ModelPart> m_5607_() {
        return Collections.emptyList();
    }

    protected Iterable<ModelPart> m_5608_() {
        return Collections.emptyList();
    }

    public void setupAnim(LivingEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    static {
        entityTranslations.put(EntityType.f_20566_, new Vec3(0.0, -0.8, 0.0));
        BACKPACK_ENTITY_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/entity/backpack.png");
        TANK_GLASS_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/entity/tank_glass.png");
    }

    private record FluidBarCacheKey(int u, int v, int fill) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidBarCacheKey that = (FluidBarCacheKey)o;
            return this.u == that.u && this.v == that.v && this.fill == that.fill;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.u, this.v, this.fill);
        }
    }
}

