/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.library;

import bbs.framework.helper.BBSFunctions;
import bbs.framework.library.BBSSprite;
import bbs.framework.models.BBSGame;
import javax.microedition.lcdui.Graphics;

public final class BBSParticles {
    public static final int effect_none = 0;
    public static final int effect_smoke = 1;
    public static final int effect_fire = 2;
    public static final int effect_fountain = 3;
    public static final int effect_fall = 4;
    public static final int effect_explode = 5;
    public static final int effect_fireworks = 6;
    public static final int effect_split = 7;
    public static final int effect_sparkle = 9;
    public static final int effect_pow = 10;
    public static final int effect_bubbles = 11;
    public static final int effect_planet = 12;
    public static final int mesh_sphere = 0;
    public static final int mesh_box = 1;
    private int[][] particles;
    private BBSSprite sParticle;
    public int startX;
    public int startY;
    public int width = 0;
    public int height = 0;
    public int mesh = 0;
    public int velocityX = 0;
    public int velocityY = 0;
    public boolean randomVelX = false;
    public boolean randomVelY = false;
    public int worldVelX = 0;
    public int worldVelY = 0;
    public int minEmission = 1;
    public int maxEmission = 10;
    public int energy = 100;
    public int rotationX = 0;
    public int rotationY = 0;
    public boolean randomRotation = false;
    private boolean emit = false;
    private int animateInMs;
    private int emitInMs;
    private int maxFrames = 1;
    private int totalFrameSet;
    private int lastParticle;
    private boolean oneShot;
    private int totalThrew;

    public BBSParticles(BBSGame game, int x, int y, String spriteName, int[] frameSet, int frameSegment, int effect, int minParticles, int maxParticles) {
        this.startX = x;
        this.startY = y;
        this.minEmission = minParticles;
        this.maxEmission = maxParticles;
        this.particles = new int[maxParticles][12];
        this.sParticle = new BBSSprite(game, spriteName, 0, 0, 0, 0, 0, 0);
        if (frameSet == null) {
            frameSet = new int[this.sParticle.sData.frames];
            for (int cnt = 0; cnt < frameSet.length; ++cnt) {
                frameSet[cnt] = cnt;
            }
        }
        if (frameSegment == 0) {
            this.sParticle.addFrameSet(frameSet, 30, true);
            this.totalFrameSet = 1;
        } else {
            this.totalFrameSet = frameSet.length / frameSegment;
            int[] newFrameSet = null;
            for (int cnt = 0; cnt < frameSet.length; ++cnt) {
                if (cnt % frameSegment == 0) {
                    newFrameSet = new int[frameSegment];
                }
                newFrameSet[cnt % frameSegment] = frameSet[cnt];
                if (cnt % frameSegment != frameSegment - 1) continue;
                this.sParticle.addFrameSet(newFrameSet, 0, cnt == frameSet.length - 1);
            }
        }
        this.sParticle.setFrameSet(1, 0);
        switch (effect) {
            case 1: {
                this.setEffectParams(20, 10, 1, 4, -12, true, false, 0, 1, minParticles, maxParticles, 0, 0, false, 10000);
                break;
            }
            case 2: {
                this.setEffectParams(10, 0, 0, 2, -4, true, true, 0, -2, minParticles, maxParticles, 0, 0, false, 3000);
                break;
            }
            case 3: {
                this.setEffectParams(40, 10, 1, 2, -4, true, false, 0, 4, minParticles, maxParticles, 0, 0, false, 4000);
                break;
            }
            case 4: {
                this.setEffectParams(300, 80, 1, 2, 0, true, false, 0, 20, minParticles, maxParticles, 0, 0, false, 3000);
                break;
            }
            case 5: {
                this.setEffectParams(40, 60, 0, 8, -40, true, true, 0, -10, minParticles, maxParticles, 0, 1, true, 4000);
                break;
            }
            case 6: {
                this.setEffectParams(50, 10, 1, 8, -15, true, false, 0, 2, minParticles, maxParticles, 0, 0, false, 7000);
                break;
            }
            case 7: {
                this.setEffectParams(60, 10, 0, 10, -10, true, false, 0, 5, minParticles, maxParticles, 0, 0, false, 2000);
                break;
            }
            case 9: {
                this.setEffectParams(0, 0, 0, 14, -10, true, false, 0, 8, minParticles, maxParticles, 0, 0, false, 1000);
                break;
            }
            case 10: {
                this.setEffectParams(0, 0, 0, 20, 20, true, true, 8, 8, minParticles, maxParticles, 10, 15, true, 3000);
                break;
            }
            case 11: {
                this.setEffectParams(0, 20, 0, 40, -5, false, false, 4, 0, minParticles, maxParticles, 4, 0, false, 21000);
                break;
            }
            case 12: {
                this.setEffectParams(150, 150, 0, 40, 40, true, true, 0, 0, minParticles, maxParticles, 4, 4, true, 10000);
                break;
            }
        }
    }

    public void setEffectParams(int width, int height, int mesh, int velocityX, int velocityY, boolean randomVelX, boolean randomVelY, int worldVelX, int worldVelY, int minEmission, int maxEmission, int rotationX, int rotationY, boolean randomRotation, int energy) {
        this.width = width;
        this.height = height;
        this.mesh = mesh;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.randomVelX = randomVelX;
        this.randomVelY = randomVelY;
        this.worldVelX = worldVelX;
        this.worldVelY = worldVelY;
        this.minEmission = minEmission;
        this.maxEmission = maxEmission;
        this.rotationX = rotationX;
        this.rotationY = rotationY;
        this.randomRotation = randomRotation;
        this.energy = energy;
    }

    private void createParticle(long currentTimeMilis, int no) {
        int rot;
        int distX = 0;
        int distY = 0;
        switch (this.mesh) {
            case 1: {
                distX = -this.width * 5 + BBSFunctions.random(currentTimeMilis, 0, this.width * 10, 18273 + no * 117);
                distY = -this.height * 5 + BBSFunctions.random(currentTimeMilis, 0, this.height * 10, 32631 + no * 129);
                break;
            }
            case 0: {
                rot = BBSFunctions.random(currentTimeMilis, 0, 359, 11411 + no * 173);
                distX = BBSFunctions.random(currentTimeMilis, 0, this.width * 5, 18273 + no * 117);
                distY = BBSFunctions.random(currentTimeMilis, 0, this.height * 5, 32631 + no * 129);
                distX = distX * BBSFunctions.sin(rot) / 100;
                distY = distY * BBSFunctions.cos(rot) / 100;
            }
        }
        if (this.randomVelX) {
            rot = BBSFunctions.random(currentTimeMilis, 0, 359, 1319 + no * 141);
            this.particles[no][2] = this.velocityX * BBSFunctions.sin(rot) / 100;
        } else {
            this.particles[no][2] = this.velocityX;
        }
        if (this.randomVelY) {
            rot = BBSFunctions.random(currentTimeMilis, 0, 359, 1723 + no * 147);
            this.particles[no][3] = this.velocityY * BBSFunctions.cos(rot) / 100;
        } else {
            this.particles[no][3] = this.velocityY;
        }
        this.particles[no][4] = 0;
        this.particles[no][5] = 0;
        this.particles[no][6] = this.randomRotation ? BBSFunctions.random(currentTimeMilis, 60, 140, no * 83) : 100;
        this.particles[no][7] = this.energy;
        this.particles[no][8] = 0;
        this.particles[no][9] = BBSFunctions.random(currentTimeMilis, 1, this.totalFrameSet, 0);
        if (this.rotationX == 0) {
            this.particles[no][0] = distX;
            this.particles[no][10] = 0;
        } else {
            this.particles[no][10] = distX;
            this.particles[no][0] = this.particles[no][10] + this.particles[no][2] * BBSFunctions.sin(this.particles[no][4] / 10) / 10;
        }
        if (this.rotationY == 0) {
            this.particles[no][1] = distY;
            this.particles[no][11] = 0;
        } else {
            this.particles[no][11] = distY;
            this.particles[no][1] = this.particles[no][11] + this.particles[no][3] * BBSFunctions.cos(this.particles[no][5] / 10) / 10;
        }
        this.lastParticle = no;
    }

    public void start(boolean oneShot) {
        this.oneShot = oneShot;
        this.totalThrew = 0;
        if (this.sParticle != null) {
            this.maxFrames = this.sParticle.frameSequence.length;
            this.animateInMs = this.energy / this.maxFrames / 30 * 30;
        }
        this.emitInMs = Math.max(30, (this.minEmission * this.energy / this.maxEmission / 30 + 1) * 30);
        this.emit = true;
    }

    public void stop() {
        this.emit = false;
    }

    public int doAnimation(BBSGame game, int time) {
        int aliveParts = 0;
        for (int cntr = this.particles.length - 1; cntr >= 0; --cntr) {
            int cnt = (this.lastParticle + cntr + 1) % this.particles.length;
            if (this.particles[cnt][7] <= 0) {
                if (!this.emit || !this.onceInMs(time, this.emitInMs) || aliveParts >= this.minEmission) continue;
                this.createParticle(game.currentTimeMillis, cnt);
                ++aliveParts;
                continue;
            }
            if (this.onceInMs(time, 600)) {
                int[] nArray = this.particles[cnt];
                nArray[2] = nArray[2] + this.worldVelX;
                int[] nArray2 = this.particles[cnt];
                nArray2[3] = nArray2[3] + this.worldVelY;
            }
            if (this.rotationX == 0) {
                int[] nArray = this.particles[cnt];
                nArray[0] = nArray[0] + this.particles[cnt][2];
            } else {
                this.particles[cnt][0] = this.particles[cnt][10] + this.particles[cnt][2] * BBSFunctions.sin(this.particles[cnt][4] / 10) / 10;
            }
            if (this.rotationY == 0) {
                int[] nArray = this.particles[cnt];
                nArray[1] = nArray[1] + this.particles[cnt][3];
            } else {
                this.particles[cnt][1] = this.particles[cnt][11] + this.particles[cnt][3] * BBSFunctions.cos(this.particles[cnt][5] / 10) / 10;
            }
            this.particles[cnt][4] = (this.particles[cnt][4] + this.rotationX * this.particles[cnt][6] / 10) % 3600;
            this.particles[cnt][5] = (this.particles[cnt][5] + this.rotationY * this.particles[cnt][6] / 10) % 3600;
            int[] nArray = this.particles[cnt];
            nArray[7] = nArray[7] - 30;
            if (!this.onceInMs(time, this.animateInMs)) continue;
            this.particles[cnt][8] = Math.min(this.particles[cnt][8] + 1, this.maxFrames - 1);
        }
        this.totalThrew += aliveParts;
        if (this.oneShot && this.totalThrew >= this.maxEmission) {
            this.stop();
        }
        return aliveParts;
    }

    public void draw(BBSGame game, Graphics g) {
        for (int cnt = 0; cnt < this.particles.length; ++cnt) {
            if (this.particles[cnt][7] <= 0) continue;
            this.sParticle.setFrameSet(this.particles[cnt][9], this.getDirection(this.particles[cnt][2]));
            this.sParticle.setFrame(this.particles[cnt][8]);
            this.sParticle.x = this.startX + this.particles[cnt][0] / 10;
            this.sParticle.y = this.startY + this.particles[cnt][1] / 10;
            this.sParticle.paint(game, g);
        }
    }

    private int getDirection(int dx) {
        if (dx >= 0) {
            return 1;
        }
        return -1;
    }

    private boolean onceInMs(long time, int duration) {
        return time % (long)duration == 0L;
    }
}

