/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.library;

import bbs.framework.helper.BBSFunctions;
import bbs.framework.interfaces.BBSIDisposable;
import bbs.framework.models.BBSGame;

public class BBSPuppetData
implements BBSIDisposable {
    private String[] sifList;
    private short[][][][] mapData;

    public BBSPuppetData(BBSGame game, String name) {
        byte[] bytes = BBSFunctions.loadData(game, name);
        int length = (short)(bytes[0] & 0xFF) * 256 + (short)(bytes[1] & 0xFF);
        for (int cnt = 2; cnt < 2 + length; ++cnt) {
            bytes[cnt] = ~bytes[cnt];
        }
        String data = "";
        try {
            data = new String(bytes, 2, length, "UTF-8");
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.sifList = BBSFunctions.splitString(data, "|");
        data = null;
        int anims = bytes[length + 2] & 0xFF;
        this.mapData = new short[anims][][][];
        int pos = length + 3;
        for (int cnt = 0; cnt < anims; ++cnt) {
            int frames = (bytes[pos] & 0xFF) * 256 + (bytes[pos + 1] & 0xFF);
            this.mapData[cnt] = new short[frames][][];
            pos += 2;
            for (int subcnt = 0; subcnt < frames; ++subcnt) {
                int sprites = (bytes[pos] & 0xFF) * 256 + (bytes[pos + 1] & 0xFF);
                pos += 2;
                this.mapData[cnt][subcnt] = new short[sprites][4];
                for (int deepcnt = 0; deepcnt < sprites; ++deepcnt) {
                    this.mapData[cnt][subcnt][deepcnt][0] = (short)(bytes[pos] & 0xFF);
                    this.mapData[cnt][subcnt][deepcnt][1] = (short)(bytes[pos + 1] & 0xFF);
                    this.mapData[cnt][subcnt][deepcnt][2] = (short)((bytes[pos + 2] & 0xFF) * 256 + (bytes[pos + 3] & 0xFF) - 32768);
                    this.mapData[cnt][subcnt][deepcnt][3] = (short)((bytes[pos + 4] & 0xFF) * 256 + (bytes[pos + 5] & 0xFF) - 32768);
                    pos += 6;
                }
            }
        }
        bytes = null;
    }

    public void freeResources() {
        this.sifList = null;
        this.mapData = null;
    }
}

