/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.library;

import bbs.framework.helper.BBSFunctions;
import bbs.framework.interfaces.BBSIDisposable;
import bbs.framework.models.BBSGame;
import javax.microedition.lcdui.Image;

public class BBSSpriteData
implements BBSIDisposable {
    public int[][] map;
    public Image spriteSet;
    public int frames;
    public int width;
    public int height;

    public BBSSpriteData(BBSGame game, String name) {
        int[] mapi;
        String[] cols;
        byte[] bytes = BBSFunctions.loadData(game, name);
        int length = (bytes[0] & 0xFF) * 256 + (bytes[1] & 0xFF);
        for (int cnt = 2; cnt < 2 + length; ++cnt) {
            bytes[cnt] = ~bytes[cnt];
        }
        this.spriteSet = Image.createImage((byte[])bytes, (int)(length + 2), (int)(bytes.length - length - 2));
        String data = "";
        try {
            data = new String(bytes, 2, length, "UTF-8");
        }
        catch (Exception ex) {
            // empty catch block
        }
        bytes = null;
        String[] rows = BBSFunctions.splitString(data, "\r\n");
        this.map = new int[rows.length - 1][];
        data = null;
        for (int cnt = 0; cnt < rows.length; ++cnt) {
            cols = BBSFunctions.splitString(rows[cnt], "\t");
            if (cols.length == 3) {
                this.frames = Integer.parseInt(cols[0]);
                this.width = Integer.parseInt(cols[1]);
                this.height = Integer.parseInt(cols[2]);
                continue;
            }
            if (cols.length != 6) continue;
            mapi = new int[]{Short.parseShort(cols[0]), Short.parseShort(cols[1]), Short.parseShort(cols[2]), Short.parseShort(cols[3]), Short.parseShort(cols[4]), Short.parseShort(cols[5])};
            this.map[cnt - 1] = mapi;
        }
        mapi = null;
        cols = null;
        rows = null;
        System.gc();
    }

    public void freeResources() {
        this.map = null;
        this.spriteSet = null;
    }
}

