/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.menu;

import bbs.framework.helper.BBSKeys;
import bbs.framework.interfaces.BBSIMenu;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSMenu;

public abstract class BBSSlideMenu
extends BBSMenu
implements BBSIMenu {
    public int state = 0;
    public int x = 0;
    public int y = 0;
    private int todir = 1;
    private int tosel = 1;
    public boolean active = true;
    protected static final int horizontal = 1;
    protected static final int vertical = 2;

    public BBSSlideMenu(BBSGame game) {
        super(game);
    }

    public void slide(int todirecory, int effect) {
        if (this.state == 0) {
            this.tosel = 1;
            this.todir = todirecory;
            this.state = effect;
        }
    }

    public void keyPress(BBSGame game, BBSKeys kcol, int time) {
        if (kcol.down && this.selection < this.menus[this.directory - 1].length) {
            ++this.selection;
        }
        if (kcol.up && this.selection > 1) {
            --this.selection;
        }
        if (kcol.fire || kcol.dblfire) {
            this.doMenuAction(game, this.directory, this.selection);
        }
    }

    public void doAnimation(BBSGame game, int time) {
        if (this.active || this.state != 0) {
            int speed = 4;
            switch (this.state) {
                case 1: {
                    this.x = Math.max(-game.w * 2, this.x + Math.min(-3, this.x / speed));
                    if (this.x != -game.w * 2) break;
                    if (this.todir <= 0) {
                        this.state = 0;
                        this.active = false;
                        break;
                    }
                    this.directory = this.todir;
                    this.state = 3;
                    this.selection = this.tosel;
                    this.active = true;
                    break;
                }
                case 2: {
                    this.y = Math.max(-game.h * 2, this.y + Math.min(-3, this.y / speed));
                    if (this.y != -game.h * 2) break;
                    if (this.todir <= 0) {
                        this.state = 0;
                        this.active = false;
                        break;
                    }
                    this.directory = this.todir;
                    this.state = 4;
                    this.selection = this.tosel;
                    this.active = true;
                    break;
                }
                case 3: {
                    this.x = Math.min(0, this.x + Math.max(3, -this.x / speed));
                    if (this.x != 0) break;
                    this.state = 0;
                    this.active = true;
                    break;
                }
                case 4: {
                    this.y = Math.min(0, this.y + Math.max(3, -this.y / speed));
                    if (this.y != 0) break;
                    this.state = 0;
                    this.active = true;
                }
            }
            if (this.state == 0 && this.todir <= 0) {
                this.freeResources(game);
                if (this.todir == 0) {
                    this.menuClosed(game);
                } else {
                    game.quitApp();
                }
            }
        }
    }
}

